/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.X_PA_ReportCube;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

public class MReportCube
extends X_PA_ReportCube {
    private static final long serialVersionUID = -4771117572936231607L;

    public MReportCube(Properties ctx, int PA_ReportCube_ID, String trxName) {
        super(ctx, PA_ReportCube_ID, trxName);
    }

    public MReportCube(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String update(boolean reset, boolean force) {
        Object[] objectArray;
        String lockSQL;
        int locked;
        long elapsed;
        long start;
        String result = this.getName() + ": ";
        Timestamp ts = null;
        String where = " WHERE PA_ReportCube_ID = " + this.getPA_ReportCube_ID();
        String periods = " (-1) ";
        if (this.getLastRecalculated() != null && !reset) {
            StringBuilder periodList = new StringBuilder();
            StringBuilder periodNames = new StringBuilder();
            String sql = "SELECT DISTINCT p.C_Period_ID, p.Name FROM C_Period p INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID) INNER JOIN PA_ReportCube c ON (c.C_Calendar_ID = y.C_Calendar_ID) INNER JOIN Fact_Acct fact ON (fact.dateacct between p.startdate and p.enddate                       and fact.ad_client_id = c.ad_client_id) WHERE c.PA_ReportCube_ID = ? AND fact.updated > c.LastRecalculated AND p.periodtype='S' ";
            this.log.log(Level.FINE, sql);
            start = System.currentTimeMillis();
            KeyNamePair[] changedPeriods = DB.getKeyNamePairs(sql, false, this.getPA_ReportCube_ID());
            elapsed = (System.currentTimeMillis() - start) / 1000L;
            this.log.log(Level.FINE, "Selecting changed periods took:" + elapsed + "s");
            if (changedPeriods != null && changedPeriods.length > 0) {
                periodList.append(" (");
                for (KeyNamePair p2 : changedPeriods) {
                    periodList.append(p2.getID() + ", ");
                    periodNames.append(p2.getName() + ", ");
                }
            } else {
                return "Nothing to update in " + this.getName();
            }
            periodList.delete(periodList.length() - 2, periodList.length());
            periodList.append(" )");
            this.log.log(Level.FINE, "Periods requiring update: " + periodNames.toString());
            periods = periodList.toString();
            where = where + " AND C_Period_ID IN " + periods;
        }
        if (!force && (locked = DB.executeUpdateEx(lockSQL = "UPDATE PA_ReportCube SET Processing = 'Y' WHERE Processing = 'N' AND PA_ReportCube_ID = " + this.getPA_ReportCube_ID(), this.get_TrxName())) != 1) {
            throw new AdempiereException("Unable to lock cube for update:" + this.getName());
        }
        try {
            String delSQL = "DELETE FROM Fact_Acct_Summary fas " + where;
            this.log.log(Level.FINE, "Delete sql: " + delSQL);
            start = System.currentTimeMillis();
            int deleted = DB.executeUpdateEx(delSQL, this.get_TrxName());
            elapsed = (System.currentTimeMillis() - start) / 1000L;
            result = result + "Deleted " + deleted + " in " + elapsed + " s;";
            this.log.log(Level.FINE, result);
            StringBuilder insert = new StringBuilder("INSERT INTO FACT_ACCT_SUMMARY (PA_ReportCube_ID , AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, C_AcctSchema_ID, Account_ID, PostingType, GL_Budget_ID, C_Period_ID, DateAcct, AmtAcctDr, AmtAcctCr, Qty");
            StringBuilder select = new StringBuilder(" ) SELECT ?, f.AD_CLIENT_ID, f.AD_ORG_ID, max(f.Created), max(f.CreatedBy), max(f.Updated), max(f.UpdatedBy), 'Y', f.C_ACCTSCHEMA_ID, f.ACCOUNT_ID, f.POSTINGTYPE, GL_Budget_ID, p.c_period_id,\tp.StartDate, COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0), COALESCE(SUM(Qty),0)");
            String from = " FROM fact_acct f  INNER JOIN C_Period p ON ( f.DateAcct BETWEEN p.StartDate AND p.EndDate )  INNER JOIN C_Year y ON ( p.C_Year_ID = y.C_Year_ID )  WHERE p.PeriodType = 'S'  AND y.C_Calendar_ID = ? ";
            if (this.getLastRecalculated() != null && !reset) {
                from = from + "AND  p.C_Period_ID IN " + periods;
            }
            StringBuilder groups = new StringBuilder(" GROUP BY f.AD_CLIENT_ID, f.AD_ORG_ID, f.C_ACCTSCHEMA_ID, f.ACCOUNT_ID, f.POSTINGTYPE, GL_Budget_ID, p.c_period_id, p.StartDate ");
            ArrayList<String> values = new ArrayList<String>();
            if (this.isProductDim()) {
                values.add("M_Product_ID");
            }
            if (this.isBPartnerDim()) {
                values.add("C_BPartner_ID");
            }
            if (this.isProjectDim()) {
                values.add("C_Project_ID");
            }
            if (this.isOrgTrxDim()) {
                values.add("AD_OrgTrx_ID");
            }
            if (this.isSalesRegionDim()) {
                values.add("C_SalesRegion_ID");
            }
            if (this.isActivityDim()) {
                values.add("C_Activity_ID");
            }
            if (this.isCampaignDim()) {
                values.add("C_Campaign_ID");
            }
            if (this.isLocToDim()) {
                values.add("C_LocTo_ID");
            }
            if (this.isLocFromDim()) {
                values.add("C_LocFrom_ID");
            }
            if (this.isUser1Dim()) {
                values.add("User1_ID");
            }
            if (this.isUser2Dim()) {
                values.add("User2_ID");
            }
            if (this.isUser3Dim()) {
                values.add("User3_ID");
            }
            if (this.isUser4Dim()) {
                values.add("User4_ID");
            }
            if (this.isUserElement1Dim()) {
                values.add("UserElement1_ID");
            }
            if (this.isUserElement2Dim()) {
                values.add("UserElement2_ID");
            }
            if (this.isSubAcctDim()) {
                values.add("C_SubAcct_ID");
            }
            if (this.isProjectPhaseDim()) {
                values.add("C_ProjectPhase_ID");
            }
            if (this.isProjectTaskDim()) {
                values.add("C_ProjectTask_ID");
            }
            for (String dim : values) {
                insert.append(", " + dim);
                select.append(", f." + dim);
                groups.append(", f." + dim);
            }
            String sql = insert.append(select.toString()).append(from).append(groups.toString()).toString();
            this.log.log(Level.FINE, sql);
            Object[] params = new Object[]{this.getPA_ReportCube_ID(), this.getC_Calendar_ID()};
            start = System.currentTimeMillis();
            int rows = DB.executeUpdateEx(sql, params, this.get_TrxName());
            long seconds = (System.currentTimeMillis() - start) / 1000L;
            String insertResult = "Inserted " + rows + " in " + seconds + " s.";
            this.log.log(Level.FINE, insertResult);
            result = result + insertResult;
            String tsSQL = "SELECT max(fas.Updated) FROM Fact_Acct_Summary fas WHERE fas.PA_ReportCube_ID = " + this.getPA_ReportCube_ID();
            ts = DB.getSQLValueTS(this.get_TrxName(), tsSQL, new Object[0]);
            this.log.log(Level.FINE, "Last updated: " + ts);
        }
        catch (DBException e) {
            Object[] objectArray2;
            String unlockSQL;
            block35: {
                block33: {
                    try {
                        this.log.log(Level.FINE, this.getName() + " update failed:" + e.getMessage());
                        unlockSQL = "UPDATE PA_ReportCube SET Processing = 'N', LastRecalculated = " + (ts == null ? "null" : "?") + " WHERE PA_ReportCube_ID = " + this.getPA_ReportCube_ID();
                        if (ts != null) break block33;
                    }
                    catch (Throwable throwable) {
                        Object[] objectArray3;
                        String unlockSQL2 = "UPDATE PA_ReportCube SET Processing = 'N', LastRecalculated = " + (ts == null ? "null" : "?") + " WHERE PA_ReportCube_ID = " + this.getPA_ReportCube_ID();
                        if (ts == null) {
                            objectArray3 = new Object[]{};
                        } else {
                            Object[] objectArray4 = new Object[1];
                            objectArray3 = objectArray4;
                            objectArray4[0] = ts;
                        }
                        Object[] parameters = objectArray3;
                        DB.executeUpdateEx(unlockSQL2, parameters, this.get_TrxName());
                        throw throwable;
                    }
                    objectArray2 = new Object[]{};
                    break block35;
                }
                Object[] objectArray5 = new Object[1];
                objectArray2 = objectArray5;
                objectArray5[0] = ts;
            }
            Object[] parameters = objectArray2;
            DB.executeUpdateEx(unlockSQL, parameters, this.get_TrxName());
        }
        String unlockSQL = "UPDATE PA_ReportCube SET Processing = 'N', LastRecalculated = " + (ts == null ? "null" : "?") + " WHERE PA_ReportCube_ID = " + this.getPA_ReportCube_ID();
        if (ts == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray6 = new Object[1];
            objectArray = objectArray6;
            objectArray6[0] = ts;
        }
        Object[] parameters = objectArray;
        DB.executeUpdateEx(unlockSQL, parameters, this.get_TrxName());
        return result;
    }
}

