/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MCharge;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRMA;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.model.X_M_RMALine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRMALine
extends X_M_RMALine {
    private static final long serialVersionUID = 3540322234762687347L;
    private MInOutLine m_ioLine = null;
    private MRMA m_parent = null;
    private int precision = 0;
    private int taxId = 0;
    private BigDecimal unitAmount = Env.ZERO;
    private BigDecimal originalQty = Env.ZERO;

    public MRMALine(Properties ctx, int M_RMALine_ID, String trxName) {
        super(ctx, M_RMALine_ID, trxName);
        if (M_RMALine_ID == 0) {
            this.setQty(Env.ONE);
            this.setQtyDelivered(Env.ONE);
        }
        this.init();
    }

    public MRMALine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.getC_Charge_ID() != 0) {
            String sql = "SELECT C_Tax_ID FROM C_Tax WHERE AD_Client_ID=? AND IsActive='Y' AND IsTaxExempt='Y' AND ValidFrom < SYSDATE ORDER BY IsDefault DESC";
            this.taxId = DB.getSQLValueEx(null, sql, Env.getAD_Client_ID(this.getCtx()));
            this.m_ioLine = null;
        } else {
            this.getShipLine();
        }
        if (this.m_ioLine != null) {
            if (this.getInvoiceLineId() != 0) {
                MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), this.getInvoiceLineId(), this.get_TrxName());
                this.precision = invoiceLine.getPrecision();
                this.unitAmount = invoiceLine.getPriceEntered();
                this.originalQty = invoiceLine.getQtyInvoiced();
                this.taxId = invoiceLine.getC_Tax_ID();
                return;
            } else {
                if (this.m_ioLine.getC_OrderLine_ID() == 0) throw new IllegalStateException("No Invoice/Order line found the Shipment/Receipt line associated");
                MOrderLine orderLine = new MOrderLine(this.getCtx(), this.m_ioLine.getC_OrderLine_ID(), this.get_TrxName());
                this.precision = orderLine.getPrecision();
                this.unitAmount = orderLine.getPriceEntered();
                this.originalQty = orderLine.getQtyDelivered();
                this.taxId = orderLine.getC_Tax_ID();
            }
            return;
        } else {
            if (this.getC_Charge_ID() == 0) return;
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            this.unitAmount = charge.getChargeAmt();
        }
    }

    public MRMA getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    public void setM_InOutLine_ID(int M_InOutLine_ID) {
        super.setM_InOutLine_ID(M_InOutLine_ID);
        this.m_ioLine = null;
    }

    public MInOutLine getShipLine() {
        if ((this.m_ioLine == null || this.is_ValueChanged("M_InOutLine_ID")) && this.getM_InOutLine_ID() != 0) {
            this.m_ioLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
        }
        return this.m_ioLine;
    }

    private int getInvoiceLineId() {
        int invoiceLine_ID = new Query(this.getCtx(), "C_InvoiceLine", "M_InOutLine_ID=?", this.get_TrxName()).setParameters(this.getM_InOutLine_ID()).firstIdOnly();
        return invoiceLine_ID <= 0 ? 0 : invoiceLine_ID;
    }

    public BigDecimal getUnitAmt() {
        return this.unitAmount;
    }

    public BigDecimal getTotalAmt() {
        BigDecimal totalAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        if (Env.ZERO.compareTo(this.getQty()) != 0 && Env.ZERO.compareTo(this.getAmt()) != 0) {
            totalAmt = this.getQty().multiply(this.getAmt());
            if (!this.getParent().isTaxIncluded()) {
                MTax tax = MTax.get(this.getCtx(), this.taxId);
                taxAmt = tax.calculateTax(this.getQty().multiply(this.unitAmount), this.getParent().isTaxIncluded(), this.precision);
            }
        }
        totalAmt = totalAmt.add(taxAmt);
        return totalAmt;
    }

    public boolean isShipLineInvoiced() {
        return this.getInvoiceLineId() != 0;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_RMA"));
            return false;
        }
        if (this.getM_InOutLine_ID() == 0 && this.getC_Charge_ID() == 0) {
            this.log.saveError("FillShipLineOrCharge", "");
            return false;
        }
        if (this.getM_InOutLine_ID() != 0 && this.getC_Charge_ID() != 0) {
            this.log.saveError("JustShipLineOrCharge", "");
            return false;
        }
        this.init();
        if (this.m_ioLine != null) {
            String whereClause;
            int[] lineIds;
            if (!this.checkQty()) {
                this.log.saveError("AmtReturned>Shipped", "");
                return false;
            }
            if ((newRecord || this.is_ValueChanged("M_InOutLine_ID")) && (lineIds = MRMALine.getAllIDs("M_RMALine", whereClause = "M_RMA_ID=" + this.getM_RMA_ID() + " AND M_InOutLine_ID=" + this.getM_InOutLine_ID() + " AND M_RMALine_ID!=" + this.getM_RMALine_ID(), this.get_TrxName())).length > 0) {
                this.log.saveError("InOutLineAlreadyEntered", "");
                return false;
            }
        }
        if (this.getC_Charge_ID() != 0 && this.getQty().doubleValue() <= 0.0) {
            if (this.getQty().signum() == 0) {
                this.setQty(Env.ONE);
            }
            if (this.getAmt().signum() == 0) {
                this.setAmt(this.getUnitAmt());
            }
        }
        if (this.getM_InOutLine_ID() != 0) {
            this.setAmt(this.getUnitAmt());
            if (newRecord && this.getQty().signum() == 0) {
                this.setQty(this.originalQty);
            }
        }
        this.setLineNetAmt(this.getTotalAmt());
        return true;
    }

    public boolean checkQty() {
        if (this.m_ioLine.getMovementQty().compareTo(this.getQty()) < 0) {
            return false;
        }
        BigDecimal totalQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Qty) FROM M_RMALine rl JOIN M_RMA r ON (r.M_RMA_ID = rl.M_RMA_ID) WHERE M_InOutLine_ID = ? AND M_RMALine_ID != ? AND r.Processed = 'Y' AND r.DocStatus IN ('CO','CL')", this.getM_InOutLine_ID(), this.getM_RMALine_ID());
        if (totalQty == null) {
            totalQty = Env.ZERO;
        }
        totalQty = totalQty.add(this.getQty());
        return this.m_ioLine.getMovementQty().compareTo(totalQty) >= 0;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderAmt();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderAmt();
    }

    private boolean updateHeaderAmt() {
        if (this.isProcessed() && !this.is_ValueChanged("Processed")) {
            return true;
        }
        String sql = "UPDATE M_RMA  SET Amt=(SELECT COALESCE(SUM(LineNetAmt),0) FROM M_RMALine WHERE M_RMA.M_RMA_ID=M_RMALine.M_RMA_ID) WHERE M_RMA_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{this.getM_RMA_ID()}, this.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getC_UOM_ID() {
        if (this.m_ioLine == null) {
            return 100;
        }
        return this.m_ioLine.getC_UOM_ID();
    }

    public int getM_Product_ID() {
        if (this.getC_Charge_ID() != 0) {
            return 0;
        }
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getM_Product_ID();
    }

    public int getC_Project_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_Project_ID();
    }

    public int getC_ProjectPhase_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_ProjectPhase_ID();
    }

    public int getC_ProjectTask_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_ProjectTask_ID();
    }

    public int getC_Activity_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_Activity_ID();
    }

    public int getC_Campaign_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_Campaign_ID();
    }

    public int getAD_OrgTrx_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getAD_OrgTrx_ID();
    }

    public int getUser1_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getUser1_ID();
    }

    public int getUser2_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getUser2_ID();
    }

    public int getUser3_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getUser3_ID();
    }

    public int getUser4_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getUser4_ID();
    }

    public int getM_AttributeSetInstance_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getM_AttributeSetInstance_ID();
    }

    public int getM_Locator_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getM_Locator_ID();
    }

    public int getC_Tax_ID() {
        return this.taxId;
    }
}

