/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatchLine;
import org.compiere.model.MQualityTest;
import org.compiere.model.Query;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProductionLine
extends X_M_ProductionLine
implements IDocumentLine {
    private static final long serialVersionUID = 1L;
    private MProduction m_parent = null;
    private MProduct m_product = null;

    public MProductionLine(Properties ctx, int M_ProductionLine_ID, String trxName) {
        super(ctx, M_ProductionLine_ID, trxName);
        if (M_ProductionLine_ID == 0) {
            this.setLine(0);
            this.setM_AttributeSetInstance_ID(0);
            this.setM_ProductionLine_ID(0);
            this.setM_Production_ID(0);
            this.setMovementQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MProductionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductionLine(MProduction header) {
        super(header.getCtx(), 0, header.get_TrxName());
        this.setM_Production_ID(header.getM_Production_ID());
        this.setAD_Client_ID(header.getAD_Client_ID());
        this.setAD_Org_ID(header.getAD_Org_ID());
    }

    public int deleteMA() {
        String sql = "DELETE FROM M_ProductionLineMA WHERE M_ProductionLine_ID = " + this.get_ID();
        int count = DB.executeUpdateEx(sql, this.get_TrxName());
        return count;
    }

    @Override
    public String toString() {
        if (this.getM_Product_ID() == 0) {
            return "No product defined for production line " + this.getLine();
        }
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        return "Production line:" + this.getLine() + " -- " + this.getMovementQty() + " of " + product.getValue();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getParent().getM_Product_ID() == this.getM_Product_ID() && this.getParent().getProductionQty().signum() == this.getMovementQty().signum()) {
            this.setIsEndProduct(true);
        } else {
            this.setIsEndProduct(false);
        }
        if (this.isEndProduct() && this.getM_AttributeSetInstance_ID() != 0) {
            String where = "M_QualityTest_ID IN (SELECT M_QualityTest_ID FROM M_Product_QualityTest WHERE M_Product_ID=?) AND M_QualityTest_ID NOT IN (SELECT M_QualityTest_ID FROM M_QualityTestResult WHERE M_AttributeSetInstance_ID=?)";
            List tests = new Query(this.getCtx(), "M_QualityTest", where, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getM_Product_ID(), this.getM_AttributeSetInstance_ID()).list();
            for (MQualityTest test : tests) {
                test.createResult(this.getM_AttributeSetInstance_ID());
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getM_Production().isProcessed()) {
            return false;
        }
        this.deleteMA();
        MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(this.getParent().getM_ProductionBatch_ID(), this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
        if (pbLine != null) {
            BigDecimal qtyReserved = this.isEndProduct() ? this.getMovementQty().negate() : this.getMovementQty();
            pbLine.setQtyReserved(pbLine.getQtyReserved().add(qtyReserved));
            pbLine.saveEx();
        }
        return true;
    }

    public boolean isParent() {
        Boolean isParent = this.getM_Product_ID() == this.getM_ProductionPlan().getM_Product_ID();
        if (!isParent.booleanValue()) {
            isParent = this.getM_Product_ID() == this.getM_Production().getM_Product_ID();
        }
        return isParent;
    }

    @Override
    public Timestamp getDateAcct() {
        if (this.getM_ProductionPlan_ID() != 0) {
            return this.getM_ProductionPlan().getM_Production().getMovementDate();
        }
        return this.getM_Production().getMovementDate();
    }

    @Override
    public boolean isSOTrx() {
        return false;
    }

    @Override
    public BigDecimal getPriceActual() {
        return Env.ZERO;
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return this;
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    @Override
    public int getC_DocType_ID() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("DocBaseType").append("=?");
        return new Query(this.getCtx(), "C_DocType", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters("MMP").firstId();
    }

    protected void setParent(MProduction parent) {
        this.m_parent = parent;
    }

    public MProduction getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MProduction(this.getCtx(), this.getM_Production_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int M_ProductionBatch_ID = this.getParent().getM_ProductionBatch_ID();
        if (newRecord) {
            if (M_ProductionBatch_ID == 0) {
                return true;
            }
            MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(M_ProductionBatch_ID, this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
            if (pbLine != null) {
                BigDecimal movementQty = this.isEndProduct() ? this.getMovementQty() : this.getMovementQty().negate();
                pbLine.setQtyReserved(pbLine.getQtyReserved().add(movementQty));
                pbLine.saveEx();
                return true;
            }
            BigDecimal movementQty = this.isEndProduct() ? this.getMovementQty() : this.getMovementQty().negate();
            pbLine = new MProductionBatchLine(this.getCtx(), 0, this.get_TrxName());
            pbLine.setM_ProductionBatch_ID(M_ProductionBatch_ID);
            pbLine.setM_Product_ID(this.getM_Product_ID());
            pbLine.setQtyReserved(movementQty);
            pbLine.setIsEndProduct(this.isEndProduct());
            pbLine.saveEx();
            return true;
        }
        if (this.is_ValueChanged("MovementQty")) {
            BigDecimal oldValue = (BigDecimal)this.get_ValueOld("MovementQty");
            BigDecimal diff = this.getMovementQty().subtract(oldValue);
            diff = this.isEndProduct() ? diff : diff.negate();
            MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(M_ProductionBatch_ID, this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
            if (pbLine == null) {
                pbLine = new MProductionBatchLine(this.getCtx(), 0, this.get_TrxName());
                pbLine.setM_ProductionBatch_ID(M_ProductionBatch_ID);
                pbLine.setM_Product_ID(this.getM_Product_ID());
                pbLine.setQtyReserved(this.getMovementQty().negate());
                pbLine.saveEx();
            }
            pbLine.setQtyReserved(this.getQtyReserved().add(diff));
            pbLine.saveEx();
        }
        return super.afterSave(newRecord, success);
    }

    @Override
    public BigDecimal getPriceActualCurrency() {
        return BigDecimal.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        MClient client = MClient.get(this.getCtx());
        return client.getC_Currency_ID();
    }

    @Override
    public int getC_ConversionType_ID() {
        return MConversionType.getDefault(this.getAD_Client_ID());
    }

    @Override
    public boolean isReversalParent() {
        return this.getM_ProductionLine_ID() < this.getReversalLine_ID();
    }
}

