/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostElement;
import org.compiere.model.Query;
import org.compiere.model.X_M_Product_Category_Acct;
import org.compiere.util.CCache;

public class MProductCategoryAcct
extends X_M_Product_Category_Acct {
    private static final long serialVersionUID = 2075372131034904732L;
    private static CCache<String, MProductCategoryAcct> s_cache = new CCache("M_Product_Category_Acct", 40, 5);

    public static MProductCategoryAcct get(Properties ctx, int M_Product_Category_ID, int C_AcctSchema_ID, String trxName) {
        String key = M_Product_Category_ID + "#" + C_AcctSchema_ID;
        MProductCategoryAcct acct = s_cache.get(key);
        if (acct != null) {
            return acct;
        }
        String whereClause = "M_Product_Category_ID=? AND C_AcctSchema_ID=?";
        acct = (MProductCategoryAcct)new Query(ctx, "M_Product_Category_Acct", "M_Product_Category_ID=? AND C_AcctSchema_ID=?", trxName).setParameters(M_Product_Category_ID, C_AcctSchema_ID).firstOnly();
        if (acct != null) {
            s_cache.put(key, acct);
        }
        return acct;
    }

    public static MProductCategoryAcct get(Properties ctx, int M_Product_Category_ID, int C_AcctSchema_ID, int AD_Org_ID, String trxName) {
        MAcctSchema as = new MAcctSchema(ctx, C_AcctSchema_ID, trxName);
        if (!"O".equals(as.getCostingLevel())) {
            return MProductCategoryAcct.get(ctx, M_Product_Category_ID, C_AcctSchema_ID, trxName);
        }
        String key = M_Product_Category_ID + "#" + C_AcctSchema_ID + "#" + AD_Org_ID;
        MProductCategoryAcct acct = s_cache.get(key);
        if (acct != null) {
            return acct;
        }
        String whereClause = "M_Product_Category_ID=? AND C_AcctSchema_ID=? AND (AD_Org_ID=? OR AD_Org_ID = 0)";
        acct = (MProductCategoryAcct)new Query(ctx, "M_Product_Category_Acct", "M_Product_Category_ID=? AND C_AcctSchema_ID=? AND (AD_Org_ID=? OR AD_Org_ID = 0)", trxName).setParameters(M_Product_Category_ID, C_AcctSchema_ID, AD_Org_ID).setOrderBy("AD_Org_ID DESC").first();
        if (acct != null) {
            s_cache.put(key, acct);
        }
        return acct;
    }

    public MProductCategoryAcct(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MProductCategoryAcct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void checkCosting() {
        if (this.getCostingMethod() != null && this.getCostingMethod().length() > 0) {
            MCostElement.getMaterialCostElement(this);
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.checkCosting();
        return success;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProductCategoryAcct[");
        sb.append(this.get_ID()).append(",M_Product_Category_ID=").append(this.getM_Product_Category_ID()).append(",C_AcctSchema_ID=").append(this.getC_AcctSchema_ID()).append(",CostingLevel=").append(this.getCostingLevel()).append(",CostingMethod=").append(this.getCostingMethod()).append("]");
        return sb.toString();
    }
}

