/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelection;
import org.compiere.model.X_C_PaySelectionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.X_HR_Employee;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.model.X_HR_Payroll;

public class MPaySelectionLine
extends X_C_PaySelectionLine {
    private static final long serialVersionUID = -3486055138810301789L;
    private MInvoice invoice = null;
    private MOrder order = null;
    private X_HR_Movement movement = null;
    private MPaySelection parent = null;

    public MPaySelectionLine(Properties ctx, int payselectionlineId, String trxName) {
        super(ctx, payselectionlineId, trxName);
        if (payselectionlineId == 0) {
            this.setIsSOTrx(false);
            this.setOpenAmt(Env.ZERO);
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setDifferenceAmt(Env.ZERO);
            this.setIsManual(false);
        }
    }

    public MPaySelectionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySelectionLine(MPaySelection paySelection, int Line, String paymentRule) {
        this(paySelection.getCtx(), 0, paySelection.get_TrxName());
        this.setClientOrg(paySelection);
        this.setC_PaySelection_ID(paySelection.getC_PaySelection_ID());
        this.setLine(Line);
        if (paymentRule != null) {
            this.setPaymentRule(paymentRule);
        }
    }

    public void setInvoice(int invoiceId, int invoicepayscheduleId, boolean isSOTrx, BigDecimal openAmt, BigDecimal payAmt, BigDecimal discountAmt) {
        this.setC_Invoice_ID(invoiceId);
        this.set_ValueOfColumn("C_InvoicePaySchedule_ID", (Object)invoicepayscheduleId);
        this.setIsSOTrx(isSOTrx);
        this.setOpenAmt(openAmt);
        this.setPayAmt(payAmt);
        MInvoice invoice = new MInvoice(this.getCtx(), invoiceId, this.get_TrxName());
        if (invoice.getC_ConversionType_ID() > 0) {
            this.setC_ConversionType_ID(invoice.getC_ConversionType_ID());
        }
        this.setDiscountAmt(discountAmt);
        this.setDifferenceAmt(openAmt.subtract(payAmt).subtract(discountAmt));
    }

    public void setInvoice(int invoiceId, int invoicePayScheduleId, BigDecimal amtSource, BigDecimal openAmt, BigDecimal payAmt, BigDecimal discountAmt) {
        MInvoice invoice = new MInvoice(this.getCtx(), invoiceId, this.get_TrxName());
        this.setC_Invoice_ID(invoiceId);
        this.setIsSOTrx(invoice.isSOTrx());
        this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        if (this.getPaymentRule() == null && invoice.getPaymentRule() != null) {
            this.setPaymentRule(invoice.getPaymentRule());
        }
        this.setAmtSource(amtSource);
        this.setOpenAmt(openAmt);
        this.setPayAmt(payAmt);
        if (invoice.getC_ConversionType_ID() > 0) {
            this.setC_ConversionType_ID(invoice.getC_ConversionType_ID());
        }
        this.setDiscountAmt(discountAmt);
        this.setDifferenceAmt(openAmt.subtract(payAmt).subtract(discountAmt));
    }

    public void setOrder(int orderId, BigDecimal amtSource, BigDecimal openAmt, BigDecimal payAmt, BigDecimal discountAmt) {
        this.setC_Order_ID(orderId);
        MOrder order = new MOrder(this.getCtx(), orderId, this.get_TrxName());
        this.setIsSOTrx(order.isSOTrx());
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setIsPrepayment(true);
        if (this.getPaymentRule() == null && order.getPaymentRule() != null) {
            this.setPaymentRule(order.getPaymentRule());
        }
        this.setAmtSource(amtSource);
        this.setOpenAmt(openAmt);
        this.setPayAmt(payAmt);
        if (order.getC_ConversionType_ID() > 0) {
            this.setC_ConversionType_ID(order.getC_ConversionType_ID());
        }
        this.setDiscountAmt(discountAmt);
        this.setDifferenceAmt(openAmt.subtract(payAmt).subtract(discountAmt));
    }

    public void setHRMovement(X_HR_Movement movement, BigDecimal sourceAmount, BigDecimal convertedAmount) {
        Optional.ofNullable(movement.getHR_Process()).ifPresent(payrollProcess -> this.setHRMovement(movement, payrollProcess.getC_ConversionType_ID(), sourceAmount, convertedAmount));
    }

    public void setHRMovement(X_HR_Movement movement, int conversionTypeId, BigDecimal sourceAmount, BigDecimal convertedAmount) {
        MBPartner partner;
        X_HR_Payroll payroll;
        this.setHR_Movement_ID(movement.getHR_Movement_ID());
        this.setC_BPartner_ID(movement.getC_BPartner_ID());
        X_HR_Employee employee = (X_HR_Employee)movement.getHR_Employee();
        if (employee != null && employee.getPaymentRule() != null) {
            this.setPaymentRule(employee.getPaymentRule());
        }
        if (this.getPaymentRule() == null && (payroll = new X_HR_Payroll(this.getCtx(), movement.getHR_Payroll_ID(), this.get_TableName())).getPaymentRule() != null) {
            this.setPaymentRule(payroll.getPaymentRule());
        }
        if (this.getPaymentRule() == null && (partner = MBPartner.get(this.getCtx(), movement.getC_BPartner_ID())).getPaymentRulePO() != null) {
            this.setPaymentRule(partner.getPaymentRulePO());
        }
        if (this.getPaymentRule() == null) {
            this.setPaymentRule("S");
        }
        this.setIsSOTrx(false);
        this.setAmtSource(sourceAmount);
        this.setOpenAmt(Optional.ofNullable(convertedAmount).orElseGet(() -> sourceAmount));
        this.setPayAmt(Optional.ofNullable(convertedAmount).orElseGet(() -> sourceAmount));
        this.setC_ConversionType_ID(conversionTypeId);
        this.setDiscountAmt(Env.ZERO);
        this.setDifferenceAmt(Env.ZERO);
    }

    public void setPaySelectionLineParent(int payselectionlineId, BigDecimal payAmt, BigDecimal discountAmt) {
        this.setC_PaySelectionLine_Parent_ID(payselectionlineId);
        MPaySelectionLine paySelectionLine = new MPaySelectionLine(this.getCtx(), payselectionlineId, this.get_TrxName());
        this.setC_BPartner_ID(paySelectionLine.getC_BPartner_ID());
        this.setC_BP_BankAccount_ID(paySelectionLine.getC_BP_BankAccount_ID());
        this.setC_Order_ID(paySelectionLine.getC_Order_ID());
        this.setC_Invoice_ID(paySelectionLine.getC_Invoice_ID());
        this.setC_InvoicePaySchedule_ID(paySelectionLine.getC_InvoicePaySchedule_ID());
        this.setHR_Movement_ID(paySelectionLine.getHR_Movement_ID());
        this.setC_Charge_ID(paySelectionLine.getC_Charge_ID());
        this.setC_ConversionType_ID(paySelectionLine.getC_ConversionType_ID());
        this.setC_Conversion_Rate_ID(paySelectionLine.getC_Conversion_Rate_ID());
        this.setIsPrepayment(paySelectionLine.isPrepayment());
        this.setPaymentRule(paySelectionLine.getPaymentRule());
        this.setIsSOTrx(paySelectionLine.isSOTrx());
        this.setAmtSource(paySelectionLine.getAmtSource());
        this.setOpenAmt(paySelectionLine.getOpenAmt());
        this.setPayAmt(payAmt);
        this.setDiscountAmt(discountAmt);
        this.setDifferenceAmt(paySelectionLine.getOpenAmt().subtract(payAmt).subtract(discountAmt));
    }

    public void setCharge(int chargeId, int partnerId, String paymentRule, BigDecimal payAmt, boolean isSOTrx) {
        this.setC_Charge_ID(chargeId);
        MCharge charge = MCharge.get(this.getCtx(), chargeId);
        if (partnerId == 0) {
            partnerId = charge.getC_BPartner_ID();
        }
        this.setC_BPartner_ID(partnerId);
        this.setPaymentRule(paymentRule);
        this.setIsSOTrx(isSOTrx);
        this.setAmtSource(payAmt);
        this.setOpenAmt(payAmt);
        this.setPayAmt(payAmt);
        this.setDiscountAmt(Env.ZERO);
        this.setDifferenceAmt(Env.ZERO);
    }

    public MInvoice getInvoice() {
        if (this.invoice == null) {
            this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.invoice;
    }

    public MOrder getOrder() {
        if (this.order == null) {
            this.order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        }
        return this.order;
    }

    public X_HR_Movement getHRMovement() {
        if (this.movement == null) {
            this.movement = new X_HR_Movement(this.getCtx(), this.getHR_Movement_ID(), this.get_TrxName());
        }
        return this.movement;
    }

    public MPaySelection getParent() {
        if (this.parent == null) {
            this.parent = new MPaySelection(this.getCtx(), this.getC_PaySelection_ID(), this.get_TrxName());
        }
        return this.parent;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.validateBPartner();
        this.setDocumentValues();
        if (this.getC_BPartner_ID() == 0) {
            throw new AdempiereException("@C_BPartner_ID@ @NotFound@");
        }
        return true;
    }

    private void setDocumentValues() {
        boolean resetConversion = false;
        BigDecimal difference = Env.ZERO;
        BigDecimal discountAmt = this.getDiscountAmt();
        BigDecimal openAmt = this.getOpenAmt();
        if ((this.is_ValueChanged("C_Invoice_ID") || this.is_ValueChanged("C_Order_ID") || this.is_ValueChanged("HR_Movement_ID")) && (this.getC_Invoice_ID() != 0 || this.getC_Order_ID() != 0 || this.getHR_Movement_ID() != 0)) {
            difference = openAmt.subtract(this.getPayAmt()).subtract(discountAmt);
            this.setIsPrepayment(this.getC_Order_ID() != 0);
            boolean bl = resetConversion = this.getHR_Movement_ID() != 0;
            if (this.getC_Order_ID() != 0) {
                resetConversion = this.getOrder().getC_Currency_ID() == this.getParent().getC_Currency_ID();
                this.setC_BPartner_ID(this.getOrder().getC_BPartner_ID());
            } else if (this.getC_Invoice_ID() != 0) {
                resetConversion = this.getInvoice().getC_Currency_ID() == this.getParent().getC_Currency_ID();
                this.setC_BPartner_ID(this.getInvoice().getC_BPartner_ID());
            } else if (this.getHR_Movement_ID() != 0 && this.getC_Charge_ID() == 0) {
                X_HR_Movement movement = new X_HR_Movement(this.getCtx(), this.getHR_Movement_ID(), this.get_TrxName());
                X_HR_Payroll payroll = new X_HR_Payroll(this.getCtx(), movement.getHR_Payroll_ID(), this.get_TrxName());
                if (payroll.getHR_Payroll_ID() == 0) {
                    throw new AdempiereException("@HR_Payroll_ID@ @NotFound@");
                }
                if (payroll.getC_Charge_ID() == 0) {
                    throw new AdempiereException("@C_Charge_ID@ @NotFound@");
                }
                this.setC_Charge_ID(payroll.getC_Charge_ID());
                this.setC_BPartner_ID(movement.getC_BPartner_ID());
            }
        } else if (this.is_ValueChanged("C_Charge_ID") && this.getC_Charge_ID() != 0) {
            discountAmt = Env.ZERO;
            openAmt = Env.ZERO;
            this.setIsPrepayment(false);
        } else if (this.getC_Invoice_ID() == 0 && this.getC_Order_ID() == 0 && this.getHR_Movement_ID() == 0) {
            discountAmt = Env.ZERO;
            openAmt = Env.ZERO;
        }
        this.setDifferenceAmt(difference);
        this.setOpenAmt(openAmt);
        if (resetConversion) {
            this.setC_ConversionType_ID(0);
            this.setC_Conversion_Rate_ID(0);
        }
        if (!(!this.is_ValueChanged("PaymentRule") || this.getPaymentRule().equals("S") || this.getPaymentRule().equals("K") || this.getPaymentRule().equals("T") || this.getPaymentRule().equals("D"))) {
            this.setPaymentRule("S");
        }
    }

    private void validateBPartner() {
        if (this.is_ValueChanged("C_BPartner_ID")) {
            int partnerId = this.getC_BPartner_ID();
            if (this.getC_Invoice_ID() != 0) {
                partnerId = this.getInvoice().getC_BPartner_ID();
            } else if (this.getC_Order_ID() != 0) {
                partnerId = this.getC_Order().getC_BPartner_ID();
            } else if (this.getHR_Movement_ID() != 0) {
                partnerId = this.getHRMovement().getC_BPartner_ID();
            }
            if (partnerId != this.getC_BPartner_ID()) {
                throw new AdempiereException("@BPartnerDiff@");
            }
        } else if (this.getC_Invoice_ID() != 0) {
            this.setC_BPartner_ID(this.getInvoice().getC_BPartner_ID());
        } else if (this.getC_Order_ID() != 0) {
            this.setC_BPartner_ID(this.getOrder().getC_BPartner_ID());
        } else if (this.getHR_Movement_ID() != 0) {
            this.setC_BPartner_ID(this.getHRMovement().getC_BPartner_ID());
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.setHeader();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.setHeader();
        return success;
    }

    private void setHeader() {
        String sql = "UPDATE C_PaySelection ps SET TotalAmt = (SELECT COALESCE(SUM(psl.PayAmt),0) FROM C_PaySelectionLine psl WHERE ps.C_PaySelection_ID=psl.C_PaySelection_ID AND psl.IsActive='Y') WHERE C_PaySelection_ID=" + this.getC_PaySelection_ID();
        DB.executeUpdate(sql, this.get_TrxName());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPaySelectionLine[");
        sb.append(this.get_ID()).append(",C_Invoice_ID=").append(this.getC_Invoice_ID()).append(",PayAmt=").append(this.getPayAmt()).append(",DifferenceAmt=").append(this.getDifferenceAmt()).append("]");
        return sb.toString();
    }

    public boolean isPaid() {
        int noGeneratedPayments = DB.getSQLValue(this.get_TrxName(), "SELECT 1 FROM C_PaySelectionCheck psc WHERE psc.C_PaySelectionCheck_ID = ? AND EXISTS(SELECT 1 FROM C_Payment p \t\t\tWHERE p.C_Payment_ID = psc.C_Payment_ID\t\t\tAND p.DocStatus NOT IN('VO', 'RE'))", this.getC_PaySelectionCheck_ID());
        return noGeneratedPayments > 0;
    }

    public boolean isUsed() {
        int noGeneratedSelections = DB.getSQLValue(this.get_TrxName(), "SELECT 1 FROM C_PaySelection cps INNER JOIN C_PaySelectionLine cpsl ON(cpsl.C_PaySelection_ID = cps.C_PaySelection_ID)WHERE cps.DocStatus NOT IN('VO', 'RE')AND cpsl.C_PaySelectionLine_Parent_ID = ?", this.getC_PaySelectionLine_ID());
        return noGeneratedSelections > 0;
    }

    public boolean isValidConversion() {
        if (this.getC_Invoice_ID() == 0 && this.getC_Order_ID() == 0) {
            return true;
        }
        int currencyDocumentId = 0;
        int currencyId = this.getC_Currency_ID();
        if (this.getC_Invoice_ID() != 0) {
            currencyDocumentId = DB.getSQLValue(this.get_TrxName(), "SELECT i.C_Currency_ID FROM C_Invoice i WHERE i.C_Invoice_ID = ?", this.getC_Invoice_ID());
        } else if (this.getC_Order_ID() != 0) {
            currencyDocumentId = DB.getSQLValue(this.get_TrxName(), "SELECT o.C_Currency_ID FROM C_Order o WHERE o.C_Order_ID = ?", this.getC_Order_ID());
        }
        if (currencyDocumentId == currencyId) {
            return true;
        }
        if (this.getC_Conversion_Rate_ID() != 0) {
            MConversionRate conversionRate = MConversionRate.get(this.getCtx(), this.getC_Conversion_Rate_ID());
            if (conversionRate == null) {
                return false;
            }
            return conversionRate.getC_Currency_ID() == currencyDocumentId && conversionRate.getC_Currency_ID_To() == currencyId;
        }
        BigDecimal CurrencyRate = MConversionRate.getRate(currencyDocumentId, currencyId, this.getPayDate(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        return CurrencyRate != null;
    }

    private int getC_Currency_ID() {
        return this.getParent().getC_Currency_ID();
    }

    private Timestamp getPayDate() {
        return this.getParent().getPayDate();
    }

    @Override
    public void setPaymentRule(String PaymentRule) {
        if (PaymentRule == null || !this.getPaymentRule().equals("S") && !this.getPaymentRule().equals("K") && !this.getPaymentRule().equals("T") && !this.getPaymentRule().equals("D")) {
            PaymentRule = "S";
        }
        super.setPaymentRule(PaymentRule);
    }
}

