/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MFreightCategory;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MPackageLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MShipper;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_M_Package;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPackage
extends X_M_Package
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20200801L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private List<MPackageLine> linesList = null;

    public MPackage(Properties ctx, int M_Package_ID, String trxName) {
        super(ctx, M_Package_ID, trxName);
    }

    public MPackage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPackage(MInOut shipment, MShipper shipper) {
        this(shipment.getCtx(), 0, shipment.get_TrxName());
        this.setClientOrg(shipment);
        this.setM_InOut_ID(shipment.getM_InOut_ID());
        this.setM_Shipper_ID(shipper.getM_Shipper_ID());
        this.setC_BPartner_ID(shipment.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(shipment.getC_BPartner_Location_ID());
        this.setM_Warehouse_ID(shipment.getM_Warehouse_ID());
        this.setDeliveryViaRule(shipment.getDeliveryViaRule());
        Optional<String> maybeFreightCostRule = Optional.ofNullable(shipment.getFreightCostRule());
        Optional<BigDecimal> maybeFreightAmt = Optional.ofNullable(shipment.getFreightAmt());
        Optional<Integer> maybeFreightCategoryId = shipment.getM_FreightCategory_ID() > 0 ? Optional.of(shipment.getM_FreightCategory_ID()) : Optional.empty();
        Optional<Integer> maybeDocumentType = Optional.of(MDocType.getDocType("MMK", this.getAD_Org_ID()));
        maybeDocumentType.ifPresent(this::setC_DocType_ID);
        maybeFreightCostRule.ifPresent(this::setFreightCostRule);
        maybeFreightAmt.ifPresent(this::setFreightAmt);
        maybeFreightCategoryId.ifPresent(this::setM_FreightCategory_ID);
    }

    public MPackage(MMovement movement, MShipper shipper) {
        this(movement.getCtx(), 0, movement.get_TrxName());
        this.setClientOrg(movement);
        this.setM_Movement_ID(movement.getM_Movement_ID());
        this.setM_Shipper_ID(shipper.getM_Shipper_ID());
        this.setC_BPartner_ID(movement.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(movement.getC_BPartner_Location_ID());
        Optional<MWarehouse> maybeWarehouse = Arrays.stream(MWarehouse.getForOrg(this.getCtx(), movement.getAD_Org_ID())).findFirst();
        Optional<String> maybeFreightCostRule = Optional.ofNullable(movement.getFreightCostRule());
        Optional<BigDecimal> maybeFreightAmt = Optional.ofNullable(movement.getFreightAmt());
        Optional<Integer> maybeDocumentType = Optional.of(MDocType.getDocType("MMK", this.getAD_Org_ID()));
        maybeWarehouse.ifPresent(warehouse -> this.setM_Warehouse_ID(warehouse.getM_Warehouse_ID()));
        maybeFreightCostRule.ifPresent(this::setFreightCostRule);
        maybeFreightAmt.ifPresent(this::setFreightAmt);
        maybeDocumentType.ifPresent(this::setC_DocType_ID);
    }

    public static MPackage create(MInOut shipment, MShipper shipper, Timestamp shipDate) {
        MPackage pack = new MPackage(shipment, shipper);
        Optional<Timestamp> maybeShipDate = Optional.ofNullable(shipDate);
        maybeShipDate.ifPresent(pack::setShipDate);
        pack.saveEx();
        Arrays.asList(shipment.getLines(false)).forEach(inOutLine -> {
            MPackageLine packageLine = new MPackageLine(pack);
            packageLine.setInOutLine((MInOutLine)inOutLine);
            if (inOutLine.getM_Product_ID() > 0) {
                MProduct product = MProduct.get(shipment.getCtx(), inOutLine.getM_Product_ID());
                BigDecimal totalWeight = inOutLine.getMovementQty().multiply(product.getWeight());
                BigDecimal totalVolume = inOutLine.getMovementQty().multiply(product.getVolume());
                packageLine.setWeight(totalWeight);
                packageLine.setVolume(totalVolume);
            }
            packageLine.saveEx();
        });
        return pack;
    }

    public static MPackage create(MMovement movement, MShipper shipper, Timestamp shipDate) {
        MPackage pack = new MPackage(movement, shipper);
        Optional<Timestamp> maybeShipDate = Optional.ofNullable(shipDate);
        maybeShipDate.ifPresent(pack::setShipDate);
        pack.saveEx();
        Arrays.asList(movement.getLines(false)).forEach(movementLine -> {
            MPackageLine packageLine = new MPackageLine(pack);
            packageLine.setMovementLine((MMovementLine)movementLine);
            if (movementLine.getM_Product_ID() > 0) {
                MProduct product = MProduct.get(movement.getCtx(), movementLine.getM_Product_ID());
                BigDecimal totalWeight = movementLine.getMovementQty().multiply(product.getWeight());
                BigDecimal totalVolume = movementLine.getMovementQty().multiply(product.getVolume());
                packageLine.setWeight(totalWeight);
                packageLine.setVolume(totalVolume);
                packageLine.saveEx();
            }
        });
        return pack;
    }

    @Override
    public String getDocumentInfo() {
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return docType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public List<MPackageLine> getLines(boolean requery) {
        if (this.linesList == null || requery) {
            this.linesList = new Query(this.getCtx(), "M_PackageLine", "M_Package_ID = ?", this.get_TrxName()).setParameters(this.getM_Package_ID()).list();
        }
        return this.linesList;
    }

    public List<MPackageLine> getLines() {
        return this.getLines(false);
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), docType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ((newRecord || this.is_ValueChanged("M_Warehouse_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_BPartner_Location_ID")) && this.getM_InOut_ID() == 0 && this.getM_Movement_ID() == 0) {
            if (this.getM_Warehouse_ID() == 0) {
                throw new AdempiereException("@M_Warehouse_ID@ @IsMandatory@");
            }
            if (this.getC_BPartner_ID() == 0) {
                throw new AdempiereException("@C_BPartner_ID@ @IsMandatory@");
            }
            if (this.getC_BPartner_Location_ID() == 0) {
                throw new AdempiereException("@C_BPartner_Location_ID@ @IsMandatory@");
            }
        }
        if ((newRecord || this.is_ValueChanged("M_FreightCategory_ID")) && this.getM_FreightCategory_ID() != 0) {
            MFreightCategory freightCategory = MFreightCategory.getById(this.getCtx(), this.getM_FreightCategory_ID(), this.get_TrxName());
            this.setIsInvoiced(freightCategory.isInvoiced());
        }
        return super.beforeSave(newRecord);
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (docType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (docType.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int tableId, String[] docAction, String[] options, int index) {
        if (Table_ID == tableId) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        this.getLines(true);
        if (this.linesList != null) {
            this.linesList.forEach(line -> {
                line.setProcessed(processed);
                line.saveEx();
            });
        }
    }

    public void addDescription(String description) {
        Optional<String> maybeDescription = Optional.ofNullable(this.getDescription());
        if (!maybeDescription.isPresent()) {
            this.setDescription(description);
        } else {
            this.setDescription(maybeDescription.get() + " | " + description);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        int currencyId = 0;
        if (this.getM_InOut_ID() != 0) {
            MInOut delivery = (MInOut)this.getM_InOut();
            return delivery.getC_Order().getC_Currency_ID();
        }
        if (this.getM_Movement_ID() != 0) {
            MMovement movement = (MMovement)this.getM_Movement();
            return movement.getC_Currency_ID();
        }
        if (currencyId == 0) {
            currencyId = Env.getContextAsInt(this.getCtx(), "$C_Currency_ID");
        }
        return currencyId;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MMPackage[").append(this.getSummary()).append("]");
        return sb.toString();
    }
}

