/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovementConfirm;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Movement;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;

public class MMovement
extends X_M_Movement
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = -1628932946440487727L;
    private MMovementLine[] movementLines = null;
    private MMovementConfirm[] movementConfirms = null;
    private String processMessage = null;
    private boolean justPrepared = false;
    private boolean m_reversal = false;

    public MMovement(Properties ctx, int movementId, String trxName) {
        super(ctx, movementId, trxName);
        if (movementId == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setIsInTransit(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setPosted(false);
            super.setProcessed(false);
        }
    }

    public MMovement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovement(MDDOrder order, Timestamp movementDate) {
        super(order.getCtx(), 0, order.get_TrxName());
        this.setDD_Order_ID(order.getDD_Order_ID());
        this.setAD_User_ID(order.getAD_User_ID());
        this.setPOReference(order.getPOReference());
        this.setReversal_ID(0);
        this.setM_Shipper_ID(order.getM_Shipper_ID());
        this.setDescription(order.getDescription());
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setAD_Org_ID(order.getAD_Org_ID());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setAD_User_ID(order.getAD_User_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setC_Charge_ID(order.getC_Charge_ID());
        this.setChargeAmt(order.getChargeAmt());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
        this.setUser3_ID(order.getUser3_ID());
        this.setUser4_ID(order.getUser4_ID());
        this.setPriorityRule(order.getPriorityRule());
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDeliveryRule(order.getDeliveryRule());
        this.setDeliveryViaRule(order.getDeliveryViaRule());
        this.setDocStatus("DR");
        this.setDocAction("PR");
        this.setFreightCostRule(order.getFreightCostRule());
        this.setFreightAmt(order.getFreightAmt());
        this.setSalesRep_ID(order.getSalesRep_ID());
    }

    public MMovementLine[] getLines(boolean requery) {
        if (this.movementLines != null && !requery) {
            MMovement.set_TrxName(this.movementLines, this.get_TrxName());
            return this.movementLines;
        }
        String whereClause = "M_Movement_ID=?";
        List<MMovementLine> list = new Query(this.getCtx(), "M_MovementLine", "M_Movement_ID=?", this.get_TrxName()).setParameters(this.getM_Movement_ID()).setOrderBy("Line").list();
        this.movementLines = new MMovementLine[list.size()];
        list.toArray(this.movementLines);
        return this.movementLines;
    }

    public MMovementConfirm[] getConfirmations(boolean requery) {
        if (this.movementConfirms != null && !requery) {
            return this.movementConfirms;
        }
        List<MMovementConfirm> list = new Query(this.getCtx(), "M_MovementConfirm", "M_Movement_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.movementConfirms = list.toArray(new MMovementConfirm[list.size()]);
        return this.movementConfirms;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            MDocType[] docTypes = MDocType.getOfDocBaseType(this.getCtx(), "MMM");
            if (docTypes.length > 0) {
                this.setC_DocType_ID(docTypes[0].getC_DocType_ID());
            } else {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @C_DocType_ID@"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_MovementLine SET Processed=? WHERE M_Movement_ID=?";
        int noLine = DB.executeUpdateEx("UPDATE M_MovementLine SET Processed=? WHERE M_Movement_ID=?", new Object[]{processed, this.get_ID()}, this.get_TrxName());
        this.movementLines = null;
        this.log.fine("Processed=" + processed + " - Lines=" + noLine);
    }

    @Override
    public boolean processIt(String processAction) {
        this.processMessage = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMessage != null) {
            return "IN";
        }
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), docType.getDocBaseType(), this.getAD_Org_ID())) {
            this.processMessage = "@PeriodClosed@";
            return "IN";
        }
        MMovementLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.processMessage = "@NoLines@";
            return "IN";
        }
        if (docType.isInTransit() && !this.isReversal()) {
            this.createConfirmation();
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMessage != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void createConfirmation() {
        MMovementConfirm[] movementConfirms = this.getConfirmations(false);
        if (movementConfirms.length > 0) {
            return;
        }
        MMovementConfirm.create(this, false);
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        MMovementLine[] movementLines;
        MMovementConfirm[] movementConfirms;
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMessage != null) {
            return "IN";
        }
        for (MMovementConfirm movementConfirm : movementConfirms = this.getConfirmations(true)) {
            if (movementConfirm.isProcessed()) continue;
            this.processMessage = "Open: @M_MovementConfirm_ID@ - " + movementConfirm.getDocumentNo();
            return "IP";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        for (MMovementLine movementLine : movementLines = this.getLines(false)) {
            MTransaction transactionFrom = null;
            MProduct product = movementLine.getProduct();
            if (product == null || !product.isStocked()) continue;
            if (!this.isReversal()) {
                this.checkMaterialPolicy(movementLine);
            }
            if (movementLine.getM_AttributeSetInstance_ID() == 0) {
                MMovementLineMA[] movementLineMAS = MMovementLineMA.get(this.getCtx(), movementLine.getM_MovementLine_ID(), this.get_TrxName());
                for (int j = 0; j < movementLineMAS.length; ++j) {
                    MMovementLineMA movementLineMA = movementLineMAS[j];
                    MLocator locator = new MLocator(this.getCtx(), movementLine.getM_Locator_ID(), this.get_TrxName());
                    MLocator locatorTo = new MLocator(this.getCtx(), movementLine.getM_LocatorTo_ID(), this.get_TrxName());
                    if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), movementLine.getM_Locator_ID(), movementLine.getM_Product_ID(), movementLineMA.getM_AttributeSetInstance_ID(), 0, movementLineMA.getMovementQty().negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        this.processMessage = "Cannot correct Inventory (MA)";
                        return "IN";
                    }
                    int attributeSetInstanceToId = movementLine.getM_AttributeSetInstanceTo_ID();
                    if (attributeSetInstanceToId == 0 && movementLine.getM_Locator_ID() != movementLine.getM_LocatorTo_ID()) {
                        attributeSetInstanceToId = movementLineMA.getM_AttributeSetInstance_ID();
                    }
                    if (!MStorage.add(this.getCtx(), locatorTo.getM_Warehouse_ID(), movementLine.getM_LocatorTo_ID(), movementLine.getM_Product_ID(), attributeSetInstanceToId, 0, movementLineMA.getMovementQty(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        this.processMessage = "Cannot correct Inventory (MA)";
                        return "IN";
                    }
                    transactionFrom = new MTransaction(this.getCtx(), locator.getAD_Org_ID(), "M-", movementLine.getM_Locator_ID(), movementLine.getM_Product_ID(), movementLineMA.getM_AttributeSetInstance_ID(), movementLineMA.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
                    transactionFrom.setM_MovementLine_ID(movementLine.getM_MovementLine_ID());
                    if (!transactionFrom.save()) {
                        this.processMessage = "Transaction From not inserted (MA)";
                        return "IN";
                    }
                    MTransaction transactionTo = new MTransaction(this.getCtx(), locatorTo.getAD_Org_ID(), "M+", movementLine.getM_LocatorTo_ID(), movementLine.getM_Product_ID(), attributeSetInstanceToId, movementLineMA.getMovementQty(), this.getMovementDate(), this.get_TrxName());
                    transactionTo.setAD_Org_ID(locatorTo.getAD_Org_ID());
                    transactionTo.setM_MovementLine_ID(movementLine.getM_MovementLine_ID());
                    if (transactionTo.save()) continue;
                    this.processMessage = "Transaction To not inserted (MA)";
                    return "IN";
                }
            }
            if (transactionFrom != null) continue;
            MLocator locator = new MLocator(this.getCtx(), movementLine.getM_Locator_ID(), this.get_TrxName());
            MLocator locatorTo = new MLocator(this.getCtx(), movementLine.getM_LocatorTo_ID(), this.get_TrxName());
            if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), movementLine.getM_Locator_ID(), movementLine.getM_Product_ID(), movementLine.getM_AttributeSetInstance_ID(), 0, movementLine.getMovementQty().negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                this.processMessage = "Cannot correct Inventory (MA)";
                return "IN";
            }
            if (!MStorage.add(this.getCtx(), locatorTo.getM_Warehouse_ID(), movementLine.getM_LocatorTo_ID(), movementLine.getM_Product_ID(), movementLine.getM_AttributeSetInstanceTo_ID(), 0, movementLine.getMovementQty(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                this.processMessage = "Cannot correct Inventory (MA)";
                return "IN";
            }
            transactionFrom = new MTransaction(this.getCtx(), locator.getAD_Org_ID(), "M-", movementLine.getM_Locator_ID(), movementLine.getM_Product_ID(), movementLine.getM_AttributeSetInstance_ID(), movementLine.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
            transactionFrom.setM_MovementLine_ID(movementLine.getM_MovementLine_ID());
            if (!transactionFrom.save()) {
                this.processMessage = "Transaction From not inserted";
                return "IN";
            }
            MTransaction transactionTo = new MTransaction(this.getCtx(), locatorTo.getAD_Org_ID(), "M+", movementLine.getM_LocatorTo_ID(), movementLine.getM_Product_ID(), movementLine.getM_AttributeSetInstanceTo_ID(), movementLine.getMovementQty(), this.getMovementDate(), this.get_TrxName());
            transactionTo.setM_MovementLine_ID(movementLine.getM_MovementLine_ID());
            transactionTo.setAD_Org_ID(locatorTo.getAD_Org_ID());
            if (transactionTo.save()) continue;
            this.processMessage = "Transaction To not inserted";
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.processMessage = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        Boolean isOverwrite;
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (docType.isOverwriteDateOnComplete()) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        }
        if (docType.isOverwriteSeqOnComplete() && (isOverwrite = Boolean.valueOf(!this.isReversal() || this.isReversal() && !docType.isCopyDocNoOnReversal())).booleanValue() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private void checkMaterialPolicy(MMovementLine line) {
        int no = MMovementLineMA.deleteMovementLineMA(line.getM_MovementLine_ID(), this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        boolean needSave = false;
        if (line.getM_AttributeSetInstance_ID() == 0) {
            MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
            String issuePolicy = product.getMMPolicy();
            MStorage[] storages = MStorage.getWarehouse(this.getCtx(), 0, line.getM_Product_ID(), 0, null, "F".equals(issuePolicy), true, line.getM_Locator_ID(), this.get_TrxName());
            BigDecimal qtyToDeliver = line.getMovementQty();
            for (MStorage storage : storages) {
                MMovementLineMA movementLineMA;
                if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                    movementLineMA = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                    movementLineMA.saveEx();
                    qtyToDeliver = Env.ZERO;
                    this.log.fine(movementLineMA + ", QtyToDeliver=" + qtyToDeliver);
                } else {
                    movementLineMA = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                    movementLineMA.saveEx();
                    qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                    this.log.fine(movementLineMA + ", QtyToDeliver=" + qtyToDeliver);
                }
                if (qtyToDeliver.signum() == 0) break;
            }
            if (qtyToDeliver.signum() != 0) {
                MAttributeSet.validateAttributeSetInstanceMandatory(product, MMovementLine.Table_ID, false, line.getM_AttributeSetInstance_ID());
                MAttributeSetInstance attributeSetInstance = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                int attributeSetInstanceId = attributeSetInstance.getM_AttributeSetInstance_ID();
                MMovementLineMA movementLineMA = new MMovementLineMA(line, attributeSetInstanceId, qtyToDeliver);
                movementLineMA.saveEx();
                this.log.fine("##: " + movementLineMA);
            }
        }
        if (needSave) {
            line.saveEx();
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMessage != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMessage = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MMovementLine[] movementLines = this.getLines(false);
            for (int i2 = 0; i2 < movementLines.length; ++i2) {
                MMovementLine movementLine = movementLines[i2];
                BigDecimal oldMovementLine = movementLine.getMovementQty();
                if (oldMovementLine.compareTo(Env.ZERO) == 0) continue;
                movementLine.setMovementQty(Env.ZERO);
                movementLine.addDescription("Void (" + oldMovementLine + ")");
                movementLine.saveEx();
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMessage != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMessage != null) {
            return false;
        }
        this.setDocAction("--");
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMessage == null;
    }

    @Override
    public MMovement reverseIt(boolean isAccrual) {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate(this.getCtx(), "#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElseGet(() -> currentDate) : this.getMovementDate();
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, docType.getDocBaseType(), this.getAD_Org_ID());
        MMovement reversalMovement = new MMovement(this.getCtx(), 0, this.get_TrxName());
        MMovement.copyValues(this, reversalMovement, this.getAD_Client_ID(), this.getAD_Org_ID());
        reversalMovement.setDocStatus("DR");
        reversalMovement.setDocAction("CO");
        reversalMovement.setIsApproved(false);
        reversalMovement.setIsInTransit(false);
        reversalMovement.setPosted(false);
        reversalMovement.setProcessed(false);
        reversalMovement.set_ValueNoCheck("DocumentNo", null);
        reversalMovement.addDescription("{->" + this.getDocumentNo() + ")");
        reversalMovement.setReversal_ID(this.getM_Movement_ID());
        reversalMovement.setReversal(true);
        if (docType.isCopyDocNoOnReversal()) {
            reversalMovement.setDocumentNo(this.getDocumentNo() + Msg.getMsg(reversalMovement.getCtx(), "^"));
        }
        if (!reversalMovement.save()) {
            this.processMessage = "Could not create Movement Reversal";
            return null;
        }
        reversalMovement.setReversal(true);
        Arrays.stream(this.getLines(true)).forEach(movementLine -> {
            MMovementLine reversalMovementLine = new MMovementLine(this.getCtx(), 0, this.get_TrxName());
            MMovement.copyValues(movementLine, reversalMovementLine, movementLine.getAD_Client_ID(), movementLine.getAD_Org_ID());
            reversalMovementLine.setM_Movement_ID(reversalMovement.getM_Movement_ID());
            reversalMovementLine.setReversalLine_ID(movementLine.getM_MovementLine_ID());
            reversalMovementLine.setMovementQty(movementLine.getMovementQty().negate());
            reversalMovementLine.setTargetQty(movementLine.getTargetQty().negate());
            reversalMovementLine.setScrappedQty(movementLine.getScrappedQty().negate());
            reversalMovementLine.setConfirmedQty(movementLine.getConfirmedQty().negate());
            reversalMovementLine.setProcessed(false);
            reversalMovementLine.saveEx();
            MMovementLineMA[] mas = MMovementLineMA.get(this.getCtx(), movementLine.getM_MovementLine_ID(), this.get_TrxName());
            Arrays.stream(mas).forEach(lineMA -> {
                MMovementLineMA reverseLine = new MMovementLineMA(reversalMovementLine, lineMA.getM_AttributeSetInstance_ID(), lineMA.getMovementQty().negate());
                reverseLine.saveEx();
            });
        });
        Arrays.stream(this.getConfirmations(true)).forEach(movementConfirm -> movementConfirm.reverseCorrectIt());
        Arrays.stream(this.getConfirmations(true)).filter(movementConfirm -> movementConfirm.getReversal_ID() > 0).forEach(movementConfirm -> {
            Arrays.stream(reversalMovement.getLines(true)).forEach(reversalMovementLine -> Arrays.stream(movementConfirm.getLines(true)).filter(movementLineConfirm -> movementLineConfirm.getM_MovementLine_ID() == reversalMovementLine.getReversalLine_ID()).forEach(movementLineConfirm -> {
                movementLineConfirm.setM_MovementLine_ID(reversalMovementLine.getM_MovementLine_ID());
                movementLineConfirm.saveEx();
            }));
            movementConfirm.setM_Movement_ID(reversalMovement.getM_Movement_ID());
            movementConfirm.setIsReversal(true);
            movementConfirm.saveEx();
        });
        if (!reversalMovement.processIt("CO")) {
            this.processMessage = "Reversal ERROR: " + reversalMovement.getProcessMsg();
            return null;
        }
        reversalMovement.closeIt();
        reversalMovement.setDocStatus("RE");
        reversalMovement.setDocAction("--");
        reversalMovement.saveEx();
        this.processMessage = reversalMovement.getDocumentNo();
        this.addDescription("(" + reversalMovement.getDocumentNo() + "<-)");
        this.setReversal_ID(reversalMovement.getM_Movement_ID());
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return reversalMovement;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMessage != null) {
            return false;
        }
        MMovement reversalMovement = this.reverseIt(true);
        if (reversalMovement == null) {
            return false;
        }
        this.processMessage = reversalMovement.getDocumentNo();
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 13);
        return this.processMessage == null;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.processMessage == null;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMessage != null) {
            return false;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.processMessage != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        stringBuffer.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMessage;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    @Override
    public boolean isReversal() {
        return this.m_reversal;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    private boolean isSameCostDimension(MAcctSchema as, MTransaction trxFrom, MTransaction trxTo) {
        if (trxFrom.getM_Product_ID() != trxTo.getM_Product_ID()) {
            throw new AdempiereException("Same product is needed - " + trxFrom + ", " + trxTo);
        }
        MProduct product = MProduct.get(this.getCtx(), trxFrom.getM_Product_ID());
        String costingLevel = product.getCostingLevel(as, trxFrom.getAD_Org_ID());
        int orgId = trxFrom.getAD_Org_ID();
        int orgToId = trxTo.getAD_Org_ID();
        int attributeSetInstanceId = trxFrom.getM_AttributeSetInstance_ID();
        int attributeSetInstanceToId = trxTo.getM_AttributeSetInstance_ID();
        if ("C".equals(costingLevel)) {
            orgId = 0;
            orgToId = 0;
            attributeSetInstanceId = 0;
            attributeSetInstanceToId = 0;
        } else if ("O".equals(costingLevel)) {
            attributeSetInstanceId = 0;
            attributeSetInstanceToId = 0;
        } else if ("B".equals(costingLevel)) {
            orgId = 0;
            orgToId = 0;
        }
        return orgId == orgToId && attributeSetInstanceId == attributeSetInstanceToId;
    }
}

