/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MBPGroup;
import org.compiere.model.MConversionRate;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_MatchPO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MMatchPO
extends X_M_MatchPO
implements IDocumentLine {
    private static final long serialVersionUID = 7189366329684552916L;
    private static CLogger s_log = CLogger.getCLogger(MMatchPO.class);
    private boolean isInOutLineChange = false;
    private MOrderLine orderLine = null;
    private MInvoiceLine invoiceLine = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMatchPO[] get(Properties ctx, int orderLineId, int invoiceLineId, String trxName) {
        if (orderLineId == 0 || invoiceLineId == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=? AND C_InvoiceLine_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, orderLineId);
            pstmt.setInt(2, invoiceLineId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static List<MMatchPO> getInOutLine(MInOutLine inOutLine) {
        return new Query(inOutLine.getCtx(), "M_MatchPO", "M_InOutLine_ID=?", inOutLine.get_TrxName()).setClient_ID().setParameters(inOutLine.getM_InOutLine_ID()).list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MMatchPO[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        if (M_InOut_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO m INNER JOIN M_InOutLine l ON (m.M_InOutLine_ID=l.M_InOutLine_ID) WHERE l.M_InOut_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_InOut_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static List<MMatchPO> getByInOutId(Properties ctx, int inOutId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("Reversal_ID IS NULL AND EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchPO.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)");
        return new Query(ctx, "M_MatchPO", whereClause.toString(), trxName).setClient_ID().setParameters(inOutId).list();
    }

    public static List<MMatchPO> getByInvoiceId(Properties ctx, int invoiceId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("Reversal_ID IS NULL AND EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchPO.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)");
        return new Query(ctx, "M_MatchPO", whereClause.toString(), trxName).setClient_ID().setParameters(invoiceId).list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MMatchPO[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        if (C_Invoice_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO mi INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) WHERE il.C_Invoice_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Invoice_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MMatchPO[] getOrderLine(Properties ctx, int C_OrderLine_ID, String trxName) {
        if (C_OrderLine_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_OrderLine_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchPO(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MMatchPO create(MInvoiceLine iLine, MInOutLine sLine, Timestamp dateTrx, BigDecimal qty) {
        String trxName = null;
        Properties ctx = null;
        int C_OrderLine_ID = 0;
        if (iLine != null) {
            trxName = iLine.get_TrxName();
            ctx = iLine.getCtx();
            C_OrderLine_ID = iLine.getC_OrderLine_ID();
        }
        if (sLine != null) {
            trxName = sLine.get_TrxName();
            ctx = sLine.getCtx();
            C_OrderLine_ID = sLine.getC_OrderLine_ID();
        }
        MMatchPO retValue = null;
        String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_OrderLine_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MMatchPO mpo = new MMatchPO(ctx, rs, trxName);
                if (qty.compareTo(mpo.getQty()) != 0) continue;
                if (iLine != null) {
                    if (mpo.getC_InvoiceLine_ID() != 0 && mpo.getC_InvoiceLine_ID() != iLine.getC_InvoiceLine_ID()) continue;
                    mpo.setC_InvoiceLine_ID(iLine);
                    if (iLine.getM_AttributeSetInstance_ID() != 0) {
                        if (mpo.getM_AttributeSetInstance_ID() == 0) {
                            mpo.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
                        } else if (mpo.getM_AttributeSetInstance_ID() != iLine.getM_AttributeSetInstance_ID()) continue;
                    }
                }
                if (sLine != null) {
                    if (mpo.getM_InOutLine_ID() != 0 && mpo.getM_InOutLine_ID() != sLine.getM_InOutLine_ID()) continue;
                    mpo.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                    if (sLine.getM_AttributeSetInstance_ID() != 0) {
                        if (mpo.getM_AttributeSetInstance_ID() == 0) {
                            mpo.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                        } else if (mpo.getM_AttributeSetInstance_ID() != sLine.getM_AttributeSetInstance_ID()) continue;
                    }
                }
                retValue = mpo;
                break;
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null) {
            if (sLine != null) {
                retValue = new MMatchPO(sLine, dateTrx, qty);
                if (iLine != null) {
                    retValue.setC_InvoiceLine_ID(iLine);
                }
            } else if (iLine != null) {
                retValue = new MMatchPO(iLine, dateTrx, qty);
            }
        }
        return retValue;
    }

    public MMatchPO(Properties ctx, int matchPOId, String trxName) {
        super(ctx, matchPOId, trxName);
        if (matchPOId == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchPO(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchPO(MInOutLine inOutLine, Timestamp dateTrx, BigDecimal qty) {
        this(inOutLine.getCtx(), 0, inOutLine.get_TrxName());
        this.setClientOrg(inOutLine);
        this.setM_InOutLine_ID(inOutLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(inOutLine.getC_OrderLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
            this.setDateAcct(dateTrx);
        }
        this.setM_Product_ID(inOutLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(inOutLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public MMatchPO(MInvoiceLine invoiceLine, Timestamp dateTrx, BigDecimal qty) {
        this(invoiceLine.getCtx(), 0, invoiceLine.get_TrxName());
        this.setClientOrg(invoiceLine);
        this.setC_InvoiceLine_ID(invoiceLine);
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(invoiceLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(invoiceLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public void setC_InvoiceLine_ID(MInvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
        if (invoiceLine == null) {
            this.setC_InvoiceLine_ID(0);
        } else {
            this.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
        }
    }

    @Override
    public void setC_InvoiceLine_ID(int invoiceLineId) {
        int old = this.getC_InvoiceLine_ID();
        if (old != invoiceLineId) {
            super.setC_InvoiceLine_ID(invoiceLineId);
        }
    }

    public MInvoiceLine getInvoiceLine() {
        if (this.invoiceLine == null && this.getC_InvoiceLine_ID() != 0) {
            this.invoiceLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        }
        return this.invoiceLine;
    }

    @Override
    public void setM_InOutLine_ID(int inOutLineId) {
        int old = this.getM_InOutLine_ID();
        if (old != inOutLineId) {
            super.setM_InOutLine_ID(inOutLineId);
            this.isInOutLineChange = true;
        }
    }

    public void setC_OrderLine_ID(MOrderLine orderLine) {
        this.orderLine = orderLine;
        if (orderLine == null) {
            this.setC_OrderLine_ID(0);
        } else {
            this.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
        }
    }

    public MOrderLine getOrderLine() {
        if (this.orderLine == null && this.getC_OrderLine_ID() != 0 || this.getC_OrderLine_ID() != this.orderLine.getC_OrderLine_ID()) {
            this.orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
        }
        return this.orderLine;
    }

    public BigDecimal getInvoicePriceActual() {
        int orderCurrency_ID;
        MInvoiceLine invoiceLine = this.getInvoiceLine();
        MInvoice invoice = invoiceLine.getParent();
        MOrder order = this.getOrderLine().getParent();
        BigDecimal priceActual = invoiceLine.getPriceActual();
        int invoiceCurrency_ID = invoice.getC_Currency_ID();
        if (invoiceCurrency_ID != (orderCurrency_ID = order.getC_Currency_ID())) {
            priceActual = MConversionRate.convert(this.getCtx(), priceActual, invoiceCurrency_ID, orderCurrency_ID, invoice.getDateInvoiced(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        }
        return priceActual;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp newerDateAcct = this.getNewerDateAcct();
            if (newerDateAcct == null) {
                newerDateAcct = this.getDateTrx();
            }
            this.setDateAcct(newerDateAcct);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine inOutLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(inOutLine.getM_AttributeSetInstance_ID());
        }
        if (this.getC_OrderLine_ID() == 0) {
            MInOutLine iol;
            MInvoiceLine invoiceLine = null;
            if (this.getC_InvoiceLine_ID() != 0 && (invoiceLine = this.getInvoiceLine()).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(invoiceLine.getC_OrderLine_ID());
            }
            if (this.getC_OrderLine_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                if (invoiceLine != null) {
                    invoiceLine.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                    invoiceLine.save();
                }
            }
        }
        if (this.getC_OrderLine_ID() != 0 && this.getC_InvoiceLine_ID() != 0 && (newRecord || this.is_ValueChanged("C_OrderLine_ID") || this.is_ValueChanged("C_InvoiceLine_ID"))) {
            BigDecimal invoicePrice;
            BigDecimal purchaseOrderPrice = this.getOrderLine().getPriceActual();
            BigDecimal difference = purchaseOrderPrice.subtract(invoicePrice = this.getInvoicePriceActual());
            if (difference.signum() != 0) {
                difference = difference.multiply(this.getQty());
                this.setPriceMatchDifference(difference);
                MBPGroup group = MBPGroup.getOfBPartner(this.getCtx(), this.getOrderLine().getC_BPartner_ID());
                BigDecimal priceMatchTolerance = group.getPriceMatchTolerance();
                if (priceMatchTolerance != null && priceMatchTolerance.signum() != 0) {
                    BigDecimal purchaseOrderAmount = purchaseOrderPrice.multiply(this.getQty());
                    BigDecimal maxTolerance = purchaseOrderAmount.multiply(priceMatchTolerance);
                    maxTolerance = maxTolerance.abs().divide(Env.ONEHUNDRED, 2, 4);
                    boolean ok = (difference = difference.abs()).compareTo(maxTolerance) <= 0;
                    this.log.config("Difference=" + this.getPriceMatchDifference() + ", Max=" + maxTolerance + " => " + ok);
                    this.setIsApproved(ok);
                }
            } else {
                this.setPriceMatchDifference(difference);
                this.setIsApproved(true);
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            MInOutLine inOutLine = (MInOutLine)this.getM_InOutLine();
            for (MTransaction trx : MTransaction.getByInOutLine(inOutLine)) {
                if (!inOutLine.getM_Product().getProductType().equals("I") || trx == null) continue;
                CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createCostDetail(trx, this);
            }
            boolean validateOrderedQty = MSysConfig.getBooleanValue("VALIDATE_MATCHING_TO_ORDERED_QTY", true, Env.getAD_Client_ID(Env.getCtx()));
            if (validateOrderedQty) {
                BigDecimal deliveredQty;
                if (this.getC_OrderLine_ID() > 0 && this.getM_InOutLine_ID() > 0 && this.getC_InvoiceLine_ID() <= 0 && (deliveredQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE M_InOutLine_ID > 0 and C_OrderLine_ID=? AND Reversal_ID IS NULL", this.getC_OrderLine_ID())) != null && deliveredQty.compareTo(this.getOrderLine().getQtyOrdered()) > 0) {
                    throw new IllegalStateException("Total matched delivered qty > ordered qty. MatchedDeliveredQty=" + deliveredQty + ", OrderedQty=" + this.orderLine.getQtyOrdered() + ", Line=" + this.orderLine);
                }
                if (this.getC_OrderLine_ID() > 0 && this.getC_InvoiceLine_ID() > 0) {
                    MOrderLine orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
                    BigDecimal invoicedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE C_InvoiceLine_ID > 0 and C_OrderLine_ID=? AND Reversal_ID IS NULL", this.getC_OrderLine_ID());
                    if (invoicedQty != null && invoicedQty.compareTo(orderLine.getQtyOrdered()) > 0) {
                        throw new IllegalStateException("Total matched invoiced qty > ordered qty. MatchedInvoicedQty=" + invoicedQty + ", OrderedQty=" + orderLine.getQtyOrdered() + ", Line=" + orderLine);
                    }
                }
            }
        }
        if (success && this.getC_OrderLine_ID() != 0) {
            MInOutLine iol;
            MOrderLine orderLine = this.getOrderLine();
            if (this.isInOutLineChange && (newRecord || this.getM_InOutLine_ID() != this.get_ValueOldAsInt("M_InOutLine_ID"))) {
                BigDecimal quantity = this.getQty();
                if (this.getM_InOutLine_ID() != 0) {
                    if (orderLine.getParent().isReturnOrder()) {
                        quantity = quantity.negate();
                    }
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().add(quantity));
                } else {
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(quantity));
                }
                orderLine.setDateDelivered(this.getDateTrx());
            }
            if (this.getC_InvoiceLine_ID() > 0 && newRecord) {
                orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().add(this.getQty()));
                orderLine.setDateInvoiced(this.getDateTrx());
                orderLine.saveEx();
            }
            if (orderLine.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getMovementQty().compareTo(orderLine.getQtyOrdered()) == 0) {
                orderLine.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            }
            return orderLine.save();
        }
        return success;
    }

    public Timestamp getNewerDateAcct() {
        String sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
        Timestamp shipDate = DB.getSQLValueTS(null, sql, this.getM_InOutLine_ID());
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXP", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(Table_ID, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success && this.getC_OrderLine_ID() != 0) {
            MOrderLine orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
            BigDecimal quantity = this.getQty();
            if (this.getM_InOutLine_ID() != 0) {
                if (orderLine.getParent().isReturnOrder()) {
                    quantity = quantity.negate();
                }
                orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(quantity));
            }
            if (this.getC_InvoiceLine_ID() != 0) {
                orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(quantity));
            }
            return orderLine.save(this.get_TrxName());
        }
        return success;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MMatchPO[");
        sb.append(this.get_ID()).append(",Qty=").append(this.getQty()).append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID()).append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID()).append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolidate(Properties ctx) {
        String sql = "SELECT * FROM M_MatchPO po WHERE EXISTS (SELECT 1 FROM M_MatchPO x WHERE po.C_OrderLine_ID=x.C_OrderLine_ID AND po.Qty=x.Qty GROUP BY C_OrderLine_ID, Qty HAVING COUNT(*) = 2)  AND AD_Client_ID=?ORDER BY C_OrderLine_ID, M_InOutLine_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int success = 0;
        int errors = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MMatchPO po1 = new MMatchPO(ctx, rs, null);
                if (!rs.next()) continue;
                MMatchPO po2 = new MMatchPO(ctx, rs, null);
                if (po1.getM_InOutLine_ID() == 0 || po1.getC_InvoiceLine_ID() != 0 || po2.getM_InOutLine_ID() != 0 || po2.getC_InvoiceLine_ID() == 0) continue;
                String s1 = "UPDATE M_MatchPO SET C_InvoiceLine_ID=" + po2.getC_InvoiceLine_ID() + " WHERE M_MatchPO_ID=" + po1.getM_MatchPO_ID();
                int no1 = DB.executeUpdate(s1, null);
                if (no1 != 1) {
                    ++errors;
                    s_log.warning("Not updated M_MatchPO_ID=" + po1.getM_MatchPO_ID());
                    continue;
                }
                String s2 = "DELETE FROM Fact_Acct WHERE AD_Table_ID=473 AND Record_ID=?";
                int no2 = DB.executeUpdate(s2, po2.getM_MatchPO_ID(), null);
                String s3 = "DELETE FROM M_MatchPO WHERE M_MatchPO_ID=?";
                int no3 = DB.executeUpdate(s3, po2.getM_MatchPO_ID(), null);
                if (no2 == 0 && no3 == 1) {
                    ++success;
                    continue;
                }
                s_log.warning("M_MatchPO_ID=" + po2.getM_MatchPO_ID() + " - Deleted=" + no2 + ", Acct=" + no3);
                ++errors;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (errors != 0 || success != 0) {
            s_log.info("Success #" + success + " - Error #" + errors);
        }
    }

    @Override
    public int getM_Locator_ID() {
        return -1;
    }

    @Override
    public BigDecimal getMovementQty() {
        return this.getQty();
    }

    @Override
    public BigDecimal getPriceActual() {
        return MConversionRate.convertBase(this.getCtx(), this.getOrderLine().getPriceActual(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
    }

    @Override
    public BigDecimal getPriceActualCurrency() {
        return this.getOrderLine().getPriceActual();
    }

    @Override
    public int getC_Currency_ID() {
        return DB.getSQLValue(this.get_TrxName(), "SELECT o.C_Currency_ID FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.C_OrderLine_ID = ? ", this.getC_OrderLine_ID());
    }

    @Override
    public int getC_ConversionType_ID() {
        return DB.getSQLValue(this.get_TrxName(), "SELECT o.C_ConversionType_ID FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.C_OrderLine_ID = ? ", this.getC_OrderLine_ID());
    }

    @Override
    public int getReversalLine_ID() {
        return -1;
    }

    @Override
    public boolean isSOTrx() {
        return false;
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    @Override
    public int getC_DocType_ID() {
        return -1;
    }

    public MMatchPO reverseIt(Timestamp reversalDate) {
        if (this.isProcessed() && this.getReversal_ID() == 0) {
            int reversalLineId;
            MMatchPO reversal = new MMatchPO(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(this, reversal);
            reversal.setC_OrderLine_ID(this.getC_OrderLine_ID());
            if (this.getC_InvoiceLine_ID() > 0) {
                reversalLineId = this.getC_InvoiceLine().getReversalLine_ID();
                if (reversalLineId > 0) {
                    reversal.setC_InvoiceLine_ID(reversalLineId);
                } else {
                    reversal.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
                }
            }
            if (this.getM_InOutLine_ID() > 0) {
                reversalLineId = this.getM_InOutLine().getReversalLine_ID();
                if (reversalLineId > 0) {
                    reversal.setM_InOutLine_ID(reversalLineId);
                } else {
                    reversal.setM_InOutLine_ID(this.getM_InOutLine_ID());
                }
            }
            reversal.setAD_Org_ID(this.getAD_Org_ID());
            reversal.setDescription("(->" + this.getDocumentNo() + ")");
            reversal.setQty(this.getQty().negate());
            reversal.setDateAcct(reversalDate);
            reversal.setDateTrx(reversalDate);
            reversal.set_ValueNoCheck("DocumentNo", null);
            reversal.setPosted(false);
            reversal.setReversal_ID(this.getM_MatchPO_ID());
            reversal.saveEx();
            this.setDescription("(" + reversal.getDocumentNo() + "<-)");
            this.setReversal_ID(reversal.getM_MatchPO_ID());
            this.saveEx();
            return reversal;
        }
        return null;
    }

    @Override
    public boolean isReversalParent() {
        return false;
    }
}

