/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.model.MIMPProcessorParameter;
import org.compiere.model.Query;
import org.compiere.model.X_IMP_Processor;
import org.compiere.model.X_IMP_ProcessorParameter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class MIMPProcessor
extends X_IMP_Processor
implements AdempiereProcessor {
    private static final long serialVersionUID = 8634765494025824138L;
    private static CLogger s_log = CLogger.getCLogger(MIMPProcessor.class);
    private static MIMPProcessor processor = null;
    private List<MIMPProcessorParameter> parameters = null;

    public void cleanInstance() {
        processor = null;
    }

    public static MIMPProcessor get(Properties ctx, int impProcessorId, String trxName) {
        if (processor == null) {
            processor = new MIMPProcessor(ctx, impProcessorId, trxName);
        }
        return processor;
    }

    public MIMPProcessor(Properties ctx, int importProcessorId, String trxName) {
        super(ctx, importProcessorId, trxName);
        if (importProcessorId == 0) {
            this.setName("Default Import Processor");
            this.setFrequencyType("H");
            this.setFrequency(1);
            this.setKeepLogDays(7);
        }
    }

    public MIMPProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MIMPProcessorLog> list = new ArrayList<MIMPProcessorLog>();
        String sql = "SELECT * FROM IMP_ProcessorLog WHERE IMP_Processor_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getIMP_Processor_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MIMPProcessorLog(this.getCtx(), rs, this.get_TrxName()));
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
        AdempiereProcessorLog[] retValue = new MIMPProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE IMP_ProcessorLog WHERE IMP_Processor_ID=" + this.getIMP_Processor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    @Override
    public String getServerID() {
        return "ReplicationProcessor" + this.get_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MIMPProcessor[] getActive(Properties ctx) {
        ArrayList<MIMPProcessor> list = new ArrayList<MIMPProcessor>();
        String sql = "SELECT * FROM IMP_Processor WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MIMPProcessor(ctx, rs, null));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            pstmt = null;
        }
        DB.close(rs, pstmt);
        pstmt = null;
        MIMPProcessor[] retValue = new MIMPProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public X_IMP_ProcessorParameter[] getIMP_ProcessorParameters(String trxName) {
        this.getProcessorParameters();
        return this.parameters.toArray(new X_IMP_ProcessorParameter[0]);
    }

    public List<MIMPProcessorParameter> getProcessorParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = new Query(this.getCtx(), "IMP_ProcessorParameter", "IMP_Processor_ID = ?", this.get_TrxName()).setParameters(this.getIMP_Processor_ID()).setOnlyActiveRecords(true).list();
        return this.parameters;
    }

    public int getParameterAsInt(String key) {
        Optional<MIMPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent() && !Util.isEmpty(maybeParameter.get().getParameterValue())) {
            try {
                return Integer.parseInt(maybeParameter.get().getParameterValue());
            }
            catch (NumberFormatException ex) {
                s_log.warning(ex.getLocalizedMessage());
            }
        }
        return 0;
    }

    public String getParameterAsString(String key) {
        Optional<MIMPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent()) {
            return maybeParameter.get().getParameterValue();
        }
        return null;
    }

    public boolean getValueAsBoolean(String key) {
        Optional<MIMPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent()) {
            return Util.isEmpty(maybeParameter.get().getParameterValue()) && (maybeParameter.get().getParameterValue().equals("Y") || maybeParameter.get().getParameterValue().equals("true"));
        }
        return false;
    }

    public BigDecimal getValueAsBigDecimal(String key) {
        Optional<MIMPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        BigDecimal bigDecimalValue = null;
        if (maybeParameter.isPresent() && !Util.isEmpty(maybeParameter.get().getParameterValue())) {
            try {
                bigDecimalValue = new BigDecimal(maybeParameter.get().getParameterValue());
            }
            catch (Exception e) {
                s_log.warning(e.getLocalizedMessage());
            }
        }
        return bigDecimalValue;
    }

    public Timestamp getValueAsDate(String key, String pattern) {
        Optional<MIMPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent() && !Util.isEmpty(maybeParameter.get().getParameterValue())) {
            try {
                return Timestamp.valueOf(maybeParameter.get().getParameterValue());
            }
            catch (Exception e) {
                s_log.warning(e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.cleanInstance();
        return super.afterSave(newRecord, success);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.cleanInstance();
        return super.afterDelete(success);
    }

    @Override
    public String toString() {
        return "MIMPProcessor [getIMP_Processor_ID()=" + this.getIMP_Processor_ID() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

