/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MEXPProcessorParameter;
import org.compiere.model.Query;
import org.compiere.model.X_EXP_Processor;
import org.compiere.model.X_EXP_ProcessorParameter;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public class MEXPProcessor
extends X_EXP_Processor {
    private static final long serialVersionUID = -2925330684523283775L;
    private static CLogger s_log = CLogger.getCLogger(MEXPProcessor.class);
    private static MEXPProcessor processor = null;
    private List<MEXPProcessorParameter> parameters = null;

    public void cleanInstance() {
        processor = null;
    }

    public static MEXPProcessor get(Properties ctx, int EXP_Processor_ID, String trxName) {
        if (processor == null) {
            processor = new MEXPProcessor(ctx, EXP_Processor_ID, trxName);
        }
        return processor;
    }

    public MEXPProcessor(Properties ctx, int EXP_Processor_ID, String trxName) {
        super(ctx, EXP_Processor_ID, trxName);
    }

    public MEXPProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public X_EXP_ProcessorParameter[] getEXP_ProcessorParameters(String trxName) {
        this.getProcessorParameters();
        return this.parameters.toArray(new X_EXP_ProcessorParameter[0]);
    }

    public List<MEXPProcessorParameter> getProcessorParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = new Query(this.getCtx(), "EXP_ProcessorParameter", "EXP_Processor_ID = ?", this.get_TrxName()).setParameters(this.getEXP_Processor_ID()).setOnlyActiveRecords(true).list();
        return this.parameters;
    }

    public int getParameterAsInt(String key) {
        Optional<MEXPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent() && !Util.isEmpty(maybeParameter.get().getParameterValue())) {
            try {
                return Integer.parseInt(maybeParameter.get().getParameterValue());
            }
            catch (NumberFormatException ex) {
                s_log.warning(ex.getLocalizedMessage());
            }
        }
        return 0;
    }

    public String getParameterAsString(String key) {
        Optional<MEXPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent()) {
            return maybeParameter.get().getParameterValue();
        }
        return null;
    }

    public boolean getValueAsBoolean(String key) {
        Optional<MEXPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent()) {
            return Util.isEmpty(maybeParameter.get().getParameterValue()) && (maybeParameter.get().getParameterValue().equals("Y") || maybeParameter.get().getParameterValue().equals("true"));
        }
        return false;
    }

    public BigDecimal getValueAsBigDecimal(String key) {
        Optional<MEXPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        BigDecimal bigDecimalValue = null;
        if (maybeParameter.isPresent() && !Util.isEmpty(maybeParameter.get().getParameterValue())) {
            try {
                bigDecimalValue = new BigDecimal(maybeParameter.get().getParameterValue());
            }
            catch (Exception e) {
                s_log.warning(e.getLocalizedMessage());
            }
        }
        return bigDecimalValue;
    }

    public Timestamp getValueAsDate(String key, String pattern) {
        Optional<MEXPProcessorParameter> maybeParameter = this.getProcessorParameters().stream().filter(parameter -> parameter.getValue().equals(key)).findFirst();
        if (maybeParameter.isPresent() && !Util.isEmpty(maybeParameter.get().getParameterValue())) {
            try {
                return Timestamp.valueOf(maybeParameter.get().getParameterValue());
            }
            catch (Exception e) {
                s_log.warning(e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.cleanInstance();
        return super.afterSave(newRecord, success);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.cleanInstance();
        return super.afterDelete(success);
    }

    @Override
    public String toString() {
        return "MEXPProcessor [getEXP_Processor_ID()=" + this.getEXP_Processor_ID() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

