/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MProductCategory;
import org.compiere.model.X_M_DiscountSchemaBreak;

public class MDiscountSchemaBreak
extends X_M_DiscountSchemaBreak {
    private static final long serialVersionUID = 6413962940750128351L;

    public MDiscountSchemaBreak(Properties ctx, int M_DiscountSchemaBreak_ID, String trxName) {
        super(ctx, M_DiscountSchemaBreak_ID, trxName);
    }

    public MDiscountSchemaBreak(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean applies(BigDecimal value, int productId, int productCategoryId) {
        if (!this.isActive()) {
            return false;
        }
        if (value.compareTo(this.getBreakValue()) < 0) {
            return false;
        }
        if (this.getM_Product_ID() == 0 && this.getM_Product_Category_ID() == 0) {
            return true;
        }
        if (this.getM_Product_ID() == productId) {
            return true;
        }
        if (productCategoryId != 0 && this.getM_Product_Category_ID() == productCategoryId) {
            return true;
        }
        return MProductCategory.isCategory(this.getM_Product_Category_ID(), productId);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_Product_ID() > 0 && this.getM_Product_Category_ID() > 0) {
            this.setM_Product_Category_ID(I_ZERO);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MDiscountSchemaBreak[");
        sb.append(this.get_ID()).append("-Seq=").append(this.getSeqNo());
        if (this.getM_Product_Category_ID() != 0) {
            sb.append(",M_Product_Category_ID=").append(this.getM_Product_Category_ID());
        }
        if (this.getM_Product_ID() != 0) {
            sb.append(",M_Product_ID=").append(this.getM_Product_ID());
        }
        sb.append(",Break=").append(this.getBreakValue());
        if (this.isBPartnerFlatDiscount()) {
            sb.append(",FlatDiscount");
        } else {
            sb.append(",Discount=").append(this.getBreakDiscount());
        }
        sb.append("]");
        return sb.toString();
    }
}

