/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.compiere.FA.feature.UseLife;
import org.compiere.FA.feature.UseLifeImpl;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MDepreciation;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MDepreciationWorkfile
extends X_A_Depreciation_Workfile
implements UseLife {
    private static final long serialVersionUID = -3814417671427820714L;
    private MAsset m_asset = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private static CCache<MultiKey, MDepreciationWorkfile> s_cacheAsset = new CCache("A_Depreciation_Workfile_Asset", 10);
    private boolean m_isFiscal = false;
    private boolean m_buildDepreciation = false;

    public MDepreciationWorkfile(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setPostingType("A");
            this.setA_QTY_Current(Env.ZERO);
            this.setA_Asset_Cost(Env.ZERO);
            this.setA_Accumulated_Depr(Env.ZERO);
            this.setA_Period_Posted(0);
            this.setA_Current_Period(0);
        }
    }

    public MDepreciationWorkfile(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MAsset getAsset() {
        return this.getAsset(false);
    }

    public MAsset getAsset(boolean bl) {
        if (this.m_asset == null || bl) {
            this.m_asset = MAsset.get(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
        }
        if (this.m_asset.get_ID() <= 0) {
            this.m_asset = null;
        }
        return this.m_asset;
    }

    public void setAsset(MAsset mAsset) {
        this.setA_Asset_ID(mAsset.get_ID());
        this.m_asset = mAsset;
    }

    @Override
    public Timestamp getAssetServiceDate() {
        MAsset mAsset = this.getAsset();
        if (mAsset == null) {
            return null;
        }
        return mAsset.getAssetServiceDate();
    }

    protected boolean afterSave(boolean bl) {
        if (this.m_buildDepreciation) {
            this.buildDepreciation();
        }
        return true;
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        MAsset mAsset;
        this.log.info("Entering: trxName=" + this.get_TrxName());
        if (bl) {
            this.setA_Life_Period(this.getUseLifeMonths());
            this.setA_Asset_Life_Years(this.getUseLifeYears());
            this.setA_Life_Period_F(this.getUseLifeMonths_F());
            this.setA_Asset_Life_Years_F(this.getUseLifeYears_F());
        }
        if ("AC".equals((mAsset = this.getAsset(true)).getA_Asset_Status()) && this.isFullyDepreciated()) {
            mAsset.changeStatus("DP", null);
            mAsset.saveEx();
        }
        if (this.is_ValueChanged("DateAcct")) {
            this.setDateAcct(TimeUtil.getMonthLastDay(this.getDateAcct()));
        }
        BigDecimal bigDecimal = this.getA_Asset_Cost();
        BigDecimal bigDecimal2 = this.getA_Accumulated_Depr();
        this.setA_Asset_Remaining(bigDecimal.subtract(bigDecimal2));
        BigDecimal bigDecimal3 = this.getA_Accumulated_Depr_F();
        this.setA_Asset_Remaining_F(bigDecimal.subtract(bigDecimal3));
        String string = null;
        if (bl || this.is_ValueChanged("A_Asset_Cost")) {
            string = "A_Asset_Cost";
        } else if (this.is_ValueChanged("A_Valoare_Cofinantare")) {
            string = "A_Valoare_Cofinantare";
        } else if (this.is_ValueChanged("A_Valoare_Tert")) {
            string = "A_Valoare_Tert";
        }
        MDepreciationWorkfile.updateFinantare(this, string);
        this.log.info("Leaving: trxName=" + this.get_TrxName() + " [RETURN TRUE]");
        return true;
    }

    public boolean isFullyDepreciated() {
        if (!this.getPostingType().equals("A")) {
            return false;
        }
        BigDecimal bigDecimal = this.getRemainingCost(null, false);
        BigDecimal bigDecimal2 = this.getRemainingCost(null, true);
        if (bigDecimal.signum() == 0 && bigDecimal2.signum() == 0) {
            return this.getA_Asset_Cost().signum() != 0;
        }
        return false;
    }

    public MDepreciationWorkfile(MAsset mAsset, String string, MAssetGroupAcct mAssetGroupAcct) {
        this(mAsset.getCtx(), 0, mAsset.get_TrxName());
        this.setA_Asset_ID(mAsset.getA_Asset_ID());
        this.setAD_Org_ID(mAsset.getAD_Org_ID());
        this.setA_Asset_Cost(mAsset.getA_Asset_Cost());
        this.setA_Accumulated_Depr(mAsset.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(mAsset.getA_Accumulated_Depr_F());
        this.setA_Current_Period(mAsset.getA_Current_Period());
        this.setIsDepreciated(mAsset.isDepreciated());
        this.setPostingType(string);
        if (mAssetGroupAcct == null) {
            mAssetGroupAcct = MAssetGroupAcct.forA_Asset_Group_ID(mAsset.getCtx(), mAsset.getA_Asset_Group_ID(), string, null);
        }
        UseLifeImpl.copyValues(this, mAssetGroupAcct);
        Timestamp timestamp = mAsset.getDateAcct();
        if (timestamp != null) {
            timestamp = TimeUtil.addMonths(timestamp, 1);
            this.setDateAcct(timestamp);
        }
        if (mAsset.getUseLifeMonths() > 0) {
            UseLifeImpl.get(this, false).setUseLifeMonths(mAsset.getUseLifeMonths());
        }
        if (mAsset.getUseLifeMonths_F() > 0) {
            UseLifeImpl.get(this, true).setUseLifeMonths(mAsset.getUseLifeMonths_F());
        }
        this.dump();
    }

    public static List<MDepreciationWorkfile> forA_Asset_ID(Properties properties, int n, String string) {
        return new Query(properties, "A_Depreciation_Workfile", "A_Asset_ID=?", string).setParameters(n).list();
    }

    public static MDepreciationWorkfile get(Properties properties, int n, String string) {
        return MDepreciationWorkfile.get(properties, n, string, null);
    }

    public static MDepreciationWorkfile get(Properties properties, int n, String string, String string2) {
        MDepreciationWorkfile mDepreciationWorkfile;
        if (n <= 0 || string == null) {
            return null;
        }
        MultiKey multiKey = new MultiKey((Object)n, (Object)string);
        if (string2 == null && (mDepreciationWorkfile = s_cacheAsset.get(multiKey)) != null) {
            return mDepreciationWorkfile;
        }
        MDepreciationWorkfile mDepreciationWorkfile2 = (MDepreciationWorkfile)new Query(properties, "A_Depreciation_Workfile", "A_Asset_ID=? AND PostingType=? ", string2).setParameters(n, string).firstOnly();
        if (string2 == null && mDepreciationWorkfile2 != null) {
            s_cacheAsset.put(multiKey, mDepreciationWorkfile2);
        }
        return mDepreciationWorkfile2;
    }

    public Timestamp getLastActionDate() {
        return TimeUtil.getMonthLastDay(TimeUtil.addMonths(this.getDateAcct(), -1));
    }

    public boolean isDepreciated(Timestamp timestamp) {
        Timestamp timestamp2 = this.getLastActionDate();
        boolean bl = !timestamp.after(timestamp2);
        this.log.fine("LastActionDate=" + timestamp2 + ", GivenDate=" + timestamp + " => isDepreciated=" + bl);
        return bl;
    }

    public MAssetAcct getA_AssetAcct(Timestamp timestamp, String string) {
        return MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), timestamp, string);
    }

    public BigDecimal getActualCost() {
        return this.getActualCost(this.getA_Asset_Cost());
    }

    public BigDecimal getActualCost(BigDecimal bigDecimal) {
        return bigDecimal.subtract(this.getA_Salvage_Value());
    }

    public void adjustCost(BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl) {
        BigDecimal bigDecimal3 = Env.ZERO;
        BigDecimal bigDecimal4 = Env.ZERO;
        if (!bl) {
            bigDecimal3 = this.getA_Asset_Cost();
            bigDecimal4 = this.getA_QTY_Current();
        }
        bigDecimal3 = bigDecimal3.add(bigDecimal);
        bigDecimal4 = bigDecimal4.add(bigDecimal2);
        this.setA_Asset_Cost(bigDecimal3);
        this.setA_QTY_Current(bigDecimal4);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("adjustCost(" + bigDecimal + ", " + bigDecimal2 + ", reset=" + bl + ") => amt=" + this.getA_Asset_Cost() + ", qty=" + this.getA_QTY_Current());
        }
    }

    public boolean adjustAccumulatedDepr(BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl) {
        if (bigDecimal == null) {
            bigDecimal = Env.ZERO;
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = Env.ZERO;
        }
        this.setA_Accumulated_Depr(bigDecimal.add(bl ? Env.ZERO : this.getA_Accumulated_Depr()));
        this.setA_Accumulated_Depr_F(bigDecimal2.add(bl ? Env.ZERO : this.getA_Accumulated_Depr_F()));
        return true;
    }

    public void adjustUseLife(int n, int n2, boolean bl) {
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Entering: deltaUseLifeYears=" + n + ", deltaUseLifeYears_F=" + n2);
        }
        UseLifeImpl.get(this, false).adjustUseLifeYears(n, bl);
        UseLifeImpl.get(this, true).adjustUseLifeYears(n2, bl);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Leaving");
        }
    }

    public int getUseLifeMonths(boolean bl) {
        return bl ? this.getUseLifeMonths_F() : this.getUseLifeMonths();
    }

    public BigDecimal getA_Accumulated_Depr(boolean bl) {
        return bl ? this.getA_Accumulated_Depr_F() : this.getA_Accumulated_Depr();
    }

    public BigDecimal getAccumulatedCost() {
        return this.getA_Accumulated_Depr(this.isFiscal());
    }

    public BigDecimal getReevaluationCost() {
        return Env.ZERO;
    }

    public BigDecimal getRemainingCost(BigDecimal bigDecimal, boolean bl) {
        BigDecimal bigDecimal2 = this.getActualCost();
        if (bigDecimal == null) {
            bigDecimal = this.getA_Accumulated_Depr(bl);
        }
        return bigDecimal2.subtract(bigDecimal);
    }

    public BigDecimal getRemainingCost(BigDecimal bigDecimal) {
        return this.getRemainingCost(bigDecimal, this.isFiscal());
    }

    public int getRemainingPeriods(int n, MDepreciation mDepreciation) {
        int n2 = this.getUseLifeMonths(this.isFiscal());
        if (mDepreciation != null) {
            n2 += mDepreciation.getFixMonthOffset();
        }
        int n3 = n >= 0 ? n : this.getA_Current_Period();
        return n2 - n3;
    }

    public int getRemainingPeriods(int n) {
        return this.getRemainingPeriods(n, null);
    }

    public boolean isFiscal() {
        return this.m_isFiscal;
    }

    public void setFiscal(boolean bl) {
        this.m_isFiscal = bl;
    }

    public void incA_Current_Period() {
        int n = this.getA_Current_Period();
        Timestamp timestamp = this.getDateAcct();
        int n2 = n + 1;
        Timestamp timestamp2 = TimeUtil.addMonths(this.getDateAcct(), 1);
        this.setA_Current_Period(n2);
        this.setDateAcct(timestamp2);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("(A_Current_Period, DateAcct)=(" + n + ", " + timestamp + ")->(" + n2 + ", " + timestamp2 + ")");
        }
    }

    public void setA_Current_Period() {
        String string = "A_Asset_ID=? AND PostingType=? AND Processed=? AND IsActive=?";
        MDepreciationExp mDepreciationExp = (MDepreciationExp)new Query(this.getCtx(), "A_Depreciation_Exp", string, this.get_TrxName()).setParameters(this.getA_Asset_ID(), this.getPostingType(), true, true).setOrderBy("A_Period DESC,DateAcct DESC").first();
        if (mDepreciationExp != null) {
            this.setA_Current_Period(mDepreciationExp.getA_Period());
            this.setDateAcct(mDepreciationExp.getDateAcct());
            this.incA_Current_Period();
        } else {
            this.log.info("There are no records from which to infer its");
        }
    }

    public void buildDepreciation() {
        int n;
        if (!this.isDepreciated()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.load(this.get_TrxName());
        MAssetAcct mAssetAcct = this.getA_AssetAcct(null, this.get_TrxName());
        MDepreciation mDepreciation = MDepreciation.get(this.getCtx(), mAssetAcct.getA_Depreciation_ID());
        MDepreciation mDepreciation2 = MDepreciation.get(this.getCtx(), mAssetAcct.getA_Depreciation_F_ID());
        int n2 = 0;
        int n3 = 0;
        BigDecimal bigDecimal = this.getActualCost();
        BigDecimal bigDecimal2 = this.getA_Accumulated_Depr(false);
        BigDecimal bigDecimal3 = this.getA_Accumulated_Depr(true);
        int n4 = this.getUseLifeMonths(false) + n2;
        int n5 = this.getUseLifeMonths(true) + n3;
        int n6 = n4 > n5 ? n4 : n5;
        BigDecimal bigDecimal4 = Env.ZERO;
        BigDecimal bigDecimal5 = Env.ZERO;
        if (CLogMgt.isLevelFine()) {
            stringBuffer.append("currentPeriod=" + this.getA_Current_Period() + ", AssetServiceDate=" + this.getAssetDepreciationDate() + "\n");
            stringBuffer.append("offset: C|F=" + n2 + "|" + n3 + "\n");
            stringBuffer.append("life: C|F=" + n4 + "|" + n5 + " + offset =" + n6 + "\n");
        }
        this.truncDepreciation();
        int n7 = n = this.getA_Current_Period();
        int n8 = 1;
        while (n7 <= n6) {
            bigDecimal4 = Env.ZERO;
            bigDecimal5 = Env.ZERO;
            String string = "" + bigDecimal2 + "|" + bigDecimal3 + " + ";
            if (n4 > n7 || !mDepreciation.requireLastPeriodAdjustment()) {
                this.setFiscal(false);
                bigDecimal4 = mDepreciation.invoke(this, mAssetAcct, n7, bigDecimal2);
                bigDecimal2 = bigDecimal2.add(bigDecimal4);
            } else if (n4 == n7) {
                bigDecimal4 = bigDecimal.subtract(bigDecimal2);
                bigDecimal2 = bigDecimal;
            }
            if (n5 > n7 || !mDepreciation2.requireLastPeriodAdjustment()) {
                this.setFiscal(true);
                bigDecimal5 = mDepreciation2.invoke(this, mAssetAcct, n7, bigDecimal3);
                bigDecimal3 = bigDecimal3.add(bigDecimal5);
            } else if (n5 == n7) {
                bigDecimal5 = bigDecimal.subtract(bigDecimal3);
                bigDecimal3 = bigDecimal;
            }
            string = string + "" + bigDecimal4 + "|" + bigDecimal5 + " = " + bigDecimal2 + "|" + bigDecimal3;
            int n9 = 0;
            Timestamp timestamp = TimeUtil.getMonthLastDay(TimeUtil.addMonths(this.getDateAcct(), n9 += n7 - n));
            MDepreciationExp.createDepreciation(this, n7, timestamp, bigDecimal4, bigDecimal5, bigDecimal2, bigDecimal3, string, this.get_TrxName());
            if (CLogMgt.isLevelFine()) {
                String string2 = "" + n8 + ": period=" + n7 + "/" + n4 + "|" + n5 + ", exp=" + bigDecimal4 + "|" + bigDecimal5 + ", accumDep=" + bigDecimal2 + "|" + bigDecimal3 + ", DateAcct=" + timestamp;
                this.log.fine("=> " + string2 + Env.NL + Env.NL);
                stringBuffer.append(string2 + Env.NL);
            }
            ++n7;
            ++n8;
        }
        this.log.fine(stringBuffer.toString());
        this.m_buildDepreciation = false;
    }

    public void truncDepreciation() {
        String string = this.get_TrxName();
        int n = this.getA_Current_Period();
        Object[] objectArray = new Object[]{false, n, this.getA_Asset_ID(), this.getPostingType()};
        int n2 = DB.executeUpdateEx("DELETE FROM A_Depreciation_Exp WHERE Processed=? AND A_Period>=? AND A_Asset_ID=? AND PostingType=?", objectArray, string);
        this.log.fine("sql=DELETE FROM A_Depreciation_Exp WHERE Processed=? AND A_Period>=? AND A_Asset_ID=? AND PostingType=?\nDeleted #" + n2);
    }

    public static void updateFinantare(SetGetModel setGetModel, String string) {
        BigDecimal bigDecimal = SetGetUtil.get_AttrValueAsBigDecimal(setGetModel, "A_Valoare_Cofinantare");
        BigDecimal bigDecimal2 = SetGetUtil.get_AttrValueAsBigDecimal(setGetModel, "A_Asset_Cost");
        BigDecimal bigDecimal3 = SetGetUtil.get_AttrValueAsBigDecimal(setGetModel, "A_Valoare_Tert");
        if (bigDecimal.signum() == 0 && bigDecimal3.signum() == 0) {
            bigDecimal = bigDecimal2;
            bigDecimal3 = Env.ZERO;
        } else if ("A_Asset_Cost".equals(string)) {
            bigDecimal = bigDecimal2.subtract(bigDecimal3);
        } else if ("A_Valoare_Cofinantare".equals(string)) {
            bigDecimal3 = bigDecimal2.subtract(bigDecimal);
        } else if ("A_Valoare_Tert".equals(string)) {
            bigDecimal = bigDecimal2.subtract(bigDecimal3);
        } else {
            bigDecimal3 = bigDecimal2.subtract(bigDecimal);
        }
        String string2 = "C";
        if (bigDecimal3.signum() == 0) {
            string2 = "P";
        } else if (bigDecimal.signum() == 0) {
            string2 = "T";
        }
        setGetModel.set_AttrValue("A_Tip_Finantare", string2);
        setGetModel.set_AttrValue("A_Valoare_Cofinantare", bigDecimal);
        setGetModel.set_AttrValue("A_Valoare_Tert", bigDecimal3);
        if ("P".equals(string2) && SetGetUtil.isPersistent(setGetModel)) {
            setGetModel.set_AttrValue("A_FundingMode_ID", null);
        }
    }

    @Override
    public boolean set_AttrValue(String string, Object object) {
        int n = this.get_ColumnIndex(string);
        if (n < 0) {
            return false;
        }
        return this.set_ValueNoCheck(string, object);
    }

    @Override
    public Object get_AttrValue(String string) {
        int n = this.get_ColumnIndex(string);
        if (n < 0) {
            return null;
        }
        return this.get_Value(n);
    }

    @Override
    public boolean is_AttrValueChanged(String string) {
        int n = this.get_ColumnIndex(string);
        if (n < 0) {
            return false;
        }
        return this.is_ValueChanged(n);
    }
}

