/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MImage;
import org.compiere.model.X_AD_Color;
import org.compiere.plaf.CompiereColor;

public class MColor
extends X_AD_Color {
    private static final long serialVersionUID = 8672637038417465668L;

    public MColor(Properties ctx, int AD_Color_ID, String trxName) {
        super(ctx, AD_Color_ID, trxName);
        if (AD_Color_ID == 0) {
            this.setName("-/-");
        }
    }

    public MColor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        return "MColor[ID=" + this.get_ID() + " - " + this.getName() + "]";
    }

    @Override
    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        this.log.config(this.p_info.getColumnName(index));
        if (index == this.get_ColumnIndex("ColorType")) {
            return rs.getString(index + 1);
        }
        return null;
    }

    @Override
    protected String saveNewSpecial(Object value, int index) {
        String colName = this.p_info.getColumnName(index);
        String colValue = value == null ? "null" : value.getClass().toString();
        this.log.fine(colName + "=" + colValue);
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    public CompiereColor getAdempiereColor() {
        if (this.get_ID() == 0) {
            return null;
        }
        String ColorType = this.getColorType();
        if (ColorType == null) {
            this.log.log(Level.SEVERE, "MColor.getAdempiereColor - No ColorType");
            return null;
        }
        CompiereColor cc = null;
        if (ColorType.equals("F")) {
            cc = new CompiereColor(this.getColor(true), true);
        } else if (ColorType.equals("G")) {
            int RepeatDistance = this.getRepeatDistance();
            String StartPoint = this.getStartPoint();
            int startPoint = StartPoint == null ? 0 : Integer.parseInt(StartPoint);
            cc = new CompiereColor(this.getColor(true), this.getColor(false), startPoint, RepeatDistance);
        } else if (ColorType.equals("L")) {
            int LineWidth = this.getLineWidth();
            int LineDistance = this.getLineDistance();
            cc = new CompiereColor(this.getColor(false), this.getColor(true), LineWidth, LineDistance);
        } else if (ColorType.equals("T")) {
            int AD_Image_ID = this.getAD_Image_ID();
            String url = this.getURL(AD_Image_ID);
            if (url == null) {
                return null;
            }
            BigDecimal ImageAlpha = this.getImageAlpha();
            float compositeAlpha = ImageAlpha == null ? 0.7f : ImageAlpha.floatValue();
            cc = new CompiereColor(url, this.getColor(true), compositeAlpha);
        }
        return cc;
    }

    private Color getColor(boolean primary) {
        int red = primary ? this.getRed() : this.getRed_1();
        int green = primary ? this.getGreen() : this.getGreen_1();
        int blue = primary ? this.getBlue() : this.getBlue_1();
        return new Color(red, green, blue);
    }

    private String getURL(int AD_Image_ID) {
        if (AD_Image_ID == 0) {
            return null;
        }
        return MImage.get(this.getCtx(), AD_Image_ID, this.get_TrxName()).getImageURL();
    }
}

