/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MAccount;
import org.compiere.model.Query;
import org.compiere.model.X_C_Campaign;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MCampaign
extends X_C_Campaign {
    private static final long serialVersionUID = -5881057827687596119L;
    private static CCache<Integer, MCampaign> campaignCacheIds = new CCache("C_Campaign", 30);
    private static CCache<String, MCampaign> campaignCacheValues = new CCache("C_Campaign", 30);

    public MCampaign(Properties ctx, int C_Campaign_ID, String trxName) {
        super(ctx, C_Campaign_ID, trxName);
    }

    public MCampaign(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MCampaign getById(Properties ctx, int campaignId, String trxName) {
        if (campaignId <= 0) {
            return null;
        }
        MCampaign campaign = campaignCacheIds.get(campaignId);
        if (campaign != null && campaign.get_ID() > 0) {
            return campaign;
        }
        campaign = (MCampaign)new Query(ctx, "C_Campaign", "C_Campaign_ID=?", trxName).setClient_ID().setParameters(campaignId).first();
        if (campaign != null && campaign.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + campaign.getValue();
            campaignCacheValues.put(key, campaign);
            campaignCacheIds.put(campaign.get_ID(), campaign);
        }
        return campaign;
    }

    public static MCampaign getByValue(Properties ctx, String campaignValue, String trxName) {
        int clientId;
        String key;
        MCampaign campaign;
        if (campaignValue == null) {
            return null;
        }
        if (campaignCacheValues.size() == 0) {
            MCampaign.getAll(ctx, true);
        }
        if ((campaign = campaignCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + campaignValue)) != null && campaign.get_ID() > 0) {
            return campaign;
        }
        campaign = (MCampaign)new Query(ctx, "C_Campaign", "Value=?", trxName).setClient_ID().setParameters(campaignValue).first();
        if (campaign != null && campaign.get_ID() > 0) {
            campaignCacheValues.put(key, campaign);
            campaignCacheIds.put(campaign.get_ID(), campaign);
        }
        return campaign;
    }

    public static List<MCampaign> getAll(Properties ctx, boolean resetCache) {
        if (resetCache || campaignCacheIds.size() > 0) {
            List<MCampaign> campaignList = new Query(Env.getCtx(), "C_Campaign", null, null).setClient_ID().setOrderBy("Name").list();
            campaignList.stream().forEach(campaign -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + campaign.getValue();
                campaignCacheIds.put(campaign.getC_Campaign_ID(), (MCampaign)campaign);
                campaignCacheValues.put(key, (MCampaign)campaign);
            });
            return campaignList;
        }
        List<MCampaign> campaignList = campaignCacheIds.entrySet().stream().map(campaign -> (MCampaign)campaign.getValue()).collect(Collectors.toList());
        return campaignList;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "C_Campaign_ID=" + this.getC_Campaign_ID(), this.get_TrxName());
        }
        return true;
    }
}

