/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MNonBusinessDay;
import org.compiere.model.MYear;
import org.compiere.model.Query;
import org.compiere.model.X_C_Calendar;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MCalendar
extends X_C_Calendar {
    private static final long serialVersionUID = 7721451326626542420L;
    private static CCache<Integer, MCalendar> s_cache = new CCache("C_Calendar", 20);
    private HashMap<String, MNonBusinessDay> nonBusinessDays;
    private SimpleDateFormat format;

    public static MCalendar get(Properties ctx, int C_Calendar_ID) {
        Integer key = new Integer(C_Calendar_ID);
        MCalendar retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCalendar(ctx, C_Calendar_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MCalendar getDefault(Properties ctx, int AD_Client_ID) {
        MClientInfo info = MClientInfo.get(ctx, AD_Client_ID);
        return MCalendar.get(ctx, info.getC_Calendar_ID());
    }

    public static MCalendar getDefault(Properties ctx) {
        return MCalendar.getDefault(ctx, Env.getAD_Client_ID(ctx));
    }

    public MCalendar(Properties ctx, int C_Calendar_ID, String trxName) {
        super(ctx, C_Calendar_ID, trxName);
    }

    public MCalendar(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCalendar(MClient client) {
        super(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setName(client.getName() + " " + Msg.translate(client.getCtx(), "C_Calendar_ID"));
    }

    public MYear createYear(Locale locale) {
        if (this.get_ID() == 0) {
            return null;
        }
        MYear year = new MYear(this);
        if (year.save()) {
            year.createStdPeriods(locale);
        }
        return year;
    }

    private void loadNonBusinessDay() {
        if (this.nonBusinessDays != null) {
            return;
        }
        List nonBusinessDaysList = new Query(this.getCtx(), "C_NonBusinessDay", "C_Calendar_ID = ?", this.get_TrxName()).setParameters(this.getC_Calendar_ID()).setOnlyActiveRecords(true).setOrderBy("Date1").list();
        this.nonBusinessDays = new HashMap();
        this.format = new SimpleDateFormat("yyyyMMdd");
        for (MNonBusinessDay nonBusinessDay : nonBusinessDaysList) {
            this.nonBusinessDays.put(this.format.format(nonBusinessDay.getDate1()) + "|" + nonBusinessDay.getAD_Org_ID(), nonBusinessDay);
        }
    }

    public boolean isNonBusinessDay(Timestamp day) {
        if (day == null) {
            return false;
        }
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(day.getTime());
        return this.isNonBusinessDay(date.getTime());
    }

    public boolean isNonBusinessDay(Date day, int orgId) {
        if (day == null) {
            return false;
        }
        this.loadNonBusinessDay();
        String keyOrg = this.format.format(day) + "|" + orgId;
        String keyGlobal = this.format.format(day) + "|" + 0;
        MNonBusinessDay nonBusinessDay = this.nonBusinessDays.get(keyOrg);
        if (nonBusinessDay == null && orgId != 0) {
            nonBusinessDay = this.nonBusinessDays.get(keyGlobal);
        }
        return nonBusinessDay != null;
    }

    public boolean isNonBusinessDay(Date day) {
        return this.isNonBusinessDay(day, 0);
    }
}

