/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.impexp.BankStatementLoaderInterface;
import org.compiere.model.MBankAccount;
import org.compiere.model.X_C_BankStatementLoader;
import org.compiere.model.X_I_BankStatement;
import org.compiere.util.Util;

public class MBankStatementLoader
extends X_C_BankStatementLoader {
    private static final long serialVersionUID = -4096456424277340847L;
    private int loadCount = 0;
    private String errorMessage = "";
    private String errorDescription = "";
    private BankStatementLoaderInterface m_loader = null;
    private String localFileName = null;

    public MBankStatementLoader(Properties ctx, int C_BankStatementLoader_ID, String trxName) {
        super(ctx, C_BankStatementLoader_ID, trxName);
        this.init(null);
    }

    public MBankStatementLoader(Properties ctx, int C_BankStatementLoader_ID, String fileName, String trxName) {
        super(ctx, C_BankStatementLoader_ID, trxName);
        this.init(fileName);
    }

    public MBankStatementLoader(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.init(null);
    }

    private void init(String fileName) {
        this.localFileName = fileName;
        try {
            this.log.info("MBankStatementLoader Class Name=" + this.getStmtLoaderClass());
            Class<?> bsrClass = Class.forName(this.getStmtLoaderClass());
            this.m_loader = (BankStatementLoaderInterface)bsrClass.newInstance();
        }
        catch (Exception e) {
            this.errorMessage = "ClassNotLoaded";
            this.errorDescription = e.getMessage();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MBankStatementLoader[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public boolean loadLines() {
        boolean result = false;
        this.log.info("MBankStatementLoader.loadLines");
        if (this.m_loader == null) {
            this.errorMessage = "ClassNotLoaded";
            return result;
        }
        if (!this.m_loader.init(this)) {
            this.errorMessage = this.m_loader.getLastErrorMessage();
            this.errorDescription = this.m_loader.getLastErrorDescription();
            return result;
        }
        if (!this.m_loader.isValid()) {
            this.errorMessage = this.m_loader.getLastErrorMessage();
            this.errorDescription = this.m_loader.getLastErrorDescription();
            return result;
        }
        if (!this.m_loader.loadLines()) {
            this.errorMessage = this.m_loader.getLastErrorMessage();
            this.errorDescription = this.m_loader.getLastErrorDescription();
            return result;
        }
        result = true;
        return result;
    }

    public boolean saveLine() {
        this.log.info("MBankStatementLoader.importLine");
        boolean result = false;
        X_I_BankStatement imp = new X_I_BankStatement(this.getCtx(), 0, this.get_TrxName());
        if (this.m_loader == null) {
            this.errorMessage = "LoadError";
            return result;
        }
        this.log.config("MBankStatementLoader.importLine Bank Account=" + this.m_loader.getBankAccountNo());
        imp.setBankAccountNo(this.m_loader.getBankAccountNo());
        this.log.config("MBankStatementLoader.importLine Routing No=" + this.m_loader.getRoutingNo());
        imp.setRoutingNo(this.m_loader.getRoutingNo());
        this.log.config("MBankStatementLoader.importLine EFT Statement Reference No=" + this.m_loader.getStatementReference());
        imp.setEftStatementReference(this.m_loader.getStatementReference());
        this.log.config("MBankStatementLoader.importLine EFT Statement Date=" + this.m_loader.getStatementDate());
        imp.setEftStatementDate(this.m_loader.getStatementDate());
        this.log.config("MBankStatementLoader.importLine Statement Date=" + this.m_loader.getStatementDate());
        imp.setStatementDate(this.m_loader.getStatementDate());
        this.log.config("MBankStatementLoader.importLine EFT Transaction ID=" + this.m_loader.getTrxID());
        imp.setEftTrxID(this.m_loader.getTrxID());
        this.log.config("MBankStatementLoader.importLine Statement Line Date=" + this.m_loader.getStatementLineDate());
        imp.setStatementLineDate(this.m_loader.getStatementLineDate());
        imp.setEftStatementLineDate(this.m_loader.getStatementLineDate());
        this.log.config("MBankStatementLoader.importLine Valuta Date=" + this.m_loader.getValutaDate());
        imp.setValutaDate(this.m_loader.getValutaDate());
        imp.setEftValutaDate(this.m_loader.getValutaDate());
        this.log.config("MBankStatementLoader.importLine Statement Amount=" + this.m_loader.getStmtAmt());
        imp.setStmtAmt(this.m_loader.getStmtAmt());
        imp.setEftAmt(this.m_loader.getStmtAmt());
        this.log.config("MBankStatementLoader.importLine Transaction Amount=" + this.m_loader.getTrxAmt());
        imp.setTrxAmt(this.m_loader.getTrxAmt());
        this.log.config("MBankStatementLoader.importLine Interest Amount=" + this.m_loader.getInterestAmt());
        imp.setInterestAmt(this.m_loader.getInterestAmt());
        this.log.config("MBankStatementLoader.importLine Reference No=" + this.m_loader.getReference());
        imp.setReferenceNo(this.m_loader.getReference());
        imp.setEftReference(this.m_loader.getReference());
        this.log.config("MBankStatementLoader.importLine Check No=" + this.m_loader.getCheckNo());
        imp.setEftCheckNo(this.m_loader.getCheckNo());
        this.log.config("MBankStatementLoader.importLine Memo=" + this.m_loader.getMemo());
        imp.setMemo(this.m_loader.getMemo());
        imp.setEftMemo(this.m_loader.getMemo());
        this.log.config("MBankStatementLoader.importLine Payee Name=" + this.m_loader.getPayeeName());
        imp.setEftPayee(this.m_loader.getPayeeName());
        this.log.config("MBankStatementLoader.importLine Payee Account No=" + this.m_loader.getPayeeAccountNo());
        imp.setEftPayeeAccount(this.m_loader.getPayeeAccountNo());
        this.log.config("MBankStatementLoader.importLine EFT Transaction Type=" + this.m_loader.getTrxType());
        imp.setEftTrxType(this.m_loader.getTrxType());
        this.log.config("MBankStatementLoader.importLine Currency=" + this.m_loader.getCurrency());
        imp.setEftCurrency(this.m_loader.getCurrency());
        imp.setISO_Code(this.m_loader.getCurrency());
        this.log.config("MBankStatementLoader.importLine Charge Name=" + this.m_loader.getChargeName());
        imp.setChargeName(this.m_loader.getChargeName());
        this.log.config("MBankStatementLoader.importLine Charge Amount=" + this.m_loader.getChargeAmt());
        imp.setChargeAmt(this.m_loader.getChargeAmt());
        imp.setLineDescription(this.m_loader.getPayeeDescription());
        imp.setC_BankAccount_ID(this.getC_BankAccount_ID());
        if (Util.isEmpty(imp.getISO_Code())) {
            MBankAccount account = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
            imp.setC_Currency_ID(account.getC_Currency_ID());
        }
        imp.setProcessed(false);
        imp.setI_IsImported(false);
        try {
            imp.saveEx();
            ++this.loadCount;
            result = true;
        }
        catch (Exception e) {
            this.errorMessage = e.getLocalizedMessage();
        }
        imp = null;
        return result;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public int getLoadCount() {
        return this.loadCount;
    }
}

