/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.validator.routines.CreditCardValidator;
import org.apache.commons.validator.routines.IBANValidator;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_C_BP_BankAccount;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public class MBPBankAccount
extends X_C_BP_BankAccount {
    private static final long serialVersionUID = 2580706419593695062L;
    private static CLogger s_log = CLogger.getCLogger(MBPBankAccount.class);
    private MBank m_bank = null;

    public static List<MBPBankAccount> getByPartner(Properties ctx, int partnerId, String whereClause, String trxName) {
        String finalWhereClause = "C_BPartner_ID=?";
        if (whereClause != null && whereClause.length() > 0) {
            finalWhereClause = finalWhereClause + " AND " + whereClause;
        }
        return new Query(ctx, "C_BP_BankAccount", finalWhereClause, trxName).setParameters(partnerId).setOnlyActiveRecords(true).list();
    }

    public static List<MBPBankAccount> getByPartner(Properties ctx, int partnerId) {
        return MBPBankAccount.getByPartner(ctx, partnerId, null, null);
    }

    @Deprecated
    public static MBPBankAccount[] getOfBPartner(Properties ctx, int partnerId) {
        return (MBPBankAccount[])MBPBankAccount.getByPartner(ctx, partnerId).stream().toArray(MBPBankAccount[]::new);
    }

    public MBPBankAccount(Properties ctx, int bankAccountId, String trxName) {
        super(ctx, bankAccountId, trxName);
        if (bankAccountId == 0) {
            this.setIsACH(false);
            this.setBPBankAcctUse("B");
        }
    }

    public MBPBankAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBPBankAccount(Properties ctx, MBPartner bp, MUser bpc, MLocation location) {
        this(ctx, 0, bp.get_TrxName());
        this.setIsACH(false);
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        this.setA_Name(bpc.getName());
        this.setA_EMail(bpc.getEMail());
        this.setA_Street(location.getAddress1());
        this.setA_City(location.getCity());
        this.setA_Zip(location.getPostal());
        this.setA_State(location.getRegionName(true));
        this.setA_Country(location.getCountryName());
    }

    public boolean isDirectDeposit() {
        if (!this.isACH()) {
            return false;
        }
        String s = this.getBPBankAcctUse();
        if (s == null) {
            return true;
        }
        return s.equals("B") || s.equals("T");
    }

    public boolean isDirectDebit() {
        if (!this.isACH()) {
            return false;
        }
        String s = this.getBPBankAcctUse();
        if (s == null) {
            return true;
        }
        return s.equals("B") || s.equals("D");
    }

    public MBank getBank() {
        int C_Bank_ID = this.getC_Bank_ID();
        if (C_Bank_ID == 0) {
            return null;
        }
        if (this.m_bank == null) {
            this.m_bank = new MBank(this.getCtx(), C_Bank_ID, this.get_TrxName());
        }
        return this.m_bank;
    }

    @Override
    public String getRoutingNo() {
        MBank bank = this.getBank();
        String rt = super.getRoutingNo();
        if (bank != null) {
            rt = bank.getRoutingNo();
        }
        return rt;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        IBANValidator validator;
        if (this.isACH() && this.getBank() != null) {
            this.setRoutingNo(null);
        }
        if (!Util.isEmpty(this.getIBAN())) {
            validator = IBANValidator.getInstance();
            if (!validator.isValid(this.getIBAN().trim())) {
                throw new AdempiereException("@ValidationError@ (@Invalid@ @IBAN@)");
            }
            this.setIBAN(this.getIBAN().trim());
        }
        if (!Util.isEmpty(this.getCreditCardNumber())) {
            if ("A".equals(this.getCreditCardType()) || "V".equals(this.getCreditCardType()) || "M".equals(this.getCreditCardType()) || "N".equals(this.getCreditCardType())) {
                validator = new CreditCardValidator();
                if (!validator.isValid(this.getCreditCardNumber().trim())) {
                    throw new AdempiereException("@ValidationError@ (@Invalid@ @CreditCardNumber@)");
                }
                this.setCreditCardNumber(this.getCreditCardNumber().trim());
            }
            if ("D".equals(this.getCreditCardType())) {
                validator = new CreditCardValidator(16L);
                if (!validator.isValid(this.getCreditCardNumber().trim())) {
                    throw new AdempiereException("@ValidationError@ (@Invalid@ @CreditCardNumber@)");
                }
                this.setCreditCardNumber(this.getCreditCardNumber().trim());
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MBP_BankAccount[").append(this.get_ID()).append(", Name=").append(this.getA_Name()).append("]");
        return sb.toString();
    }
}

