/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.Query;
import org.compiere.model.X_M_Attribute;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MAttribute
extends X_M_Attribute {
    private static final long serialVersionUID = 7869800574413317999L;
    private static CLogger s_log = CLogger.getCLogger(MAttribute.class);
    private MAttributeValue[] m_values = null;

    public static MAttribute[] getOfClient(Properties ctx, boolean onlyProductAttributes, boolean onlyListAttributes) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String sql = "";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(AD_Client_ID);
        if (onlyProductAttributes) {
            sql = sql + " AND IsInstanceAttribute=?";
            params.add(false);
        }
        if (onlyListAttributes) {
            sql = sql + " AND AttributeValueType=?";
            params.add("L");
        }
        String whereClause = "AD_Client_ID=?" + sql;
        List<MAttribute> list = new Query(ctx, "M_Attribute", whereClause, null).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Name").list();
        MAttribute[] retValue = new MAttribute[list.size()];
        list.toArray(retValue);
        s_log.fine("AD_Client_ID=" + AD_Client_ID + " - #" + list.size());
        return retValue;
    }

    public MAttribute(Properties ctx, int M_Attribute_ID, String trxName) {
        super(ctx, M_Attribute_ID, trxName);
        if (M_Attribute_ID == 0) {
            this.setAttributeValueType("S");
            this.setIsInstanceAttribute(false);
            this.setIsMandatory(false);
        }
    }

    public MAttribute(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttributeValue[] getMAttributeValues() {
        if (this.m_values == null && "L".equals(this.getAttributeValueType())) {
            String whereClause = "M_Attribute_ID=?";
            ArrayList list = new ArrayList();
            if (!this.isMandatory()) {
                list.add(null);
            }
            list.addAll(new Query(this.getCtx(), "M_AttributeValue", "M_Attribute_ID=?", null).setParameters(this.getM_Attribute_ID()).setOrderBy("Value").setOnlyActiveRecords(true).list());
            this.m_values = new MAttributeValue[list.size()];
            list.toArray(this.m_values);
        }
        return this.m_values;
    }

    public MAttributeInstance getMAttributeInstance(int M_AttributeSetInstance_ID) {
        String whereClause = "M_Attribute_ID=? AND M_AttributeSetInstance_ID=?";
        MAttributeInstance retValue = (MAttributeInstance)new Query(this.getCtx(), "M_AttributeInstance", "M_Attribute_ID=? AND M_AttributeSetInstance_ID=?", this.get_TrxName()).setParameters(this.getM_Attribute_ID(), M_AttributeSetInstance_ID).first();
        return retValue;
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, MAttributeValue value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = value != null ? new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value.getM_AttributeValue_ID(), value.getName(), this.get_TrxName()) : new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, 0, null, this.get_TrxName());
        } else if (value != null) {
            instance.setM_AttributeValue_ID(value.getM_AttributeValue_ID());
            instance.setValue(value.getName());
        } else {
            instance.setM_AttributeValue_ID(0);
            instance.setValue(null);
        }
        instance.saveEx();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, String value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValue(value);
        }
        instance.saveEx();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, BigDecimal value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValueNumber(value);
        }
        instance.saveEx();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAttribute[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getAttributeValueType()).append(",Instance=").append(this.isInstanceAttribute()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && this.is_ValueChanged("IsInstanceAttribute") && this.isInstanceAttribute()) {
            String sql = "UPDATE M_AttributeSet mas SET IsInstanceAttribute='Y' WHERE IsInstanceAttribute='N' AND EXISTS (SELECT * FROM M_AttributeUse mau WHERE mas.M_AttributeSet_ID=mau.M_AttributeSet_ID AND mau.M_Attribute_ID=" + this.getM_Attribute_ID() + ")";
            int no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("AttributeSet Instance set #" + no);
        }
        return success;
    }
}

