/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import org.compiere.FA.feature.UseLifeImpl;
import org.compiere.model.Query;
import org.compiere.model.X_A_Asset_Class;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAssetClass
extends X_A_Asset_Class {
    private static CCache<Integer, MAssetClass> s_cache = new CCache("A_Asset_Class", 20);

    public MAssetClass(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MAssetClass(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MAssetClass get(Properties properties, int n) {
        if (n <= 0) {
            return null;
        }
        MAssetClass mAssetClass = s_cache.get(n);
        if (mAssetClass == null) {
            mAssetClass = new MAssetClass(properties, n, null);
        }
        if (mAssetClass.get_ID() != n) {
            return null;
        }
        s_cache.put(n, mAssetClass);
        return mAssetClass;
    }

    public static MAssetClass get(Properties properties, String string) {
        return (MAssetClass)new Query(properties, "A_Asset_Class", "UPPER(Value)=UPPER(?) AND AD_Client_ID IN (0,?)", null).setParameters(string, Env.getAD_Client_ID(properties)).setOrderBy("AD_Client_ID DESC").firstOnly();
    }

    public void setDescription() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getValue();
        if (string2 != null) {
            stringBuffer.append(string2).append(" ");
        }
        if ((string = this.getName()) != null) {
            stringBuffer.append(string);
        }
        super.setDescription(stringBuffer.toString());
    }

    public void setLevels() {
        this.setMFX_Grupa(0);
        this.setMFX_SubGrupa(0);
        this.setMFX_Clasa(0);
        this.setMFX_SubClasa(0);
        String string = this.getValue();
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = string.split("\\.");
        try {
            if (stringArray.length >= 1) {
                this.setMFX_Grupa(Integer.valueOf(stringArray[0]));
            }
            if (stringArray.length >= 2) {
                this.setMFX_SubGrupa(Integer.valueOf(stringArray[1]));
            }
            if (stringArray.length >= 3) {
                this.setMFX_Clasa(Integer.valueOf(stringArray[2]));
            }
            if (stringArray.length >= 4) {
                this.setMFX_SubClasa(Integer.valueOf(stringArray[3]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.log.warning("@Error@ @Value@=" + string);
        }
    }

    public int getA_Life_Period_Min(Timestamp timestamp) {
        Calendar calendar = TimeUtil.getCalendar(timestamp);
        if (calendar.get(1) >= 2004) {
            return this.getA_Life_Period_Min();
        }
        return this.getA_Life_Period_2004();
    }

    public String validate(boolean bl, int n, Timestamp timestamp) {
        this.log.fine("Entering");
        int n2 = 0;
        int n3 = 1000000;
        Calendar calendar = TimeUtil.getCalendar(timestamp);
        if (calendar.get(1) >= 2004) {
            n2 = this.getA_Life_Period_Min();
            n3 = this.getA_Life_Period_Max();
        } else {
            n2 = this.getA_Life_Period_2004();
            n3 = this.getA_Life_Period_2004();
        }
        if (CLogMgt.isLevelFine()) {
            this.log.fine("serviceDate=" + timestamp + ", A_Life_Period_Min=" + n2 + ", A_Life_Period_Max=" + n3 + ", A_Life_Period=" + n);
        }
        if (n < n2 || n > n3) {
            String string = "@UseLifeMonths@=" + n + " @NotBetween@ " + n2 + " - " + n3;
            if (bl) {
                this.log.saveError("Error", string);
            }
            if (CLogMgt.isLevelFine()) {
                this.log.fine("Leaving: " + string);
                Thread.dumpStack();
            }
            return string;
        }
        this.log.fine("Leaving: OK!");
        return "";
    }

    public boolean validate(UseLifeImpl useLifeImpl) {
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Entering: UseLifeImpl=" + useLifeImpl);
        }
        if (!useLifeImpl.isFiscal()) {
            this.log.fine("Leaving: fiscal=false [RETURN TRUE]");
            return true;
        }
        this.log.fine("asset is fiscal");
        int n = useLifeImpl.getUseLifeMonths();
        Timestamp timestamp = useLifeImpl.getAssetServiceDate();
        String string = this.validate(true, n, timestamp);
        boolean bl = string == null || string.length() == 0;
        this.log.fine("Leaving: ok=" + bl);
        return bl;
    }

    public boolean isDepreciated() {
        return this.getA_Life_Period_Min() != 0 || this.getA_Life_Period_Max() != 0;
    }

    @Override
    public boolean beforeSave(boolean bl) {
        this.setDescription();
        if (this.is_ValueChanged("Value")) {
            this.setValue(this.getValue().trim());
            this.setLevels();
        }
        return true;
    }
}

