/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MAssetDisposed;
import org.compiere.model.MAssetSplit;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset_Change;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;

public class MAssetChange
extends X_A_Asset_Change {
    private static final long serialVersionUID = 5906751299228645904L;
    private static CLogger s_log = CLogger.getCLogger(MAssetChange.class);

    public MAssetChange(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MAssetChange(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        String string = this.getTextDetails();
        if (string == null || string.length() == 0) {
            this.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", this.getChangeType()));
        }
        return true;
    }

    public static MAssetChange createSplit(MAssetSplit mAssetSplit, MDepreciationWorkfile mDepreciationWorkfile) {
        MAssetChange mAssetChange = new MAssetChange(mAssetSplit.getCtx(), 0, mAssetSplit.get_TrxName());
        mAssetChange.setAD_Org_ID(mAssetSplit.getAD_Org_ID());
        mAssetChange.setA_Asset_ID(mDepreciationWorkfile.getA_Asset_ID());
        mAssetChange.setChangeType("SPL");
        String string = Msg.parseTranslation(mAssetSplit.getCtx(), " @A_Asset_Split_ID@ " + mAssetSplit.getDocumentInfo());
        mAssetChange.setTextDetails(string + " " + MRefList.getListDescription(mAssetSplit.getCtx(), "A_Update_Type", "SPL"));
        mAssetChange.setPostingType(mDepreciationWorkfile.getPostingType());
        mAssetChange.setAssetValueAmt(mAssetSplit.getA_Asset_Cost());
        mAssetChange.setA_QTY_Current(mAssetSplit.getA_QTY_Split());
        mAssetChange.setA_Split_Percent(mAssetSplit.getA_Percent_Split());
        mAssetChange.setDateAcct(mAssetSplit.getDateAcct());
        mAssetChange.setChangeDate(mAssetSplit.getDateDoc());
        mAssetChange.saveEx();
        return mAssetChange;
    }

    public static MAssetChange createAddition(MAssetSplit mAssetSplit, MAsset mAsset, MAsset mAsset2, MDepreciationWorkfile mDepreciationWorkfile) {
        MAssetChange mAssetChange = new MAssetChange(mAssetSplit.getCtx(), 0, mAssetSplit.get_TrxName());
        mAssetChange.setAD_Org_ID(mAssetSplit.getAD_Org_ID());
        mAssetChange.setA_Asset_ID(mDepreciationWorkfile.getA_Asset_ID());
        mAssetChange.setChangeType("ADD");
        String string = Msg.parseTranslation(mAssetSplit.getCtx(), " @From@ @A_Asset_ID@ " + mAsset.getValue() + " @To@  @Value@" + mAsset2.getValue() + " @A_Asset_Split_ID@ " + mAssetSplit.getDocumentInfo());
        mAssetChange.setTextDetails(string + " " + MRefList.getListDescription(mAssetSplit.getCtx(), "A_Update_Type", "ADD"));
        mAssetChange.setPostingType(mDepreciationWorkfile.getPostingType());
        mAssetChange.setAssetValueAmt(mDepreciationWorkfile.getA_Asset_Cost());
        mAssetChange.setA_QTY_Current(mDepreciationWorkfile.getA_QTY_Current());
        mAssetChange.setDateAcct(mAssetSplit.getDateAcct());
        mAssetChange.setChangeDate(mAssetSplit.getDateDoc());
        mAssetChange.setA_Split_Percent(mAssetSplit.getA_Percent_Split());
        mAssetChange.setA_Parent_Asset_ID(mAsset.getA_Asset_ID());
        mAssetChange.saveEx();
        return mAssetChange;
    }

    public static MAssetChange createAddition(MAssetAddition mAssetAddition, MDepreciationWorkfile mDepreciationWorkfile) {
        MAssetChange mAssetChange = new MAssetChange(mAssetAddition.getCtx(), 0, mAssetAddition.get_TrxName());
        mAssetChange.setAD_Org_ID(mAssetAddition.getAD_Org_ID());
        mAssetChange.setA_Asset_ID(mAssetAddition.getA_Asset_ID());
        mAssetChange.setChangeType("ADD");
        mAssetChange.setTextDetails(MRefList.getListDescription(mAssetAddition.getCtx(), "A_Update_Type", "ADD"));
        mAssetChange.setPostingType(mDepreciationWorkfile.getPostingType());
        mAssetChange.setAssetValueAmt(mAssetAddition.getAssetValueAmt());
        mAssetChange.setA_QTY_Current(mAssetAddition.getA_QTY_Current());
        mAssetChange.saveEx();
        return mAssetChange;
    }

    public static MAssetChange createDisposal(MAssetDisposed mAssetDisposed, MDepreciationWorkfile mDepreciationWorkfile) {
        MAssetChange mAssetChange = new MAssetChange(mAssetDisposed.getCtx(), 0, mAssetDisposed.get_TrxName());
        mAssetChange.setAD_Org_ID(mAssetDisposed.getAD_Org_ID());
        mAssetChange.setA_Asset_ID(mAssetDisposed.getA_Asset_ID());
        mAssetChange.setChangeType("DIS");
        mAssetChange.setTextDetails(MRefList.getListDescription(mAssetDisposed.getCtx(), "A_Update_Type", "DIS"));
        mAssetChange.setPostingType(mDepreciationWorkfile.getPostingType());
        mAssetChange.setAssetValueAmt(mAssetDisposed.getA_Disposal_Amt());
        mAssetChange.setA_QTY_Current(mDepreciationWorkfile.getA_QTY_Current());
        mAssetChange.saveEx();
        return mAssetChange;
    }

    public static MAssetChange create(Properties properties, String string, PO[] pOArray, String string2) {
        return MAssetChange.create(properties, string, pOArray, false, string2);
    }

    public static MAssetChange createAndSave(Properties properties, String string, PO[] pOArray, String string2) {
        return null;
    }

    public static MAssetChange create(Properties properties, String string, PO[] pOArray, boolean bl, String string2) {
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Entering: changeType=" + string);
        }
        if (pOArray == null || pOArray.length == 0) {
            s_log.fine("Entering/Leaving: POs is empty");
            return null;
        }
        MAssetChange mAssetChange = new MAssetChange(properties, 0, string2);
        mAssetChange.setChangeType(string);
        for (PO pO : pOArray) {
            mAssetChange.addChanges(pO);
        }
        if (bl) {
            mAssetChange.saveEx();
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Leaving: change=" + mAssetChange);
        }
        return mAssetChange;
    }

    public void addChanges(PO pO) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: po=" + pO);
        }
        if (pO == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: po=" + pO);
        }
    }
}

