/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccount;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelection;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.X_HR_Concept;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.model.X_HR_Payroll;

public class CalloutPaySelection
extends CalloutEngine {
    public String payAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        BigDecimal OpenAmt = (BigDecimal)mTab.getValue("OpenAmt");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("PayAmt");
        BigDecimal DifferenceAmt = OpenAmt.subtract(PayAmt).subtract(DiscountAmt);
        this.log.fine(" - OpenAmt=" + OpenAmt + " - PayAmt=" + PayAmt + ", Discount=" + DiscountAmt + ", Difference=" + DifferenceAmt);
        mTab.setValue("DifferenceAmt", (Object)DifferenceAmt);
        return "";
    }

    public String discountAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        BigDecimal OpenAmt = (BigDecimal)mTab.getValue("OpenAmt");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal PayAmt = OpenAmt.subtract(DiscountAmt);
        BigDecimal DifferenceAmt = Env.ZERO;
        this.log.fine(" - OpenAmt=" + OpenAmt + " - PayAmt=" + PayAmt + ", Discount=" + DiscountAmt + ", Difference=" + DifferenceAmt);
        mTab.setValue("PayAmt", (Object)PayAmt);
        mTab.setValue("DifferenceAmt", (Object)DifferenceAmt);
        return "";
    }

    public String conversion(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String colName = mField.getColumnName();
        if (!colName.equals("C_ConversionType_ID") && !colName.equals("C_Conversion_Rate_ID")) {
            return "";
        }
        Integer C_Invoice_ID = (Integer)mTab.getValue("C_Invoice_ID");
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        Integer C_PaySelection_ID = (Integer)mTab.getValue("C_PaySelection_ID");
        if (!(C_Invoice_ID != null && C_Invoice_ID != 0 || C_Order_ID != null && C_Order_ID != 0)) {
            return "";
        }
        BigDecimal AmtSource = (BigDecimal)mTab.getValue("AmtSource");
        BigDecimal OpenAmt = (BigDecimal)mTab.getValue("OpenAmt");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("PayAmt");
        BigDecimal DifferenceAmt = OpenAmt.subtract(PayAmt).subtract(DiscountAmt);
        this.log.fine(" - OpenAmt=" + OpenAmt + " - PayAmt=" + PayAmt + ", Discount=" + DiscountAmt + ", Difference=" + DifferenceAmt);
        int AD_Client_ID = 0;
        int AD_Org_ID = 0;
        int C_ConversionType_ID = 0;
        int C_Conversion_Rate_ID = 0;
        Integer ii = (Integer)mTab.getValue("C_ConversionType_ID");
        if (ii != null) {
            C_ConversionType_ID = ii;
        }
        if ((ii = (Integer)mTab.getValue("C_Conversion_Rate_ID")) != null) {
            C_Conversion_Rate_ID = ii;
        }
        if ((ii = (Integer)mTab.getValue("AD_Client_ID")) != null) {
            AD_Client_ID = ii;
        }
        if ((ii = (Integer)mTab.getValue("AD_Org_ID")) != null) {
            AD_Org_ID = ii;
        }
        int C_Currency_Document_ID = 0;
        if (C_Invoice_ID != null && C_Invoice_ID != 0) {
            MInvoice invoice = new MInvoice(ctx, (int)C_Invoice_ID, null);
            C_Currency_Document_ID = invoice.getC_Currency_ID();
        } else if (C_Order_ID != 0) {
            MOrder order = new MOrder(ctx, C_Order_ID, null);
            C_Currency_Document_ID = order.getC_Currency_ID();
        }
        MPaySelection selection = new MPaySelection(ctx, C_PaySelection_ID, null);
        int C_Currency_ID = selection.getC_Currency_ID();
        MCurrency currency = MCurrency.get(ctx, C_Currency_ID);
        Timestamp ConvDate = selection.getDateDoc();
        BigDecimal CurrentCurrencyRate = Env.ONE;
        BigDecimal CurrencyRate = Env.ONE;
        if (OpenAmt.doubleValue() != 0.0) {
            CurrentCurrencyRate = AmtSource.divide(OpenAmt, MathContext.DECIMAL128);
            DiscountAmt = DiscountAmt.multiply(CurrentCurrencyRate).setScale(currency.getStdPrecision(), 4);
            PayAmt = PayAmt.multiply(CurrentCurrencyRate).setScale(currency.getStdPrecision(), 4);
        }
        if (C_Conversion_Rate_ID != 0) {
            CurrencyRate = MConversionRate.getRate(ctx, C_Conversion_Rate_ID);
        } else if (C_Currency_ID > 0 && C_Currency_Document_ID > 0 && C_Currency_ID != C_Currency_Document_ID) {
            this.log.fine("InvCurrency=" + C_Currency_Document_ID + ", PayCurrency=" + C_Currency_ID + ", Date=" + ConvDate + ", Type=" + C_ConversionType_ID);
            CurrencyRate = MConversionRate.getRate(C_Currency_Document_ID, C_Currency_ID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        }
        if (CurrencyRate == null || CurrencyRate.compareTo(Env.ZERO) == 0) {
            return "NoCurrencyConversion";
        }
        this.log.fine("Rate=" + CurrencyRate + ", InvoiceOpenAmt=" + AmtSource);
        OpenAmt = AmtSource.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
        PayAmt = PayAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
        DiscountAmt = DiscountAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
        DifferenceAmt = OpenAmt.subtract(PayAmt).subtract(DiscountAmt);
        mTab.setValue("OpenAmt", (Object)OpenAmt);
        mTab.setValue("PayAmt", (Object)PayAmt);
        mTab.setValue("DiscountAmt", (Object)DiscountAmt);
        mTab.setValue("DifferenceAmt", (Object)DifferenceAmt);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int C_Invoice_ID = (Integer)value;
        if (C_Invoice_ID == 0) {
            return "";
        }
        int C_Currency_ID = Env.getContextAsInt(ctx, WindowNo, "C_Currency_ID");
        Timestamp PayDate = Env.getContextAsDate(ctx, WindowNo, "PayDate");
        int C_ConversionType_ID = 0;
        int C_BPartner_ID = 0;
        if (PayDate == null) {
            PayDate = new Timestamp(System.currentTimeMillis());
        }
        BigDecimal AmtSource = Env.ZERO;
        BigDecimal OpenAmt = Env.ZERO;
        BigDecimal DiscountAmt = Env.ZERO;
        Boolean IsSOTrx = Boolean.FALSE;
        String sql = "SELECT invoiceOpen(i.C_Invoice_ID, 0) AmtSource, currencyConvert(invoiceOpen(i.C_Invoice_ID, 0), i.C_Currency_ID,?, i.DateInvoiced, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID), paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?), i.IsSOTrx, i.C_ConversionType_ID, i.C_BPartner_ID FROM C_Invoice_v i WHERE i.C_Invoice_ID=?";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_Currency_ID);
            pstmt.setTimestamp(2, PayDate);
            pstmt.setInt(3, C_Invoice_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                AmtSource = rs.getBigDecimal(1);
                OpenAmt = rs.getBigDecimal(2);
                DiscountAmt = rs.getBigDecimal(3);
                IsSOTrx = new Boolean("Y".equals(rs.getString(4)));
                C_ConversionType_ID = rs.getInt(5);
                C_BPartner_ID = rs.getInt(6);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.fine(" - OpenAmt=" + OpenAmt + " (Invoice=" + C_Invoice_ID + ",Currency=" + C_Currency_ID + ")");
        mTab.setValue("AmtSource", (Object)AmtSource);
        mTab.setValue("OpenAmt", (Object)OpenAmt);
        mTab.setValue("PayAmt", (Object)OpenAmt.subtract(DiscountAmt));
        mTab.setValue("DiscountAmt", (Object)DiscountAmt);
        mTab.setValue("DifferenceAmt", (Object)Env.ZERO);
        mTab.setValue("IsSOTrx", (Object)IsSOTrx);
        mTab.setValue("C_ConversionType_ID", (Object)C_ConversionType_ID);
        mTab.setValue("C_BPartner_ID", (Object)C_BPartner_ID);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String order(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int C_Order_ID = (Integer)value;
        if (C_Order_ID == 0) {
            return "";
        }
        int C_Currency_ID = Env.getContextAsInt(ctx, WindowNo, "C_Currency_ID");
        Timestamp PayDate = Env.getContextAsDate(ctx, WindowNo, "PayDate");
        int C_ConversionType_ID = 0;
        int C_BPartner_ID = 0;
        if (PayDate == null) {
            PayDate = new Timestamp(System.currentTimeMillis());
        }
        BigDecimal AmtSource = Env.ZERO;
        BigDecimal OpenAmt = Env.ZERO;
        Boolean IsSOTrx = Boolean.FALSE;
        String sql = "SELECT o.GrandTotal, currencyConvert(o.GrandTotal, o.C_Currency_ID,?, o.DateOrdered, o.C_ConversionType_ID, o.AD_Client_ID, o.AD_Org_ID), o.IsSOTrx, o.C_ConversionType_ID, o.C_BPartner_ID FROM C_Order o WHERE o.C_Order_ID = ?";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_Currency_ID);
            pstmt.setInt(2, C_Order_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                AmtSource = rs.getBigDecimal(1);
                OpenAmt = rs.getBigDecimal(2);
                IsSOTrx = new Boolean("Y".equals(rs.getString(3)));
                C_ConversionType_ID = rs.getInt(4);
                C_BPartner_ID = rs.getInt(5);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.fine(" - OpenAmt=" + OpenAmt + " (Order=" + C_Order_ID + ",Currency=" + C_Currency_ID + ")");
        mTab.setValue("AmtSource", (Object)AmtSource);
        mTab.setValue("OpenAmt", (Object)OpenAmt);
        mTab.setValue("PayAmt", (Object)OpenAmt);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("DifferenceAmt", (Object)Env.ZERO);
        mTab.setValue("IsSOTrx", (Object)IsSOTrx);
        mTab.setValue("C_ConversionType_ID", (Object)C_ConversionType_ID);
        mTab.setValue("C_BPartner_ID", (Object)C_BPartner_ID);
        return "";
    }

    public String payrollMovement(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int HR_Movement_ID = (Integer)value;
        if (HR_Movement_ID == 0) {
            return "";
        }
        X_HR_Movement movement = new X_HR_Movement(ctx, HR_Movement_ID, null);
        X_HR_Concept concept = new X_HR_Concept(ctx, movement.getHR_Concept_ID(), null);
        if (!concept.getColumnType().equals("A")) {
            return "@HR_Concept_ID@ <> @Amount@";
        }
        X_HR_Payroll payroll = new X_HR_Payroll(ctx, movement.getHR_Payroll_ID(), null);
        if (payroll.getC_Charge_ID() == 0) {
            return "@C_Charge_ID@ @NotFound@";
        }
        mTab.setValue("PayAmt", (Object)movement.getAmount());
        mTab.setValue("C_Charge_ID", (Object)payroll.getC_Charge_ID());
        mTab.setValue("C_BPartner_ID", (Object)movement.getC_BPartner_ID());
        return "";
    }

    public String bankAccount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int C_BankAccount_ID = (Integer)value;
        if (C_BankAccount_ID == 0) {
            return "";
        }
        MBankAccount account = MBankAccount.get(ctx, C_BankAccount_ID);
        if (account == null) {
            return "";
        }
        mTab.setValue("C_Currency_ID", (Object)account.getC_Currency_ID());
        return "";
    }
}

