/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_M_AttributeSetInstance;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MSequence;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class CalloutOrder
extends CalloutEngine {
    private boolean steps = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block35: {
            boolean newDocNo;
            Integer C_DocType_ID = (Integer)value;
            if (C_DocType_ID == null || C_DocType_ID == 0) {
                return "";
            }
            String oldDocNo = (String)mTab.getValue("DocumentNo");
            boolean bl = newDocNo = oldDocNo == null;
            if (!newDocNo && oldDocNo.startsWith("<") && oldDocNo.endsWith(">")) {
                newDocNo = true;
            }
            Integer oldC_DocType_ID = (Integer)mTab.getValue("C_DocType_ID");
            String sql = "SELECT d.DocSubTypeSO,d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext,s.CurrentNextSys,s.AD_Sequence_ID,d.IsSOTrx, s.StartNewYear, s.DateColumn FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
            pstmt = null;
            rs = null;
            try {
                int AD_Sequence_ID = 0;
                if (!newDocNo && oldC_DocType_ID != 0) {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, oldC_DocType_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Sequence_ID = rs.getInt(7);
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                String DocSubTypeSO = "";
                boolean IsSOTrx = true;
                if (rs.next()) {
                    DocSubTypeSO = rs.getString(1);
                    if (DocSubTypeSO == null) {
                        DocSubTypeSO = "--";
                    }
                    Env.setContext(ctx, WindowNo, "OrderType", DocSubTypeSO);
                    if (!DocSubTypeSO.equals("SO")) {
                        mTab.setValue("IsDropShip", (Object)"N");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("DeliveryRule", (Object)"F");
                    } else if (DocSubTypeSO.equals("PR")) {
                        mTab.setValue("DeliveryRule", (Object)"R");
                    } else {
                        mTab.setValue("DeliveryRule", (Object)"A");
                    }
                    if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("PR") || DocSubTypeSO.equals("WI")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                    } else {
                        mTab.setValue("InvoiceRule", (Object)"D");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        mTab.setValue("PaymentRule", (Object)"P");
                    }
                    if ("N".equals(rs.getString(8))) {
                        IsSOTrx = false;
                    }
                    Env.setContext(ctx, WindowNo, "HasCharges", rs.getString(2));
                    if (rs.getString(4).equals("Y")) {
                        if (!newDocNo && AD_Sequence_ID != rs.getInt(7)) {
                            newDocNo = true;
                        }
                        if (newDocNo) {
                            if (Ini.isPropertyBool("AdempiereSys") && Env.getAD_Client_ID(Env.getCtx()) < 1000000) {
                                mTab.setValue("DocumentNo", (Object)("<" + rs.getString(6) + ">"));
                            } else if ("Y".equals(rs.getString(9))) {
                                String dateColumn = rs.getString(10);
                                mTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear(mTab, rs.getInt(7), dateColumn, null) + ">"));
                            } else {
                                mTab.setValue("DocumentNo", (Object)("<" + rs.getString(5) + ">"));
                            }
                        }
                    }
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("PR")) break block35;
                sql = "SELECT PaymentRule,C_PaymentTerm_ID,InvoiceRule,DeliveryRule,FreightCostRule,DeliveryViaRule, PaymentRulePO,PO_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?";
                pstmt = DB.prepareStatement(sql, null);
                int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block35;
                String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                if (s != null && s.length() != 0) {
                    if (IsSOTrx && (s.equals("B") || s.equals("S") || s.equals("U"))) {
                        s = "P";
                    }
                    if (!IsSOTrx && s.equals("B")) {
                        s = "P";
                    }
                    mTab.setValue("PaymentRule", (Object)s);
                }
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                }
                if ((s = rs.getString(3)) != null && s.length() != 0) {
                    mTab.setValue("InvoiceRule", (Object)s);
                }
                if ((s = rs.getString(4)) != null && s.length() != 0) {
                    mTab.setValue("DeliveryRule", (Object)s);
                }
                if ((s = rs.getString(5)) != null && s.length() != 0) {
                    mTab.setValue("FreightCostRule", (Object)s);
                }
                if ((s = rs.getString(6)) != null && s.length() != 0) {
                    mTab.setValue("DeliveryViaRule", (Object)s);
                }
            }
            catch (SQLException e) {
                String string;
                try {
                    this.log.log(Level.SEVERE, sql, e);
                    string = e.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block37: {
            Integer C_BPartner_ID = (Integer)value;
            if (C_BPartner_ID == null || C_BPartner_ID == 0) {
                return "";
            }
            String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, lship.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, lbill.C_BPartner_Location_ID AS Bill_Location_ID, p.SOCreditStatus,  COALESCE(p.SalesRep_ID, sr.SalesRep_ID) AS SalesRep_ID,  COALESCE(sr.C_SalesRegion_ID, bsr.C_SalesRegion_ID) AS C_SalesRegion_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT JOIN C_SalesRegion bsr ON(bsr.C_SalesRegion_ID = lbill.C_SalesRegion_ID) LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y') LEFT JOIN C_SalesRegion sr ON(sr.C_SalesRegion_ID = lship.C_SalesRegion_ID) LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
            boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
            pstmt = null;
            rs = null;
            try {
                String s;
                String cont;
                String loc;
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block37;
                Integer salesRep = rs.getInt("SalesRep_ID");
                if (IsSOTrx && salesRep != 0) {
                    mTab.setValue("SalesRep_ID", (Object)salesRep);
                }
                int salesRegionId = rs.getInt("C_SalesRegion_ID");
                if (IsSOTrx && salesRegionId != 0) {
                    mTab.setValue("C_SalesRegion_ID", (Object)salesRegionId);
                }
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = Env.getContextAsInt(ctx, "#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                mTab.setValue("Bill_BPartner_ID", (Object)C_BPartner_ID);
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (bill_Location_ID == 0) {
                    mTab.setValue("Bill_Location_ID", null);
                } else {
                    mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                }
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    shipTo_ID = Integer.parseInt(loc);
                }
                if (shipTo_ID == 0) {
                    mTab.setValue("C_BPartner_Location_ID", null);
                } else {
                    mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(shipTo_ID));
                }
                int contID = rs.getInt("AD_User_ID");
                if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (cont = Env.getContext(ctx, WindowNo, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                    mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                }
                if (IsSOTrx) {
                    double CreditLimit = rs.getDouble("SO_CreditLimit");
                    String SOCreditStatus = rs.getString("SOCreditStatus");
                    if (CreditLimit != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat(12).format(CreditAvailable), false);
                        }
                    }
                }
                if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                    mTab.setValue("POReference", (Object)s);
                }
                if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                    mTab.setValue("IsDiscountPrinted", (Object)s);
                } else {
                    mTab.setValue("IsDiscountPrinted", (Object)"N");
                }
                String OrderType = Env.getContext(ctx, WindowNo, "OrderType");
                mTab.setValue("InvoiceRule", (Object)"D");
                mTab.setValue("DeliveryRule", (Object)"A");
                mTab.setValue("PaymentRule", (Object)"P");
                if (OrderType.equals("PR")) {
                    mTab.setValue("InvoiceRule", (Object)"I");
                    mTab.setValue("DeliveryRule", (Object)"R");
                } else if (OrderType.equals("WR")) {
                    mTab.setValue("PaymentRule", (Object)"B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        mTab.setValue("InvoiceRule", (Object)s);
                    }
                    if ((s = rs.getString("DeliveryRule")) != null && s.length() != 0) {
                        mTab.setValue("DeliveryRule", (Object)s);
                    }
                    if ((s = rs.getString("FreightCostRule")) != null && s.length() != 0) {
                        mTab.setValue("FreightCostRule", (Object)s);
                    }
                    if ((s = rs.getString("DeliveryViaRule")) != null && s.length() != 0) {
                        mTab.setValue("DeliveryViaRule", (Object)s);
                    }
                }
            }
            catch (SQLException e) {
                String string;
                try {
                    this.log.log(Level.SEVERE, sql, e);
                    string = e.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bPartnerBill(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block31: {
            if (this.isCalloutActive()) {
                return "";
            }
            Integer bill_BPartner_ID = (Integer)value;
            if (bill_BPartner_ID == null || bill_BPartner_ID == 0) {
                return "";
            }
            String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule,p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,c.AD_User_ID,p.PO_PriceList_ID, p.PaymentRulePO, p.PO_PaymentTerm_ID,lbill.C_BPartner_Location_ID AS Bill_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
            boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
            pstmt = null;
            rs = null;
            try {
                String s;
                double CreditLimit;
                String cont;
                String loc;
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, bill_BPartner_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block31;
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = Env.getContextAsInt(ctx, "#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (bill_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    bill_Location_ID = Integer.parseInt(loc);
                }
                if (bill_Location_ID == 0) {
                    mTab.setValue("Bill_Location_ID", null);
                } else {
                    mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                }
                int contID = rs.getInt("AD_User_ID");
                if (bill_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (cont = Env.getContext(ctx, WindowNo, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("Bill_User_ID", null);
                } else {
                    mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                }
                if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                    double CreditAvailable = rs.getDouble("CreditAvailable");
                    if (!rs.wasNull() && CreditAvailable < 0.0) {
                        mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat(12).format(CreditAvailable), false);
                    }
                }
                if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                    mTab.setValue("POReference", (Object)s);
                } else {
                    mTab.setValue("POReference", null);
                }
                s = rs.getString("SO_Description");
                if (s != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                    mTab.setValue("IsDiscountPrinted", (Object)s);
                } else {
                    mTab.setValue("IsDiscountPrinted", (Object)"N");
                }
                String OrderType = Env.getContext(ctx, WindowNo, "OrderType");
                mTab.setValue("InvoiceRule", (Object)"D");
                mTab.setValue("PaymentRule", (Object)"P");
                if (OrderType.equals("PR")) {
                    mTab.setValue("InvoiceRule", (Object)"I");
                } else if (OrderType.equals("WR")) {
                    mTab.setValue("PaymentRule", (Object)"B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        mTab.setValue("InvoiceRule", (Object)s);
                    }
                }
            }
            catch (SQLException e) {
                String string;
                try {
                    this.log.log(Level.SEVERE, "bPartnerBill", e);
                    string = e.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String priceList(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_PriceList_ID = (Integer)mTab.getValue("M_PriceList_ID");
        if (M_PriceList_ID == null || M_PriceList_ID == 0) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT pl.IsTaxIncluded,pl.EnforcePriceLimit,pl.C_Currency_ID,c.StdPrecision,plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            Timestamp date = new Timestamp(System.currentTimeMillis());
            if (mTab.getAD_Table_ID() == I_C_Order.Table_ID) {
                date = Env.getContextAsDate(ctx, WindowNo, "DateOrdered");
            } else if (mTab.getAD_Table_ID() == I_C_Invoice.Table_ID) {
                date = Env.getContextAsDate(ctx, WindowNo, "DateInvoiced");
            }
            pstmt.setTimestamp(2, date);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("IsTaxIncluded", (Object)new Boolean("Y".equals(rs.getString(1))));
                Integer ii = new Integer(rs.getInt(3));
                mTab.setValue("C_Currency_ID", (Object)ii);
                Env.setContext(ctx, WindowNo, "M_PriceList_Version_ID", rs.getInt(5));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            String string = e.getLocalizedMessage();
            return string;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        Integer M_Product_ID = (Integer)value;
        Integer M_AttributeSetInstance_ID = 0;
        if (M_Product_ID == null || M_Product_ID == 0) {
            mTab.setValue("M_AttributeSetInstance_ID", null);
            mTab.setValue("PriceList", (Object)new BigDecimal(0));
            mTab.setValue("PriceLimit", (Object)new BigDecimal(0));
            mTab.setValue("PriceActual", (Object)new BigDecimal(0));
            mTab.setValue("PriceEntered", (Object)new BigDecimal(0));
            mTab.setValue("C_Currency_ID", null);
            mTab.setValue("Discount", (Object)new BigDecimal(0));
            mTab.setValue("C_UOM_ID", null);
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        I_M_AttributeSetInstance asi = product.getM_AttributeSetInstance();
        mTab.setValue("C_Charge_ID", null);
        MProduct m_product = MProduct.get(Env.getCtx(), M_Product_ID);
        mTab.setValue("M_AttributeSetInstance_ID", (Object)m_product.getEnvAttributeSetInstance(ctx, WindowNo));
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)asi.getM_AttributeSetInstance_ID());
        }
        int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyOrdered");
        boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, Qty, IsSOTrx, null);
        int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateOrdered");
        int M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC", M_PriceList_ID, orderDate)) > 0) {
            Env.setContext(ctx, WindowNo, "M_PriceList_Version_ID", M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        pp.setPriceDate(orderDate);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("Discount", (Object)pp.getDiscount());
        mTab.setValue("C_UOM_ID", (Object)new Integer(pp.getC_UOM_ID()));
        mTab.setValue("QtyOrdered", mTab.getValue("QtyEntered"));
        Env.setContext(ctx, WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        if (Env.isSOTrx(ctx, WindowNo) && product.isStocked()) {
            BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
            int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
            M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, "M_AttributeSetInstance_ID");
            BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(QtyOrdered) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            } else {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation(ctx, "@QtyAvailable@=" + available + " - @QtyNotReserved@=" + notReserved + " = " + total);
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                }
            }
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)new Integer(100));
        Env.setContext(ctx, WindowNo, "DiscountSchema", "N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_Charge_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceLimit", (Object)Env.ZERO);
                mTab.setValue("PriceList", (Object)Env.ZERO);
                mTab.setValue("Discount", (Object)Env.ZERO);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                this.log.log(Level.SEVERE, sql, e);
                string = e.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "C_Charge_ID");
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = 0;
        shipC_BPartner_Location_ID = column.equals("C_BPartner_Location_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        Timestamp billDate = Env.getContextAsDate(ctx, WindowNo, "DateOrdered");
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = Env.getContextAsDate(ctx, WindowNo, "DatePromised");
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int billC_BPartner_Location_ID = Env.getContextAsInt(ctx, WindowNo, "Bill_Location_ID");
        if (billC_BPartner_Location_ID == 0) {
            billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        }
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        int C_Tax_ID = Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx")), null);
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int uOMToId = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
        int productId = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int priceListId = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
        int standardPrecision = MPriceList.getStandardPrecision(ctx, priceListId);
        BigDecimal quantityEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal quantityOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        this.log.fine("QtyEntered=" + quantityEntered + ", Ordered=" + quantityOrdered + ", UOM=" + uOMToId);
        BigDecimal priceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal priceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal priceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal priceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + priceList + ", Limit=" + priceLimit + ", Precision=" + standardPrecision);
        this.log.fine("PriceEntered=" + priceEntered + ", Actual=" + priceActual + ", Discount=" + discount);
        if (productId == 0) {
            if (mField.getColumnName().equals("PriceActual")) {
                priceEntered = (BigDecimal)value;
                mTab.setValue("PriceEntered", value);
            } else if (mField.getColumnName().equals("PriceEntered")) {
                priceActual = (BigDecimal)value;
                mTab.setValue("PriceActual", value);
            }
        } else if ((mField.getColumnName().equals("QtyOrdered") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("C_UOM_ID") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext(ctx, WindowNo, "DiscountSchema"))) {
            int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                quantityOrdered = MUOMConversion.convertProductFrom(ctx, productId, uOMToId, quantityEntered);
            }
            if (quantityOrdered == null) {
                quantityOrdered = quantityEntered;
            }
            boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
            MProductPricing pp = new MProductPricing(productId, C_BPartner_ID, quantityOrdered, IsSOTrx, null);
            pp.setM_PriceList_ID(priceListId);
            int priceListVersionId = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(priceListVersionId);
            Timestamp date = (Timestamp)mTab.getValue("DateOrdered");
            pp.setPriceDate(date);
            priceEntered = MUOMConversion.convertProductFrom(ctx, productId, uOMToId, pp.getPriceStd());
            if (priceEntered == null) {
                priceEntered = pp.getPriceStd();
            }
            this.log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + priceEntered + ", Discount=" + pp.getDiscount());
            priceActual = pp.getPriceStd();
            mTab.setValue("PriceActual", (Object)pp.getPriceStd());
            mTab.setValue("Discount", (Object)pp.getDiscount());
            mTab.setValue("PriceEntered", (Object)priceEntered);
            Env.setContext(ctx, WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        } else if (mField.getColumnName().equals("PriceActual")) {
            priceActual = (BigDecimal)value;
            priceEntered = MUOMConversion.convertProductFrom(ctx, productId, uOMToId, priceActual);
            if (priceEntered == null) {
                priceEntered = priceActual;
            }
            this.log.fine("PriceActual=" + priceActual + " -> PriceEntered=" + priceEntered);
            mTab.setValue("PriceEntered", (Object)priceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            priceEntered = (BigDecimal)value;
            priceActual = MUOMConversion.convertProductTo(ctx, productId, uOMToId, priceEntered);
            if (priceActual == null) {
                priceActual = priceEntered;
            }
            this.log.fine("PriceEntered=" + priceEntered + " -> PriceActual=" + priceActual);
            mTab.setValue("PriceActual", (Object)priceActual);
        }
        if (mField.getColumnName().equals("Discount")) {
            if (priceList.doubleValue() != 0.0) {
                priceActual = new BigDecimal((100.0 - discount.doubleValue()) / 100.0 * priceList.doubleValue());
            }
            if (priceActual.scale() > standardPrecision) {
                priceActual = priceActual.setScale(standardPrecision, 4);
            }
            if ((priceEntered = MUOMConversion.convertProductFrom(ctx, productId, uOMToId, priceActual)) == null) {
                priceEntered = priceActual;
            }
            mTab.setValue("PriceActual", (Object)priceActual);
            mTab.setValue("PriceEntered", (Object)priceEntered);
        } else {
            discount = priceList.intValue() == 0 ? Env.ZERO : new BigDecimal((priceList.doubleValue() - priceActual.doubleValue()) / priceList.doubleValue() * 100.0);
            if (discount.scale() > 2) {
                discount = discount.setScale(2, 4);
            }
            mTab.setValue("Discount", (Object)discount);
        }
        this.log.fine("PriceEntered=" + priceEntered + ", Actual=" + priceActual + ", Discount=" + discount);
        if (MPriceList.isCheckPriceLimit(priceListId).booleanValue() && priceLimit.doubleValue() != 0.0 && priceActual.compareTo(priceLimit) < 0) {
            priceActual = priceLimit;
            priceEntered = MUOMConversion.convertProductFrom(ctx, productId, uOMToId, priceLimit);
            if (priceEntered == null) {
                priceEntered = priceLimit;
            }
            this.log.fine("(under) PriceEntered=" + priceEntered + ", Actual" + priceLimit);
            mTab.setValue("PriceActual", (Object)priceLimit);
            mTab.setValue("PriceEntered", (Object)priceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (priceList.intValue() != 0) {
                discount = new BigDecimal((priceList.doubleValue() - priceActual.doubleValue()) / priceList.doubleValue() * 100.0);
                if (discount.scale() > 2) {
                    discount = discount.setScale(2, 4);
                }
                mTab.setValue("Discount", (Object)discount);
            }
        }
        BigDecimal lineNetAmount = null;
        if (productId != 0 && (product = MProduct.get(ctx, productId)).getC_UOM_ID() != uOMToId && priceEntered != null && !priceEntered.equals(Env.ZERO) && quantityEntered != null && !quantityEntered.equals(Env.ZERO)) {
            lineNetAmount = quantityEntered.multiply(priceEntered);
        }
        if (lineNetAmount == null) {
            lineNetAmount = quantityOrdered.multiply(priceActual);
        }
        if (lineNetAmount.scale() > standardPrecision) {
            lineNetAmount = lineNetAmount.setScale(standardPrecision, 4);
        }
        this.log.info("LineNetAmt=" + lineNetAmount);
        mTab.setValue("LineNetAmt", (Object)lineNetAmount);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        int C_UOM_To_ID;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        if (this.steps) {
            this.log.warning("init - M_Product_ID=" + M_Product_ID + " - ");
        }
        BigDecimal QtyOrdered = Env.ZERO;
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered;
            QtyOrdered = QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyOrdered/PriceEntered=" + QtyOrdered + "/" + PriceEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyOrdered")) {
            BigDecimal QtyEntered;
            C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        } else {
            QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        }
        if (M_Product_ID != 0 && Env.isSOTrx(ctx, WindowNo) && QtyOrdered.signum() > 0 && (product = MProduct.get(ctx, M_Product_ID)).isStocked()) {
            int M_AttributeSetInstance_ID;
            int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
            BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, "M_AttributeSetInstance_ID"), null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(QtyOrdered) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            } else {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation(ctx, "@QtyAvailable@=" + available + "  -  @QtyNotReserved@=" + notReserved + "  =  " + total);
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                }
            }
        }
        return "";
    }
}

