/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import com.akunagroup.uk.postcode.AddressLookupInterface;
import com.akunagroup.uk.postcode.Postcode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.CityAutoCompleter;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRegion;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBoxEditable;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DefaultContextProvider;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VLocationDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 6952838437136830975L;
    private Object[] header = null;
    private int m_WindowNo = 0;
    private boolean m_change = false;
    private MLocation m_location;
    private int m_origCountry_ID;
    private int s_oldCountry_ID = 0;
    private static CLogger log = CLogger.getCLogger(VLocationDialog.class);
    private CPanel panel = new CPanel();
    private CPanel mainPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private BorderLayout panelLayout = new BorderLayout();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private BorderLayout southLayout = new BorderLayout();
    private CLabel lAddress1 = new CLabel(Msg.getElement(Env.getCtx(), "Address1"));
    private CLabel lAddress2 = new CLabel(Msg.getElement(Env.getCtx(), "Address2"));
    private CLabel lAddress3 = new CLabel(Msg.getElement(Env.getCtx(), "Address3"));
    private CLabel lAddress4 = new CLabel(Msg.getElement(Env.getCtx(), "Address4"));
    private CLabel lCity = new CLabel(Msg.getMsg(Env.getCtx(), "City"));
    private CLabel lCountry = new CLabel(Msg.getMsg(Env.getCtx(), "Country"));
    private CLabel lRegion = new CLabel(Msg.getMsg(Env.getCtx(), "Region"));
    private CLabel lPostal = new CLabel(Msg.getMsg(Env.getCtx(), "Postal"));
    private CLabel lPostalAdd = new CLabel(Msg.getMsg(Env.getCtx(), "PostalAdd"));
    private CLabel lOnline = new CLabel("");
    private CTextField fAddress1 = new CTextField(20);
    private CTextField fAddress2 = new CTextField(20);
    private CTextField fAddress3 = new CTextField(20);
    private CTextField fAddress4 = new CTextField(20);
    private CTextField fCity = new CTextField(20);
    private CityAutoCompleter fCityAutoCompleter;
    private CComboBoxEditable fCountry;
    private CComboBoxEditable fRegion;
    private CTextField fPostal = new CTextField(5);
    private CTextField fPostalAdd = new CTextField(5);
    private CButton fOnline = new CButton();
    private CButton bUrl = new CButton();
    private GridBagConstraints gbc = new GridBagConstraints();
    private Insets labelInsets = new Insets(2, 15, 2, 0);
    private Insets fieldInsets = new Insets(2, 5, 2, 10);
    private boolean isCityMandatory = false;
    private boolean isRegionMandatory = false;
    private boolean isAddress1Mandatory = false;
    private boolean isAddress2Mandatory = false;
    private boolean isAddress3Mandatory = false;
    private boolean isAddress4Mandatory = false;
    private boolean isPostalMandatory = false;
    private boolean isPostalAddMandatory = false;
    private boolean inCountryAction;
    private boolean inOKAction;

    public VLocationDialog(Frame frame, String title, MLocation location) {
        super(frame, title, true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.m_location = location;
        if (this.m_location == null) {
            this.m_location = new MLocation(Env.getCtx(), 0, null);
        }
        if (this.m_location.getC_Location_ID() == 0) {
            this.setTitle(Msg.getMsg(Env.getCtx(), "LocationNew"));
        } else {
            this.setTitle(Msg.getMsg(Env.getCtx(), "LocationUpdate"));
        }
        Env.setContext(Env.getCtx(), this.m_WindowNo, 1113, "C_Region_ID", null);
        Env.setContext(Env.getCtx(), this.m_WindowNo, 1113, "C_Country_ID", null);
        this.fCountry = new CComboBoxEditable(MCountry.getCountries(Env.getCtx()));
        this.fCountry.setSelectedItem(this.m_location.getCountry());
        this.m_origCountry_ID = this.m_location.getC_Country_ID();
        this.fRegion = new CComboBoxEditable(MRegion.getRegions(Env.getCtx(), this.m_origCountry_ID));
        if (this.m_location.getCountry().isHasRegion()) {
            if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                this.lRegion.setText(this.m_location.getCountry().get_Translation("RegionName"));
            } else {
                this.lRegion.setText(Msg.getMsg(Env.getCtx(), "Region"));
            }
        }
        this.fRegion.setSelectedItem(this.m_location.getRegion());
        this.fOnline.setText(Msg.getMsg(Env.getCtx(), "Online"));
        this.initLocation();
        this.fCountry.addActionListener(this);
        this.fOnline.addActionListener(this);
        this.bUrl.addActionListener(this);
        this.fRegion.addActionListener(this);
        AEnv.positionCenterWindow(frame, this);
    }

    void jbInit() throws Exception {
        this.panel.setLayout(this.panelLayout);
        this.southPanel.setLayout(this.southLayout);
        this.mainPanel.setLayout(this.gridBagLayout);
        this.panelLayout.setHgap(5);
        this.panelLayout.setVgap(10);
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.mainPanel, "Center");
        this.panel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.confirmPanel, "North");
        this.bUrl.setMargin(ConfirmPanel.s_insets);
        this.bUrl.setIcon(Env.getImageIcon("Online10.gif"));
        this.confirmPanel.addComponent(this.bUrl);
        this.confirmPanel.addActionListener(this);
        this.fCityAutoCompleter = new CityAutoCompleter(this.fCity, this.m_WindowNo);
    }

    private void initLocation() {
        MCountry country = this.m_location.getCountry();
        log.fine(country.getName() + ", Region=" + country.isHasRegion() + " " + country.getCaptureSequence() + ", C_Location_ID=" + this.m_location.getC_Location_ID());
        if (country.getC_Country_ID() != this.s_oldCountry_ID) {
            this.fRegion.removeAllItems();
            if (country.isHasRegion()) {
                for (MRegion region : MRegion.getRegions(Env.getCtx(), country.getC_Country_ID())) {
                    this.fRegion.addItem(region);
                }
                if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                    this.lRegion.setText(this.m_location.getCountry().get_Translation("RegionName"));
                } else {
                    this.lRegion.setText(Msg.getMsg(Env.getCtx(), "Region"));
                }
            }
            this.s_oldCountry_ID = this.m_location.getC_Country_ID();
        }
        if (this.m_location.getC_Region_ID() > 0 && this.m_location.getC_Region().getC_Country_ID() == country.getC_Country_ID()) {
            this.fRegion.setSelectedItem(this.m_location.getC_Region());
        } else {
            this.fRegion.setSelectedItem(null);
            this.m_location.setC_Region_ID(0);
        }
        if (country.isHasRegion() && this.m_location.getC_Region_ID() > 0) {
            Env.setContext(Env.getCtx(), this.m_WindowNo, 1113, "C_Region_ID", String.valueOf(this.m_location.getC_Region_ID()));
        } else {
            Env.setContext(Env.getCtx(), this.m_WindowNo, 1113, "C_Region_ID", "0");
        }
        Env.setContext(Env.getCtx(), this.m_WindowNo, 1113, "C_Country_ID", String.valueOf(country.get_ID()));
        this.fCityAutoCompleter.fillList();
        this.gbc.anchor = 18;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.fieldInsets;
        this.gbc.fill = 2;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.mainPanel.removeAll();
        this.mainPanel.add(Box.createVerticalStrut(5), this.gbc);
        int line = 1;
        String ds = country.getCaptureSequence();
        if (ds == null || ds.length() == 0) {
            log.log(Level.SEVERE, "CaptureSequence empty - " + country);
            ds = "";
        }
        this.isCityMandatory = false;
        this.isRegionMandatory = false;
        this.isAddress1Mandatory = false;
        this.isAddress2Mandatory = false;
        this.isAddress3Mandatory = false;
        this.isAddress4Mandatory = false;
        this.isPostalMandatory = false;
        this.isPostalAddMandatory = false;
        StringTokenizer st = new StringTokenizer(ds, "@", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("CO")) {
                this.addLine(line++, this.lCountry, this.fCountry);
                if (!this.m_location.getCountry().isPostcodeLookup()) continue;
                this.addLine(line++, this.lOnline, this.fOnline);
                continue;
            }
            if (s.startsWith("A1")) {
                this.addLine(line++, this.lAddress1, this.fAddress1);
                this.isAddress1Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A2")) {
                this.addLine(line++, this.lAddress2, this.fAddress2);
                this.isAddress2Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A3")) {
                this.addLine(line++, this.lAddress3, this.fAddress3);
                this.isAddress3Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A4")) {
                this.addLine(line++, this.lAddress4, this.fAddress4);
                this.isAddress4Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("C")) {
                this.addLine(line++, this.lCity, this.fCity);
                this.isCityMandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("P")) {
                this.addLine(line++, this.lPostal, this.fPostal);
                this.isPostalMandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A")) {
                this.addLine(line++, this.lPostalAdd, this.fPostalAdd);
                this.isPostalAddMandatory = s.endsWith("!");
                continue;
            }
            if (!s.startsWith("R") || !this.m_location.getCountry().isHasRegion()) continue;
            this.addLine(line++, this.lRegion, this.fRegion);
            this.isRegionMandatory = s.endsWith("!");
        }
        if (this.m_location.getC_Location_ID() != 0) {
            this.fAddress1.setText(this.m_location.getAddress1());
            this.fAddress2.setText(this.m_location.getAddress2());
            this.fAddress3.setText(this.m_location.getAddress3());
            this.fAddress4.setText(this.m_location.getAddress4());
            this.fCity.setText(this.m_location.getCity());
            this.fPostal.setText(this.m_location.getPostal());
            this.fPostalAdd.setText(this.m_location.getPostal_Add());
            if (this.m_location.getCountry().isHasRegion()) {
                if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                    this.lRegion.setText(this.m_location.getCountry().get_Translation("RegionName"));
                } else {
                    this.lRegion.setText(Msg.getMsg(Env.getCtx(), "Region"));
                }
                this.fRegion.setSelectedItem(this.m_location.getRegion());
            }
            if (!this.fCountry.getSelectedItem().equals(country)) {
                this.fCountry.setSelectedItem(country);
            }
        }
        this.pack();
    }

    private void addLine(int line, JLabel label, JComponent field) {
        this.gbc.gridy = line;
        this.gbc.insets = this.labelInsets;
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 2;
        label.setHorizontalAlignment(4);
        this.mainPanel.add((Component)label, this.gbc);
        this.gbc.insets = this.fieldInsets;
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 0;
        this.gbc.insets = this.fieldInsets;
        this.mainPanel.add((Component)field, this.gbc);
    }

    @Override
    public void dispose() {
        if (!this.m_change && this.m_location != null && !this.m_location.is_new()) {
            this.m_location = new MLocation(this.m_location.getCtx(), this.m_location.get_ID(), null);
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            String msg;
            this.inOKAction = true;
            if (this.m_location.getCountry().isHasRegion() && this.fRegion.getSelectedItem() == null && this.fCityAutoCompleter.getC_Region_ID() > 0 && this.fCityAutoCompleter.getC_Region_ID() != this.m_location.getC_Region_ID()) {
                this.fRegion.setSelectedItem(MRegion.get(Env.getCtx(), this.fCityAutoCompleter.getC_Region_ID()));
                this.m_location.setRegion(MRegion.get(Env.getCtx(), this.fCityAutoCompleter.getC_Region_ID()));
            }
            if ((msg = this.validate_OK()) != null) {
                ADialog.error(0, this, "FillMandatory", Msg.parseTranslation(Env.getCtx(), msg));
                this.inOKAction = false;
                return;
            }
            if (this.action_OK()) {
                this.m_change = true;
                this.dispose();
            } else {
                ADialog.error(this.m_WindowNo, this, "CityNotFound");
            }
            this.inOKAction = false;
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_change = false;
            this.dispose();
        } else if (e.getSource() == this.fCountry) {
            this.inCountryAction = true;
            MCountry c = (MCountry)this.fCountry.getSelectedItem();
            this.m_location.setCountry(c);
            this.initLocation();
            this.fCountry.requestFocus();
            this.inCountryAction = false;
        } else if (e.getSource() == this.fRegion) {
            if (this.inCountryAction || this.inOKAction) {
                return;
            }
            MRegion r = (MRegion)this.fRegion.getSelectedItem();
            this.m_location.setRegion(r);
            this.m_location.setC_City_ID(0);
            this.m_location.setCity(null);
            this.initLocation();
            this.fRegion.requestFocus();
        } else if (e.getSource() == this.fOnline) {
            MCountry c = (MCountry)this.fCountry.getSelectedItem();
            if (c.isPostcodeLookup()) {
                this.lookupPostcode(c, this.fPostal.getText());
            }
        } else if (e.getSource() == this.bUrl) {
            Env.startBrowser(DefaultContextProvider.GOOGLE_MAPS_URL_PREFIX + this.getCurrentLocation());
        }
    }

    private String validate_OK() {
        String fields = "";
        if (this.isAddress1Mandatory && this.fAddress1.getText().trim().length() == 0) {
            fields = fields + " @Address1@, ";
        }
        if (this.isAddress2Mandatory && this.fAddress2.getText().trim().length() == 0) {
            fields = fields + " @Address2@, ";
        }
        if (this.isAddress3Mandatory && this.fAddress3.getText().trim().length() == 0) {
            fields = fields + " @Address3@, ";
        }
        if (this.isAddress4Mandatory && this.fAddress4.getText().trim().length() == 0) {
            fields = fields + " @Address4@, ";
        }
        if (this.isCityMandatory && this.fCity.getText().trim().length() == 0) {
            fields = fields + " @C_City_ID@, ";
        }
        if (this.isRegionMandatory && this.fRegion.getSelectedItem() == null) {
            fields = fields + " @C_Region_ID@, ";
        }
        if (this.isPostalMandatory && this.fPostal.getText().trim().length() == 0) {
            fields = fields + " @Postal@, ";
        }
        if (this.isPostalAddMandatory && this.fPostalAdd.getText().trim().length() == 0) {
            fields = fields + " @PostalAdd@, ";
        }
        if (fields.trim().length() > 0) {
            return fields.substring(0, fields.length() - 2);
        }
        return null;
    }

    private boolean action_OK() {
        this.m_location.setAddress1(this.fAddress1.getText());
        this.m_location.setAddress2(this.fAddress2.getText());
        this.m_location.setAddress3(this.fAddress3.getText());
        this.m_location.setAddress4(this.fAddress4.getText());
        this.m_location.setCity(this.fCity.getText());
        this.m_location.setC_City_ID(this.fCityAutoCompleter.getC_City_ID());
        this.m_location.setPostal(this.fPostal.getText());
        this.m_location.setPostal_Add(this.fPostalAdd.getText());
        MCountry c = (MCountry)this.fCountry.getSelectedItem();
        this.m_location.setCountry(c);
        if (this.m_location.getCountry().isHasRegion()) {
            MRegion r = (MRegion)this.fRegion.getSelectedItem();
            this.m_location.setRegion(r);
        } else {
            this.m_location.setC_Region_ID(0);
        }
        return this.m_location.save();
    }

    public boolean isChanged() {
        return this.m_change;
    }

    public MLocation getValue() {
        return this.m_location;
    }

    private String lookupPostcode(MCountry country, String postcode) {
        AddressLookupInterface pcLookup = null;
        try {
            AddressLookupInterface pcLookupTmp = (AddressLookupInterface)Class.forName(country.getLookupClassName()).newInstance();
            pcLookup = pcLookupTmp.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "lookupAddress(): " + e.getMessage();
        }
        postcode = postcode.replaceAll(" ", "").toUpperCase();
        log.fine("Looking up postcode: " + postcode);
        pcLookup.setServerUrl(country.getLookupUrl());
        pcLookup.setClientID(country.getLookupClientID());
        pcLookup.setPassword(country.getLookupPassword());
        if (pcLookup.lookupPostcode(postcode) != 1) {
            return "Postcode Lookup Error";
        }
        this.fillLocation(pcLookup.getAddressData(), country);
        this.fAddress1.requestFocusInWindow();
        return "";
    }

    private void fillLocation(HashMap<String, Object> postcodeData, MCountry country) {
        String warningTitle;
        String warningMsg;
        int response;
        if ((this.fAddress1 != null || this.fAddress2 != null || this.fAddress3 != null || this.fAddress4 != null || this.fCity != null) && (response = JOptionPane.showConfirmDialog(null, warningMsg = "Existing address information will be overwritten. Proceed?", warningTitle = "Warning", 0)) == 1) {
            return;
        }
        Set<String> pcodeKeys = postcodeData.keySet();
        Iterator<String> iterator = pcodeKeys.iterator();
        this.header = null;
        this.header = new Object[pcodeKeys.size()];
        String headerStr = null;
        if (pcodeKeys.size() > 2) {
            System.out.println("Too many postcodes returned from Postcode Lookup - need to Implement ResultData");
        } else {
            int i = 0;
            while ((headerStr = iterator.hasNext() ? iterator.next() : null) != null || iterator.hasNext()) {
                this.header[i] = headerStr;
                Postcode values = (Postcode)postcodeData.get(headerStr);
                this.fAddress1.setText(values.getStreet1());
                this.fAddress2.setText(values.getStreet2());
                this.fAddress3.setText(values.getStreet3());
                this.fAddress4.setText(values.getStreet4());
                this.fCity.setText(values.getCity());
                this.fPostal.setText(values.getPostcode());
                if (country.isHasRegion()) {
                    MRegion[] regions = MRegion.getRegions(country.getCtx(), country.getC_Country_ID());
                    if (regions.length > 0) {
                        boolean found = false;
                        for (i = 0; i < regions.length && !found; ++i) {
                            if (!regions[i].getName().equals(values.getRegion())) continue;
                            this.fRegion.setSelectedItem(regions[i]);
                            log.fine("Found region: " + regions[i].getName());
                            found = true;
                        }
                        if (!found) {
                            MRegion region = new MRegion(country, values.getRegion());
                            if (region.save()) {
                                log.fine("Added new region from web service: " + values.getRegion());
                                Env.reset(false);
                                this.fRegion = new CComboBoxEditable(MRegion.getRegions(Env.getCtx(), country.getC_Country_ID()));
                                this.fRegion.setSelectedItem(values);
                            } else {
                                log.severe("Error saving new region: " + region.getName());
                            }
                        }
                    } else {
                        log.severe("Region lookup failed for Country: " + country.getName());
                    }
                }
                ++i;
            }
        }
    }

    private String getCurrentLocation() {
        this.m_location.setAddress1(this.fAddress1.getText());
        this.m_location.setAddress2(this.fAddress2.getText());
        this.m_location.setAddress3(this.fAddress3.getText());
        this.m_location.setAddress4(this.fAddress4.getText());
        this.m_location.setCity(this.fCity.getText());
        this.m_location.setPostal(this.fPostal.getText());
        this.m_location.setPostal_Add(this.fPostalAdd.getText());
        MCountry c = (MCountry)this.fCountry.getSelectedItem();
        this.m_location.setCountry(c);
        if (this.m_location.getCountry().isHasRegion()) {
            MRegion r = (MRegion)this.fRegion.getSelectedItem();
            this.m_location.setRegion(r);
        } else {
            this.m_location.setC_Region_ID(0);
        }
        return this.m_location.toString().replace(" ", "%");
    }
}

