/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridField;
import org.compiere.swing.CButton;
import org.compiere.swing.CTable;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public final class VHeaderRenderer
implements TableCellRenderer,
MouseListener,
ChangeListener {
    private Integer prefWidth;
    private CButton m_button;
    private JCheckBox m_check;
    private int m_alignment;
    private JLabel m_label;
    private boolean m_multiSelection = false;
    private JTable m_table;
    private int m_column;
    private boolean mousePressed;
    private boolean m_headerOnly;

    public VHeaderRenderer() {
        this.m_check = null;
        this.m_button = new CButton();
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.putClientProperty("Plastic.is3D", Boolean.FALSE);
    }

    public VHeaderRenderer(boolean multiSelection) {
        this.m_multiSelection = multiSelection;
        if (this.m_multiSelection) {
            this.m_button = null;
            this.m_check = new JCheckBox();
            this.m_check.setMargin(new Insets(0, 0, 0, 0));
            this.m_check.setHorizontalAlignment(0);
            this.m_check.addItemListener(new MyItemListener());
            this.m_alignment = 0;
        } else {
            this.m_alignment = 4;
        }
    }

    public VHeaderRenderer(GridField mField) {
        this.m_alignment = DisplayType.isNumeric(mField.getDisplayType()) ? 4 : (mField.getDisplayType() == 20 ? 0 : 2);
        this.m_label = new JLabel();
        if (mField.getPreferredWidthInListView() != 0) {
            this.prefWidth = mField.getPreferredWidthInListView();
        }
    }

    public VHeaderRenderer(int displayType) {
        this.m_alignment = DisplayType.isNumeric(displayType) ? 4 : (displayType == 20 ? 0 : 2);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (!(source instanceof AbstractButton)) {
            return;
        }
        boolean checked = ((JCheckBox)source).isSelected();
        if (!checked && this.m_check.isSelected()) {
            this.m_headerOnly = true;
            this.m_check.setSelected(false);
            this.m_table.getTableHeader().repaint();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        CTable cTable;
        ImageIcon icon = null;
        this.m_table = table2;
        this.m_column = column;
        if (table2 instanceof CTable && (cTable = (CTable)table2).getSortColumn() == table2.convertColumnIndexToModel(column)) {
            ImageIcon imageIcon = icon = cTable.isSortAscending() ? Env.getImageIcon2("uparrow") : Env.getImageIcon2("downarrow");
        }
        if (this.m_label == null && this.m_button == null && this.m_check == null) {
            Component headerComponent;
            TableCellRenderer headerRenderer = table2.getTableHeader().getDefaultRenderer();
            Component component = headerComponent = headerRenderer == null ? null : headerRenderer.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            if (value == null) {
                headerComponent.setPreferredSize(new Dimension(0, 0));
            }
            if (headerComponent instanceof JLabel) {
                ((JLabel)headerComponent).setIcon(icon);
                ((JLabel)headerComponent).setHorizontalTextPosition(10);
            }
            return headerComponent;
        }
        if (this.m_button == null && this.m_check == null) {
            this.m_label.setHorizontalAlignment(this.m_alignment);
            if (value == null) {
                this.m_label.setPreferredSize(new Dimension(0, 0));
            } else {
                this.m_label.setText(value.toString());
                if (this.prefWidth != null && this.prefWidth > 0) {
                    this.m_label.setPreferredSize(new Dimension(this.prefWidth, this.m_label.getHeight()));
                    this.m_label.setToolTipText(value.toString());
                }
            }
            this.m_label.setIcon(icon);
            this.m_label.setHorizontalTextPosition(10);
            return this.m_label;
        }
        if (this.m_button == null) {
            JTableHeader header;
            if (table2 != null && (header = table2.getTableHeader()) != null) {
                this.m_check.setForeground(header.getForeground());
                this.m_check.setBackground(header.getBackground());
                this.m_check.setBorder(new MatteBorder(0, 0, 1, 1, AdempierePLAF.getSecondary1()));
                this.m_check.setFont(header.getFont());
                this.m_check.setBorderPainted(true);
                this.m_check.setEnabled(true);
                header.addMouseListener(this);
            }
            return this.m_check;
        }
        if (value == null) {
            this.m_button.setPreferredSize(new Dimension(0, 0));
            return this.m_button;
        }
        this.m_button.setText(value.toString());
        this.m_button.setIcon(icon);
        this.m_button.setHorizontalTextPosition(10);
        return this.m_button;
    }

    protected void handleClickEvent(MouseEvent e) {
        JTableHeader header = (JTableHeader)e.getSource();
        JTable tableView = header.getTable();
        TableColumnModel columnModel = tableView.getColumnModel();
        int viewColumn = columnModel.getColumnIndexAtX(e.getX());
        int column = tableView.convertColumnIndexToModel(viewColumn);
        if (viewColumn == this.m_column && e.getClickCount() == 1 && column != -1) {
            this.m_check.doClick();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mousePressed) {
            this.mousePressed = false;
            this.handleClickEvent(e);
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof AbstractButton)) {
                return;
            }
            if (VHeaderRenderer.this.m_headerOnly) {
                VHeaderRenderer.this.m_headerOnly = false;
                return;
            }
            boolean checked = e.getStateChange() == 1;
            int y = VHeaderRenderer.this.m_table.getRowCount();
            for (int x = 0; x < y; ++x) {
                Object data = VHeaderRenderer.this.m_table.getValueAt(x, VHeaderRenderer.this.m_column);
                if (data instanceof IDColumn) {
                    IDColumn record = (IDColumn)data;
                    record.setSelected(checked);
                    VHeaderRenderer.this.m_table.setValueAt(record, x, VHeaderRenderer.this.m_column);
                    continue;
                }
                if (!(data instanceof Boolean)) continue;
                boolean record = (Boolean)data;
                record = checked;
                VHeaderRenderer.this.m_table.setValueAt(record, x, VHeaderRenderer.this.m_column);
            }
            ((MiniTable)VHeaderRenderer.this.m_table).fireRowSelectionEvent();
        }
    }
}

