/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import org.adempiere.exceptions.ValueChangeListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.db.CConnection;
import org.compiere.db.CConnectionDialog;
import org.compiere.model.GridField;
import org.compiere.swing.CEditor;
import org.compiere.util.DB;

public class CConnectionEditor
extends JComponent
implements CEditor {
    private static final long serialVersionUID = 259945316129032408L;
    private JTextField m_text = new JTextField(10);
    private JLabel m_db = new JLabel();
    private JLabel m_server = new JLabel();
    private CConnection m_value = null;
    private boolean m_rw = true;
    private boolean m_mandatory = false;

    public CConnectionEditor() {
        this.setName("ConnectionEditor");
        CConnectionEditor_MouseListener ml = new CConnectionEditor_MouseListener();
        this.m_text.setEditable(false);
        this.m_text.setBorder(null);
        this.m_text.addMouseListener(ml);
        this.m_server.setIcon(new ImageIcon(this.getClass().getResource("Server16.gif")));
        this.m_server.setFocusable(false);
        this.m_server.setBorder(null);
        this.m_server.setOpaque(true);
        this.m_server.addMouseListener(ml);
        this.m_db.setIcon(new ImageIcon(this.getClass().getResource("Database16.gif")));
        this.m_db.setFocusable(false);
        this.m_db.setBorder(null);
        this.m_db.setOpaque(true);
        this.m_db.addMouseListener(ml);
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.m_server, "West");
        this.add((Component)this.m_text, "Center");
        this.add((Component)this.m_db, "East");
    }

    @Override
    public void setReadWrite(boolean rw) {
        this.m_rw = rw;
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_rw;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setBackground(boolean error) {
        Color c = null;
        c = error ? AdempierePLAF.getFieldBackground_Error() : (!this.m_rw ? AdempierePLAF.getFieldBackground_Inactive() : (this.m_mandatory ? AdempierePLAF.getFieldBackground_Mandatory() : AdempierePLAF.getFieldBackground_Normal()));
        this.setBackground(c);
    }

    @Override
    public void setBackground(Color color) {
        this.m_server.setBackground(color);
        this.m_text.setBackground(color);
        this.m_db.setBackground(color);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void setValue(Object value) {
        if (value != null && value instanceof CConnection) {
            this.m_value = (CConnection)value;
        }
        this.setDisplay();
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        if (this.m_value == null) {
            return "";
        }
        return this.m_value.getName();
    }

    public void setDisplay() {
        this.m_text.setText(this.getDisplay());
        if (this.m_value == null) {
            return;
        }
        if (this.m_value.isAppsServerOK(false) || this.m_value.isDatabaseOK()) {
            this.m_text.setForeground(AdempierePLAF.getTextColor_OK());
            this.setBackground(false);
            if (!this.m_value.isAppsServerOK(false)) {
                this.m_server.setBackground(AdempierePLAF.getFieldBackground_Error());
            }
            if (!this.m_value.isDatabaseOK()) {
                this.m_db.setBackground(AdempierePLAF.getFieldBackground_Error());
            }
        } else {
            this.m_text.setForeground(AdempierePLAF.getTextColor_Issue());
            this.setBackground(true);
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    private void fireActionPerformed() {
        ActionEvent e = null;
        ActionListener[] listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, 1001, "actionPerformed");
            }
            listeners[i].actionPerformed(e);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("CConnectionEditor");
        frame.setDefaultCloseOperation(3);
        frame.getRootPane().getContentPane().add(new CConnectionEditor());
        AdempierePLAF.showCenterScreen(frame);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    @Override
    public GridField getField() {
        return null;
    }

    public class CConnectionEditor_MouseListener
    extends MouseAdapter {
        private boolean m_active = false;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!CConnectionEditor.this.isEnabled() || !CConnectionEditor.this.m_rw || this.m_active) {
                return;
            }
            this.m_active = true;
            CConnectionEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            CConnectionDialog cd = new CConnectionDialog(CConnectionEditor.this.m_value);
            CConnectionEditor.this.setValue(cd.getConnection());
            if (!cd.isCancel()) {
                CConnectionEditor.this.fireActionPerformed();
            } else {
                DB.closeTarget();
                DB.setDBTarget(CConnectionEditor.this.m_value);
            }
            CConnectionEditor.this.setCursor(Cursor.getDefaultCursor());
            this.m_active = false;
        }
    }
}

