/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MPriceList;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InvoiceHistory
extends CDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 7886949815469558804L;
    private int m_C_BPartner_ID;
    private int m_M_Product_ID;
    private int m_M_Warehouse_ID;
    private int m_M_AttributeSetInstance_ID;
    private static CLogger log = CLogger.getCLogger(InvoiceHistory.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private JLabel label = new JLabel();
    private FlowLayout northLayout = new FlowLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel();
    private JTabbedPane centerTabbedPane = new JTabbedPane();
    private JScrollPane pricePane = new JScrollPane();
    private MiniTable m_tablePrice = new MiniTable();
    private DefaultTableModel m_modelPrice = null;
    private JScrollPane orderPricePane = new JScrollPane();
    private MiniTable m_tableOrderPrice = new MiniTable();
    private DefaultTableModel m_modelOrderPrice = null;
    private JScrollPane reservedPane = new JScrollPane();
    private MiniTable m_tableReserved = new MiniTable();
    private DefaultTableModel m_modelReserved = null;
    private JScrollPane orderedPane = new JScrollPane();
    private MiniTable m_tableOrdered = new MiniTable();
    private DefaultTableModel m_modelOrdered = null;
    private JScrollPane unconfirmedPane = new JScrollPane();
    private MiniTable m_tableUnconfirmed = new MiniTable();
    private DefaultTableModel m_modelUnconfirmed = null;
    private JScrollPane atpPane = new JScrollPane();
    private MiniTable m_tableAtp = new MiniTable();
    private DefaultTableModel m_modelAtp = null;

    public InvoiceHistory(Dialog frame, int C_BPartner_ID, int M_Product_ID, int M_Warehouse_ID, int M_AttributeSetInstance_ID) {
        super(frame, Msg.getMsg(Env.getCtx(), "PriceHistory"), true);
        log.config("C_BPartner_ID=" + C_BPartner_ID + ", M_Product_ID=" + M_Product_ID + ", M_Warehouse_ID=" + M_Warehouse_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        this.m_C_BPartner_ID = C_BPartner_ID;
        this.m_M_Product_ID = M_Product_ID;
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
        try {
            this.jbInit();
            this.dynInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        this.mainPanel.setPreferredSize(new Dimension(700, 400));
        AEnv.positionCenterWindow(frame, this);
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.mainPanel.setLayout(this.mainLayout);
        this.label.setText("Label");
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.label, null);
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.mainPanel.add((Component)this.centerTabbedPane, "Center");
        this.centerTabbedPane.addChangeListener(this);
        this.centerTabbedPane.add((Component)this.pricePane, Msg.getMsg(Env.getCtx(), "PriceHistory"));
        this.centerTabbedPane.add((Component)this.orderPricePane, Msg.translate(Env.getCtx(), "OrderPriceHistory"));
        this.centerTabbedPane.add((Component)this.reservedPane, Msg.translate(Env.getCtx(), "QtyReserved"));
        this.centerTabbedPane.add((Component)this.orderedPane, Msg.translate(Env.getCtx(), "QtyOrdered"));
        this.centerTabbedPane.add((Component)this.unconfirmedPane, Msg.getMsg(Env.getCtx(), "QtyUnconfirmed"));
        if (this.m_M_Product_ID != 0) {
            this.centerTabbedPane.add((Component)this.atpPane, Msg.getMsg(Env.getCtx(), "ATP"));
        }
        this.pricePane.getViewport().add((Component)this.m_tablePrice, null);
        this.orderPricePane.getViewport().add((Component)this.m_tableOrderPrice, null);
        this.reservedPane.getViewport().add((Component)this.m_tableReserved, null);
        this.orderedPane.getViewport().add((Component)this.m_tableOrdered, null);
        this.unconfirmedPane.getViewport().add((Component)this.m_tableUnconfirmed, null);
        if (this.m_M_Product_ID != 0) {
            this.atpPane.getViewport().add((Component)this.m_tableAtp, null);
        }
        this.confirmPanel.addActionListener(this);
    }

    private boolean dynInit() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), this.m_C_BPartner_ID == 0 ? "C_BPartner_ID" : "M_Product_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "PriceActual"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyInvoiced"));
        columnNames.add(Msg.translate(Env.getCtx(), "Discount"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "DateInvoiced"));
        columnNames.add(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        Vector<Vector<Object>> data = null;
        data = this.m_C_BPartner_ID == 0 ? this.queryBPartner(true) : this.queryProduct(true);
        this.m_modelPrice = new DefaultTableModel(data, columnNames);
        this.m_tablePrice.setModel(this.m_modelPrice);
        this.m_tablePrice.setColumnClass(0, String.class, true);
        this.m_tablePrice.setColumnClass(1, Double.class, true);
        this.m_tablePrice.setColumnClass(2, Double.class, true);
        this.m_tablePrice.setColumnClass(3, BigDecimal.class, true);
        this.m_tablePrice.setColumnClass(4, String.class, true);
        this.m_tablePrice.setColumnClass(5, Timestamp.class, true);
        this.m_tablePrice.setColumnClass(6, String.class, true);
        this.m_tablePrice.autoSize();
        return data.size() != 0;
    }

    private Vector<Vector<Object>> queryProduct(boolean isInvoicePrice) {
        String sql = isInvoicePrice ? "SELECT p.Name,l.PriceActual,l.PriceList,l.QtyInvoiced,i.DateInvoiced,dt.PrintName || ' ' || i.DocumentNo As DocumentNo,o.Name, NULL, i.M_PriceList_ID FROM C_Invoice i INNER JOIN C_InvoiceLine l ON (i.C_Invoice_ID=l.C_Invoice_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) INNER JOIN AD_Org o ON (i.AD_Org_ID=o.AD_Org_ID) INNER JOIN M_Product p  ON (l.M_Product_ID=p.M_Product_ID) WHERE i.C_BPartner_ID=" + this.m_M_Product_ID + "ORDER BY i.DateInvoiced DESC" : "SELECT p.Name, ol.PriceActual, ol.PriceList, ol.QtyOrdered, o.DateOrdered,  dt.PrintName || ' ' || o.DocumentNo As DocumentNo, org.Name, NULL, o.M_PriceList_ID FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN AD_Org org ON (o.AD_Org_ID=o.AD_Org_ID) INNER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID) WHERE o.C_BPartner_ID=" + this.m_C_BPartner_ID + "ORDER BY o.DateOrdered DESC";
        Vector<Vector<Object>> data = this.fillTable(sql, this.m_C_BPartner_ID);
        sql = "SELECT Name from C_BPartner WHERE C_BPartner_ID=?";
        this.fillLabel(sql, this.m_C_BPartner_ID);
        return data;
    }

    private Vector<Vector<Object>> queryBPartner(boolean isInvoicePrice) {
        String sql = isInvoicePrice ? "SELECT bp.Name,l.PriceActual,l.PriceList,l.QtyInvoiced,i.DateInvoiced,dt.PrintName || ' ' || i.DocumentNo As DocumentNo,o.Name,NULL, i.M_PriceList_ID FROM C_Invoice i INNER JOIN C_InvoiceLine l ON (i.C_Invoice_ID=l.C_Invoice_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) INNER JOIN AD_Org o ON (i.AD_Org_ID=o.AD_Org_ID) INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID) WHERE l.M_Product_ID=" + this.m_M_Product_ID + "ORDER BY i.DateInvoiced DESC" : "SELECT bp.Name, ol.PriceActual, ol.PriceList, ol.QtyOrdered, o.DateOrdered,  dt.PrintName || ' ' || o.DocumentNo As DocumentNo, org.Name, NULL, o.M_PriceList_ID \tFROM C_Order o \tINNER JOIN C_OrderLine ol\tON (o.C_Order_ID = ol.C_Order_ID)  INNER JOIN C_DocType dt\t\tON (o.C_DocType_ID = dt.C_DocType_ID)  INNER JOIN AD_Org org\t\tON (o.AD_Org_ID = org.AD_Org_ID)  INNER JOIN C_BPartner bp\tON (o.C_BPartner_ID = bp.C_BPartner_ID)  WHERE ol.M_Product_ID=" + this.m_M_Product_ID + " ORDER BY o.DateOrdered DESC";
        Vector<Vector<Object>> data = this.fillTable(sql, this.m_M_Product_ID);
        sql = "SELECT Name from M_Product WHERE M_Product_ID=?";
        this.fillLabel(sql, this.m_M_Product_ID);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Vector<Object>> fillTable(String sql, int parameter) {
        log.fine(sql + "; Parameter=" + parameter);
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(6);
                line.add(rs.getString(1));
                line.add(rs.getBigDecimal(2));
                line.add(new Double(rs.getDouble(4)));
                BigDecimal discountBD = rs.getBigDecimal(8);
                if (discountBD == null) {
                    double priceList = rs.getDouble(3);
                    double priceActual = rs.getDouble(2);
                    if (priceList != 0.0) {
                        discountBD = new BigDecimal((priceList - priceActual) / priceList * 100.0);
                        int precision = MPriceList.getStandardPrecision(Env.getCtx(), rs.getInt(9));
                        if (discountBD.scale() > precision) {
                            discountBD = discountBD.setScale(precision, RoundingMode.HALF_UP);
                        }
                    } else {
                        discountBD = Env.ZERO;
                    }
                }
                line.add(discountBD);
                line.add(rs.getString(6));
                line.add(rs.getTimestamp(5));
                line.add(rs.getString(7));
                data.add(line);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("#" + data.size());
        return data;
    }

    private void fillLabel(String sql, int parameter) {
        log.fine(sql + "; Parameter=" + parameter);
        String retValue = DB.getSQLValueString(null, sql, parameter);
        if (retValue != null) {
            this.label.setText(retValue);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.centerTabbedPane.getSelectedIndex() == 1) {
            this.initOrderPriceHistoryTab();
        } else if (this.centerTabbedPane.getSelectedIndex() == 2) {
            this.initReservedOrderedTab(true);
        } else if (this.centerTabbedPane.getSelectedIndex() == 3) {
            this.initReservedOrderedTab(false);
        } else if (this.centerTabbedPane.getSelectedIndex() == 4) {
            this.initUnconfirmedTab();
        } else if (this.centerTabbedPane.getSelectedIndex() == 5) {
            this.initAtpTab();
        }
    }

    private void initReservedOrderedTab(boolean reserved) {
        if (reserved && this.m_modelReserved != null) {
            return;
        }
        if (!reserved && this.m_modelOrdered != null) {
            return;
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), this.m_C_BPartner_ID == 0 ? "C_BPartner_ID" : "M_Product_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "PriceActual"));
        columnNames.add(Msg.translate(Env.getCtx(), reserved ? "QtyReserved" : "QtyOrdered"));
        columnNames.add(Msg.translate(Env.getCtx(), "Discount"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "DateOrdered"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        Vector<Vector<Object>> data = null;
        String sql = this.m_C_BPartner_ID == 0 ? "SELECT bp.Name AS BPName, ol.PriceActual AS PriceActual,ol.PriceList AS PriceList ,ol.QtyReserved AS QtyReserved,o.DateOrdered AS DateOrdered,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name AS WarehouseName,ol.Discount AS Discount FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=" + this.m_M_Product_ID + " AND o.IsSOTrx=" + (reserved ? "'Y'" : "'N'") : "SELECT p.Name AS BPName , ol.PriceActual AS PriceActual ,ol.PriceList AS PriceList ,ol.QtyReserved AS QtyReserved,o.DateOrdered AS DateOrdered ,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name AS WarehouseName,ol.Discount AS Discount FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_Product p  ON (ol.M_Product_ID=p.M_Product_ID) WHERE ol.QtyReserved<>0 AND o.C_BPartner_ID=" + this.m_C_BPartner_ID + " AND o.IsSOTrx=" + (reserved ? "'Y'" : "'N'");
        if (reserved) {
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT null AS BPName, 0 AS PriceActual,0 AS PriceList,ol.QtyReserved AS QtyReserved,o.DateOrdered AS DateOrdered,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name AS WarehouseName,0 AS Discount FROM PP_Order o INNER JOIN PP_Order_BOMLine ol ON (o.PP_Order_ID=ol.PP_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_Product p  ON (ol.M_Product_ID=p.M_Product_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=" + this.m_M_Product_ID;
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT null AS BPName , 0 AS PriceActual ,0 AS PriceList , ol.QtyReserved AS QtyReserved,o.DateOrdered AS DateOrdered ,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name AS WarehouseName,0 AS Discount FROM DD_Order o INNER JOIN DD_OrderLine ol ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Locator l ON (l.M_Locator_ID = ol.M_LocatorTo_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_Product p  ON (ol.M_Product_ID=p.M_Product_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=" + this.m_M_Product_ID;
        } else {
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT null AS BPName, 0 AS PriceActual,0 AS PriceList, o.QtyOrdered AS QtyReserved,o.DateOrdered AS DateOrdered,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name AS WarehouseName,0 AS Discount FROM PP_Order o INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (o.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_Product p  ON (o.M_Product_ID=p.M_Product_ID) WHERE o.QtyOrdered<>0 AND o.M_Product_ID=" + this.m_M_Product_ID;
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT null AS BPName , 0 AS PriceActual ,0 AS PriceList ,ol.QtyOrdered - ol.QtyDelivered AS QtyReserved,o.DateOrdered AS DateOrdered ,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, wf.Name AS WarehouseName,0 AS Discount FROM DD_Order o INNER JOIN DD_OrderLine ol ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Locator lf on (lf.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse wf ON (lf.M_Warehouse_ID=wf.M_Warehouse_ID) INNER JOIN M_Product p  ON (ol.M_Product_ID=p.M_Product_ID) WHERE (ol.QtyOrdered - ol.QtyDelivered) <>0 AND ol.M_Product_ID=" + this.m_M_Product_ID;
        }
        sql = sql + " ORDER BY DateOrdered";
        data = this.fillTable(sql, this.m_C_BPartner_ID);
        MiniTable table2 = null;
        if (reserved) {
            this.m_modelReserved = new DefaultTableModel(data, columnNames);
            this.m_tableReserved.setModel(this.m_modelReserved);
            table2 = this.m_tableReserved;
        } else {
            this.m_modelOrdered = new DefaultTableModel(data, columnNames);
            this.m_tableOrdered.setModel(this.m_modelOrdered);
            table2 = this.m_tableOrdered;
        }
        table2.setColumnClass(0, String.class, true);
        table2.setColumnClass(1, BigDecimal.class, true);
        table2.setColumnClass(2, Double.class, true);
        table2.setColumnClass(3, BigDecimal.class, true);
        table2.setColumnClass(4, String.class, true);
        table2.setColumnClass(5, Timestamp.class, true);
        table2.setColumnClass(6, String.class, true);
        table2.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUnconfirmedTab() {
        if (this.m_modelUnconfirmed != null) {
            return;
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), this.m_C_BPartner_ID == 0 ? "C_BPartner_ID" : "M_Product_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "MovementQty"));
        columnNames.add(Msg.translate(Env.getCtx(), "MovementDate"));
        columnNames.add(Msg.translate(Env.getCtx(), "IsSOTrx"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        String sql = null;
        int parameter = 0;
        if (this.m_C_BPartner_ID == 0) {
            sql = "SELECT bp.Name, CASE WHEN io.IsSOTrx='Y' THEN iol.MovementQty*-1 ELSE iol.MovementQty END AS MovementQty, io.MovementDate,io.IsSOTrx, dt.PrintName || ' ' || io.DocumentNo As DocumentNo, w.Name FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID=io.M_InOut_ID) INNER JOIN C_BPartner bp  ON (io.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_DocType dt ON (io.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (io.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_InOutLineConfirm lc ON (iol.M_InOutLine_ID=lc.M_InOutLine_ID) WHERE iol.M_Product_ID=? AND lc.Processed='N' ORDER BY io.MovementDate,io.IsSOTrx";
            parameter = this.m_M_Product_ID;
        } else {
            sql = "SELECT p.Name, CASE WHEN io.IsSOTrx='Y' THEN iol.MovementQty*-1 ELSE iol.MovementQty END AS MovementQty, io.MovementDate,io.IsSOTrx, dt.PrintName || ' ' || io.DocumentNo As DocumentNo, w.Name FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID=io.M_InOut_ID) INNER JOIN M_Product p  ON (iol.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (io.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (io.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_InOutLineConfirm lc ON (iol.M_InOutLine_ID=lc.M_InOutLine_ID) WHERE io.C_BPartner_ID=? AND lc.Processed='N' ORDER BY io.MovementDate,io.IsSOTrx";
            parameter = this.m_C_BPartner_ID;
        }
        Vector data = new Vector();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, parameter);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(6);
                line.add(rs.getString(1));
                line.add(new Double(rs.getDouble(2)));
                line.add(rs.getTimestamp(3));
                line.add(new Boolean("Y".equals(rs.getString(4))));
                line.add(rs.getString(5));
                line.add(rs.getString(6));
                data.add(line);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.fine("#" + data.size());
        this.m_modelUnconfirmed = new DefaultTableModel(data, columnNames);
        this.m_tableUnconfirmed.setModel(this.m_modelUnconfirmed);
        MiniTable table2 = this.m_tableUnconfirmed;
        table2.setColumnClass(0, String.class, true);
        table2.setColumnClass(1, Double.class, true);
        table2.setColumnClass(2, Timestamp.class, true);
        table2.setColumnClass(3, Boolean.class, true);
        table2.setColumnClass(4, String.class, true);
        table2.setColumnClass(5, String.class, true);
        table2.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAtpTab() {
        String asi;
        double qtyReserved;
        double qtyOrdered;
        double qtyDelivered;
        Vector<Object> line;
        if (this.m_modelAtp != null) {
            return;
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyOnHand"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyReserved"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyOrdered"));
        columnNames.add(Msg.translate(Env.getCtx(), "ATP"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"));
        boolean showDetail = CLogMgt.isLevelFine();
        String sql = "SELECT s.QtyOnHand, 0 AS QtyReserved, 0 AS QtyOrdered, productAttribute(s.M_AttributeSetInstance_ID), s.M_AttributeSetInstance_ID,";
        if (!showDetail) {
            sql = "SELECT SUM(s.QtyOnHand), 0 AS QtyReserved, 0 AS QtyOrdered, productAttribute(s.M_AttributeSetInstance_ID), 0,";
        }
        sql = sql + " w.Name, l.Value , 0 AS QtyDelivered FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) WHERE M_Product_ID=?";
        if (this.m_M_Warehouse_ID != 0) {
            sql = sql + " AND l.M_Warehouse_ID=?";
        }
        if (this.m_M_AttributeSetInstance_ID > 0) {
            sql = sql + " AND s.M_AttributeSetInstance_ID=?";
        }
        sql = sql + " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
        if (!showDetail) {
            sql = sql + " GROUP BY productAttribute(s.M_AttributeSetInstance_ID), w.Name, l.Value";
        }
        sql = sql + " ORDER BY l.Value";
        Vector data = new Vector();
        double qtyExpected = 0.0;
        double qtyOnHand = 0.0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            if (this.m_M_Warehouse_ID != 0) {
                pstmt.setInt(2, this.m_M_Warehouse_ID);
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                pstmt.setInt(3, this.m_M_AttributeSetInstance_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                line = new Vector<Object>(9);
                line.add(null);
                qtyOnHand = rs.getDouble(1);
                qtyDelivered = rs.getDouble(8);
                qtyOrdered = rs.getDouble(3);
                qtyReserved = rs.getDouble(2);
                qtyExpected += qtyOnHand;
                qtyExpected += qtyOrdered;
                qtyExpected -= qtyReserved;
                line.add(qtyOnHand);
                line.add(qtyReserved);
                line.add(qtyOrdered);
                line.add(qtyExpected);
                line.add(null);
                line.add(null);
                line.add(rs.getString(6));
                line.add(rs.getString(7));
                asi = rs.getString(4);
                if (showDetail && (asi == null || asi.length() == 0)) {
                    asi = "{" + rs.getInt(5) + "}";
                }
                line.add(asi);
                data.add(line);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        sql = "SELECT o.DatePromised,CASE WHEN o.IsSOTrx = 'Y' THEN ol.QtyReserved ELSE 0  END AS QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID), ol.M_AttributeSetInstance_ID, dt.DocBaseType, bp.Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name , CASE WHEN o.IsSOTrx = 'N' THEN ol.QtyReserved ELSE 0 END AS QtyOrdered , ol.QtyDelivered AS QtyDelivered FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=" + this.m_M_Product_ID;
        if (this.m_M_Warehouse_ID != 0) {
            sql = sql + " AND ol.M_Warehouse_ID=" + this.m_M_Warehouse_ID;
        }
        if (this.m_M_AttributeSetInstance_ID > 0) {
            sql = sql + " AND ol.M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID;
        }
        sql = sql + " UNION ALL ";
        sql = sql + "SELECT o.DatePromised, ol.QtyReserved AS QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID), ol.M_AttributeSetInstance_ID, dt.DocBaseType, bp.Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, wf.Name , 0 AS QtyOrdered , ol.QtyInTransit AS QtyDelivered FROM DD_Order o INNER JOIN DD_OrderLine ol ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Locator lf on (lf.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse wf ON (lf.M_Warehouse_ID=wf.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID) WHERE ol.QtyReserved <>0 AND o.DocStatus in ('IP','CO') AND o.IsDelivered = 'N'  AND ol.M_Product_ID=" + this.m_M_Product_ID;
        if (this.m_M_Warehouse_ID != 0) {
            sql = sql + " AND wf.M_Warehouse_ID=" + this.m_M_Warehouse_ID;
        }
        if (this.m_M_AttributeSetInstance_ID > 0) {
            sql = sql + " AND ol.M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID;
        }
        sql = sql + " UNION ALL ";
        sql = sql + "SELECT o.DatePromised, 0 AS QtyReserved, productAttribute(ol.M_AttributeSetInstanceTo_ID), ol.M_AttributeSetInstanceTo_ID, dt.DocBaseType, bp.Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name , ol.QtyOrdered, ol.QtyDelivered AS QtyDelivered FROM DD_Order o INNER JOIN DD_OrderLine ol ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Locator l ON (l.M_Locator_ID = ol.M_LocatorTo_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID) WHERE ol.QtyOrdered<>0 AND o.DocStatus in ('IP','CO') AND o.IsDelivered = 'N'  AND ol.M_Product_ID=" + this.m_M_Product_ID;
        if (this.m_M_Warehouse_ID != 0) {
            sql = sql + " AND w.M_Warehouse_ID=" + this.m_M_Warehouse_ID;
        }
        if (this.m_M_AttributeSetInstance_ID > 0) {
            sql = sql + " AND ol.M_AttributeSetInstanceTo_ID=" + this.m_M_AttributeSetInstance_ID;
        }
        sql = sql + " UNION ALL ";
        sql = sql + "SELECT o.DatePromised, 0 AS QtyReserved, productAttribute(o.M_AttributeSetInstance_ID), o.M_AttributeSetInstance_ID, dt.DocBaseType, null AS Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name , o.QtyOrdered AS QtyOrdered , o.QtyDelivered AS QtyDelivered FROM PP_Order o INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (o.M_Warehouse_ID=w.M_Warehouse_ID) WHERE o.M_Product_ID=" + this.m_M_Product_ID;
        if (this.m_M_Warehouse_ID != 0) {
            sql = sql + " AND o.M_Warehouse_ID=" + this.m_M_Warehouse_ID;
        }
        if (this.m_M_AttributeSetInstance_ID > 0) {
            sql = sql + " AND o.M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID;
        }
        sql = sql + " UNION ALL ";
        sql = sql + "SELECT o.DatePromised, ol.QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID), ol.M_AttributeSetInstance_ID, dt.DocBaseType, null AS Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name , 0 AS QtyOrdered , ol.QtyDelivered AS QtyDelivered FROM PP_Order o INNER JOIN PP_Order_BOMLine ol ON (o.PP_Order_ID=ol.PP_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=" + this.m_M_Product_ID;
        if (this.m_M_Warehouse_ID != 0) {
            sql = sql + " AND ol.M_Warehouse_ID=" + this.m_M_Warehouse_ID;
        }
        if (this.m_M_AttributeSetInstance_ID > 0) {
            sql = sql + " AND ol.M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID;
        }
        sql = sql + " ORDER BY DatePromised";
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                line = new Vector(9);
                qtyDelivered = rs.getDouble(10);
                qtyOrdered = rs.getDouble(9);
                qtyReserved = rs.getDouble(2);
                qtyExpected += qtyOrdered;
                qtyExpected -= qtyReserved;
                line.add(rs.getTimestamp(1));
                line.add(0);
                line.add(qtyReserved);
                line.add(qtyOrdered);
                line.add(qtyExpected);
                line.add(rs.getString(7));
                line.add(rs.getString(6));
                line.add(rs.getString(8));
                line.add(null);
                asi = rs.getString(3);
                if (showDetail && (asi == null || asi.length() == 0)) {
                    asi = "{" + rs.getInt(4) + "}";
                }
                line.add(asi);
                data.add(line);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MiniTable table2 = null;
        this.m_modelAtp = new DefaultTableModel(data, columnNames);
        this.m_tableAtp.setModel(this.m_modelAtp);
        table2 = this.m_tableAtp;
        table2.setColumnClass(0, Timestamp.class, true);
        table2.setColumnClass(1, Double.class, true);
        table2.setColumnClass(2, Double.class, true);
        table2.setColumnClass(3, Double.class, true);
        table2.setColumnClass(4, Double.class, true);
        table2.setColumnClass(5, String.class, true);
        table2.setColumnClass(6, String.class, true);
        table2.setColumnClass(7, String.class, true);
        table2.setColumnClass(8, String.class, true);
        table2.setColumnClass(9, String.class, true);
        table2.autoSize();
    }

    private void initOrderPriceHistoryTab() {
        if (this.m_modelOrderPrice != null) {
            return;
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate(Env.getCtx(), this.m_C_BPartner_ID == 0 ? "C_BPartner_ID" : "M_Product_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "PriceActual"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyOrdered"));
        columnNames.add(Msg.translate(Env.getCtx(), "Discount"));
        columnNames.add(Msg.translate(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "DateOrdered"));
        columnNames.add(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        Vector<Vector<Object>> data = null;
        data = this.m_C_BPartner_ID == 0 ? this.queryBPartner(false) : this.queryProduct(false);
        this.m_modelOrderPrice = new DefaultTableModel(data, columnNames);
        this.m_tableOrderPrice.setModel(this.m_modelOrderPrice);
        this.m_tableOrderPrice.setColumnClass(0, String.class, true);
        this.m_tableOrderPrice.setColumnClass(1, Double.class, true);
        this.m_tableOrderPrice.setColumnClass(2, Double.class, true);
        this.m_tableOrderPrice.setColumnClass(3, BigDecimal.class, true);
        this.m_tableOrderPrice.setColumnClass(4, String.class, true);
        this.m_tableOrderPrice.setColumnClass(5, Timestamp.class, true);
        this.m_tableOrderPrice.setColumnClass(6, String.class, true);
        this.m_tableOrderPrice.autoSize();
    }
}

