/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.FindCellEditor;
import org.compiere.apps.search.FindValueEditor;
import org.compiere.apps.search.FindValueRenderer;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MUserQuery;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Column;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CComboBoxEditable;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTable;
import org.compiere.swing.CTextField;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public final class Find
extends CDialog
implements ActionListener,
ChangeListener,
DataStatusListener {
    private static final long serialVersionUID = -5064336990363669996L;
    private int m_AD_Tab_ID;
    private int m_targetWindowNo;
    private int m_AD_Table_ID;
    private String m_tableName;
    private String m_whereExtended;
    private GridField[] m_findFields;
    private MQuery m_query = null;
    private boolean m_isCancel = false;
    private static CLogger log = CLogger.getCLogger(Find.class);
    private int m_total;
    private PreparedStatement m_pstmt;
    private boolean hasValue = false;
    private boolean hasDocNo = false;
    private boolean hasName = false;
    private boolean hasDescription = false;
    private int m_sLine = 6;
    private ArrayList<VEditor> m_sEditors = new ArrayList();
    private ArrayList<VEditor> m_sEditors2 = new ArrayList();
    private Hashtable<Integer, GridField> m_targetFields = new Hashtable();
    public static final int TABNO = 99;
    public static final int FIELDLENGTH = 20;
    public static final int AD_REFERENCE_ID_YESNO = 319;
    private String m_sLast;
    private String m_sNew;
    private String m_sTipText;
    private String m_sToolTipText;
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private StatusBar statusBar = new StatusBar();
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel advancedPanel = new CPanel();
    private BorderLayout advancedLayout = new BorderLayout();
    private ConfirmPanel confirmPanelA = new ConfirmPanel(true, true, false, false, false, false, true);
    private CButton bIgnore = new CButton();
    private JToolBar toolBar = new JToolBar();
    private CComboBoxEditable fQueryName = new CComboBoxEditable();
    private CButton bSave = new CButton();
    private CButton bNew = new CButton();
    private CButton bDelete = new CButton();
    private ConfirmPanel confirmPanelS = new ConfirmPanel(true);
    private BorderLayout simpleLayout = new BorderLayout();
    private CPanel scontentPanel = new CPanel();
    private GridBagLayout scontentLayout = new GridBagLayout();
    private CPanel simplePanel = new CPanel();
    private CLabel valueLabel = new CLabel();
    private CLabel nameLabel = new CLabel();
    private CLabel descriptionLabel = new CLabel();
    private CTextField valueField = new CTextField();
    private CTextField nameField = new CTextField();
    private CTextField descriptionField = new CTextField();
    private CLabel docNoLabel = new CLabel();
    private CTextField docNoField = new CTextField();
    private Component spaceE;
    private Component spaceN;
    private Component spaceW;
    private Component spaceS;
    private JScrollPane advancedScrollPane = new JScrollPane();
    private CTable advancedTable = new CTable(){
        private static final long serialVersionUID = -6201749159307529032L;

        @Override
        public boolean isCellEditable(int row, int column) {
            boolean editable;
            boolean bl = editable = column == 2 || column == 3 || column == 0 || column == 1 || column == 6;
            if (!editable && row >= 0) {
                String columnName = null;
                Object value = this.getModel().getValueAt(row, 2);
                if (value != null) {
                    columnName = value instanceof ValueNamePair ? ((ValueNamePair)value).getValue() : value.toString();
                }
                boolean bl2 = editable = Find.this.getTargetMField(columnName) != null;
            }
            if (column == 0 && row == 0) {
                editable = false;
            }
            return editable;
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            super.columnMoved(e);
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            if (this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            super.columnMarginChanged(e);
        }
    };
    public static final int INDEX_ANDOR = 0;
    public static final int INDEX_LEFTBRACKET = 1;
    public static final int INDEX_COLUMNNAME = 2;
    public static final int INDEX_OPERATOR = 3;
    public static final int INDEX_VALUE = 4;
    public static final int INDEX_VALUE2 = 5;
    public static final int INDEX_RIGHTBRACKET = 6;
    public CComboBox columns = null;
    public CComboBox operators = null;
    private MUserQuery[] userQueries;
    private ValueNamePair[] columnValueNamePairs;
    private CComboBox leftBrackets;
    private CComboBox rightBrackets;
    private CComboBox andOr;
    private static final String FIELD_SEPARATOR = "<^>";
    private static final String SEGMENT_SEPARATOR = "<~>";
    boolean isPair = false;
    boolean isTwoColumns = false;

    public Find(Frame owner, int targetWindowNo, String title, int AD_Tab_ID, int AD_Table_ID, String tableName, String whereExtended, GridField[] findFields, int minRecords) {
        super(owner, Msg.getMsg(Env.getCtx(), "Find") + ": " + title, true);
        log.info(title);
        this.m_targetWindowNo = targetWindowNo;
        this.m_AD_Tab_ID = AD_Tab_ID;
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_tableName = tableName;
        this.m_whereExtended = whereExtended;
        this.m_findFields = findFields;
        this.m_sLast = "** ".concat(Msg.getMsg(Env.getCtx(), "Last Query")).concat(" **");
        this.m_sNew = "** ".concat(Msg.getMsg(Env.getCtx(), "New Query")).concat(" **");
        this.m_sTipText = "<".concat(Msg.getMsg(Env.getCtx(), "SelectOrEnterQueryName")).concat(">");
        this.m_sToolTipText = Msg.getMsg(Env.getCtx(), "SelectOrEnterQueryNameToolTip");
        this.m_query = new MQuery(tableName);
        this.m_query.addRestriction(Env.parseContext(Env.getCtx(), this.m_targetWindowNo, whereExtended, false));
        Env.setContext(Env.getCtx(), this.m_targetWindowNo, "Find_Table_ID", this.m_AD_Table_ID);
        Env.setContext(Env.getCtx(), 1110, "Find_Table_ID", this.m_AD_Table_ID);
        try {
            this.jbInit();
            this.initFind();
            if (this.m_total < minRecords) {
                this.dispose();
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Find", e);
        }
        this.getRootPane().setDefaultButton(this.confirmPanelS.getOKButton());
        AEnv.showCenterWindow(owner, this);
    }

    private void jbInit() throws Exception {
        this.spaceE = Box.createHorizontalStrut(8);
        this.spaceN = Box.createVerticalStrut(8);
        this.spaceW = Box.createHorizontalStrut(8);
        this.spaceS = Box.createVerticalStrut(8);
        this.bIgnore.setIcon(new ImageIcon(Adempiere.class.getResource("images/Ignore24.gif")));
        this.bIgnore.setMargin(new Insets(2, 2, 2, 2));
        this.bIgnore.setToolTipText(Msg.getMsg(Env.getCtx(), "Ignore"));
        this.bIgnore.addActionListener(this);
        this.fQueryName.setToolTipText(this.m_sToolTipText);
        this.fQueryName.setEditable(true);
        this.fQueryName.addActionListener(this);
        this.fQueryName.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                int index = Find.this.fQueryName.getSelectedIndex();
                if (index < 0 && (Find.this.fQueryName.getSelectedItem() == null || Find.this.fQueryName.getSelectedItem().equals(Find.this.m_sTipText))) {
                    Find.this.fQueryName.setSelectedIndex(-1);
                    Find.this.fQueryName.setSelectedItem("");
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (Find.this.fQueryName.getSelectedItem() != null && Find.this.fQueryName.getSelectedItem().equals("")) {
                    Find.this.fQueryName.setSelectedItem(Find.this.m_sTipText);
                }
            }
        });
        this.bSave.setIcon(new ImageIcon(Adempiere.class.getResource("images/Save24.gif")));
        this.bSave.setMargin(new Insets(2, 2, 2, 2));
        this.bSave.setToolTipText(Msg.getMsg(Env.getCtx(), "Save"));
        this.bSave.addActionListener(this);
        this.bNew.setIcon(new ImageIcon(Adempiere.class.getResource("images/New24.gif")));
        this.bNew.setMargin(new Insets(2, 2, 2, 2));
        this.bNew.setToolTipText(Msg.getMsg(Env.getCtx(), "New"));
        this.bNew.addActionListener(this);
        this.bDelete.setIcon(new ImageIcon(Adempiere.class.getResource("images/Delete24.gif")));
        this.bDelete.setMargin(new Insets(2, 2, 2, 2));
        this.bDelete.setToolTipText(Msg.getMsg(Env.getCtx(), "Delete"));
        this.bDelete.addActionListener(this);
        this.southPanel.setLayout(this.southLayout);
        this.valueLabel.setLabelFor(this.valueField);
        this.valueLabel.setText(Msg.translate(Env.getCtx(), "Value"));
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(Msg.translate(Env.getCtx(), "Name"));
        this.descriptionLabel.setLabelFor(this.descriptionField);
        this.descriptionLabel.setText(Msg.translate(Env.getCtx(), "Description"));
        this.valueField.setText("%");
        this.valueField.setColumns(20);
        this.nameField.setText("%");
        this.nameField.setColumns(20);
        this.descriptionField.setText("%");
        this.descriptionField.setColumns(20);
        this.scontentPanel.setToolTipText(Msg.getMsg(Env.getCtx(), "FindTip"));
        this.docNoLabel.setLabelFor(this.docNoField);
        this.docNoLabel.setText(Msg.translate(Env.getCtx(), "DocumentNo"));
        this.docNoField.setText("%");
        this.docNoField.setColumns(20);
        this.advancedScrollPane.setPreferredSize(new Dimension(540, 410));
        this.southPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.scontentPanel.setLayout(this.scontentLayout);
        this.simplePanel.setLayout(this.simpleLayout);
        this.simplePanel.add((Component)this.confirmPanelS, "South");
        this.simplePanel.add((Component)this.scontentPanel, "Center");
        this.scontentPanel.add((Component)this.valueLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.nameLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.descriptionLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
        this.scontentPanel.add((Component)this.valueField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.descriptionField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.scontentPanel.add((Component)this.docNoLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.nameField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add((Component)this.docNoField, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.scontentPanel.add(this.spaceE, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceN, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceW, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.scontentPanel.add(this.spaceS, new GridBagConstraints(2, 15, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.tabbedPane.add((Component)this.simplePanel, Msg.getMsg(Env.getCtx(), "Find"));
        this.toolBar.add((Component)this.bIgnore, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.bNew, null);
        this.toolBar.add((Component)this.bDelete, null);
        this.toolBar.add((Component)this.fQueryName, null);
        this.toolBar.add((Component)this.bSave, null);
        this.advancedPanel.setLayout(this.advancedLayout);
        this.advancedPanel.add((Component)this.toolBar, "North");
        this.advancedPanel.add((Component)this.confirmPanelA, "South");
        this.advancedPanel.add((Component)this.advancedScrollPane, "Center");
        this.advancedScrollPane.getViewport().add((Component)this.advancedTable, null);
        this.tabbedPane.add((Component)this.advancedPanel, Msg.getMsg(Env.getCtx(), "Advanced"));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.confirmPanelA.addActionListener(this);
        this.confirmPanelS.addActionListener(this);
        CButton b = ConfirmPanel.createNewButton(true);
        this.confirmPanelS.addComponent(b);
        b.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Find.this.cmd_cancel();
            }
        });
    }

    private void initFind() {
        GridField mField;
        int i;
        log.config("");
        int parameterNo = 0;
        for (i = 0; i < this.m_findFields.length; ++i) {
            mField = this.m_findFields[i];
            if (!mField.isSelectionColumn()) continue;
            ++parameterNo;
        }
        if (parameterNo >= 7) {
            this.isTwoColumns = true;
        }
        for (i = 0; i < this.m_findFields.length; ++i) {
            GridFieldVO vo;
            mField = this.m_findFields[i];
            if (mField.getVO().displayType == 20) {
                GridField ynfield;
                vo = mField.getVO();
                GridFieldVO ynvo = vo.clone(vo.ctx, vo.WindowNo, vo.TabNo, vo.AD_Window_ID, vo.AD_Tab_ID, vo.tabReadOnly);
                ynvo.IsDisplayed = true;
                ynvo.displayType = 17;
                ynvo.AD_Reference_Value_ID = 319;
                ynvo.lookupInfo = MLookupFactory.getLookupInfo(ynvo.ctx, ynvo.WindowNo, ynvo.AD_Column_ID, ynvo.displayType, Env.getLanguage(ynvo.ctx), ynvo.ColumnName, ynvo.AD_Reference_Value_ID, ynvo.IsParent, ynvo.ValidationCode);
                ynvo.lookupInfo.InfoFactoryClass = ynvo.InfoFactoryClass;
                this.m_findFields[i] = ynfield = new GridField(ynvo);
                mField = ynfield;
            }
            if (mField.getVO().displayType == 28) {
                vo = mField.getVO();
                if (vo.AD_Reference_Value_ID > 0) {
                    GridField postedfield;
                    GridFieldVO postedvo = vo.clone(vo.ctx, vo.WindowNo, vo.TabNo, vo.AD_Window_ID, vo.AD_Tab_ID, vo.tabReadOnly);
                    postedvo.IsDisplayed = true;
                    postedvo.displayType = 17;
                    postedvo.lookupInfo = MLookupFactory.getLookupInfo(postedvo.ctx, postedvo.WindowNo, postedvo.AD_Column_ID, postedvo.displayType, Env.getLanguage(postedvo.ctx), postedvo.ColumnName, postedvo.AD_Reference_Value_ID, postedvo.IsParent, postedvo.ValidationCode);
                    postedvo.lookupInfo.InfoFactoryClass = postedvo.InfoFactoryClass;
                    this.m_findFields[i] = postedfield = new GridField(postedvo);
                    mField = postedfield;
                }
            }
            if (mField.isSelectionColumn()) {
                this.addSelectionColumn(mField);
                this.isPair = !this.isPair;
            }
            this.m_targetFields.put(new Integer(mField.getAD_Column_ID()), mField);
        }
        this.valueLabel.setVisible(this.hasValue);
        this.valueField.setVisible(this.hasValue);
        if (this.hasValue) {
            this.valueField.addActionListener(this);
        }
        this.docNoLabel.setVisible(this.hasDocNo);
        this.docNoField.setVisible(this.hasDocNo);
        if (this.hasDocNo) {
            this.docNoField.addActionListener(this);
        }
        this.nameLabel.setVisible(this.hasName);
        this.nameField.setVisible(this.hasName);
        if (this.hasName) {
            this.nameField.addActionListener(this);
        }
        this.descriptionLabel.setVisible(this.hasDescription);
        this.descriptionField.setVisible(this.hasDescription);
        if (this.hasDescription) {
            this.descriptionField.addActionListener(this);
        }
        this.m_total = this.getNoOfRecords(null, false);
        this.setStatusDB(this.m_total);
        this.statusBar.setStatusLine("");
        this.tabbedPane.addChangeListener(this);
        this.confirmPanelA.getOKButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryEnter"));
        this.confirmPanelA.getCancelButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryCancel"));
        this.confirmPanelS.getOKButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryEnter"));
        this.confirmPanelS.getCancelButton().setToolTipText(Msg.getMsg(Env.getCtx(), "QueryCancel"));
    }

    private void addSelectionColumn(GridField mField) {
        log.config(mField.getHeader());
        int displayLength = mField.getDisplayLength();
        if (displayLength > 20) {
            mField.setDisplayLength(20);
        } else {
            displayLength = 0;
        }
        VEditor editor = null;
        VEditor editor2 = null;
        CLabel label = null;
        if (mField.isLookup()) {
            VLookup vl = new VLookup(mField.getColumnName(), false, false, true, mField.getLookup());
            vl.setField(mField);
            vl.setName(mField.getColumnName());
            editor = vl;
            if (displayLength > 0) {
                mField.setDisplayLength(displayLength);
            }
            label = VEditorFactory.getLabel(mField);
            int lpos = 1;
            int fpos = 2;
            if (this.isTwoColumns) {
                if (!this.isPair) {
                    lpos = 1;
                    fpos = 2;
                    ++this.m_sLine;
                } else {
                    lpos = 3;
                    fpos = 4;
                }
            } else {
                lpos = 1;
                fpos = 2;
                ++this.m_sLine;
            }
            if (label != null) {
                this.scontentPanel.add((Component)label, new GridBagConstraints(lpos, this.m_sLine, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
            }
            this.scontentPanel.add((Component)((Object)editor), new GridBagConstraints(fpos, this.m_sLine, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        } else if (mField.isRangeLookup()) {
            new Box(0);
            Box box = Box.createHorizontalBox();
            editor = VEditorFactory.getEditor(mField, false);
            label = VEditorFactory.getLabel(mField);
            editor.setMandatory(false);
            editor.setReadWrite(true);
            box.add((Component)((Object)editor));
            editor2 = VEditorFactory.getEditor(mField, false);
            editor2.setMandatory(false);
            editor2.setReadWrite(true);
            if (editor2 instanceof CTextField) {
                ((CTextField)((Object)editor2)).addActionListener(this);
            }
            CLabel separator = new CLabel(" - ");
            box.add(separator);
            box.add((Component)((Object)editor2));
            if (displayLength > 0) {
                mField.setDisplayLength(displayLength);
            }
            int lpos = 1;
            int fpos = 2;
            if (this.isTwoColumns) {
                if (!this.isPair) {
                    lpos = 1;
                    fpos = 2;
                    ++this.m_sLine;
                } else {
                    lpos = 3;
                    fpos = 4;
                }
            } else {
                lpos = 1;
                fpos = 2;
                ++this.m_sLine;
            }
            if (label != null) {
                this.scontentPanel.add((Component)label, new GridBagConstraints(lpos, this.m_sLine, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
            }
            this.scontentPanel.add((Component)box, new GridBagConstraints(fpos, this.m_sLine, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        } else {
            editor = VEditorFactory.getEditor(mField, false);
            editor.setMandatory(false);
            editor.setReadWrite(true);
            label = VEditorFactory.getLabel(mField);
            if (displayLength > 0) {
                mField.setDisplayLength(displayLength);
            }
            int lpos = 1;
            int fpos = 2;
            if (this.isTwoColumns) {
                if (!this.isPair) {
                    lpos = 1;
                    fpos = 2;
                    ++this.m_sLine;
                } else {
                    lpos = 3;
                    fpos = 4;
                }
            } else {
                lpos = 1;
                fpos = 2;
                ++this.m_sLine;
            }
            label = VEditorFactory.getLabel(mField);
            if (label != null) {
                this.scontentPanel.add((Component)label, new GridBagConstraints(lpos, this.m_sLine, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 5, 5, 5), 0, 0));
            }
            this.scontentPanel.add((Component)((Object)editor), new GridBagConstraints(fpos, this.m_sLine, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        if (editor instanceof CTextField) {
            ((CTextField)((Object)editor)).addActionListener(this);
        }
        this.m_sEditors.add(editor);
        this.m_sEditors2.add(editor2);
    }

    private void initFindAdvanced() {
        log.config("");
        this.advancedTable.setModel(new DefaultTableModel(0, 7));
        this.advancedTable.setSelectionMode(0);
        this.advancedTable.setAutoResizeMode(4);
        this.advancedTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ProxyRenderer renderer = new ProxyRenderer(this.advancedTable.getDefaultRenderer(Object.class));
        this.advancedTable.setDefaultRenderer(Object.class, renderer);
        InputMap im = this.advancedTable.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        final Action tabAction = this.advancedTable.getActionMap().get(im.get(tab));
        AbstractAction tabActionWrapper = new AbstractAction(){
            private static final long serialVersionUID = -6868476640719619801L;

            @Override
            public void actionPerformed(ActionEvent e) {
                tabAction.actionPerformed(e);
                JTable table2 = (JTable)e.getSource();
                table2.requestFocusInWindow();
            }
        };
        this.advancedTable.getActionMap().put(im.get(tab), tabActionWrapper);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        final Action shiftTabAction = this.advancedTable.getActionMap().get(im.get(shiftTab));
        AbstractAction shiftTabActionWrapper = new AbstractAction(){
            private static final long serialVersionUID = 5493691483070046620L;

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftTabAction.actionPerformed(e);
                JTable table2 = (JTable)e.getSource();
                table2.requestFocusInWindow();
            }
        };
        this.advancedTable.getActionMap().put(im.get(shiftTab), shiftTabActionWrapper);
        ArrayList<ValueNamePair> items = new ArrayList<ValueNamePair>();
        for (int c = 0; c < this.m_findFields.length; ++c) {
            GridField field = this.m_findFields[c];
            String columnName = field.getColumnName();
            String header = field.getHeader();
            if ((header == null || header.length() == 0) && ((header = Msg.translate(Env.getCtx(), columnName)) == null || header.length() == 0)) continue;
            if (field.isKey()) {
                header = header + " (ID)";
            }
            ValueNamePair pp = new ValueNamePair(columnName, header);
            items.add(pp);
        }
        this.columnValueNamePairs = new ValueNamePair[items.size()];
        items.toArray(this.columnValueNamePairs);
        Arrays.sort(this.columnValueNamePairs);
        this.columns = new CComboBox(this.columnValueNamePairs);
        this.columns.addActionListener(this);
        TableColumn tc = this.advancedTable.getColumnModel().getColumn(2);
        tc.setPreferredWidth(120);
        FindCellEditor dce = new FindCellEditor(this.columns);
        dce.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent ce) {
            }

            @Override
            public void editingStopped(ChangeEvent ce) {
                int col = Find.this.advancedTable.getSelectedColumn();
                int row = Find.this.advancedTable.getSelectedRow();
                if (col == 2 && row >= 0) {
                    Find.this.advancedTable.setValueAt(null, row, 4);
                    Find.this.advancedTable.setValueAt(null, row, 5);
                }
            }
        });
        tc.setCellEditor(dce);
        tc.setHeaderValue(Msg.translate(Env.getCtx(), "AD_Column_ID"));
        this.andOr = new CComboBox(new String[]{"", Msg.getMsg(Env.getCtx(), "AND"), Msg.getMsg(Env.getCtx(), "OR")});
        tc = this.advancedTable.getColumnModel().getColumn(0);
        tc.setPreferredWidth(45);
        dce = new FindCellEditor(this.andOr);
        tc.setCellEditor(dce);
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "And/Or"));
        this.leftBrackets = new CComboBox(new String[]{"", "(", "((", "((("});
        tc = this.advancedTable.getColumnModel().getColumn(1);
        tc.setPreferredWidth(25);
        dce = new FindCellEditor(this.leftBrackets);
        tc.setCellEditor(dce);
        tc.setHeaderValue("(");
        this.operators = new CComboBox(MQuery.OPERATORS);
        tc = this.advancedTable.getColumnModel().getColumn(3);
        tc.setPreferredWidth(55);
        dce = new FindCellEditor(this.operators);
        tc.setCellEditor(dce);
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "Operator"));
        tc = this.advancedTable.getColumnModel().getColumn(4);
        FindValueEditor fve = new FindValueEditor(this, false);
        tc.setCellEditor(fve);
        tc.setPreferredWidth(120);
        tc.setCellRenderer(new ProxyRenderer(new FindValueRenderer(this, false)));
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "QueryValue"));
        tc = this.advancedTable.getColumnModel().getColumn(5);
        tc.setPreferredWidth(120);
        fve = new FindValueEditor(this, true);
        tc.setCellEditor(fve);
        tc.setCellRenderer(new ProxyRenderer(new FindValueRenderer(this, false)));
        tc.setHeaderValue(Msg.getMsg(Env.getCtx(), "QueryValue2"));
        this.rightBrackets = new CComboBox(new String[]{"", ")", "))", ")))"});
        tc = this.advancedTable.getColumnModel().getColumn(6);
        tc.setPreferredWidth(25);
        dce = new FindCellEditor(this.rightBrackets);
        tc.setCellEditor(dce);
        tc.setHeaderValue(")");
        this.refreshUserQueries();
    }

    @Override
    public void dispose() {
        log.config("");
        if (this.m_pstmt != null) {
            try {
                this.m_pstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.m_pstmt = null;
        for (VEditor editor : this.m_sEditors) {
            if (!(editor instanceof CTextField)) continue;
            ((CTextField)((Object)editor)).removeActionListener(this);
        }
        if (this.m_targetFields != null) {
            this.m_targetFields.clear();
        }
        this.m_targetFields = null;
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.cmd_cancel();
        } else if (e.getActionCommand().equals("Refresh")) {
            this.cmd_refresh();
        } else if (e.getActionCommand().equals("New")) {
            this.m_query = MQuery.getNoRecordQuery(this.m_tableName, true);
            this.m_total = 0;
            this.dispose();
        } else if (e.getSource() == this.bIgnore) {
            this.cmd_ignore();
        } else if (e.getSource() == this.bNew) {
            this.cmd_new();
        } else if (e.getSource() == this.bSave) {
            this.cmd_save(true);
        } else if (e.getSource() == this.bDelete) {
            this.cmd_delete();
        } else if (e.getSource() == this.columns) {
            String columnName = null;
            Object selected = this.columns.getSelectedItem();
            if (selected != null) {
                if (selected instanceof ValueNamePair) {
                    ValueNamePair column = (ValueNamePair)selected;
                    columnName = column.getValue();
                } else {
                    columnName = selected.toString();
                }
            }
            if (columnName != null) {
                log.config("Column: " + columnName);
                if (columnName.endsWith("_ID") || columnName.endsWith("_Acct")) {
                    this.operators.setModel((ComboBoxModel)new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS_ID));
                } else if (columnName.startsWith("Is")) {
                    this.operators.setModel((ComboBoxModel)new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS_YN));
                } else {
                    this.operators.setModel((ComboBoxModel)new DefaultComboBoxModel<ValueNamePair>(MQuery.OPERATORS));
                }
            }
        } else if (e.getSource() == this.fQueryName) {
            int index = this.fQueryName.getSelectedIndex();
            if (index < 0) {
                if (this.fQueryName.getSelectedItem() == null || this.fQueryName.getSelectedItem().equals(this.m_sTipText)) {
                    return;
                }
            } else if (index == 0) {
                this.advancedTable.stopEditor(false);
                DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
                int cnt = model.getRowCount();
                if (cnt > 0) {
                    for (int i = cnt - 1; i >= 0; --i) {
                        model.removeRow(i);
                    }
                    this.cmd_new();
                }
                this.fQueryName.setSelectedIndex(-1);
                this.fQueryName.setSelectedItem(this.m_sTipText);
                this.advancedTable.requestFocusInWindow();
            } else {
                this.parseUserQuery(this.userQueries[index - 1]);
            }
        } else if (e.getSource() == this.confirmPanelA.getOKButton()) {
            this.cmd_ok_Advanced();
        } else if (e.getSource() == this.confirmPanelS.getOKButton()) {
            this.cmd_ok_Simple();
        } else if (e.getSource() instanceof JTextField && this.tabbedPane.getSelectedIndex() == 0) {
            this.cmd_ok_Simple();
        }
    }

    private StringBuffer codeUserQuery() {
        this.advancedTable.stopEditor(true);
        this.m_query = new MQuery(this.m_tableName);
        this.m_query.addRestriction(Env.parseContext(Env.getCtx(), this.m_targetWindowNo, this.m_whereExtended, false));
        StringBuffer code = new StringBuffer();
        int openBrackets = 0;
        for (int row = 0; row < this.advancedTable.getRowCount(); ++row) {
            Object op;
            String rBrackets;
            Object column = this.advancedTable.getValueAt(row, 2);
            if (column == null) continue;
            String ColumnName = column instanceof ValueNamePair ? ((ValueNamePair)column).getValue() : column.toString();
            String infoName = column.toString();
            GridField field = this.getTargetMField(ColumnName);
            if (field == null) continue;
            boolean isProductCategoryField = this.isProductCategoryField(field.getAD_Column_ID());
            String ColumnSQL = field.getColumnSQL(false);
            String lBrackets = (String)this.advancedTable.getValueAt(row, 1);
            if (lBrackets != null) {
                openBrackets += lBrackets.length();
            }
            if ((rBrackets = (String)this.advancedTable.getValueAt(row, 6)) != null) {
                openBrackets -= rBrackets.length();
            }
            boolean and = true;
            if (row > 0) {
                boolean bl = and = !"OR".equals((String)this.advancedTable.getValueAt(row, 0));
            }
            if ((op = this.advancedTable.getValueAt(row, 3)) == null) continue;
            String Operator = ((ValueNamePair)op).getValue();
            Object value = this.advancedTable.getValueAt(row, 4);
            if (value == null) {
                if (!MQuery.OPERATORS[0].equals(op) && !MQuery.OPERATORS[1].equals(op)) continue;
                this.m_query.addRestriction(ColumnSQL, Operator, null, infoName, null, and, openBrackets);
                if (code.length() > 0) {
                    code.append(SEGMENT_SEPARATOR);
                }
                code.append(ColumnName).append(FIELD_SEPARATOR).append(Operator).append(FIELD_SEPARATOR).append("").append(FIELD_SEPARATOR).append("").append(FIELD_SEPARATOR).append(and ? "AND" : "OR").append(FIELD_SEPARATOR).append(lBrackets != null ? lBrackets : "").append(FIELD_SEPARATOR).append(rBrackets != null ? rBrackets : "");
                continue;
            }
            Object parsedValue = this.parseValue(field, value);
            if (parsedValue == null) continue;
            String infoDisplay = value.toString();
            if (field.isLookup()) {
                infoDisplay = field.getLookup().getDisplay(value);
            } else if (field.getDisplayType() == 20) {
                infoDisplay = Msg.getMsg(Env.getCtx(), infoDisplay);
            }
            Object value2 = null;
            if (MQuery.OPERATORS[8].equals(op)) {
                value2 = this.advancedTable.getValueAt(row, 5);
                if (value2 == null) continue;
                Object parsedValue2 = this.parseValue(field, value2);
                String infoDisplay_to = value2.toString();
                if (parsedValue2 == null) continue;
                this.m_query.addRangeRestriction(ColumnSQL, parsedValue, parsedValue2, infoName, infoDisplay, infoDisplay_to, and, openBrackets);
            } else if (isProductCategoryField && MQuery.OPERATORS[0].equals(op)) {
                if (!(parsedValue instanceof Integer)) continue;
                this.m_query.addRestriction(this.getSubCategoryWhereClause((Integer)parsedValue), and, openBrackets);
            } else {
                this.m_query.addRestriction(ColumnSQL, Operator, parsedValue, infoName, infoDisplay, and, openBrackets);
            }
            if (code.length() > 0) {
                code.append(SEGMENT_SEPARATOR);
            }
            code.append(ColumnName).append(FIELD_SEPARATOR).append(Operator).append(FIELD_SEPARATOR).append(value.toString()).append(FIELD_SEPARATOR).append(value2 != null ? value2.toString() : "").append(FIELD_SEPARATOR).append(and ? "AND" : "OR").append(FIELD_SEPARATOR).append(lBrackets != null ? lBrackets : "").append(FIELD_SEPARATOR).append(rBrackets != null ? rBrackets : "");
        }
        return code;
    }

    private void parseUserQuery(MUserQuery userQuery) {
        int i;
        String code = userQuery.getCode();
        log.fine("Parse user query: " + code);
        String[] segments = code.split(Pattern.quote(SEGMENT_SEPARATOR), -1);
        this.advancedTable.stopEditor(true);
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        int cnt = model.getRowCount();
        for (i = cnt - 1; i >= 0; --i) {
            model.removeRow(i);
        }
        for (i = 0; i < segments.length; ++i) {
            String[] fields = segments[i].split(Pattern.quote(FIELD_SEPARATOR));
            model.addRow(new Object[]{"", "", null, MQuery.OPERATORS[0], null, null, ""});
            String columnName = null;
            block2: for (int j = 0; j < fields.length; ++j) {
                GridField field;
                if (j == 0) {
                    for (ValueNamePair vnp : this.columnValueNamePairs) {
                        if (!vnp.getValue().equals(fields[j])) continue;
                        model.setValueAt(vnp, i, 2);
                        columnName = fields[j];
                        continue block2;
                    }
                    continue;
                }
                if (j == 1) {
                    for (ValueNamePair vnp : MQuery.OPERATORS) {
                        if (!vnp.getValue().equals(fields[j])) continue;
                        model.setValueAt(vnp, i, 3);
                        continue block2;
                    }
                    continue;
                }
                if (j == 2 && fields[j].length() > 0) {
                    field = this.getTargetMField(columnName);
                    Object value = this.parseString(field, fields[j]);
                    model.setValueAt(value, i, 4);
                    continue;
                }
                if (j == 3 && fields[j].length() > 0) {
                    field = this.getTargetMField(columnName);
                    Object value = this.parseString(field, fields[j]);
                    model.setValueAt(value, i, 5);
                    continue;
                }
                if (j == 4 && fields[j].length() > 0) {
                    if (i == 0) continue;
                    model.setValueAt(fields[j], i, 0);
                    continue;
                }
                if (j == 5 && fields[j].length() > 0) {
                    model.setValueAt(fields[j], i, 1);
                    continue;
                }
                if (j != 6 || fields[j].length() <= 0) continue;
                model.setValueAt(fields[j], i, 6);
            }
        }
        this.advancedTable.invalidate();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.getRootPane().setDefaultButton(this.confirmPanelS.getOKButton());
        } else {
            this.initFindAdvanced();
            this.getRootPane().setDefaultButton(this.confirmPanelA.getOKButton());
            this.advancedTable.requestFocusInWindow();
        }
    }

    private void cmd_ok_Simple() {
        String value;
        this.m_query = new MQuery(this.m_tableName);
        this.m_query.addRestriction(Env.parseContext(Env.getCtx(), this.m_targetWindowNo, this.m_whereExtended, false));
        if (this.hasValue && !this.valueField.getText().equals("%") && this.valueField.getText().length() != 0) {
            value = this.valueField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction("UPPER(Value)", " LIKE ", value, this.valueLabel.getText(), value);
        }
        if (this.hasDocNo && !this.docNoField.getText().equals("%") && this.docNoField.getText().length() != 0) {
            value = this.docNoField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction("UPPER(DocumentNo)", " LIKE ", value, this.docNoLabel.getText(), value);
        }
        if (this.hasName && !this.nameField.getText().equals("%") && this.nameField.getText().length() != 0) {
            value = this.nameField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction("UPPER(Name)", " LIKE ", value, this.nameLabel.getText(), value);
        }
        if (this.hasDescription && !this.descriptionField.getText().equals("%") && this.descriptionField.getText().length() != 0) {
            value = this.descriptionField.getText().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            this.m_query.addRestriction("UPPER(Description)", " LIKE ", value, this.descriptionLabel.getText(), value);
        }
        for (int i = 0; i < this.m_sEditors.size(); ++i) {
            VEditor ved = this.m_sEditors.get(i);
            Object value2 = ved.getValue();
            Object modifiedvalue = null;
            String ColumnSQL = null;
            String ColumnName = ((Component)((Object)ved)).getName();
            GridField field = this.getTargetMField(ColumnName);
            if (value2 != null && value2.toString().length() > 0) {
                ColumnName = ((Component)((Object)ved)).getName();
                log.fine(ColumnName + "=" + value2);
                field = this.getTargetMField(ColumnName);
                boolean isProductCategoryField = this.isProductCategoryField(field.getAD_Column_ID());
                ColumnSQL = field.getColumnSQL(false);
                if (this.isSearchLike(field)) {
                    String valueStr = value2.toString().toUpperCase();
                    if (!valueStr.endsWith("%")) {
                        valueStr = valueStr + "%";
                    }
                    ColumnSQL = "UPPER(" + ColumnSQL + ")";
                    modifiedvalue = valueStr;
                } else {
                    modifiedvalue = value2;
                }
                if (modifiedvalue.toString().indexOf(37) != -1 && !field.isRangeLookup()) {
                    this.m_query.addRestriction(ColumnSQL, " LIKE ", modifiedvalue, ColumnName, ved.getDisplay());
                } else if (isProductCategoryField && value2 instanceof Integer) {
                    this.m_query.addRestriction(this.getSubCategoryWhereClause((Integer)value2));
                } else if (!field.isRangeLookup()) {
                    this.m_query.addRestriction(ColumnSQL, "=", value2, ColumnName, ved.getDisplay());
                }
            }
            if (!field.isRangeLookup()) continue;
            VEditor editor2 = this.m_sEditors2.get(i);
            Object value22 = null;
            Object parsedValue = null;
            Object parsedValue2 = null;
            String infoDisplay_to = null;
            String infoDisplay = null;
            if (editor2 != null) {
                value22 = editor2.getValue();
            }
            if (value2 != null && !value2.toString().isEmpty() && value22 != null && !value22.toString().isEmpty() && value22.toString().length() > 0) {
                ColumnName = ((Component)((Object)ved)).getName();
                log.fine(ColumnName + "=" + value22);
                field = this.getTargetMField(ColumnName);
                infoDisplay = value2.toString();
                parsedValue = this.parseValue(field, value2);
                parsedValue2 = this.parseValue(field, value22);
                infoDisplay_to = value22.toString();
                if (parsedValue2 == null) continue;
                this.m_query.addRangeRestriction(ColumnSQL, parsedValue, parsedValue2, ColumnSQL, infoDisplay, infoDisplay_to);
                continue;
            }
            if (value2 != null && !value2.toString().isEmpty() && (value22 == null || value22.toString().isEmpty())) {
                ColumnName = ((Component)((Object)ved)).getName();
                this.m_query.addRestriction(ColumnSQL, ">=", value2, ColumnName, ved.getDisplay());
                continue;
            }
            if (value2 != null && !value2.toString().isEmpty() || value22 == null || value22.toString().isEmpty()) continue;
            ColumnName = ((Component)((Object)ved)).getName();
            field = this.getTargetMField(ColumnName);
            ColumnSQL = field.getColumnSQL(false);
            this.m_query.addRestriction(ColumnSQL, "<=", value22, ColumnName, editor2.getDisplay());
        }
        this.m_isCancel = false;
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            this.dispose();
        }
    }

    private void cmd_ok_Advanced() {
        this.m_isCancel = false;
        this.cmd_save(true);
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            this.dispose();
        }
    }

    private void cmd_cancel() {
        this.advancedTable.stopEditor(false);
        log.info("");
        this.m_query = null;
        this.m_total = 999999;
        this.m_isCancel = true;
        this.dispose();
    }

    private void cmd_ignore() {
        log.info("");
        this.refreshUserQueries();
    }

    private void cmd_new() {
        this.advancedTable.stopEditor(true);
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        int rows = model.getRowCount();
        model.addRow(new Object[]{rows == 0 ? "" : "AND", "", null, MQuery.OPERATORS[0], null, null, ""});
        this.advancedTable.requestFocusInWindow();
    }

    private void cmd_save(boolean saveQuery) {
        Object selected = this.fQueryName.getSelectedItem();
        if (selected == null) {
            return;
        }
        StringBuffer code = this.codeUserQuery();
        String name = selected.toString();
        if (!(name.equals(this.m_sNew) || name.equals(this.m_sLast) || name.equals(this.m_sTipText) || Util.isEmpty(name, true))) {
            MUserQuery uq = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID, name);
            if (code.length() > 0) {
                if (uq == null) {
                    uq = new MUserQuery(Env.getCtx(), 0, null);
                    uq.setName(name);
                    uq.setAD_Table_ID(this.m_AD_Table_ID);
                    uq.setAD_Tab_ID(this.m_AD_Tab_ID);
                    uq.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
                }
                uq.setCode(code.toString());
            } else if (code.length() <= 0) {
                if (uq.delete(true)) {
                    ADialog.info(this.m_targetWindowNo, this, "Deleted", name);
                    this.refreshUserQueries();
                } else {
                    ADialog.warn(this.m_targetWindowNo, this, "DeleteError", name);
                }
                return;
            }
            if (uq.save()) {
                this.refreshUserQueries();
            } else {
                ADialog.warn(this.m_targetWindowNo, this, "SaveError", name);
            }
        }
        if (saveQuery) {
            MUserQuery last = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID, this.m_sLast);
            if (code.length() > 0) {
                if (last == null) {
                    last = new MUserQuery(Env.getCtx(), 0, null);
                    last.setName(this.m_sLast);
                    last.setAD_Table_ID(this.m_AD_Table_ID);
                    last.setAD_Tab_ID(this.m_AD_Tab_ID);
                    last.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
                }
                last.setCode(code.toString());
            } else if (code.length() <= 0) {
                if (!last.delete(true)) {
                    ADialog.warn(this.m_targetWindowNo, this, "DeleteError", name);
                }
                return;
            }
            if (!last.save()) {
                ADialog.warn(this.m_targetWindowNo, this, "SaveError", name);
            }
        }
    }

    private void refreshUserQueries() {
        String value = this.m_sLast;
        if (this.fQueryName.getItemCount() > 0) {
            value = (String)this.fQueryName.getSelectedItem();
        }
        this.userQueries = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID);
        this.fQueryName.removeAllItems();
        boolean selected = false;
        this.fQueryName.addItem(this.m_sNew);
        for (int i = 0; i < this.userQueries.length; ++i) {
            this.fQueryName.addItem(this.userQueries[i].getName());
            if (!value.equals(this.userQueries[i].getName())) continue;
            this.fQueryName.setSelectedItem(this.userQueries[i].getName());
            this.parseUserQuery(this.userQueries[i]);
            selected = true;
        }
        if (!selected) {
            this.fQueryName.setSelectedIndex(-1);
            this.fQueryName.setSelectedItem(this.m_sTipText);
        }
    }

    private boolean isProductCategoryField(int columnId) {
        X_AD_Column col = new X_AD_Column(Env.getCtx(), columnId, null);
        if (col.get_ID() == 0) {
            return false;
        }
        return "M_Product_Category_ID".equals(col.getColumnName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getSubCategoryWhereClause(int productCategoryId) {
        int subTreeRootParentId = 0;
        String retString = " M_Product_Category_ID IN (";
        String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
        Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) == productCategoryId) {
                    subTreeRootParentId = rs.getInt(2);
                }
                categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
            }
            retString = retString + this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId);
            retString = retString + ") ";
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            retString = "";
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        catch (AdempiereSystemError e2) {
            log.log(Level.SEVERE, sql, e2);
            retString = "";
            {
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
        return retString;
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        String ret = "";
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret = ret + this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId) + ",";
        }
        log.fine(ret);
        return ret + productCategoryId;
    }

    private Object parseValue(GridField field, Object in) {
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                if (in instanceof Integer) {
                    return in;
                }
                int i = Integer.parseInt(in.toString());
                return new Integer(i);
            }
            if (DisplayType.isNumeric(dt)) {
                if (in instanceof BigDecimal) {
                    return in;
                }
                return DisplayType.getNumberFormat(dt).parse(in.toString());
            }
            if (DisplayType.isDate(dt)) {
                if (in instanceof Timestamp) {
                    return in;
                }
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, in + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? "Y" : "N";
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            StringBuffer errMsg = new StringBuffer();
            errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
            ADialog.error(0, this, "ValidationError", errMsg.toString());
            return null;
        }
        return in;
    }

    private Object parseString(GridField field, String in) {
        log.log(Level.FINE, "Parse: " + field + ":" + in);
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                int i = Integer.parseInt(in);
                return new Integer(i);
            }
            if (DisplayType.isNumeric(dt)) {
                return DisplayType.getNumberFormat(dt).parse(in);
            }
            if (DisplayType.isDate(dt)) {
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, in + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in).getTime();
                    return new Timestamp(time);
                }
            }
            if (dt == 20) {
                return Boolean.valueOf(in);
            }
            return in;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, ex);
            return null;
        }
    }

    private void cmd_delete() {
        this.advancedTable.stopEditor(false);
        DefaultTableModel model = (DefaultTableModel)this.advancedTable.getModel();
        int row = this.advancedTable.getSelectedRow();
        if (row >= 0) {
            model.removeRow(row);
        } else {
            int i;
            PO uq = null;
            Object o = this.fQueryName.getSelectedItem();
            if (this.userQueries != null && o != null) {
                String selected = o.toString();
                for (i = 0; i < this.userQueries.length; ++i) {
                    if (!this.userQueries[i].getName().equals(selected)) continue;
                    uq = this.userQueries[i];
                    break;
                }
            }
            if (uq != null) {
                uq.delete(true);
                this.userQueries = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID);
                String[] queries = new String[this.userQueries.length];
                for (i = 0; i < this.userQueries.length; ++i) {
                    queries[i] = this.userQueries[i].getName();
                }
                this.fQueryName.setModel(new DefaultComboBoxModel<String>(queries));
                this.fQueryName.setValue("");
                int cnt = model.getRowCount();
                for (int i2 = cnt - 1; i2 >= 0; --i2) {
                    model.removeRow(i2);
                }
                this.advancedTable.invalidate();
            }
        }
        this.cmd_refresh();
        this.advancedTable.requestFocusInWindow();
    }

    private void cmd_refresh() {
        this.advancedTable.stopEditor(false);
        int records = this.getNoOfRecords(this.m_query, true);
        this.setStatusDB(records);
        this.statusBar.setStatusLine("");
    }

    public MQuery getQuery() {
        MRole role = MRole.getDefault();
        if (role.isQueryMax(this.getTotalRecords()) && !this.m_isCancel) {
            this.m_query = MQuery.getNoRecordQuery(this.m_tableName, false);
            this.m_total = 0;
            log.warning("Query - over max");
        } else {
            log.info("Query=" + this.m_query);
        }
        return this.m_query;
    }

    public int getTotalRecords() {
        return this.m_total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNoOfRecords(MQuery query, boolean alertZeroRecords) {
        ResultSet rs;
        Statement stmt;
        block13: {
            log.config("" + query);
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ");
            sql.append(this.m_tableName);
            boolean hasWhere = false;
            if (this.m_whereExtended != null && this.m_whereExtended.length() > 0) {
                sql.append(" WHERE ").append(this.m_whereExtended);
                hasWhere = true;
            }
            if (query != null && query.isActive()) {
                if (hasWhere) {
                    sql.append(" AND ");
                } else {
                    sql.append(" WHERE ");
                }
                sql.append(query.getWhereClause());
            }
            String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
            finalSQL = Env.parseContext(Env.getCtx(), this.m_targetWindowNo, finalSQL, false);
            Env.setContext(Env.getCtx(), this.m_targetWindowNo, 99, "_TabInfo_FindSQL", finalSQL);
            this.m_total = 999999;
            stmt = null;
            rs = null;
            try {
                stmt = DB.createStatement();
                rs = stmt.executeQuery(finalSQL);
                if (!rs.next()) break block13;
                this.m_total = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, finalSQL, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
            }
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
        MRole role = MRole.getDefault();
        if (this.m_total == 0 && alertZeroRecords) {
            ADialog.info(this.m_targetWindowNo, this, "FindZeroRecords");
        } else if (query != null && role.isQueryMax(this.m_total)) {
            ADialog.error(this.m_targetWindowNo, this, "FindOverMax", this.m_total + " > " + role.getMaxQueryRecords());
            this.m_total = 0;
        } else {
            log.config("#" + this.m_total);
        }
        if (query != null) {
            this.statusBar.setStatusToolTip(query.getWhereClause());
        }
        return this.m_total;
    }

    private void setStatusDB(int currentCount) {
        String text = " " + currentCount + " / " + this.m_total + " ";
        this.statusBar.setStatusDB(text);
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        log.config(e.getMessage());
        boolean changed = e.isChanged();
        this.bIgnore.setEnabled(changed);
        this.bNew.setEnabled(!changed);
        this.bSave.setEnabled(changed);
        this.bDelete.setEnabled(!changed);
    }

    public GridField getTargetMField(String columnName) {
        if (columnName == null) {
            return null;
        }
        for (int c = 0; c < this.m_findFields.length; ++c) {
            GridField field = this.m_findFields[c];
            if (!columnName.equals(field.getColumnName())) continue;
            return field;
        }
        return null;
    }

    private boolean isSearchLike(GridField field) {
        return DisplayType.isText(field.getDisplayType()) && MColumn.isSuggestSelectionColumn(field.getColumnName(), true);
    }

    private class ProxyRenderer
    implements TableCellRenderer {
        private TableCellRenderer m_renderer;

        public ProxyRenderer(TableCellRenderer renderer) {
            this.m_renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component comp = this.m_renderer.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, col);
            if (hasFocus && table2.isCellEditable(row, col)) {
                table2.editCellAt(row, col);
            }
            return comp;
        }
    }

    private class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

