/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Container;
import java.awt.Frame;
import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.adempiere.util.ProcessUtil;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.ProcessController;
import org.compiere.apps.ProcessModalDialog;
import org.compiere.apps.Waiting;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.print.ReportCtl;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;

public class ProcessCtl
implements Runnable {
    int windowNo;
    ASyncProcess parentProcess;
    ProcessInfo processInstance;
    private Trx transaction;
    private Waiting waiting;
    private boolean isServerProcess = false;
    private boolean isOnlyProcess = false;
    private static CLogger log = CLogger.getCLogger(ProcessCtl.class);

    public static ProcessCtl process(ASyncProcess parent, int WindowNo, ProcessInfo processInfo, Trx trx) {
        log.fine("WindowNo=" + WindowNo + " - " + processInfo);
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), processInfo.getAD_Process_ID(), processInfo.getRecord_ID());
        }
        catch (Exception e) {
            processInfo.setSummary(e.getLocalizedMessage());
            processInfo.setError(true);
            log.warning(processInfo.toString());
            return null;
        }
        catch (Error e) {
            processInfo.setSummary(e.getLocalizedMessage());
            processInfo.setError(true);
            log.warning(processInfo.toString());
            return null;
        }
        if (instance != null && !instance.save()) {
            processInfo.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            processInfo.setError(true);
            return null;
        }
        processInfo.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ProcessModalDialog para = new ProcessModalDialog((Frame)Env.getFrame((Container)((Object)parent)), WindowNo, processInfo);
        if (para.isValidDialog()) {
            para.validate();
            para.pack();
            AEnv.showCenterWindow(Env.getWindow(WindowNo), para);
            if (!para.isOK()) {
                return null;
            }
        }
        ProcessCtl worker = new ProcessCtl(parent, WindowNo, processInfo, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public static ProcessCtl process(ASyncProcess parent, int WindowNo, ProcessController parameter, ProcessInfo pi, Trx trx) {
        log.fine("WindowNo=" + WindowNo + " - " + pi);
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        if (parameter != null && parameter.saveParameters() != null) {
            return null;
        }
        ProcessCtl worker = new ProcessCtl(parent, WindowNo, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public ProcessCtl(ASyncProcess parent, int WindowNo, ProcessInfo pi, boolean isOnlyProcess, Trx trx) {
        this.windowNo = WindowNo;
        this.parentProcess = parent;
        this.processInstance = pi;
        this.transaction = trx;
        this.isOnlyProcess = isOnlyProcess;
    }

    public ProcessCtl(ASyncProcess parent, int WindowNo, ProcessInfo pi, Trx trx) {
        this(parent, WindowNo, pi, false, trx);
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.processInstance != null) {
            thread.setName(this.processInstance.getTitle() + "-" + this.processInstance.getAD_PInstance_ID());
        }
        thread.start();
    }

    @Override
    public void run() {
        int estimate;
        log.fine("AD_PInstance_ID=" + this.processInstance.getAD_PInstance_ID() + ", Record_ID=" + this.processInstance.getRecord_ID());
        this.lock();
        String procedureName = "";
        boolean isDirectPrint = false;
        boolean isPrintPreview = this.processInstance.isPrintPreview();
        MProcess process = null;
        if (this.processInstance.getAD_Process_ID() != 0) {
            process = MProcess.get(Env.getCtx(), this.processInstance.getAD_Process_ID());
        } else {
            process = MProcess.getFromInstance(Env.getCtx(), this.processInstance.getAD_PInstance_ID());
            this.processInstance.setAD_Process_ID(process.getAD_Process_ID());
        }
        if (process.getAD_Process_ID() <= 0) {
            this.processInstance.setSummary(Msg.parseTranslation(Env.getCtx(), "@AD_Process_ID@ @NotFound@"), true);
            this.unlock();
            log.log(Level.SEVERE, "run", "AD_Process_ID=" + this.processInstance.getAD_Process_ID() + " Not Found");
            return;
        }
        this.processInstance.setTitle(process.get_Translation("Name"));
        if (this.waiting != null) {
            this.waiting.setTitle(this.processInstance.getTitle());
        }
        procedureName = process.getProcedureName();
        this.processInstance.setClassName(process.getClassname());
        if (process.isReport() && process.isDirectPrint() && !Ini.isPropertyBool("PrintPreview") && !isPrintPreview) {
            isDirectPrint = true;
        }
        if (!isPrintPreview && Ini.isPropertyBool("PrintPreview")) {
            isPrintPreview = true;
        }
        if ((estimate = process.getEstimatedSeconds()) != 0) {
            this.processInstance.setEstSeconds(estimate + 1);
            if (this.waiting != null) {
                this.waiting.setTimerEstimate(this.processInstance.getEstSeconds());
            }
        }
        this.isServerProcess = process.isServerProcess();
        if (procedureName == null) {
            procedureName = "";
        }
        if (process.isWorkflow()) {
            this.startWorkflow(process.getAD_Workflow_ID());
            this.unlock();
            return;
        }
        if (process.isJasper() && "org.compiere.report.ReportStarter".equals(this.processInstance.getClassName())) {
            this.processInstance.setClassName(null);
        }
        if (this.processInstance.getClassName() != null) {
            if (process.isJasper()) {
                this.processInstance.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                this.unlock();
                return;
            }
            if (!process.isReport() && procedureName.length() == 0) {
                this.unlock();
                return;
            }
            if (process.isReport() && process.getAD_ReportView_ID() == 0 && !process.isJasper()) {
                this.unlock();
                return;
            }
        }
        if (process.isReport() && procedureName.length() > 0) {
            this.processInstance.setReportingProcess(true);
            if (!this.startDBProcess(procedureName)) {
                this.unlock();
                return;
            }
        }
        if (process.isJasper()) {
            this.processInstance.setReportingProcess(true);
            this.processInstance.setClassName("org.compiere.report.ReportStarter");
            this.startProcess();
            this.unlock();
            return;
        }
        if (process.isReport()) {
            this.processInstance.setReportingProcess(true);
            if (!this.isOnlyProcess) {
                boolean ok = ReportCtl.start(this.parentProcess, this.windowNo, this.processInstance, isDirectPrint);
                this.processInstance.setSummary("Report " + this.processInstance.getTitle(), !ok);
            }
            this.unlock();
        } else {
            if (procedureName.length() > 0 && !this.startDBProcess(procedureName)) {
                this.unlock();
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.processInstance);
            this.unlock();
        }
    }

    private void lock() {
        if (this.parentProcess != null) {
            if (this.parentProcess instanceof Container) {
                JFrame frame = Env.getFrame((Container)((Object)this.parentProcess));
                if (frame instanceof AWindow) {
                    ((AWindow)frame).setBusyTimer(this.processInstance.getEstSeconds());
                } else {
                    this.waiting = new Waiting((Frame)frame, Msg.getMsg(Env.getCtx(), "Processing"), false, this.processInstance.getEstSeconds());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        log.finer("lock");
                        ProcessCtl.this.parentProcess.lockUI(ProcessCtl.this.processInstance);
                    }
                });
                if (this.waiting != null) {
                    this.waiting.toFront();
                    this.waiting.setVisible(true);
                }
            } else {
                log.finer("lock");
                this.parentProcess.lockUI(this.processInstance);
            }
        }
    }

    private void unlock() {
        if (this.processInstance.isBatch()) {
            this.processInstance.setIsTimeout(true);
        }
        if (this.parentProcess != null) {
            if (this.parentProcess instanceof Container) {
                if (this.waiting != null) {
                    this.waiting.dispose();
                }
                this.waiting = null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String summary = ProcessCtl.this.processInstance.getSummary();
                        log.finer("unlock - " + summary);
                        if (summary != null && summary.indexOf(64) != -1) {
                            ProcessCtl.this.processInstance.setSummary(Msg.parseTranslation(Env.getCtx(), summary));
                        }
                        ProcessCtl.this.parentProcess.unlockUI(ProcessCtl.this.processInstance);
                    }
                });
            } else {
                this.parentProcess.unlockUI(this.processInstance);
            }
        }
    }

    private boolean startWorkflow(int AD_Workflow_ID) {
        log.fine(AD_Workflow_ID + " - " + this.processInstance);
        boolean started = false;
        if (this.isServerProcess) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInstance = server.workflow(Env.getRemoteCallCtx(Env.getCtx()), this.processInstance, AD_Workflow_ID);
                    log.finest("server => " + this.processInstance);
                    started = true;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
                started = false;
            }
        }
        if (!started && !this.isServerProcess) {
            MWFProcess wfProcess;
            if (this.transaction != null) {
                this.processInstance.setTransactionName(this.transaction.getTrxName());
            }
            started = (wfProcess = ProcessUtil.startWorkFlow(Env.getCtx(), this.processInstance, AD_Workflow_ID)) != null;
        }
        return started;
    }

    private boolean startProcess() {
        log.fine(this.processInstance.toString());
        boolean started = false;
        boolean clientOnly = false;
        if (!this.processInstance.getClassName().toLowerCase().startsWith("@script:")) {
            try {
                Class<?> processClass = Class.forName(this.processInstance.getClassName());
                if (ClientProcess.class.isAssignableFrom(processClass)) {
                    clientOnly = true;
                }
            }
            catch (Exception processClass) {
                // empty catch block
            }
        }
        if (this.isServerProcess && !clientOnly) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInstance = server.process(Env.getRemoteCallCtx(Env.getCtx()), this.processInstance);
                    log.finest("server => " + this.processInstance);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.processInstance, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.processInstance, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.processInstance, ex);
                }
                started = false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.processInstance, cause);
                started = false;
            }
        }
        if (!(started || this.isServerProcess && !clientOnly)) {
            if (this.processInstance.getClassName().toLowerCase().startsWith("@script:")) {
                return ProcessUtil.startScriptProcess(Env.getCtx(), this.processInstance, this.transaction);
            }
            if (this.processInstance.isManagedTransaction()) {
                return ProcessUtil.startJavaProcess(Env.getCtx(), this.processInstance, this.transaction);
            }
            return ProcessUtil.startJavaProcess(Env.getCtx(), this.processInstance, this.transaction, this.processInstance.isManagedTransaction());
        }
        return !this.processInstance.isError();
    }

    private boolean startDBProcess(String ProcedureName) {
        log.fine(ProcedureName + "(" + this.processInstance.getAD_PInstance_ID() + ")");
        boolean started = false;
        if (this.isServerProcess) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInstance = server.dbProcess(this.processInstance, ProcedureName);
                    log.finest("server => " + this.processInstance);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.processInstance, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.processInstance, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.processInstance, ex);
                    cause = ex;
                }
                this.processInstance.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.processInstance.setError(true);
                return false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.processInstance, cause);
                this.processInstance.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.processInstance.setError(true);
                return false;
            }
        }
        if (!started) {
            if (this.processInstance.isManagedTransaction()) {
                return ProcessUtil.startDatabaseProcedure(this.processInstance, ProcedureName, this.transaction);
            }
            return ProcessUtil.startDatabaseProcedure(this.processInstance, ProcedureName, this.transaction, this.processInstance.isManagedTransaction());
        }
        return true;
    }
}

