/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.controller.SmallViewController;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_ReportView;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.util.ASPUtil;

public abstract class ProcessController
extends SmallViewController {
    private int windowNo;
    protected ProcessInfo processInfo;
    private MProcess process;
    protected int processId;
    private boolean isProcessed = false;
    private boolean isError;
    private int columns;
    private String textMsg = null;
    private boolean isOnlyPanel;
    private boolean showButtons = true;
    private boolean showDescription = true;
    private boolean autoStart;
    private boolean isOKPressed = false;
    private HashMap<Integer, Boolean> fieldsInfoOnly;
    private List<MPInstance> savedParams;
    private static CLogger log = CLogger.getCLogger(ProcessController.class);
    public static final int COLUMNS_1 = 1;
    public static final int COLUMNS_2 = 2;

    public ProcessController(int WindowNo, ProcessInfo pi, int columns) {
        this.windowNo = WindowNo;
        this.processInfo = pi;
        this.processId = pi.getAD_Process_ID();
        this.columns = columns;
    }

    public ProcessController(int WindowNo, ProcessInfo pi) {
        this(WindowNo, pi, 1);
    }

    public abstract void afterInit();

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public void setIsProcessed(boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    public void setShowButtons(boolean showButtons) {
        this.showButtons = showButtons;
    }

    public void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    public boolean isShowDescription() {
        return this.showDescription;
    }

    public boolean isShowButtons() {
        return this.showButtons;
    }

    public boolean isOnlyPanel() {
        return this.isOnlyPanel;
    }

    public void setIsOnlyPanel(boolean isOnlyPanel) {
        this.isOnlyPanel = isOnlyPanel;
    }

    public boolean isOkPressed() {
        return this.isOKPressed;
    }

    public void setIsOkPressed(boolean isOkPressed) {
        this.isOKPressed = isOkPressed;
    }

    public String getName() {
        return this.process.get_Translation("Name");
    }

    public String getDescription() {
        return this.process.get_Translation("Description");
    }

    public String getHelp() {
        return this.process.get_Translation("Help");
    }

    public String getShowHelp() {
        return this.process.getShowHelp();
    }

    public boolean isReport() {
        return this.process.isReport();
    }

    public String getTextMsg() {
        if (this.textMsg != null) {
            return this.textMsg;
        }
        String name = this.getName();
        if (name == null) {
            throw new AdempiereException("@NotFound@ @AD_Process_ID@=" + this.processInfo.getAD_Process_ID() + ". @CheckMissingTrl@");
        }
        String description = this.getDescription();
        String help = this.getHelp();
        StringBuffer messageText = new StringBuffer();
        messageText.append("<b>");
        if (description == null || description.trim().length() == 0) {
            messageText.append(Msg.getMsg(Env.getCtx(), "StartProcess?"));
        } else {
            messageText.append(description);
        }
        messageText.append("</b>");
        if (help != null && help.trim().length() > 0) {
            messageText.append("<p>").append(help).append("</p>");
        }
        return messageText.toString();
    }

    public boolean isInfoOnly(int processParaID) {
        Boolean isInfoOnly = this.fieldsInfoOnly.get(processParaID);
        return isInfoOnly != null && isInfoOnly != false;
    }

    public boolean isError() {
        return this.isError;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    @Override
    public boolean loadData() {
        log.config("");
        boolean hasFields = false;
        ASPUtil aspUtil = ASPUtil.getInstance(Env.getCtx());
        this.process = aspUtil.getProcess(this.processInfo.getAD_Process_ID());
        for (MProcessPara para : aspUtil.getProcessParameters(this.processInfo.getAD_Process_ID())) {
            if (!para.isActive()) continue;
            hasFields = true;
            this.createField(para, this.windowNo);
        }
        return hasFields;
    }

    private void loadSavedInstances() {
        this.savedParams = MPInstance.get(Env.getCtx(), this.processInfo.getAD_Process_ID(), this.processInfo.getAD_User_ID());
    }

    public List<MPInstance> getSavedInstances(boolean reQuery) {
        if (reQuery) {
            this.loadSavedInstances();
        }
        return this.savedParams;
    }

    public boolean createFieldsAndEditors() {
        boolean isOk = super.init();
        this.afterInit();
        return isOk;
    }

    @Override
    public String validateParameters() {
        log.config("");
        String msg = this.validateFields();
        if (msg != null && msg.length() > 0) {
            this.processInfo.setSummary(msg);
            this.processInfo.setError(true);
            return msg;
        }
        return null;
    }

    public String saveParameters() {
        return this.saveParameters(null);
    }

    public String saveParameters(String saveName) {
        log.config("");
        this.setIsProcessed(false);
        String validError = this.validateParameters();
        if (validError != null) {
            return validError;
        }
        if (this.processInfo.getAD_PInstance_ID() <= 0) {
            MPInstance instance = null;
            this.processInfo.setParameter(null);
            try {
                instance = new MPInstance(Env.getCtx(), this.processInfo.getAD_Process_ID(), this.processInfo.getRecord_ID());
                instance.setName(saveName);
                instance.saveEx();
                this.processInfo.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            }
            catch (Exception e) {
                this.processInfo.setSummary(e.getLocalizedMessage());
                this.processInfo.setError(true);
                log.warning(this.processInfo.toString());
                return this.processInfo.getSummary();
            }
        }
        for (int i = 0; i < this.getFieldSize(); ++i) {
            GridField field = this.getField(i);
            GridField fieldTo = this.getFieldTo(i);
            if (field.isInfoOnly()) continue;
            field.validateValue();
            Object result = this.getValue(i);
            Object result2 = null;
            if (fieldTo != null) {
                result2 = this.getValue_To(i);
            }
            MPInstancePara para = new MPInstancePara(Env.getCtx(), this.processInfo.getAD_PInstance_ID(), i);
            para.setParameterName(field.getColumnName());
            if (result instanceof Timestamp || result2 instanceof Timestamp) {
                para.setP_Date((Timestamp)result);
                if (fieldTo != null && result2 != null) {
                    para.setP_Date_To((Timestamp)result2);
                }
            } else if (result instanceof Integer || result2 instanceof Integer) {
                Integer ii;
                if (result != null) {
                    ii = (Integer)result;
                    para.setP_Number((int)ii);
                }
                if (fieldTo != null && result2 != null) {
                    ii = (Integer)result2;
                    para.setP_Number_To((int)ii);
                }
            } else if (result instanceof BigDecimal || result2 instanceof BigDecimal) {
                para.setP_Number((BigDecimal)result);
                if (fieldTo != null && result2 != null) {
                    para.setP_Number_To((BigDecimal)result2);
                }
            } else if (result instanceof Boolean) {
                Boolean bb = (Boolean)result;
                String value = bb != false ? "Y" : "N";
                para.setP_String(value);
            } else {
                if (result != null) {
                    para.setP_String(result.toString());
                }
                if (fieldTo != null && result2 != null) {
                    para.setP_String_To(result2.toString());
                }
            }
            para.setInfo(this.getDisplay(i));
            if (fieldTo != null) {
                para.setInfo_To(this.getDisplay_To(i));
            }
            para.saveEx();
            log.fine(para.toString());
        }
        this.setIsProcessed(true);
        return null;
    }

    public boolean loadParameters(String saveName) {
        if (this.savedParams == null || saveName == null) {
            return false;
        }
        for (MPInstance instance : this.savedParams) {
            if (!instance.getName().equals(saveName)) continue;
            this.loadParameters(instance);
            return true;
        }
        return false;
    }

    public boolean loadParameters(MPInstance instance) {
        log.config("");
        MPInstancePara[] params = instance.getParameters();
        block0: for (int j = 0; j < this.getFieldSize(); ++j) {
            GridField field = this.getField(j);
            GridField fieldTo = this.getFieldTo(j);
            this.setValue(j, null);
            if (fieldTo != null) {
                this.setValue_To(j, null);
            }
            for (int i = 0; i < params.length; ++i) {
                MPInstancePara para = params[i];
                para.getParameterName();
                if (!field.getColumnName().equals(para.getParameterName())) continue;
                if (para.getP_Date() != null || para.getP_Date_To() != null) {
                    this.setValue(j, para.getP_Date());
                    if (fieldTo != null) {
                        this.setValue_To(j, para.getP_Date_To());
                    }
                } else if (para.getP_String() != null || para.getP_String_To() != null) {
                    this.setValue(j, para.getP_String());
                    if (fieldTo != null) {
                        this.setValue_To(j, para.getP_String_To());
                    }
                } else if (!Env.ZERO.equals(para.getP_Number()) || !Env.ZERO.equals(para.getP_Number_To())) {
                    this.setValue(j, para.getP_Number());
                    if (fieldTo != null) {
                        this.setValue_To(j, para.getP_Number_To());
                    }
                }
                log.fine(para.toString());
                continue block0;
            }
        }
        return true;
    }

    public String updateInstance(String saveName) {
        if (this.savedParams == null || saveName == null) {
            return null;
        }
        String errorMsg = null;
        try {
            for (MPInstance instance : this.savedParams) {
                if (!instance.getName().equals(saveName)) continue;
                this.deleteInstance(instance);
                errorMsg = this.saveParameters(saveName);
                if (errorMsg == null) continue;
                throw new AdempiereException(errorMsg);
            }
        }
        catch (Exception ex) {
            errorMsg = ex.getLocalizedMessage();
            log.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        return errorMsg;
    }

    public String deleteInstance(String saveName) {
        if (this.savedParams == null || saveName == null) {
            return null;
        }
        String errorMsg = null;
        try {
            for (MPInstance instance : this.savedParams) {
                if (!instance.getName().equals(saveName)) continue;
                this.deleteInstance(instance);
                break;
            }
        }
        catch (Exception ex) {
            errorMsg = ex.getLocalizedMessage();
            log.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        return errorMsg;
    }

    private void deleteInstance(MPInstance instance) {
        if (instance == null) {
            return;
        }
        instance.setName(null);
        instance.saveEx();
        this.savedParams.remove(instance);
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public String getLogInfo(boolean reload) {
        if (reload && this.process.getProcedureName() != null && this.process.getProcedureName().trim().length() > 0) {
            ProcessInfoUtil.setLogFromDB(this.processInfo);
        }
        StringBuffer messageText = new StringBuffer();
        messageText.append("<p><font color=\"").append(this.processInfo.isError() ? "#FF0000" : "#0000FF").append("\">** ").append(this.processInfo.getSummary()).append("</font></p>");
        messageText.append(this.processInfo.getLogInfo(true));
        return messageText.toString();
    }

    protected MProcess getReportProcess() {
        return new MProcess(Env.getCtx(), this.processId, null);
    }

    protected Lookup listPrintFormat() {
        int AD_Column_ID = 0;
        int table_ID = 0;
        MProcess pr = new MProcess(Env.getCtx(), this.processId, null);
        try {
            if (pr.getAD_ReportView_ID() > 0) {
                X_AD_ReportView m_Reportview = new X_AD_ReportView(Env.getCtx(), pr.getAD_ReportView_ID(), null);
                table_ID = m_Reportview.getAD_Table_ID();
            } else if (pr.getAD_PrintFormat_ID() > 0) {
                MPrintFormat format = new MPrintFormat(Env.getCtx(), pr.getAD_PrintFormat_ID(), null);
                table_ID = format.getAD_Table_ID();
            }
            String valCode = null;
            if (table_ID > 0) {
                valCode = "AD_PrintFormat.AD_Table_ID=" + table_ID;
            }
            MLookup lookup = MLookupFactory.get(Env.getCtx(), this.windowNo, AD_Column_ID, 19, Env.getLanguage(Env.getCtx()), "AD_PrintFormat_ID", 0, false, valCode);
            return lookup;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    protected boolean isAllowHTMLView() {
        MRole roleCurrent = MRole.get(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()));
        boolean m_isAllowHTMLView = roleCurrent.isAllow_HTML_View();
        return m_isAllowHTMLView;
    }

    protected boolean isAllowXLSView() {
        MRole roleCurrent = MRole.get(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()));
        boolean m_isAllowXLSView = roleCurrent.isAllow_XLS_View();
        return m_isAllowXLSView;
    }

    protected MPInstance getLastProcessInstance() {
        String where = "AD_Process_ID = ? AND AD_User_ID = ? AND Name IS NULL ";
        MPInstance lastProcessInstance = (MPInstance)MTable.get(Env.getCtx(), "AD_PInstance").createQuery(where, null).setOnlyActiveRecords(true).setClient_ID().setParameters(this.getReportProcess().getAD_Process_ID(), Env.getContextAsInt(Env.getCtx(), "#AD_User_ID")).setOrderBy("Created DESC").first();
        return lastProcessInstance;
    }

    public void validateAutoStart() {
        if (this.isAutoStart()) {
            return;
        }
        if (!this.hasParameters() && this.getShowHelp() != null && this.getShowHelp().equals("N")) {
            this.setAutoStart(true);
        }
        if (this.getShowHelp() != null && this.getShowHelp().equals("S")) {
            this.setAutoStart(true);
        }
    }

    public void openResult() {
        String tableName;
        if (!this.getProcessInfo().isOpenResult()) {
            return;
        }
        ArrayList<Integer> keys = new ArrayList<Integer>();
        int[] keysAsarray = this.getProcessInfo().getIDs();
        if (keysAsarray != null && keysAsarray.length > 0) {
            for (int key : keysAsarray) {
                keys.add(key);
            }
        }
        if (Util.isEmpty(tableName = this.getProcessInfo().getResultTableName())) {
            return;
        }
        if (keys == null || keys.isEmpty()) {
            return;
        }
        MTable table = MTable.get(Env.getCtx(), tableName);
        if (table.getKeyColumns() == null || table.getKeyColumns().length == 0) {
            return;
        }
        String keyColumn = table.getKeyColumns()[0];
        String whereClause = new String(keyColumn + " IN" + ((Object)keys).toString().replace('[', '(').replace(']', ')'));
        MQuery query = new MQuery(tableName);
        query.addRestriction(whereClause);
        this.openResult(query);
    }

    public abstract void openResult(MQuery var1);
}

