/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.event.WindowEvent;
import org.compiere.apps.ADialog;
import org.compiere.apps.AGlassPane;
import org.compiere.apps.APanel;
import org.compiere.model.MQuery;
import org.compiere.swing.CFrame;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class AWindow
extends CFrame {
    private static final long serialVersionUID = -1925388774073536474L;
    private AGlassPane m_glassPane = new AGlassPane();
    private APanel m_APanel = new APanel(this);
    private static CLogger log = CLogger.getCLogger(AWindow.class);

    public AWindow() {
        this((GraphicsConfiguration)null);
    }

    public AWindow(GraphicsConfiguration gc) {
        super(gc);
        this.setIconImage(Env.getImage("mWindow.gif"));
        this.getContentPane().add((Component)this.m_APanel, "Center");
        this.setGlassPane(this.m_glassPane);
    }

    protected boolean initWorkbench(int AD_Workbench_ID) {
        return this.initWorkbench(AD_Workbench_ID, true);
    }

    protected boolean initWorkbench(int AD_Workbench_ID, boolean showError) {
        this.setName("AWindow_WB_" + AD_Workbench_ID);
        boolean loadedOK = this.m_APanel.initPanel(AD_Workbench_ID, 0, null);
        if (!loadedOK && showError && this.m_APanel.getLoadError() != null) {
            ADialog.warn(0, this, this.m_APanel.getLoadError(), null);
        }
        this.commonInit();
        return loadedOK;
    }

    public boolean initWindow(int AD_Window_ID, MQuery query) {
        return this.initWindow(AD_Window_ID, query, true);
    }

    public boolean initWindow(int AD_Window_ID, MQuery query, boolean showError) {
        this.setName("AWindow_" + AD_Window_ID);
        this.setAD_Window_ID(AD_Window_ID);
        boolean loadedOK = this.m_APanel.initPanel(0, AD_Window_ID, query);
        if (loadedOK) {
            this.commonInit();
        } else if (showError && this.m_APanel.getLoadError() != null) {
            ADialog.warn(0, this, this.m_APanel.getLoadError(), null);
        }
        return loadedOK;
    }

    private void commonInit() {
        this.setJMenuBar(this.m_APanel.getMenuBar());
        this.setTitle(this.m_APanel.getTitle());
        Image image = this.m_APanel.getImage();
        if (image != null) {
            this.setIconImage(image);
        }
    }

    public void setBusy(boolean busy) {
        if (busy == this.m_glassPane.isVisible()) {
            return;
        }
        log.config(this.getName() + " - " + busy);
        this.m_glassPane.setMessage(null);
        this.m_glassPane.setVisible(busy);
        if (busy) {
            this.m_glassPane.requestFocus();
        }
    }

    public void setBusyMessage(String AD_Message) {
        this.m_glassPane.setMessage(AD_Message);
    }

    public void setBusyTimer(int time) {
        this.m_glassPane.setBusyTimer(time);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
    }

    public APanel getAPanel() {
        return this.m_APanel;
    }

    @Override
    public void dispose() {
        if (Env.hideWindow(this)) {
            return;
        }
        log.info(this.toString());
        if (this.m_APanel != null) {
            this.m_APanel.dispose();
        }
        this.m_APanel = null;
        this.removeAll();
        super.dispose();
    }

    public int getWindowNo() {
        if (this.m_APanel != null) {
            return this.m_APanel.getWindowNo();
        }
        return 0;
    }

    @Override
    public String toString() {
        return this.getName() + "_" + this.getWindowNo();
    }
}

