/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MDistribution;
import org.compiere.model.MDistributionLine;
import org.compiere.model.MElementValue;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public final class Fact {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Doc m_doc = null;
    private MAcctSchema m_acctSchema = null;
    private String m_trxName;
    private String m_postingType = null;
    public static final String POST_Actual = "A";
    public static final String POST_Budget = "B";
    public static final String POST_Commitment = "E";
    public static final String POST_Reservation = "R";
    private boolean m_converted = false;
    private ArrayList<FactLine> m_lines = new ArrayList();

    public Fact(Doc document, MAcctSchema acctSchema, String defaultPostingType) {
        this.m_doc = document;
        this.m_acctSchema = acctSchema;
        this.m_postingType = defaultPostingType;
        this.m_trxName = document.getTrxName();
        this.log.config(this.toString());
    }

    public void dispose() {
        this.m_lines.clear();
        this.m_lines = null;
    }

    public FactLine createLine(DocLine docLine, MAccount account, int C_Currency_ID, BigDecimal debitAmt, BigDecimal creditAmt) {
        if (account == null) {
            this.log.info("No account for " + docLine + ": Amt=" + debitAmt + "/" + creditAmt + " - " + this.toString());
            return null;
        }
        FactLine line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), docLine == null ? 0 : docLine.get_ID(), this.m_trxName);
        line.setDocumentInfo(this.m_doc, docLine);
        line.setPostingType(this.m_postingType);
        line.setAccount(this.m_acctSchema, account);
        if (!line.setAmtSource(C_Currency_ID, debitAmt, creditAmt)) {
            if (docLine == null || docLine.getQty() == null || docLine.getQty().signum() == 0) {
                this.log.fine("Both amounts & qty = 0/Null - " + docLine + " - " + this.toString());
                return null;
            }
            this.log.fine("Both amounts = 0/Null, Qty=" + docLine.getQty() + " - " + docLine + " - " + this.toString());
        }
        line.convert();
        if (docLine != null && (docLine.getAmtAcctDr() != null || docLine.getAmtAcctCr() != null)) {
            line.setAmtAcct(docLine.getAmtAcctDr(), docLine.getAmtAcctCr());
        }
        this.log.fine(line.toString());
        this.add(line);
        return line;
    }

    public void add(FactLine line) {
        this.m_lines.add(line);
    }

    public void remove(FactLine line) {
        this.m_lines.remove(line);
    }

    public FactLine createLine(DocLine docLine, MAccount accountDr, MAccount accountCr, int C_Currency_ID, BigDecimal Amt) {
        if (Amt.signum() < 0) {
            return this.createLine(docLine, accountCr, C_Currency_ID, null, Amt.abs());
        }
        return this.createLine(docLine, accountDr, C_Currency_ID, Amt, null);
    }

    public FactLine createLine(DocLine docLine, MAccount account, int C_Currency_ID, BigDecimal Amt) {
        if (Amt.signum() < 0) {
            return this.createLine(docLine, account, C_Currency_ID, null, Amt.abs());
        }
        return this.createLine(docLine, account, C_Currency_ID, Amt, null);
    }

    public boolean isPostingType(String PostingType) {
        return this.m_postingType.equals(PostingType);
    }

    public boolean isConverted() {
        return this.m_converted;
    }

    public MAcctSchema getAcctSchema() {
        return this.m_acctSchema;
    }

    public boolean isSourceBalanced() {
        boolean retValue;
        if (this.m_lines.size() == 0 || this.m_doc.isMultiCurrency()) {
            return true;
        }
        BigDecimal balance = this.getSourceBalance();
        boolean bl = retValue = balance.signum() == 0;
        if (retValue) {
            this.log.finer(this.toString());
        } else {
            this.log.warning("NO - Diff=" + balance + " - " + this.toString());
        }
        return retValue;
    }

    protected BigDecimal getSourceBalance() {
        BigDecimal result = Env.ZERO;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine line = this.m_lines.get(i);
            result = result.add(line.getSourceBalance());
        }
        return result;
    }

    public FactLine balanceSource() {
        if (!this.m_acctSchema.isSuspenseBalancing() || this.m_doc.isMultiCurrency()) {
            return null;
        }
        BigDecimal diff = this.getSourceBalance();
        this.log.finer("Diff=" + diff);
        FactLine line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
        line.setDocumentInfo(this.m_doc, null);
        line.setPostingType(this.m_postingType);
        line.setAccount(this.m_acctSchema, this.m_acctSchema.getSuspenseBalancing_Acct());
        if (diff.signum() < 0) {
            line.setAmtSource(this.m_doc.getC_Currency_ID(), diff.abs(), Env.ZERO);
        } else {
            line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, diff);
        }
        line.convert();
        this.log.fine(line.toString());
        this.m_lines.add(line);
        return line;
    }

    public boolean isSegmentBalanced() {
        if (this.m_lines.size() == 0 || this.m_doc.isMultiCurrency()) {
            return true;
        }
        MAcctSchemaElement[] elements = this.m_acctSchema.getAcctSchemaElements();
        for (int i = 0; i < elements.length; ++i) {
            MAcctSchemaElement ase = elements[i];
            if (!ase.isBalanced() || this.isSegmentBalanced(ase.getElementType())) continue;
            return false;
        }
        return true;
    }

    public boolean isSegmentBalanced(String segmentType) {
        if (segmentType.equals("OO")) {
            HashMap<Integer, BigDecimal> map = new HashMap<Integer, BigDecimal>();
            for (int i = 0; i < this.m_lines.size(); ++i) {
                FactLine line = this.m_lines.get(i);
                Integer key = new Integer(line.getAD_Org_ID());
                BigDecimal bal = line.getSourceBalance();
                BigDecimal oldBal = (BigDecimal)map.get(key);
                if (oldBal != null) {
                    bal = bal.add(oldBal);
                }
                map.put(key, bal);
            }
            for (BigDecimal bal : map.values()) {
                if (bal.signum() == 0) continue;
                map.clear();
                this.log.warning("(" + segmentType + ") NO - " + this.toString() + ", Balance=" + bal);
                return false;
            }
            map.clear();
            this.log.finer("(" + segmentType + ") - " + this.toString());
            return true;
        }
        this.log.finer("(" + segmentType + ") (not checked) - " + this.toString());
        return true;
    }

    public void balanceSegments() {
        MAcctSchemaElement[] elements = this.m_acctSchema.getAcctSchemaElements();
        for (int i = 0; i < elements.length; ++i) {
            MAcctSchemaElement ase = elements[i];
            if (!ase.isBalanced()) continue;
            this.balanceSegment(ase.getElementType());
        }
    }

    private void balanceSegment(String elementType) {
        if (this.m_lines.size() == 0) {
            return;
        }
        this.log.fine("(" + elementType + ") - " + this.toString());
        if (elementType.equals("OO")) {
            HashMap<Integer, Balance> map = new HashMap<Integer, Balance>();
            for (int i = 0; i < this.m_lines.size(); ++i) {
                FactLine line = this.m_lines.get(i);
                Integer key = new Integer(line.getAD_Org_ID());
                Balance oldBalance = (Balance)map.get(key);
                if (oldBalance == null) {
                    oldBalance = new Balance(line.getAmtSourceDr(), line.getAmtSourceCr());
                    map.put(key, oldBalance);
                    continue;
                }
                oldBalance.add(line.getAmtSourceDr(), line.getAmtSourceCr());
            }
            for (Integer key : map.keySet()) {
                Balance difference = (Balance)map.get(key);
                this.log.info(elementType + "=" + key + ", " + difference);
                if (difference.isZeroBalance()) continue;
                FactLine line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
                line.setDocumentInfo(this.m_doc, null);
                line.setPostingType(this.m_postingType);
                if (difference.getBalance().signum() < 0) {
                    if (difference.isReversal()) {
                        line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueTo_Acct(elementType));
                        line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, difference.getPostBalance());
                    } else {
                        line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueFrom_Acct(elementType));
                        line.setAmtSource(this.m_doc.getC_Currency_ID(), difference.getPostBalance(), Env.ZERO);
                    }
                } else if (difference.isReversal()) {
                    line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueFrom_Acct(elementType));
                    line.setAmtSource(this.m_doc.getC_Currency_ID(), difference.getPostBalance(), Env.ZERO);
                } else {
                    line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueTo_Acct(elementType));
                    line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, difference.getPostBalance());
                }
                line.convert();
                line.setAD_Org_ID(key);
                this.m_lines.add(line);
                this.log.fine("(" + elementType + ") - " + line);
            }
            map.clear();
        }
    }

    public boolean isAcctBalanced() {
        boolean retValue;
        if (this.m_lines.size() == 0) {
            return true;
        }
        BigDecimal balance = this.getAcctBalance();
        boolean bl = retValue = balance.signum() == 0;
        if (retValue) {
            this.log.finer(this.toString());
        } else {
            this.log.warning("NO - Diff=" + balance + " - " + this.toString());
        }
        return retValue;
    }

    protected BigDecimal getAcctBalance() {
        BigDecimal result = Env.ZERO;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine line = this.m_lines.get(i);
            result = result.add(line.getAcctBalance());
        }
        return result;
    }

    public FactLine balanceAccounting() {
        BigDecimal diff = this.getAcctBalance();
        this.log.fine("Balance=" + diff + ", CurrBal=" + this.m_acctSchema.isCurrencyBalancing() + " - " + this.toString());
        FactLine line = null;
        BigDecimal BSamount = Env.ZERO;
        FactLine BSline = null;
        BigDecimal PLamount = Env.ZERO;
        FactLine PLline = null;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine l = this.m_lines.get(i);
            BigDecimal amt = l.getAcctBalance().abs();
            if (l.isBalanceSheet() && amt.compareTo(BSamount) > 0) {
                BSamount = amt;
                BSline = l;
                continue;
            }
            if (l.isBalanceSheet() || amt.compareTo(PLamount) <= 0) continue;
            PLamount = amt;
            PLline = l;
        }
        if (this.m_acctSchema.isCurrencyBalancing()) {
            boolean switchIt;
            line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
            line.setDocumentInfo(this.m_doc, null);
            line.setPostingType(this.m_postingType);
            line.setAccount(this.m_acctSchema, this.m_acctSchema.getCurrencyBalancing_Acct());
            line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, Env.ZERO);
            line.convert();
            BigDecimal drAmt = Env.ZERO;
            BigDecimal crAmt = Env.ZERO;
            boolean isDR = diff.signum() < 0;
            BigDecimal difference = diff.abs();
            if (isDR) {
                drAmt = difference;
            } else {
                crAmt = difference;
            }
            boolean bl = switchIt = BSline != null && (BSline.isDrSourceBalance() && isDR || !BSline.isDrSourceBalance() && !isDR);
            if (switchIt) {
                drAmt = Env.ZERO;
                crAmt = Env.ZERO;
                if (isDR) {
                    crAmt = difference.negate();
                } else {
                    drAmt = difference.negate();
                }
            }
            line.setAmtAcct(drAmt, crAmt);
            this.log.fine(line.toString());
            this.m_lines.add(line);
        } else {
            line = BSline != null ? BSline : PLline;
            if (line == null) {
                this.log.severe("No Line found");
            } else {
                this.log.fine("Adjusting Amt=" + diff + "; Line=" + line);
                line.currencyCorrect(diff);
                this.log.fine(line.toString());
            }
        }
        return line;
    }

    public boolean checkAccounts() {
        if (this.m_lines.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine line = this.m_lines.get(i);
            MAccount account = line.getAccount();
            if (account == null) {
                this.log.warning("No Account for " + line);
                return false;
            }
            MElementValue ev = account.getAccount();
            if (ev == null) {
                this.log.warning("No Element Value for " + account + ": " + line);
                this.m_doc.p_Error = account.toString();
                return false;
            }
            if (ev.isSummary()) {
                this.log.warning("Cannot post to Summary Account " + ev + ": " + line);
                this.m_doc.p_Error = ev.toString();
                return false;
            }
            if (ev.isActive()) continue;
            this.log.warning("Cannot post to Inactive Account " + ev + ": " + line);
            this.m_doc.p_Error = ev.toString();
            return false;
        }
        return true;
    }

    public boolean distribute() {
        int i;
        if (this.m_lines.size() == 0) {
            return true;
        }
        ArrayList<FactLine> newLines = new ArrayList<FactLine>();
        for (i = 0; i < this.m_lines.size(); ++i) {
            FactLine factLineSource = this.m_lines.get(i);
            List<MDistribution> distributions = MDistribution.get(factLineSource.getAccount(), this.m_postingType, this.m_doc.getC_DocType_ID(), factLineSource.getDateAcct());
            if ((distributions == null || distributions.size() == 0) && ((distributions = MDistribution.get(factLineSource.getCtx(), factLineSource.getC_AcctSchema_ID(), this.m_postingType, this.m_doc.getC_DocType_ID(), factLineSource.getAD_Org_ID(), factLineSource.getAccount_ID(), factLineSource.getM_Product_ID(), factLineSource.getC_BPartner_ID(), factLineSource.getC_Project_ID(), factLineSource.getC_Campaign_ID(), factLineSource.getC_Activity_ID(), factLineSource.getAD_OrgTrx_ID(), factLineSource.getC_SalesRegion_ID(), factLineSource.getC_LocTo_ID(), factLineSource.getC_LocFrom_ID(), factLineSource.getUser1_ID(), factLineSource.getUser2_ID(), factLineSource.getUser3_ID(), factLineSource.getUser4_ID(), factLineSource.getDateAcct())) == null || distributions.size() == 0)) continue;
            if (distributions.size() > 1) {
                this.log.warning("More then one Distributiion for " + factLineSource.getAccount());
            }
            MDistribution distribution = distributions.get(0);
            List<MDistributionLine> distributionLines = distribution.getLines(false);
            if (distribution.getPercentTotal().signum() != 0) {
                if (distribution.isCreateReversal()) {
                    FactLine reversal = factLineSource.reverse(distribution.getName());
                    this.log.info("Reversal=" + reversal);
                    newLines.add(reversal);
                } else {
                    MDistributionLine distributionLine = (MDistributionLine)distributionLines.stream().findFirst().get();
                    if (!distributionLine.isOverwritePostingType() || distributionLine.getPostingType() == null || distribution.getPostingType() == null || distributionLine.getPostingType() == null || distribution.getPostingType().equals(distributionLine.getPostingType()) || distributionLine.getPercent().doubleValue() != 0.0) {
                        this.m_lines.remove(i);
                        --i;
                    }
                }
            }
            distribution.distribute(factLineSource.getAccount(), factLineSource.getSourceBalance(), factLineSource.getQty(), factLineSource.getC_Currency_ID(), this.m_doc.getAmount().signum());
            for (MDistributionLine distributionLine : distributionLines) {
                FactLine factLine = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
                factLine.setDocumentInfo(this.m_doc, factLineSource.getDocLine());
                factLine.setAccount(this.m_acctSchema, distributionLine.getAccount());
                if (factLine.getLine_ID() <= 0 && factLineSource.getLine_ID() > 0) {
                    factLine.setLine_ID(factLineSource.getLine_ID());
                }
                if (factLine.getAD_OrgTrx_ID() <= 0 && factLineSource.getAD_OrgTrx_ID() > 0) {
                    factLine.setAD_OrgTrx_ID(factLineSource.getAD_OrgTrx_ID());
                }
                if (factLine.getC_Campaign_ID() <= 0 && factLineSource.getC_Campaign_ID() > 0) {
                    factLine.setC_Campaign_ID(factLineSource.getC_Campaign_ID());
                }
                if (factLine.getC_Project_ID() <= 0 && factLineSource.getC_Project_ID() > 0) {
                    factLine.setC_Project_ID(factLineSource.getC_Project_ID());
                }
                if (factLine.getC_ProjectPhase_ID() <= 0 && factLineSource.getC_ProjectPhase_ID() > 0) {
                    factLine.setC_ProjectPhase_ID(factLineSource.getC_ProjectPhase_ID());
                }
                if (factLine.getC_ProjectTask_ID() <= 0 && factLineSource.getC_ProjectTask_ID() > 0) {
                    factLine.setC_ProjectTask_ID(factLineSource.getC_ProjectTask_ID());
                }
                if (factLine.getC_Activity_ID() <= 0 && factLineSource.getC_Activity_ID() > 0) {
                    factLine.setC_Activity_ID(factLineSource.getC_Activity_ID());
                }
                if (factLine.getC_SalesRegion_ID() <= 0 && factLineSource.getC_SalesRegion_ID() > 0) {
                    factLine.setC_SalesRegion_ID(factLineSource.getC_SalesRegion_ID());
                }
                if (factLine.getUser1_ID() <= 0 && factLineSource.getUser1_ID() > 0) {
                    factLine.setUser1_ID(factLineSource.getUser1_ID());
                }
                if (factLine.getUser2_ID() <= 0 && factLineSource.getUser2_ID() > 0) {
                    factLine.setUser2_ID(factLineSource.getUser2_ID());
                }
                if (factLine.getUser3_ID() <= 0 && factLineSource.getUser3_ID() > 0) {
                    factLine.setUser3_ID(factLineSource.getUser3_ID());
                }
                if (factLine.getUser4_ID() <= 0 && factLineSource.getUser4_ID() > 0) {
                    factLine.setUser4_ID(factLineSource.getUser4_ID());
                }
                if (factLine.getUserElement1_ID() <= 0 && factLineSource.getUserElement1_ID() > 0) {
                    factLine.setUserElement1_ID(factLineSource.getUserElement1_ID());
                }
                if (factLine.getUserElement2_ID() <= 0 && factLineSource.getUserElement2_ID() > 0) {
                    factLine.setUserElement2_ID(factLineSource.getUserElement2_ID());
                }
                if (factLine.getC_LocFrom_ID() <= 0 && factLineSource.getC_LocFrom_ID() > 0) {
                    factLine.setC_LocFrom_ID(factLineSource.getC_LocFrom_ID());
                }
                if (factLine.getC_LocTo_ID() <= 0 && factLineSource.getC_LocTo_ID() > 0) {
                    factLine.setC_LocTo_ID(factLineSource.getC_LocTo_ID());
                }
                factLine.setPostingType(this.m_postingType);
                if (distributionLine.isOverwritePostingType() && distributionLine.getPostingType() != null && !distribution.getPostingType().equals(distributionLine.getPostingType()) && distributionLine.getPercent().doubleValue() == 0.0) {
                    factLine.setPostingType(distributionLine.getPostingType());
                }
                if (distributionLine.isOverwriteOrg()) {
                    factLine.setAD_Org_ID(distributionLine.getOrg_ID());
                }
                if (distributionLine.isOverwriteAcct()) {
                    factLine.setAccount_ID(distributionLine.getAccount_ID());
                }
                if (distributionLine.isOverwriteActivity()) {
                    factLine.setC_Activity_ID(distributionLine.getC_Activity_ID());
                }
                if (distributionLine.isOverwriteBPartner()) {
                    factLine.setC_BPartner_ID(distributionLine.getC_BPartner_ID());
                }
                if (distributionLine.isOverwriteCampaign()) {
                    factLine.setC_Campaign_ID(distributionLine.getC_Campaign_ID());
                }
                if (distributionLine.isOverwriteLocFrom()) {
                    factLine.setC_LocFrom_ID(distributionLine.getC_LocFrom_ID());
                }
                if (distributionLine.isOverwriteLocTo()) {
                    factLine.setC_LocTo_ID(distributionLine.getC_LocTo_ID());
                }
                if (distributionLine.isOverwriteOrgTrx()) {
                    factLine.setAD_OrgTrx_ID(distributionLine.getAD_OrgTrx_ID());
                }
                if (distributionLine.isOverwriteProduct()) {
                    factLine.setM_Product_ID(distributionLine.getM_Product_ID());
                }
                if (distributionLine.isOverwriteProject()) {
                    factLine.setC_Project_ID(distributionLine.getC_Project_ID());
                }
                if (distributionLine.isOverwriteSalesRegion()) {
                    factLine.setC_SalesRegion_ID(distributionLine.getC_SalesRegion_ID());
                }
                if (distributionLine.isOverwriteUser1()) {
                    factLine.setUser1_ID(distributionLine.getUser1_ID());
                }
                if (distributionLine.isOverwriteUser2()) {
                    factLine.setUser2_ID(distributionLine.getUser2_ID());
                }
                if (distributionLine.isOverwriteUser3()) {
                    factLine.setUser3_ID(distributionLine.getUser3_ID());
                }
                if (distributionLine.isOverwriteUser4()) {
                    factLine.setUser4_ID(distributionLine.getUser4_ID());
                }
                if (distributionLine.isInvertAccountSign()) {
                    if (distributionLine.getAmt() != null && distributionLine.getAmt().signum() < 0) {
                        factLine.setAmtSource(factLineSource.getC_Currency_ID(), null, distributionLine.getAmt().abs());
                    } else {
                        factLine.setAmtSource(factLineSource.getC_Currency_ID(), distributionLine.getAmt(), null);
                    }
                } else if (distributionLine.getAmt() != null && distributionLine.getAmt().signum() < 0) {
                    factLine.setAmtSource(factLineSource.getC_Currency_ID(), null, distributionLine.getAmt().abs());
                } else {
                    factLine.setAmtSource(factLineSource.getC_Currency_ID(), distributionLine.getAmt(), null);
                }
                factLine.setQty(distributionLine.getQty());
                factLine.convert();
                String description = distribution.getName() + " #" + distributionLine.getLine();
                if (distributionLine.getDescription() != null) {
                    description = description + " - " + distributionLine.getDescription();
                }
                factLine.addDescription(description);
                this.log.info(factLine.toString());
                newLines.add(factLine);
            }
        }
        for (i = 0; i < newLines.size(); ++i) {
            this.m_lines.add((FactLine)newLines.get(i));
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Fact[");
        sb.append(this.m_doc.toString());
        sb.append(",").append(this.m_acctSchema.toString());
        sb.append(",PostType=").append(this.m_postingType);
        sb.append("]");
        return sb.toString();
    }

    public FactLine[] getLines() {
        FactLine[] temp = new FactLine[this.m_lines.size()];
        this.m_lines.toArray(temp);
        return temp;
    }

    public boolean save(String trxName) {
        this.m_trxName = trxName;
        for (int i = 0; i < this.m_lines.size(); ++i) {
            FactLine fl = this.m_lines.get(i);
            if (fl.save(trxName)) continue;
            return false;
        }
        return true;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    private void set_TrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public Doc getDocument() {
        return this.m_doc;
    }

    public class Balance {
        public BigDecimal DR = Env.ZERO;
        public BigDecimal CR = Env.ZERO;

        public Balance(BigDecimal dr, BigDecimal cr) {
            this.DR = dr;
            this.CR = cr;
        }

        public void add(BigDecimal dr, BigDecimal cr) {
            this.DR = this.DR.add(dr);
            this.CR = this.CR.add(cr);
        }

        public BigDecimal getBalance() {
            return this.DR.subtract(this.CR);
        }

        public BigDecimal getPostBalance() {
            BigDecimal bd = this.getBalance().abs();
            if (this.isReversal()) {
                return bd.negate();
            }
            return bd;
        }

        public boolean isZeroBalance() {
            return this.getBalance().signum() == 0;
        }

        public boolean isReversal() {
            return this.DR.signum() <= 0 && this.CR.signum() <= 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Balance[");
            sb.append("DR=").append(this.DR).append("-CR=").append(this.CR).append(" = ").append(this.getBalance()).append("]");
            return sb.toString();
        }
    }
}

