/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_FMBatch;
import org.compiere.acct.Fact;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMBatch;
import org.spin.model.MFMTransaction;
import org.spin.model.X_FM_TransactionType_Acct;

public class Doc_FMBatch
extends Doc {
    private MFMBatch batch = null;
    private MFMAccount account = null;
    private MFMAgreement agreement = null;
    public static final String DOCTYPE_Financial_Batch = "FMB";

    public Doc_FMBatch(MAcctSchema[] mAcctSchemaArray, ResultSet resultSet, String string) {
        super(mAcctSchemaArray, MFMBatch.class, resultSet, DOCTYPE_Financial_Batch, string);
    }

    @Override
    protected String loadDocumentDetails() {
        this.batch = (MFMBatch)this.getPO();
        this.account = (MFMAccount)this.batch.getFM_Account();
        this.agreement = (MFMAgreement)this.account.getFM_Agreement();
        this.setDateDoc(this.getDateAcct());
        this.p_lines = this.loadLines(this.batch);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    @Override
    public Timestamp getDateAcct() {
        return this.batch.getDateAcct();
    }

    private DocLine[] loadLines(MFMBatch mFMBatch) {
        ArrayList<DocLine_FMBatch> arrayList = new ArrayList<DocLine_FMBatch>();
        List list = new Query(this.getCtx(), "FM_Transaction", "FM_Transaction.FM_Batch_ID = ? AND FM_Transaction.Amount <> 0 AND EXISTS(SELECT 1 FROM FM_TransactionType tt \t\t\t\t\tWHERE tt.FM_TransactionType_ID = FM_Transaction.FM_TransactionType_ID)", this.getTrxName()).setParameters(mFMBatch.getFM_Batch_ID()).list();
        for (MFMTransaction mFMTransaction : list) {
            DocLine_FMBatch docLine_FMBatch = new DocLine_FMBatch(mFMTransaction, this);
            this.log.fine(docLine_FMBatch.toString());
            arrayList.add(docLine_FMBatch);
        }
        DocLine[] docLineArray = new DocLine[arrayList.size()];
        arrayList.toArray(docLineArray);
        return docLineArray;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal bigDecimal = Env.ZERO;
        return bigDecimal;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema mAcctSchema) {
        Fact fact = new Fact(this, mAcctSchema, "A");
        for (DocLine docLine : this.p_lines) {
            MAccount mAccount;
            MAccount mAccount2;
            DocLine_FMBatch docLine_FMBatch = (DocLine_FMBatch)docLine;
            BigDecimal bigDecimal = docLine.getAmtSource();
            bigDecimal = bigDecimal.setScale(mAcctSchema.getStdPrecision(), 4);
            X_FM_TransactionType_Acct x_FM_TransactionType_Acct = docLine_FMBatch.getTransactionTypeAcct(mAcctSchema.getC_AcctSchema_ID());
            if (x_FM_TransactionType_Acct == null) continue;
            if (!this.agreement.isSOTrx()) {
                mAccount2 = MAccount.getValidCombination(this.getCtx(), x_FM_TransactionType_Acct.getFM_Expense_Acct(), this.getTrxName());
                fact.createLine(docLine, mAccount2, this.account.getC_Currency_ID(), bigDecimal, null);
                mAccount = MAccount.getValidCombination(this.getCtx(), x_FM_TransactionType_Acct.getFM_Revenue_Acct(), this.getTrxName());
                fact.createLine(docLine, mAccount, this.account.getC_Currency_ID(), null, bigDecimal);
                continue;
            }
            mAccount2 = MAccount.getValidCombination(this.getCtx(), x_FM_TransactionType_Acct.getFM_Expense_Acct(), this.getTrxName());
            fact.createLine(docLine, mAccount2, this.account.getC_Currency_ID(), bigDecimal, null);
            mAccount = MAccount.getValidCombination(this.getCtx(), x_FM_TransactionType_Acct.getFM_Revenue_Acct(), this.getTrxName());
            fact.createLine(docLine, mAccount, this.account.getC_Currency_ID(), null, bigDecimal);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(fact);
        return arrayList;
    }
}

