/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.acct.DocFactory;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_AllocationHdr;
import org.compiere.acct.Doc_GLJournal;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MFactAcct;
import org.compiere.model.MNote;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public abstract class Doc {
    private static int[] documentsTableID = null;
    private static String[] documentsTableName = null;
    public static final String DOCTYPE_ARInvoice = "ARI";
    public static final String DOCTYPE_ARCredit = "ARC";
    public static final String DOCTYPE_ARReceipt = "ARR";
    public static final String DOCTYPE_ARProForma = "ARF";
    public static final String DOCTYPE_APInvoice = "API";
    public static final String DOCTYPE_APCredit = "APC";
    public static final String DOCTYPE_APPayment = "APP";
    public static final String DOCTYPE_BankStatement = "CMB";
    public static final String DOCTYPE_CashJournal = "CMC";
    public static final String DOCTYPE_Allocation = "CMA";
    public static final String DOCTYPE_MatShipment = "MMS";
    public static final String DOCTYPE_MatReceipt = "MMR";
    public static final String DOCTYPE_MatInventory = "MMI";
    public static final String DOCTYPE_MatMovement = "MMM";
    public static final String DOCTYPE_MatProduction = "MMP";
    public static final String DOCTYPE_MatMatchInv = "MXI";
    public static final String DOCTYPE_MatMatchPO = "MXP";
    public static final String DOCTYPE_GLJournal = "GLJ";
    public static final String DOCTYPE_POrder = "POO";
    public static final String DOCTYPE_SOrder = "SOO";
    public static final String DOCTYPE_ProjectIssue = "PJI";
    public static final String DOCTYPE_PurchaseRequisition = "POR";
    public static final String DOCTYPE_ManufacturingPlannedOrder = "MPO";
    public static final String STATUS_NotPosted = "N";
    public static final String STATUS_NotBalanced = "b";
    public static final String STATUS_NotConvertible = "c";
    public static final String STATUS_PeriodClosed = "p";
    public static final String STATUS_InvalidAccount = "i";
    public static final String STATUS_PostPrepared = "y";
    public static final String STATUS_Posted = "Y";
    public static final String STATUS_Error = "E";
    protected static CLogger s_log = CLogger.getCLogger(Doc.class);
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_manageLocalTrx;
    private MAcctSchema[] accountingSchemes = null;
    private Properties m_ctx = null;
    private String m_trxName = null;
    protected PO p_po = null;
    private String m_DocumentType = null;
    private String m_DocStatus = null;
    private String m_DocumentNo = null;
    private String m_Description = null;
    private int m_GL_Category_ID = 0;
    private MPeriod m_period = null;
    private int m_C_Period_ID = 0;
    private int m_C_LocFrom_ID = 0;
    private int m_C_LocTo_ID = 0;
    private Timestamp m_DateAcct = null;
    private Timestamp m_DateDoc = null;
    private boolean m_TaxIncluded = false;
    private boolean m_MultiCurrency = false;
    private int m_BP_C_SalesRegion_ID = -1;
    private int m_C_BPartner_ID = -1;
    private int m_C_BankAccount_ID = -1;
    private int m_C_CashBook_ID = -1;
    private int m_C_Currency_ID = -1;
    protected DocLine[] p_lines;
    private ArrayList<Fact> m_fact = null;
    protected static final int NO_CURRENCY = -2;
    protected String p_Status = "E";
    protected String p_Error = null;
    public static final int AMTTYPE_Gross = 0;
    public static final int AMTTYPE_Net = 1;
    public static final int AMTTYPE_Charge = 2;
    private BigDecimal[] m_Amounts = new BigDecimal[4];
    private BigDecimal m_qty = null;
    public static final int ACCTTYPE_Charge = 0;
    public static final int ACCTTYPE_C_Receivable = 1;
    public static final int ACCTTYPE_V_Liability = 2;
    public static final int ACCTTYPE_V_Liability_Services = 3;
    public static final int ACCTTYPE_C_Receivable_Services = 4;
    public static final int ACCTTYPE_UnallocatedCash = 10;
    public static final int ACCTTYPE_BankInTransit = 11;
    public static final int ACCTTYPE_PaymentSelect = 12;
    public static final int ACCTTYPE_C_Prepayment = 13;
    public static final int ACCTTYPE_V_Prepayment = 14;
    public static final int ACCTTYPE_BankUnidentified = 15;
    public static final int ACCTTYPE_CashAsset = 20;
    public static final int ACCTTYPE_CashTransfer = 21;
    public static final int ACCTTYPE_CashExpense = 22;
    public static final int ACCTTYPE_CashReceipt = 23;
    public static final int ACCTTYPE_CashDifference = 24;
    public static final int ACCTTYPE_DiscountExp = 30;
    public static final int ACCTTYPE_DiscountRev = 31;
    public static final int ACCTTYPE_WriteOff = 32;
    public static final int ACCTTYPE_BankAsset = 40;
    public static final int ACCTTYPE_InterestRev = 41;
    public static final int ACCTTYPE_InterestExp = 42;
    public static final int ACCTTYPE_InvDifferences = 50;
    public static final int ACCTTYPE_NotInvoicedReceipts = 51;
    public static final int ACCTTYPE_ProjectAsset = 61;
    public static final int ACCTTYPE_ProjectWIP = 62;
    public static final int ACCTTYPE_PPVOffset = 101;
    public static final int ACCTTYPE_CommitmentOffset = 111;
    public static final int ACCTTYPE_CommitmentOffsetSales = 112;

    public static Doc get(MAcctSchema[] ass, int AD_Table_ID, int Record_ID, String trxName) {
        try {
            return new DocFactory().withAccountingSchemes(ass).withTableID(AD_Table_ID).withRecordID(Record_ID).withTrxName(trxName).get();
        }
        catch (AdempiereUserError e) {
            s_log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static Doc get(MAcctSchema[] ass, int AD_Table_ID, ResultSet rs, String trxName) throws AdempiereUserError {
        return new DocFactory().withAccountingSchemes(ass).withTableID(AD_Table_ID).withResultSet(rs).withTrxName(trxName).get();
    }

    public static String postImmediate(MAcctSchema[] ass, int AD_Table_ID, int Record_ID, boolean force, String trxName) {
        Doc doc = Doc.get(ass, AD_Table_ID, Record_ID, trxName);
        if (doc != null) {
            return doc.post(force, true);
        }
        return "NoDoc";
    }

    Doc(MAcctSchema[] ass, Class<?> clazz, ResultSet rs, String defaultDocumentType, String trxName) {
        this.accountingSchemes = ass;
        this.m_ctx = new Properties(this.accountingSchemes[0].getCtx());
        this.m_ctx.setProperty("#AD_Client_ID", String.valueOf(this.accountingSchemes[0].getAD_Client_ID()));
        String className = clazz.getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        try {
            Constructor<?> constructor = clazz.getConstructor(Properties.class, ResultSet.class, String.class);
            this.p_po = (PO)constructor.newInstance(this.m_ctx, rs, trxName);
        }
        catch (Exception e) {
            String msg = className + ": " + e.getLocalizedMessage();
            this.log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.getDocStatus();
        this.setDocumentType(defaultDocumentType);
        this.m_trxName = trxName;
        this.m_manageLocalTrx = false;
        if (this.m_trxName == null) {
            this.m_trxName = "Post" + this.m_DocumentType + this.p_po.get_ID();
            this.m_manageLocalTrx = true;
        }
        this.p_po.set_TrxName(this.m_trxName);
        this.m_Amounts[0] = Env.ZERO;
        this.m_Amounts[1] = Env.ZERO;
        this.m_Amounts[2] = Env.ZERO;
        this.m_Amounts[3] = Env.ZERO;
    }

    public String getPostStatus() {
        return this.p_Status;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public String get_TableName() {
        return this.p_po.get_TableName();
    }

    public int get_Table_ID() {
        return this.p_po.get_Table_ID();
    }

    public int get_ID() {
        return this.p_po.get_ID();
    }

    protected PO getPO() {
        return this.p_po;
    }

    public final String post(boolean force, boolean repost) {
        if (!(this.getDocStatus() == null || this.getDocStatus().equals("CO") || this.getDocStatus().equals("CL") || this.getDocStatus().equals("VO") || this.getDocStatus().equals("RE"))) {
            return "Invalid DocStatus='" + this.getDocStatus() + "' for DocumentNo=" + this.getDocumentNo();
        }
        if (this.p_po.getAD_Client_ID() != this.accountingSchemes[0].getAD_Client_ID()) {
            String error = "AD_Client_ID Conflict - Document=" + this.p_po.getAD_Client_ID() + ", AcctSchema=" + this.accountingSchemes[0].getAD_Client_ID();
            this.log.severe(error);
            return error;
        }
        String trxName = null;
        if (!this.m_manageLocalTrx) {
            trxName = this.getTrxName();
        }
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this.get_TableName()).append(" SET Processing='Y' WHERE ").append(this.get_TableName()).append("_ID=").append(this.get_ID()).append(" AND Processed='Y' AND IsActive='Y'");
        if (!force) {
            sql.append(" AND (Processing='N' OR Processing IS NULL)");
        }
        if (!repost) {
            sql.append(" AND Posted='N'");
        }
        if (DB.executeUpdate(sql.toString(), trxName) != 1) {
            this.log.log(Level.SEVERE, "Resubmit - Cannot lock " + this.get_TableName() + "_ID=" + this.get_ID() + ", Force=" + force + ",RePost=" + repost);
            if (force) {
                return "Cannot Lock - ReSubmit";
            }
            return "Cannot Lock - ReSubmit or RePost with Force";
        }
        this.log.info("Locked: " + this.get_TableName() + "_ID=" + this.get_ID());
        this.p_Error = this.loadDocumentDetails();
        if (this.p_Error != null) {
            return this.p_Error;
        }
        Trx trx = Trx.get(this.getTrxName(), true);
        if (repost) {
            if (this.isPosted() && !this.isPeriodOpen()) {
                this.log.log(Level.SEVERE, this.toString() + " - Period Closed for already posed document");
                this.unlock();
                trx.commit();
                trx.close();
                return "PeriodClosed";
            }
            this.deleteAcct();
        } else if (this.isPosted()) {
            this.log.log(Level.SEVERE, this.toString() + " - Document already posted");
            this.unlock();
            trx.commit();
            trx.close();
            return "AlreadyPosted";
        }
        this.p_Status = STATUS_NotPosted;
        this.m_fact = new ArrayList();
        boolean OK = true;
        this.getPO().setDoc(this);
        try {
            for (int i = 0; OK && i < this.accountingSchemes.length; ++i) {
                boolean skip = false;
                if (this.accountingSchemes[i].getAD_OrgOnly_ID() != 0) {
                    skip = this.accountingSchemes[i].isSkipOrg(this.getAD_Org_ID());
                    if (this.p_lines != null) {
                        for (int line = 0; skip && line < this.p_lines.length && (skip = this.accountingSchemes[i].isSkipOrg(this.p_lines[line].getAD_Org_ID())); ++line) {
                        }
                    }
                }
                if (skip) continue;
                this.log.info("(" + i + ") " + this.p_po);
                this.p_Status = this.postLogic(i);
                if (this.p_Status.equals(STATUS_Posted)) continue;
                OK = false;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.p_Status = STATUS_Error;
            this.p_Error = e.toString();
            OK = false;
        }
        String validatorMsg = null;
        if (this.p_Status.equals(STATUS_Posted) && (validatorMsg = ModelValidationEngine.get().fireDocValidate(this.getPO(), 15)) != null) {
            this.p_Status = STATUS_Error;
            this.p_Error = validatorMsg;
            OK = false;
        }
        this.p_Status = this.postCommit(this.p_Status);
        if (this.p_Status.equals(STATUS_Posted) && (validatorMsg = ModelValidationEngine.get().fireDocValidate(this.getPO(), 16)) != null) {
            this.p_Status = STATUS_Error;
            this.p_Error = validatorMsg;
            OK = false;
        }
        if (!this.p_Status.equals(STATUS_Posted)) {
            String AD_MessageValue = "PostingError-" + this.p_Status;
            int AD_User_ID = this.p_po.getUpdatedBy();
            MNote note = new MNote(this.getCtx(), AD_MessageValue, AD_User_ID, this.getAD_Client_ID(), this.getAD_Org_ID(), null);
            note.setRecord(this.p_po.get_Table_ID(), this.p_po.get_ID());
            note.setReference(this.toString());
            StringBuffer Text = new StringBuffer(Msg.getMsg(Env.getCtx(), AD_MessageValue));
            if (this.p_Error != null) {
                Text.append(" (").append(this.p_Error).append(")");
            }
            String cn = this.getClass().getName();
            Text.append(" - ").append(cn.substring(cn.lastIndexOf(46))).append(" (").append(this.getDocumentType()).append(" - DocumentNo=").append(this.getDocumentNo()).append(", DateAcct=").append(this.getDateAcct().toString().substring(0, 10)).append(", Amount=").append(this.getAmount()).append(", Sta=").append(this.p_Status).append(" - PeriodOpen=").append(this.isPeriodOpen()).append(", Balanced=").append(this.isBalanced());
            note.setTextMsg(Text.toString());
            note.saveEx();
            this.p_Error = Text.toString();
        }
        for (int i = 0; i < this.m_fact.size(); ++i) {
            Fact fact = this.m_fact.get(i);
            if (fact == null) continue;
            fact.dispose();
        }
        this.p_lines = null;
        if (this.p_Status.equals(STATUS_Posted)) {
            return null;
        }
        return this.p_Error;
    }

    private int deleteAcct() {
        StringBuffer sql = new StringBuffer("DELETE Fact_Acct WHERE AD_Table_ID=").append(this.get_Table_ID()).append(" AND Record_ID=").append(this.p_po.get_ID());
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        if (no != 0) {
            this.log.info("deleted=" + no);
        }
        return no;
    }

    private final String postLogic(int index) {
        this.log.info("(" + index + ") " + this.p_po);
        if (!this.accountingSchemes[index].isSuspenseBalancing() && !this.isBalanced()) {
            return STATUS_NotBalanced;
        }
        if (!this.isConvertible(this.accountingSchemes[index])) {
            return STATUS_NotConvertible;
        }
        if (!this.isPeriodOpen()) {
            return STATUS_PeriodClosed;
        }
        if (this.isReversed().booleanValue() && this.IsReverseGenerated().booleanValue() && this.isReverseWithOriginalAccounting().booleanValue()) {
            return this.generateReverseWithOriginalAccounting(this.accountingSchemes[index]);
        }
        ArrayList<Fact> facts = this.createFacts(this.accountingSchemes[index]);
        if (facts == null) {
            return STATUS_Error;
        }
        String validatorMsg = ModelValidationEngine.get().fireFactsValidate(this.accountingSchemes[index], facts, this.getPO());
        if (validatorMsg != null) {
            this.p_Error = validatorMsg;
            return STATUS_Error;
        }
        for (int f = 0; f < facts.size(); ++f) {
            Fact fact = facts.get(f);
            if (fact == null) {
                return STATUS_Error;
            }
            this.m_fact.add(fact);
            this.p_Status = STATUS_PostPrepared;
            if (!fact.checkAccounts()) {
                return STATUS_InvalidAccount;
            }
            if (!fact.distribute()) {
                return STATUS_Error;
            }
            if (!fact.isSourceBalanced()) {
                fact.balanceSource();
                if (!fact.isSourceBalanced()) {
                    return STATUS_NotBalanced;
                }
            }
            if (!fact.isSegmentBalanced()) {
                fact.balanceSegments();
                if (!fact.isSegmentBalanced()) {
                    return STATUS_NotBalanced;
                }
            }
            if (fact.isAcctBalanced()) continue;
            fact.balanceAccounting();
            if (fact.isAcctBalanced()) continue;
            return STATUS_NotBalanced;
        }
        return STATUS_Posted;
    }

    private final String postCommit(String status) {
        this.log.info("Sta=" + status + " DT=" + this.getDocumentType() + " ID=" + this.p_po.get_ID());
        this.p_Status = status;
        Trx trx = Trx.get(this.getTrxName(), true);
        try {
            if (status.equals(STATUS_Posted)) {
                for (int i = 0; i < this.m_fact.size(); ++i) {
                    Fact fact = this.m_fact.get(i);
                    if (fact == null || fact.save(this.getTrxName())) continue;
                    this.log.log(Level.SEVERE, "(fact not saved) ... rolling back");
                    if (this.m_manageLocalTrx) {
                        trx.rollback();
                        trx.close();
                    }
                    this.unlock();
                    return STATUS_Error;
                }
            }
            if (!this.save(this.getTrxName())) {
                this.log.log(Level.SEVERE, "(doc not saved) ... rolling back");
                if (this.m_manageLocalTrx) {
                    trx.rollback();
                    trx.close();
                }
                this.unlock();
                return STATUS_Error;
            }
            if (this.m_manageLocalTrx) {
                trx.commit(true);
                trx.close();
                trx = null;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "... rolling back", e);
            status = STATUS_Error;
            if (this.m_manageLocalTrx) {
                try {
                    if (trx != null) {
                        trx.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (trx != null) {
                        trx.close();
                    }
                    trx = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.unlock();
        }
        this.p_Status = status;
        return status;
    }

    public String getTrxName() {
        return this.m_trxName;
    }

    private void unlock() {
        String trxName = null;
        if (!this.m_manageLocalTrx) {
            trxName = this.getTrxName();
        }
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this.get_TableName()).append(" SET Processing='N' WHERE ").append(this.get_TableName()).append("_ID=").append(this.p_po.get_ID());
        DB.executeUpdate(sql.toString(), trxName);
    }

    public String getDocumentType() {
        if (this.m_DocumentType == null) {
            this.setDocumentType(null);
        }
        return this.m_DocumentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocumentType(String DocumentType) {
        ResultSet rsDT;
        CPreparedStatement pstmt;
        String sql;
        if (DocumentType != null) {
            this.m_DocumentType = DocumentType;
        }
        if (this.m_DocumentType == null && this.getC_DocType_ID() != 0) {
            block17: {
                sql = "SELECT DocBaseType, GL_Category_ID FROM C_DocType WHERE C_DocType_ID=?";
                pstmt = null;
                rsDT = null;
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getC_DocType_ID());
                    rsDT = pstmt.executeQuery();
                    if (!rsDT.next()) break block17;
                    this.m_DocumentType = rsDT.getString(1);
                    this.m_GL_Category_ID = rsDT.getInt(2);
                }
                catch (SQLException e) {
                    try {
                        this.log.log(Level.SEVERE, sql, e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rsDT, pstmt);
                        rsDT = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rsDT, pstmt);
                    rsDT = null;
                    pstmt = null;
                }
            }
            DB.close(rsDT, pstmt);
            rsDT = null;
            pstmt = null;
        }
        if (this.m_DocumentType == null) {
            this.log.log(Level.SEVERE, "No DocBaseType for C_DocType_ID=" + this.getC_DocType_ID() + ", DocumentNo=" + this.getDocumentNo());
        }
        if (this.m_GL_Category_ID == 0) {
            sql = "SELECT GL_Category_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=?";
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getAD_Client_ID());
                pstmt.setString(2, this.m_DocumentType);
                rsDT = pstmt.executeQuery();
                if (rsDT.next()) {
                    this.m_GL_Category_ID = rsDT.getInt(1);
                }
                rsDT.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        if (this.m_GL_Category_ID == 0) {
            sql = "SELECT GL_Category_ID FROM GL_Category WHERE AD_Client_ID=? ORDER BY IsDefault DESC";
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getAD_Client_ID());
                rsDT = pstmt.executeQuery();
                if (rsDT.next()) {
                    this.m_GL_Category_ID = rsDT.getInt(1);
                }
                rsDT.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        if (this.m_GL_Category_ID == 0) {
            this.log.log(Level.SEVERE, "No default GL_Category - " + this.toString());
        }
        if (this.m_DocumentType == null) {
            throw new IllegalStateException("Document Type not found");
        }
    }

    public boolean isBalanced() {
        boolean retValue;
        if (this.isMultiCurrency()) {
            return true;
        }
        boolean bl = retValue = this.getBalance().signum() == 0;
        if (retValue) {
            this.log.fine("Yes " + this.toString());
        } else {
            this.log.warning("NO - " + this.toString());
        }
        return retValue;
    }

    public boolean isConvertible(MAcctSchema acctSchema) {
        if (this.getC_Currency_ID() == -2) {
            this.log.fine("(none) - " + this.toString());
            return true;
        }
        if (this instanceof Doc_GLJournal) {
            int glj_as = (Integer)this.p_po.get_Value("C_AcctSchema_ID");
            if (acctSchema.getC_AcctSchema_ID() != glj_as) {
                return true;
            }
        }
        if (this instanceof Doc_AllocationHdr) {
            return true;
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(this.getC_Currency_ID()));
        for (int i = 0; this.p_lines != null && i < this.p_lines.length; ++i) {
            int C_Currency_ID = this.p_lines[i].getC_Currency_ID();
            if (C_Currency_ID == -2) continue;
            set.add(new Integer(C_Currency_ID));
        }
        if (set.size() == 1 && acctSchema.getC_Currency_ID() == this.getC_Currency_ID()) {
            this.log.fine("(same) Cur=" + this.getC_Currency_ID() + " - " + this.toString());
            return true;
        }
        boolean convertible = true;
        Iterator it = set.iterator();
        while (it.hasNext() && convertible) {
            int C_Currency_ID = (Integer)it.next();
            if (C_Currency_ID == acctSchema.getC_Currency_ID()) continue;
            BigDecimal amt = MConversionRate.getRate(C_Currency_ID, acctSchema.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
            if (amt == null) {
                convertible = false;
                this.log.warning("NOT from C_Currency_ID=" + C_Currency_ID + " to " + acctSchema.getC_Currency_ID() + " - " + this.toString());
                continue;
            }
            this.log.fine("From C_Currency_ID=" + C_Currency_ID);
        }
        this.log.fine("Convertible=" + convertible + ", AcctSchema C_Currency_ID=" + acctSchema.getC_Currency_ID() + " - " + this.toString());
        return convertible;
    }

    public void setPeriod() {
        Integer ii;
        if (this.m_period != null) {
            return;
        }
        int index = this.p_po.get_ColumnIndex("C_Period_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            this.m_period = MPeriod.get(this.getCtx(), ii);
        }
        if (this.m_period == null) {
            this.m_period = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
        }
        this.m_C_Period_ID = this.m_period != null && this.m_period.isOpen(this.getDocumentType(), this.getDateAcct()) ? this.m_period.getC_Period_ID() : -1;
        this.log.fine(this.getDateAcct() + " - " + this.getDocumentType() + " => " + this.m_C_Period_ID);
    }

    public int getC_Period_ID() {
        if (this.m_period == null) {
            this.setPeriod();
        }
        return this.m_C_Period_ID;
    }

    public boolean isPeriodOpen() {
        boolean open;
        this.setPeriod();
        boolean bl = open = this.m_C_Period_ID > 0;
        if (open) {
            this.log.fine("Yes - " + this.toString());
        } else {
            this.log.warning("NO - " + this.toString());
        }
        return open;
    }

    public BigDecimal getAmount(int AmtType) {
        if (AmtType < 0 || AmtType >= this.m_Amounts.length) {
            return null;
        }
        return this.m_Amounts[AmtType];
    }

    public void setAmount(int AmtType, BigDecimal amt) {
        if (AmtType < 0 || AmtType >= this.m_Amounts.length) {
            return;
        }
        this.m_Amounts[AmtType] = amt == null ? Env.ZERO : amt;
    }

    public BigDecimal getAmount() {
        return this.m_Amounts[0];
    }

    public void setQty(BigDecimal qty) {
        this.m_qty = qty;
    }

    public BigDecimal getQty() {
        if (this.m_qty == null) {
            int index = this.p_po.get_ColumnIndex("Qty");
            this.m_qty = index != -1 ? (BigDecimal)this.p_po.get_Value(index) : Env.ZERO;
        }
        return this.m_qty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValidCombinationId(int acctType, MAcctSchema acctSchema) {
        int para_1 = 0;
        String sql = null;
        if (acctType == 0) {
            int cmp = this.getAmount(2).compareTo(Env.ZERO);
            if (cmp == 0) {
                return 0;
            }
            sql = cmp < 0 ? "SELECT CH_Expense_Acct FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=?" : "SELECT CH_Revenue_Acct FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_Charge_ID();
        } else if (acctType == 2) {
            sql = "SELECT V_Liability_Acct FROM C_BP_Vendor_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 3) {
            sql = "SELECT V_Liability_Services_Acct FROM C_BP_Vendor_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 1) {
            sql = "SELECT C_Receivable_Acct FROM C_BP_Customer_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 4) {
            sql = "SELECT C_Receivable_Services_Acct FROM C_BP_Customer_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 14) {
            sql = "SELECT V_Prepayment_Acct FROM C_BP_Vendor_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 13) {
            sql = "SELECT C_Prepayment_Acct FROM C_BP_Customer_Acct WHERE C_BPartner_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 10) {
            sql = "SELECT B_UnallocatedCash_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (acctType == 11) {
            sql = "SELECT B_InTransit_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (acctType == 15) {
            sql = "SELECT B_Unidentified_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (acctType == 12) {
            sql = "SELECT B_PaymentSelect_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (acctType == 30) {
            sql = "SELECT a.PayDiscount_Exp_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 31) {
            sql = "SELECT PayDiscount_Rev_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 32) {
            sql = "SELECT WriteOff_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 40) {
            sql = "SELECT B_Asset_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (acctType == 41) {
            sql = "SELECT B_InterestRev_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (acctType == 42) {
            sql = "SELECT B_InterestExp_Acct FROM C_BankAccount_Acct WHERE C_BankAccount_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_BankAccount_ID();
        } else if (acctType == 20) {
            sql = "SELECT CB_Asset_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (acctType == 21) {
            sql = "SELECT CB_CashTransfer_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (acctType == 22) {
            sql = "SELECT CB_Expense_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (acctType == 23) {
            sql = "SELECT CB_Receipt_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (acctType == 24) {
            sql = "SELECT CB_Differences_Acct FROM C_CashBook_Acct WHERE C_CashBook_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_CashBook_ID();
        } else if (acctType == 50) {
            sql = "SELECT W_Differences_Acct FROM M_Warehouse_Acct WHERE M_Warehouse_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getM_Warehouse_ID();
        } else if (acctType == 51) {
            sql = "SELECT NotInvoicedReceipts_Acct FROM C_BP_Group_Acct a, C_BPartner bp WHERE a.C_BP_Group_ID=bp.C_BP_Group_ID AND bp.C_BPartner_ID=? AND a.C_AcctSchema_ID=?";
            para_1 = this.getC_BPartner_ID();
        } else if (acctType == 61) {
            sql = "SELECT PJ_Asset_Acct FROM C_Project_Acct WHERE C_Project_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_Project_ID();
        } else if (acctType == 62) {
            sql = "SELECT PJ_WIP_Acct FROM C_Project_Acct WHERE C_Project_ID=? AND C_AcctSchema_ID=?";
            para_1 = this.getC_Project_ID();
        } else if (acctType == 101) {
            sql = "SELECT PPVOffset_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            para_1 = -1;
        } else if (acctType == 111) {
            sql = "SELECT CommitmentOffset_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            para_1 = -1;
        } else if (acctType == 112) {
            sql = "SELECT CommitmentOffsetSales_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            para_1 = -1;
        } else {
            this.log.severe("Not found AcctType=" + acctType);
            return 0;
        }
        if (sql == null || para_1 == 0) {
            this.log.severe("No Parameter for AcctType=" + acctType + " - SQL=" + sql);
            return 0;
        }
        int Account_ID = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            if (para_1 == -1) {
                pstmt.setInt(1, acctSchema.getC_AcctSchema_ID());
            } else {
                pstmt.setInt(1, para_1);
                pstmt.setInt(2, acctSchema.getC_AcctSchema_ID());
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Account_ID = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            int n;
            try {
                this.log.log(Level.SEVERE, "AcctType=" + acctType + " - SQL=" + sql, e);
                n = 0;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return n;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (Account_ID == 0) {
            this.log.severe("NO account Type=" + acctType + ", Record=" + this.p_po.get_ID());
            return 0;
        }
        return Account_ID;
    }

    public final MAccount getAccount(int acctType, MAcctSchema acctSchema) {
        int validCombinationId = this.getValidCombinationId(acctType, acctSchema);
        if (validCombinationId == 0) {
            return null;
        }
        MAccount account = MAccount.getValidCombination(acctSchema.getCtx(), validCombinationId, this.getTrxName());
        return account;
    }

    private final boolean save(String trxName) {
        this.log.fine(this.toString() + "->" + this.p_Status);
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this.get_TableName()).append(" SET Posted='").append(this.p_Status).append("',Processing='N' ").append("WHERE ").append(this.get_TableName()).append("_ID=").append(this.p_po.get_ID());
        int no = DB.executeUpdate(sql.toString(), trxName);
        return no == 1;
    }

    public DocLine getDocLine(int Record_ID) {
        if (this.p_lines == null || this.p_lines.length == 0 || Record_ID == 0) {
            return null;
        }
        for (int i = 0; i < this.p_lines.length; ++i) {
            if (this.p_lines[i].get_ID() != Record_ID) continue;
            return this.p_lines[i];
        }
        return null;
    }

    public String toString() {
        return this.p_po.toString();
    }

    public int getAD_Client_ID() {
        return this.p_po.getAD_Client_ID();
    }

    public int getAD_Org_ID() {
        return this.p_po.getAD_Org_ID();
    }

    public String getDocumentNo() {
        if (this.m_DocumentNo != null) {
            return this.m_DocumentNo;
        }
        int index = this.p_po.get_ColumnIndex("DocumentNo");
        if (index == -1) {
            index = this.p_po.get_ColumnIndex("Name");
        }
        if (index == -1) {
            throw new UnsupportedOperationException("No DocumentNo");
        }
        this.m_DocumentNo = (String)this.p_po.get_Value(index);
        return this.m_DocumentNo;
    }

    public String getDescription() {
        if (this.m_Description == null) {
            int index = this.p_po.get_ColumnIndex("Description");
            this.m_Description = index != -1 ? (String)this.p_po.get_Value(index) : "";
        }
        return this.m_Description;
    }

    public int getC_Currency_ID() {
        if (this.m_C_Currency_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_Currency_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_Currency_ID = ii;
            }
            if (this.m_C_Currency_ID == -1) {
                this.m_C_Currency_ID = -2;
            }
        }
        return this.m_C_Currency_ID;
    }

    public void setC_Currency_ID(int C_Currency_ID) {
        this.m_C_Currency_ID = C_Currency_ID;
    }

    public boolean isMultiCurrency() {
        return this.m_MultiCurrency;
    }

    public void setIsMultiCurrency(boolean mc) {
        this.m_MultiCurrency = mc;
    }

    public boolean isTaxIncluded() {
        return this.m_TaxIncluded;
    }

    public void setIsTaxIncluded(boolean ti) {
        this.m_TaxIncluded = ti;
    }

    public int getC_ConversionType_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ConversionType_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getGL_Category_ID() {
        return this.m_GL_Category_ID;
    }

    public int getGL_Budget_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("GL_Budget_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public Timestamp getDateAcct() {
        if (this.m_DateAcct != null) {
            return this.m_DateAcct;
        }
        int index = this.p_po.get_ColumnIndex("DateAcct");
        if (index != -1) {
            this.m_DateAcct = (Timestamp)this.p_po.get_Value(index);
            if (this.m_DateAcct != null) {
                return this.m_DateAcct;
            }
        }
        throw new IllegalStateException("No DateAcct");
    }

    public void setDateAcct(Timestamp da) {
        this.m_DateAcct = da;
    }

    public Timestamp getDateDoc() {
        if (this.m_DateDoc != null) {
            return this.m_DateDoc;
        }
        int index = this.p_po.get_ColumnIndex("DateDoc");
        if (index == -1) {
            index = this.p_po.get_ColumnIndex("MovementDate");
        }
        if (index != -1) {
            this.m_DateDoc = (Timestamp)this.p_po.get_Value(index);
            if (this.m_DateDoc != null) {
                return this.m_DateDoc;
            }
        }
        throw new IllegalStateException("No DateDoc");
    }

    public void setDateDoc(Timestamp dd) {
        this.m_DateDoc = dd;
    }

    public boolean isPosted() {
        int index = this.p_po.get_ColumnIndex("Posted");
        if (index != -1) {
            Object posted = this.p_po.get_Value(index);
            if (posted instanceof Boolean) {
                return (Boolean)posted;
            }
            if (posted instanceof String) {
                return STATUS_Posted.equals(posted);
            }
        }
        throw new IllegalStateException("No Posted");
    }

    public boolean isSOTrx() {
        int index = this.p_po.get_ColumnIndex("IsSOTrx");
        if (index == -1) {
            index = this.p_po.get_ColumnIndex("IsReceipt");
        }
        if (index != -1) {
            Object posted = this.p_po.get_Value(index);
            if (posted instanceof Boolean) {
                return (Boolean)posted;
            }
            if (posted instanceof String) {
                return STATUS_Posted.equals(posted);
            }
        }
        return false;
    }

    public int getC_DocType_ID() {
        int index = this.p_po.get_ColumnIndex("C_DocType_ID");
        if (index != -1) {
            Integer ii = (Integer)this.p_po.get_Value(index);
            if (ii != null && ii == 0 && (index = this.p_po.get_ColumnIndex("C_DocTypeTarget_ID")) != -1) {
                ii = (Integer)this.p_po.get_Value(index);
            }
            if (ii != null) {
                return ii;
            }
        }
        return 0;
    }

    public int getC_Charge_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Charge_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getSalesRep_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("SalesRep_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_BankAccount_ID() {
        if (this.m_C_BankAccount_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_BankAccount_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_BankAccount_ID = ii;
            }
            if (this.m_C_BankAccount_ID == -1) {
                this.m_C_BankAccount_ID = 0;
            }
        }
        return this.m_C_BankAccount_ID;
    }

    public void setC_BankAccount_ID(int C_BankAccount_ID) {
        this.m_C_BankAccount_ID = C_BankAccount_ID;
    }

    public int getC_CashBook_ID() {
        if (this.m_C_CashBook_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_CashBook_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_CashBook_ID = ii;
            }
            if (this.m_C_CashBook_ID == -1) {
                this.m_C_CashBook_ID = 0;
            }
        }
        return this.m_C_CashBook_ID;
    }

    public void setC_CashBook_ID(int C_CashBook_ID) {
        this.m_C_CashBook_ID = C_CashBook_ID;
    }

    public int getM_Warehouse_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_Warehouse_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_BPartner_ID() {
        if (this.m_C_BPartner_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_BPartner_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_BPartner_ID = ii;
            }
            if (this.m_C_BPartner_ID == -1) {
                this.m_C_BPartner_ID = 0;
            }
        }
        return this.m_C_BPartner_ID;
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        this.m_C_BPartner_ID = C_BPartner_ID;
    }

    public int getC_BPartner_Location_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_BPartner_Location_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_Project_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Project_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_ProjectPhase_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ProjectPhase_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_ProjectTask_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ProjectTask_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_SalesRegion_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_SalesRegion_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getBP_C_SalesRegion_ID() {
        if (this.m_BP_C_SalesRegion_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_SalesRegion_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_BP_C_SalesRegion_ID = ii;
            }
            if (this.m_BP_C_SalesRegion_ID == -1) {
                this.m_BP_C_SalesRegion_ID = 0;
            }
        }
        return this.m_BP_C_SalesRegion_ID;
    }

    public void setBP_C_SalesRegion_ID(int C_SalesRegion_ID) {
        this.m_BP_C_SalesRegion_ID = C_SalesRegion_ID;
    }

    public int getC_Activity_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Activity_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_Campaign_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Campaign_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getM_Product_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_Product_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getAD_OrgTrx_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("AD_OrgTrx_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_LocFrom_ID() {
        return this.m_C_LocFrom_ID;
    }

    public void setC_LocFrom_ID(int C_LocFrom_ID) {
        this.m_C_LocFrom_ID = C_LocFrom_ID;
    }

    public int getC_LocTo_ID() {
        return this.m_C_LocTo_ID;
    }

    public void setC_LocTo_ID(int C_LocTo_ID) {
        this.m_C_LocTo_ID = C_LocTo_ID;
    }

    public int getUser1_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User1_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUser2_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User2_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUser3_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User3_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUser4_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User4_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUserElement1_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("UserElement1_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUserElement2_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("UserElement2_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getValue(String ColumnName) {
        Integer ii;
        int index = this.p_po.get_ColumnIndex(ColumnName);
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    protected abstract String loadDocumentDetails();

    public abstract BigDecimal getBalance();

    public abstract ArrayList<Fact> createFacts(MAcctSchema var1);

    public ArrayList<Fact> getFacts() {
        return this.m_fact;
    }

    public static int[] getDocumentsTableID() {
        Doc.fillDocumentsTableArrays();
        return documentsTableID;
    }

    public static String[] getDocumentsTableName() {
        Doc.fillDocumentsTableArrays();
        return documentsTableName;
    }

    private static void fillDocumentsTableArrays() {
        block6: {
            if (documentsTableID != null) break block6;
            String sql = "SELECT t.AD_Table_ID, t.TableName FROM AD_Table t, AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND IsView='N' ORDER BY t.AD_Table_ID";
            ArrayList<Integer> tableIDs = new ArrayList<Integer>();
            ArrayList<String> tableNames = new ArrayList<String>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    tableIDs.add(rs.getInt(1));
                    tableNames.add(rs.getString(2));
                }
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            documentsTableID = new int[tableIDs.size()];
            documentsTableName = new String[tableIDs.size()];
            for (int i = 0; i < documentsTableID.length; ++i) {
                Doc.documentsTableID[i] = (Integer)tableIDs.get(i);
                Doc.documentsTableName[i] = (String)tableNames.get(i);
            }
        }
    }

    public String getDocStatus() {
        if (this.m_DocStatus != null) {
            return this.m_DocStatus;
        }
        int index = this.p_po.get_ColumnIndex("DocStatus");
        if (index != -1) {
            this.m_DocStatus = (String)this.p_po.get_Value(index);
        }
        return this.m_DocStatus;
    }

    public int getReversalId() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("Reversal_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public Boolean isReversed() {
        if (this.getReversalId() > 0) {
            return true;
        }
        return false;
    }

    public Boolean IsReverseGenerated() {
        return this.getReversalId() < this.getPO().get_ID();
    }

    public Boolean isReverseWithOriginalAccounting() {
        String isReverseWithOriginalAccounting = DB.getSQLValueString(this.getPO().get_TrxName(), "SELECT IsReversedWithOriginalAcct FROM C_DocType WHERE C_DocType_ID=?", this.getC_DocType_ID());
        if (isReverseWithOriginalAccounting != null && STATUS_Posted.equals(isReverseWithOriginalAccounting)) {
            return true;
        }
        return false;
    }

    private String generateReverseWithOriginalAccounting(MAcctSchema originalAccountSchema) {
        this.getReversalFactAcct(originalAccountSchema).stream().forEach(factAcct -> {
            MFactAcct reverseFactAcct = new MFactAcct(this.getPO().getCtx(), 0, this.getPO().get_TrxName());
            PO.copyValues(factAcct, reverseFactAcct);
            reverseFactAcct.setAD_Org_ID(factAcct.getAD_Org_ID());
            reverseFactAcct.setAD_Table_ID(this.getPO().get_Table_ID());
            reverseFactAcct.setDateAcct(this.getDateAcct());
            reverseFactAcct.setC_Period_ID(this.getC_Period_ID());
            reverseFactAcct.setRecord_ID(this.getPO().get_ID());
            reverseFactAcct.setQty(factAcct.getQty().negate());
            FactLine.setSourceAmount(originalAccountSchema, reverseFactAcct, factAcct.getAmtSourceDr().negate(), factAcct.getAmtSourceCr().negate());
            FactLine.setAccountingAmount(originalAccountSchema, reverseFactAcct, factAcct.getAmtAcctDr().negate(), factAcct.getAmtAcctCr().negate());
            reverseFactAcct.saveEx();
        });
        return STATUS_Posted;
    }

    private List<MFactAcct> getReversalFactAcct(MAcctSchema originalAccountSchema) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AD_Table_ID").append("=? AND ");
        whereClause.append("Record_ID").append("=? AND ");
        whereClause.append("C_AcctSchema_ID").append("=?");
        return new Query(this.getCtx(), "Fact_Acct", whereClause.toString(), this.getPO().get_TrxName()).setClient_ID().setParameters(this.getPO().get_Table_ID(), this.getReversalId(), originalAccountSchema.getC_AcctSchema_ID()).setOrderBy("Fact_Acct_ID").list();
    }
}

