/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProject;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class ProjectCreateAsset
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_Product_ID = 0;
    private int m_UseLifeYears = 0;
    private Timestamp m_DateTrx = null;
    private String message = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (processInfoParameterArray[i].getParameterName().equalsIgnoreCase("C_Project_ID")) {
                this.m_C_Project_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (processInfoParameterArray[i].getParameterName().equalsIgnoreCase("M_Product_ID")) {
                this.m_Product_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (processInfoParameterArray[i].getParameterName().equalsIgnoreCase("UseLifeYears")) {
                this.m_UseLifeYears = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (processInfoParameterArray[i].getParameterName().equalsIgnoreCase("DateTrx")) {
                this.m_DateTrx = (Timestamp)processInfoParameterArray[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_C_Project_ID == 0) {
            return "Missing Mandatory Field Value (Project)";
        }
        MProject mProject = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        this.log.info("doIt - " + mProject);
        if (!"A".equals(mProject.getProjectCategory())) {
            return "Project is not asset type";
        }
        MProduct mProduct = new MProduct(this.getCtx(), this.m_Product_ID, this.get_TrxName());
        MProductCategory mProductCategory = MProductCategory.get(this.getCtx(), mProduct.getM_Product_Category_ID());
        if (mProductCategory.getA_Asset_Group_ID() == 0) {
            return "Product is not asset type";
        }
        MAssetAddition mAssetAddition = MAssetAddition.createAsset(mProject, mProduct);
        mAssetAddition.setDateAcct(this.m_DateTrx);
        mAssetAddition.setDateDoc(this.m_DateTrx);
        mAssetAddition.setM_Product_ID(this.m_Product_ID);
        if (this.m_UseLifeYears > 0) {
            mAssetAddition.setDeltaUseLifeYears(this.m_UseLifeYears);
            mAssetAddition.setDeltaUseLifeYears_F(this.m_UseLifeYears);
        }
        mAssetAddition.saveEx();
        if (!mAssetAddition.processIt("CO")) {
            return "Error Process Asset Addition";
        }
        mAssetAddition.saveEx();
        this.message = this.message + ". @A_Asset_Addition_ID@ - " + mAssetAddition;
        return "Asset Created " + this.message;
    }
}

