/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util.rpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.exp.WrapperUtil;
import org.adempiere.util.rpl.EntityWrapper;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MImage;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class EntityWrapperFactory {
    private static CLogger log = CLogger.getCLogger(EntityWrapperFactory.class);
    private PO entity;
    private MClient client;
    private MEXPFormat exportFormat;
    private Integer replicationMode;
    private String replicationType;
    private Integer replicationEvent;
    private EntityWrapper wrapper;
    private String transactionName;
    private Properties context;
    private String docAction;
    private String docStatus;
    private Map<MEXPFormat, EntityWrapper> embeddedFormats = new HashMap<MEXPFormat, EntityWrapper>();
    private static EntityWrapperFactory instance;

    public static EntityWrapperFactory create() {
        if (instance == null) {
            instance = new EntityWrapperFactory();
        }
        instance.wipeValues();
        return instance;
    }

    private Properties getContext() {
        return this.context;
    }

    private String getTransactionName() {
        return this.transactionName;
    }

    private void wipeValues() {
        this.entity = null;
        this.wrapper = null;
        this.exportFormat = null;
        this.replicationMode = null;
        this.replicationType = null;
        this.replicationEvent = null;
    }

    public final PO getEntity() {
        return this.entity;
    }

    public final EntityWrapperFactory withEntity(PO entity) {
        if (entity == null) {
            throw new AdempiereException("@Entity@ @NotFound@");
        }
        this.entity = entity;
        this.context = entity.getCtx();
        this.transactionName = entity.get_TrxName();
        return this;
    }

    public final MEXPFormat getExportFormat() {
        return this.exportFormat;
    }

    public final EntityWrapperFactory withExportFormat(MEXPFormat exportFormat) {
        this.exportFormat = exportFormat;
        return this;
    }

    public final Integer getReplicationMode() {
        return this.replicationMode;
    }

    public final EntityWrapperFactory withReplicationMode(Integer replicationMode) {
        this.replicationMode = replicationMode;
        return this;
    }

    public final String getReplicationType() {
        return this.replicationType;
    }

    public final EntityWrapperFactory withReplicationType(String replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public final Integer getReplicationEvent() {
        return this.replicationEvent;
    }

    public final EntityWrapperFactory withReplicationEvent(Integer replicationEvent) {
        this.replicationEvent = replicationEvent;
        return this;
    }

    public final EntityWrapper getWrapper() {
        return this.wrapper;
    }

    public final EntityWrapperFactory withWrapper(EntityWrapper wrapper) {
        if (wrapper == null) {
            throw new AdempiereException("@Wrapper@ @NotFound@");
        }
        this.wrapper = wrapper;
        this.withReplicationEvent(wrapper.getReplicationEvent());
        this.withReplicationMode(wrapper.getReplicationMode());
        this.withReplicationType(wrapper.getReplicationType());
        this.context = wrapper.getContext();
        this.transactionName = wrapper.getTransactionName();
        return this;
    }

    public final MClient getClient() {
        return this.client;
    }

    public final EntityWrapperFactory withClient(MClient client) {
        this.client = client;
        return this;
    }

    public EntityWrapper buildWrapper() {
        if (this.client == null) {
            throw new AdempiereException("@AD_Client_ID@ @NotFound@");
        }
        if (this.exportFormat == null || this.exportFormat.getEXP_Format_ID() == 0) {
            throw new AdempiereException("@EXP_Format_ID@ @NotFound@");
        }
        if (this.entity == null || this.entity.get_ID() == 0 || Util.isEmpty(this.entity.get_UUID())) {
            throw new AdempiereException("@Entity@ @NotFound@");
        }
        this.wrapper = this.createWrapper(this.exportFormat, this.entity);
        this.wrapper.setAttributes(this.exportFormat, this.client, this.replicationMode, this.replicationType, this.replicationEvent);
        return this.getWrapper();
    }

    public EntityWrapperFactory buildEntity() {
        if (this.client == null) {
            throw new AdempiereException("@AD_Client_ID@ @NotFound@");
        }
        if (this.exportFormat == null || this.exportFormat.getEXP_Format_ID() == 0) {
            throw new AdempiereException("@EXP_Format_ID@ @NotFound@");
        }
        if (this.wrapper == null || Util.isEmpty(this.wrapper.getUuid())) {
            throw new AdempiereException("@Wrapper0@ @NotFound@");
        }
        this.entity = this.buildEntity(this.exportFormat, this.wrapper, this.getTransactionName());
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntityWrapperFactory saveEntity() {
        if (3 == this.replicationEvent || 9 == this.replicationEvent || 3 == this.replicationEvent) {
            // empty if block
        }
        if (this.getEntity() == null) {
            return this;
        }
        if (!this.entity.is_Changed() && !(this.entity instanceof DocAction)) {
            log.info("Object not changed = " + this.entity.toString());
            return this;
        }
        Env.setContext(this.entity.getCtx(), "#AD_Client_ID", this.entity.getAD_Client_ID());
        if (0 == this.replicationMode) {
            if (3 == this.replicationEvent || 9 == this.replicationEvent || 3 == this.replicationEvent) {
                this.entity.deleteEx(true);
                return this;
            }
            if ("B".equals(this.replicationType)) {
                MReplicationStrategy rplStrategy = new MReplicationStrategy(this.client.getCtx(), this.client.getAD_ReplicationStrategy_ID(), this.entity.get_TrxName());
                WrapperUtil.exportRecord(this.entity, this.client, 0, "M", 5, rplStrategy, this.exportFormat);
                this.entity.saveReplica(true);
                return this;
            }
            if (!"M".equals(this.replicationType) && !"R".equals(this.replicationType)) {
                if (!"L".equals(this.replicationType)) throw new AdempiereException("@EXPReplicationTypeNonValidType@");
                return this;
            }
            this.entity.saveReplica(true);
            return this;
        }
        if (1 != this.replicationMode) return this;
        if (!"M".equals(this.replicationType)) return this;
        if (!(this.entity instanceof DocAction)) return this;
        DocAction document = (DocAction)((Object)this.entity);
        this.entity.set_ValueOfColumn("DocAction", (Object)this.docStatus);
        this.entity.set_ValueOfColumn("DocStatus", (Object)"DR");
        this.entity.set_ValueOfColumn("Processing", (Object)false);
        this.entity.set_ValueOfColumn("Processed", (Object)false);
        if (13 == this.replicationEvent && this.docStatus.equals("RE") && this.docAction.equals("--")) {
            this.entity.saveEx();
            return this;
        }
        if ((this.docAction.equals("PR") || this.docAction.equals("CO")) && !this.docStatus.equals("CO") && !this.docStatus.equals("CL") && !this.docStatus.equals("VO") && !this.docStatus.equals("RE") || this.docAction.equals("CL") && this.docStatus.equals("CO") && !this.docStatus.equals("VO") && !this.docStatus.equals("RE")) {
            try {
                if (!document.processIt(this.docAction)) {
                    log.info("PO.toString() = can not " + this.entity.get_Value("DocAction"));
                }
                this.entity.saveEx();
                if (this.embeddedFormats.isEmpty()) return this;
                this.embeddedFormats.entrySet().stream().forEach(embedded -> {
                    PO embeddedEntity = this.buildEntity((MEXPFormat)embedded.getKey(), (EntityWrapper)embedded.getValue(), this.getTransactionName());
                    embeddedEntity.saveReplica(true);
                });
                return this;
            }
            catch (Exception e) {
                throw new AdempiereException(e.getLocalizedMessage());
            }
        }
        this.entity.saveEx();
        return this;
    }

    private PO findEntityFromWrapper(MEXPFormat exportFormat, EntityWrapper wrapper) {
        List values = null;
        log.info("expFormat = " + exportFormat);
        try {
            Collection<MEXPFormatLine> uniqueFormatLines = exportFormat.getUniqueColumns();
            if (uniqueFormatLines == null || uniqueFormatLines.size() < 1) {
                throw new AdempiereException("@EXPFormatLineNoUniqueColumns@");
            }
            AtomicInteger replicationId = new AtomicInteger(0);
            ArrayList<Object> parameters = new ArrayList<Object>();
            StringBuffer whereClause = new StringBuffer("");
            uniqueFormatLines.forEach(uniqueFormatLine -> {
                MColumn column = MColumn.get(this.getContext(), uniqueFormatLine.getAD_Column_ID());
                log.info("UNIQUE column = [" + column.getAD_Table().getTableName() + "." + column.getColumnName() + "]");
                String columnName = column.getColumnName();
                String key = uniqueFormatLine.getValue();
                String type = uniqueFormatLine.getType();
                Object value = null;
                if ("E".equals(type) || "A".equals(type)) {
                    value = wrapper.getValueAsObject(key);
                    log.info("value=" + value);
                } else if ("R".equals(type)) {
                    log.info("referencedExpFormat.EXP_EmbeddedFormat_ID = " + uniqueFormatLine.getEXP_EmbeddedFormat_ID());
                    MEXPFormat referencedExpFormat = MEXPFormat.get(this.getContext(), uniqueFormatLine.getEXP_EmbeddedFormat_ID(), this.getTransactionName());
                    log.info("referencedExpFormat = " + referencedExpFormat);
                    EntityWrapper referencedWrapper = wrapper.getReference(key);
                    if (referencedWrapper == null) {
                        throw new AdempiereException("@ReferencedRecordNotFound@");
                    }
                    PO childEntity = this.findEntityFromWrapper(referencedExpFormat, referencedWrapper);
                    boolean createNonExistingRecords = uniqueFormatLine.isCreateNonExisting();
                    if (createNonExistingRecords && (childEntity == null || childEntity.get_ID() <= 0)) {
                        PO entityToCreate = this.buildEntity(referencedExpFormat, referencedWrapper, this.getTransactionName());
                        log.info("Embeded - entityToCreate = " + entityToCreate);
                        if (!entityToCreate.is_Changed()) {
                            log.info("Object not changed = " + entityToCreate.toString());
                        } else {
                            entityToCreate.saveReplica(true);
                        }
                    }
                    value = childEntity.get_ID();
                } else {
                    throw new AdempiereException("@EXPFormatLineNonValidType@");
                }
                if (!Optional.ofNullable(value).isPresent()) {
                    if (DisplayType.isID(column.getAD_Reference_ID()) || 11 == column.getAD_Reference_ID()) {
                        if (wrapper.getValueAsInt(key) > 0) {
                            if (13 == column.getAD_Reference_ID()) {
                                replicationId.set(wrapper.getValueAsInt(key));
                            }
                        } else {
                            value = null;
                        }
                    } else if (value == null) {
                        value = wrapper.getValueAsObject(key);
                    }
                }
                if (parameters.size() == 0) {
                    whereClause.append(" ").append(columnName).append(" = ? ");
                } else {
                    whereClause.append(" AND ").append(columnName).append(" = ? ");
                }
                parameters.add(value);
            });
            values = new Query(this.getContext(), MTable.get(this.getContext(), exportFormat.getAD_Table_ID()), whereClause.toString(), this.getTransactionName()).setParameters(parameters).list();
            if (values.size() > 1) {
                throw new AdempiereException("@EXPFormatLineNoUniqueColumns@ : " + exportFormat.getName());
            }
            if (values.size() <= 0) {
                PO po = MTable.get(this.getContext(), exportFormat.getAD_Table_ID()).getPO(0, this.getTransactionName());
                if (replicationId.get() > 0) {
                    po.set_CustomColumn(po.get_KeyColumns()[0], replicationId.get());
                }
                return po;
            }
            return (PO)values.get(0);
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }

    private PO buildEntity(MEXPFormat expFormat, EntityWrapper wrapper, String trxName) {
        PO entity = this.findEntityFromWrapper(expFormat, wrapper);
        if (entity == null) {
            throw new AdempiereException("@UnableToLoadEntity@");
        }
        if ("R".equals(this.replicationType) && entity.get_ID() == 0) {
            return null;
        }
        log.info("PO.toString() = " + entity.toString());
        if (entity.get_KeyColumns().length < 1) {
            throw new AdempiereException("@EDIMultiColumnNotSupported@");
        }
        List<MEXPFormatLine> formatLines = expFormat.getFormatLinesOrderedBy("IsMandatory , Position");
        if (formatLines == null || formatLines.size() < 1) {
            throw new AdempiereException("@EXPFormatNoLines@");
        }
        for (MEXPFormatLine formatLine : formatLines) {
            log.info("=================== Beginnig of Format Line ===============================");
            log.info("formatLine: [" + formatLine.toString() + "]");
            this.setReplicaValues(formatLine, wrapper, entity);
        }
        return entity;
    }

    private void setReplicaValues(MEXPFormatLine formatLine, EntityWrapper wrapper, PO entity) {
        Object value = this.getValueFromFormat(formatLine, entity, wrapper);
        if (value == null) {
            return;
        }
        MColumn column = MColumn.get(this.getContext(), formatLine.getAD_Column_ID());
        log.info("column=[" + column + "]");
        if (value != null && !"M".equals(formatLine.getType())) {
            Class clazz = DisplayType.getClass(column.getAD_Reference_ID(), true);
            if (column.getColumnName().equalsIgnoreCase("Posted") || column.getColumnName().equalsIgnoreCase("Processed") || column.getColumnName().equalsIgnoreCase("Processing")) {
                clazz = Boolean.class;
            } else if (column.getColumnName().equalsIgnoreCase("Record_ID")) {
                clazz = Integer.class;
            } else if (column.getColumnName().equalsIgnoreCase("AD_Language") || column.getColumnName().equalsIgnoreCase("EntityType")) {
                clazz = String.class;
            }
            log.info("clazz = " + clazz.getName());
            log.info("formatLinesType = " + formatLine.getType());
            if ("M".equals(formatLine.getType())) {
                throw new AdempiereException("@WeCantBeHere@");
            }
            if (16 == column.getAD_Reference_ID() || 15 == column.getAD_Reference_ID()) {
                entity.set_ValueOfColumn(formatLine.getAD_Column_ID(), (Object)wrapper.getValueAsTimestamp(formatLine.getValue()));
                log.info("Set value of column [" + column.getColumnName() + "]=[" + value + "]");
            } else if (DisplayType.isID(column.getAD_Reference_ID()) || 11 == column.getAD_Reference_ID()) {
                if (!Util.isEmpty(value.toString())) {
                    int intValue = Integer.parseInt(value.toString());
                    value = new Integer(intValue);
                } else {
                    value = null;
                }
                log.info("About to set int value of column [" + column.getColumnName() + "]=[" + value + "]");
                entity.set_ValueOfColumn(formatLine.getAD_Column_ID(), value);
                log.info("Set int value of column [" + column.getColumnName() + "]=[" + value + "]");
            } else if (DisplayType.isNumeric(column.getAD_Reference_ID()) && column.getAD_Reference_ID() != 11) {
                value = !Util.isEmpty(value.toString()) ? new BigDecimal(value.toString()) : null;
                log.info("About to set BigDecimal value of column [" + column.getColumnName() + "]=[" + value + "]");
                entity.set_ValueOfColumn(formatLine.getAD_Column_ID(), value);
                log.info("Set BigDecimal value of column [" + column.getColumnName() + "]=[" + value + "]");
            } else if (20 == column.getAD_Reference_ID()) {
                if (clazz == Boolean.class) {
                    String v = value.toString().equals("true") ? "Y" : "N";
                    entity.set_ValueOfColumn(formatLine.getAD_Column_ID(), (Object)v);
                }
            } else {
                try {
                    log.info("About to set value of column [" + column.getColumnName() + "]=[" + value + "]");
                    if (clazz == Boolean.class) {
                        String v = value.toString().equals("true") ? "Y" : "N";
                        entity.set_ValueOfColumn(formatLine.getAD_Column_ID(), (Object)v);
                    } else {
                        entity.set_ValueOfColumn(formatLine.getAD_Column_ID(), clazz.cast(value));
                    }
                    log.info("Set value of column [" + column.getColumnName() + "]=[" + value + "]");
                }
                catch (ClassCastException ex) {
                    ex.printStackTrace();
                    throw new AdempiereException(ex);
                }
            }
        }
    }

    private Object getValueFromFormat(MEXPFormatLine line, PO entity, EntityWrapper wrapper) {
        Object value = null;
        String key = line.getValue();
        String type = line.getType();
        Boolean saveAfterProcess = line.isSaveAfterProcess();
        if ("E".equals(type) || "A".equals(type)) {
            value = wrapper.getValueAsObject(key);
            log.info("value=[" + value + "]");
        } else if ("R".equals(type)) {
            MEXPFormat referencedExpFormat = MEXPFormat.get(this.getContext(), line.getEXP_EmbeddedFormat_ID(), this.getTransactionName());
            log.info("referencedExpFormat = " + referencedExpFormat);
            log.info("Seach for XML Element = " + key);
            EntityWrapper referencedWrapper = wrapper.getReference(key);
            log.info("referencedNode = " + referencedWrapper);
            if (referencedWrapper != null) {
                PO embeddedEntity = this.findEntityFromWrapper(referencedExpFormat, referencedWrapper);
                if (embeddedEntity != null && embeddedEntity.get_ID() > 0) {
                    value = embeddedEntity.get_ID();
                }
                log.info("referenced Record_ID = " + value);
            } else {
                log.info("NULL VALUE FOR " + key);
                value = null;
            }
            log.info("value=[" + value + "]");
        } else if ("M".equals(line.getType())) {
            List<EntityWrapper> embeddedList;
            if (entity.is_Changed()) {
                if (entity instanceof DocAction) {
                    this.docAction = ((DocAction)((Object)entity)).getDocAction();
                    this.docStatus = ((DocAction)((Object)entity)).getDocStatus();
                    entity.set_ValueOfColumn("DocStatus", (Object)"DR");
                    entity.set_ValueOfColumn("DocAction", (Object)"CO");
                    entity.set_ValueOfColumn("Processing", (Object)false);
                    entity.set_ValueOfColumn("Processed", (Object)false);
                }
                entity.saveReplica(true);
            }
            MEXPFormat referencedExpFormat = MEXPFormat.get(this.getContext(), line.getEXP_EmbeddedFormat_ID(), this.getTransactionName());
            log.info("embeddedExpFormat = " + referencedExpFormat);
            if (!referencedExpFormat.getAD_Table().isView() && (embeddedList = wrapper.getChildren(key)) != null) {
                embeddedList.forEach(embeddedWrapper -> {
                    if (!saveAfterProcess.booleanValue()) {
                        PO embeddedEntity = this.buildEntity(referencedExpFormat, (EntityWrapper)embeddedWrapper, this.getTransactionName());
                        log.info("embeddedPo = " + embeddedEntity);
                        if (!embeddedEntity.is_Changed()) {
                            log.info("Object not changed = " + entity.toString());
                        } else {
                            embeddedEntity.saveReplica(true);
                        }
                    } else {
                        this.embeddedFormats.put(referencedExpFormat, (EntityWrapper)embeddedWrapper);
                    }
                });
            }
        } else {
            throw new AdempiereException("@EXPFormatLineNonValidType@");
        }
        return value;
    }

    private EntityWrapper createWrapper(MEXPFormat exportFormat, PO entity) {
        EntityWrapper wrapperToCreate = new EntityWrapper();
        wrapperToCreate.setTableName(entity.get_TableName());
        exportFormat.getFormatLines().forEach(exportFormatLine -> this.createWrapperFromLine((MEXPFormatLine)exportFormatLine, entity, wrapperToCreate));
        return wrapperToCreate;
    }

    private void createWrapperFromLine(MEXPFormatLine exportFormatLine, PO entity, EntityWrapper wrapper) {
        if (exportFormatLine.getType().equals("E") || exportFormatLine.getType().equals("A")) {
            Object value;
            log.info("Format Line Search key: " + exportFormatLine.getValue());
            if (exportFormatLine.getAD_Column_ID() == 0) {
                throw new AdempiereException(Msg.getMsg(entity.getCtx(), "EXPColumnMandatory"));
            }
            MColumn column = MColumn.get(entity.getCtx(), exportFormatLine.getAD_Column_ID());
            if (column == null) {
                throw new AdempiereException(Msg.getMsg(entity.getCtx(), "EXPColumnMandatory"));
            }
            if (column.isVirtualColumn()) {
                log.info("This is Virtual Column!");
            }
            if ((value = entity.get_Value(column.getColumnName())) == null && exportFormatLine.getType().equals("A") && exportFormatLine.isMandatory()) {
                throw new AdempiereException(Msg.getMsg(entity.getCtx(), "EXPFieldMandatory"));
            }
            if (column.getAD_Reference_ID() == 32 && exportFormatLine.getType().equals("E")) {
                int imageId = (Integer)value;
                MImage image = new MImage(entity.getCtx(), imageId, null);
                if (image.getAD_Image_ID() > 0) {
                    EntityWrapper childElement = new EntityWrapper();
                    childElement.setTableName("AD_Image");
                    childElement.setId(imageId);
                    childElement.setUuid(image.getUUID());
                    childElement.setValue("Name", image.getName());
                    if (!Util.isEmpty(image.getDescription())) {
                        childElement.setValue("Description", image.getDescription());
                    }
                    if (!Util.isEmpty(image.getImageURL())) {
                        childElement.setValue("ImageURL", image.getImageURL());
                    }
                    if (image.getBinaryData() != null && image.getBinaryData().length > 0) {
                        childElement.setValue("BinaryData", image.getBinaryData());
                    }
                }
            } else {
                wrapper.setValue(column.getColumnName(), entity.get_Value(column.getColumnName()));
            }
        } else if (exportFormatLine.getType().equals("M")) {
            MEXPFormat embeddedFormat = MEXPFormat.get(entity.getCtx(), exportFormatLine.getEXP_EmbeddedFormat_ID(), this.getTransactionName());
            MTable tableEmbedded = MTable.get(entity.getCtx(), embeddedFormat.getAD_Table_ID());
            log.info("Table Embedded = " + tableEmbedded);
            StringBuffer whereClause = new StringBuffer(entity.get_KeyColumns()[0] + "=?");
            if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                whereClause.append(" AND ").append(embeddedFormat.getWhereClause());
            }
            new Query(entity.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), this.getTransactionName()).setApplyAccessFilter(true).setParameters(entity.get_ID()).list().forEach(embeddedEntity -> {
                EntityWrapper child = this.createWrapper(embeddedFormat, (PO)embeddedEntity);
                wrapper.addChild(exportFormatLine.getValue(), child);
            });
        } else if (exportFormatLine.getType().equals("R")) {
            MColumn column;
            int embeddedFormatId = exportFormatLine.getEXP_EmbeddedFormat_ID();
            MEXPFormat referencedFormat = MEXPFormat.get(entity.getCtx(), embeddedFormatId, this.getTransactionName());
            MTable tableEmbedded = MTable.get(entity.getCtx(), referencedFormat.getAD_Table_ID());
            log.info("Table Embedded = " + tableEmbedded);
            StringBuffer whereClause = new StringBuffer(tableEmbedded.getTableName() + "_ID =?");
            if (referencedFormat.getWhereClause() != null & !"".equals(referencedFormat.getWhereClause())) {
                whereClause.append(" AND ").append(referencedFormat.getWhereClause());
            }
            String columnName = "";
            columnName = exportFormatLine.getAD_Column_ID() != 0 ? ((column = MColumn.get(entity.getCtx(), exportFormatLine.getAD_Column_ID())).getAD_Reference_ID() == 18 || column.getAD_Reference_ID() == 30 ? column.getColumnName() : tableEmbedded.getTableName() + "_ID") : tableEmbedded.getTableName() + "_ID";
            Object value = entity.get_Value(columnName);
            if (value != null) {
                List instances = null;
                MTable tableForGet = MTable.get(this.getContext(), tableEmbedded.getTableName());
                if (tableForGet.getAccessLevel().equals("7") || tableForGet.getAccessLevel().equals("6")) {
                    instances = new Query(entity.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), this.getTransactionName()).setParameters(value).list();
                    List tenantSpecificInstances = new Query(entity.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), this.getTransactionName()).setApplyAccessFilter(true).setParameters(value).list();
                    instances.addAll(tenantSpecificInstances);
                } else {
                    instances = new Query(entity.getCtx(), tableEmbedded.getTableName(), whereClause.toString(), this.getTransactionName()).setApplyAccessFilter(true).setParameters(value).list();
                }
                if (instances.size() > 0) {
                    EntityWrapper reference = this.createWrapper(referencedFormat, (PO)instances.stream().findFirst().get());
                    wrapper.setReference(exportFormatLine.getValue(), reference);
                }
            }
        } else {
            throw new AdempiereException(Msg.getMsg(entity.getCtx(), "EXPUnknownLineType"));
        }
    }
}

