/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util.rpl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MEXPFormat;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class EntityWrapper {
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final String ID_KEY = "Record_ID";
    public static final String UUID_KEY = "UUID";
    public static final String TABLE_NAME_KEY = "TableName";
    public static final String CLIENT_VALUE_KEY = "AD_Client_Value";
    public static final String CLIENT_UUID_KEY = "AD_Client_UUID";
    public static final String EXPORT_FORMAT_VALUE_KEY = "EXP_Format_Value";
    public static final String EXPORT_FORMAT_UUID_KEY = "EXP_Format_UUID";
    public static final String EXPORT_FORMAT_DESCRIPTION_KEY = "EXP_Format_Description";
    public static final String EXPORT_FORMAT_VERSION_KEY = "Version";
    public static final String REPLICATION_MODE_KEY = "ReplicationMode";
    public static final String REPLICATION_EVENT_KEY = "ReplicationEvent";
    public static final String REPLICATION_TYPE_KEY = "ReplicationType";
    private String transactionName;
    private Properties context;
    private Map<String, Boolean> tablesMap = new HashMap<String, Boolean>();

    public void setAttributes(MEXPFormat exportFormat, MClient client, int replicationMode, String replicationType, int replicationEvent) {
        this.setExportFormatAttributes(exportFormat);
        this.setClientAttributes(client);
        this.setReplicationMode(replicationMode);
        this.setReplicationType(replicationType);
        this.setReplicationEvent(replicationEvent);
    }

    public void setClientAttributes(MClient client) {
        this.setValue(CLIENT_VALUE_KEY, client.getValue());
        this.setValue(CLIENT_UUID_KEY, client.getUUID());
    }

    public void setExportFormatAttributes(MEXPFormat exportFormat) {
        this.setValue(EXPORT_FORMAT_VALUE_KEY, exportFormat.getValue());
        this.setValue(EXPORT_FORMAT_UUID_KEY, exportFormat.getUUID());
        if (!Util.isEmpty(exportFormat.getDescription())) {
            this.setValue(EXPORT_FORMAT_DESCRIPTION_KEY, exportFormat.getDescription());
        }
        this.setValue(EXPORT_FORMAT_VERSION_KEY, exportFormat.getVersion());
    }

    public String getExportFormatValue() {
        return this.getValueAsString(EXPORT_FORMAT_VALUE_KEY);
    }

    public String getExportFormatUuid() {
        return this.getValueAsString(EXPORT_FORMAT_UUID_KEY);
    }

    public String getExportFormatDescription() {
        return this.getValueAsString(EXPORT_FORMAT_DESCRIPTION_KEY);
    }

    public String getExportFormatVersion() {
        return this.getValueAsString(EXPORT_FORMAT_VERSION_KEY);
    }

    public String getClientValue() {
        return this.getValueAsString(CLIENT_VALUE_KEY);
    }

    public String getClientUuid() {
        return this.getValueAsString(CLIENT_UUID_KEY);
    }

    public void setReplicationMode(Integer replicationMode) {
        if (replicationMode != null) {
            this.setValue(REPLICATION_MODE_KEY, replicationMode);
        }
    }

    public int getReplicationMode() {
        return this.getValueAsInt(REPLICATION_MODE_KEY);
    }

    public void setReplicationEvent(Integer replicationEvent) {
        if (replicationEvent != null) {
            this.setValue(REPLICATION_EVENT_KEY, replicationEvent);
        }
    }

    public int getReplicationEvent() {
        return this.getValueAsInt(REPLICATION_EVENT_KEY);
    }

    public void setReplicationType(String replicationType) {
        if (replicationType != null) {
            this.setValue(REPLICATION_TYPE_KEY, replicationType);
        }
    }

    public String getReplicationType() {
        return this.getValueAsString(REPLICATION_TYPE_KEY);
    }

    public void addChild(String key, EntityWrapper child) {
        if (Util.isEmpty(child.getTableName())) {
            return;
        }
        List<EntityWrapper> children = null;
        children = this.attributes.containsKey(key) ? this.getChildren(key) : new ArrayList<EntityWrapper>();
        children.add(child);
        this.attributes.put(key, children);
        this.tablesMap.put(child.getTableName(), true);
    }

    public void setReference(String key, EntityWrapper reference) {
        if (Util.isEmpty(reference.getTableName())) {
            return;
        }
        this.attributes.put(key, reference);
        this.tablesMap.put(reference.getTableName(), true);
    }

    public EntityWrapper getReference(String key) {
        Object value = this.attributes.get(key);
        if (EntityWrapper.class.isAssignableFrom(value.getClass())) {
            return (EntityWrapper)value;
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            EntityWrapper wrapper = new EntityWrapper();
            wrapper.setMap((Map)value);
            return wrapper;
        }
        return null;
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> onlyValuesMap = new HashMap<String, Object>();
        this.attributes.entrySet().forEach(set -> {
            Object convertedValue = null;
            if (set.getValue() != null) {
                if (EntityWrapper.class.isAssignableFrom(set.getValue().getClass())) {
                    convertedValue = ((EntityWrapper)set.getValue()).getMap();
                } else if (List.class.isAssignableFrom(set.getValue().getClass())) {
                    ArrayList convertedList = new ArrayList();
                    this.getValueAsList(set.getValue()).forEach(child -> {
                        if (EntityWrapper.class.isAssignableFrom(child.getClass())) {
                            convertedList.add(((EntityWrapper)child).getMap());
                        }
                    });
                    convertedValue = convertedList;
                } else {
                    convertedValue = set.getValue();
                }
            }
            onlyValuesMap.put((String)set.getKey(), convertedValue);
        });
        return onlyValuesMap;
    }

    public void setMap(Map<String, Object> map) {
        this.attributes.putAll(map);
    }

    public int getId() {
        return this.getValueAsInt(this.attributes.get(ID_KEY));
    }

    public void setId(int id) {
        this.attributes.put(ID_KEY, id);
    }

    public String getUuid() {
        return this.getValueAsString(this.attributes.get(UUID_KEY));
    }

    public void setUuid(String uuid) {
        this.attributes.put(UUID_KEY, uuid);
    }

    public String getTableName() {
        return this.getValueAsString(this.attributes.get(TABLE_NAME_KEY));
    }

    public void setTableName(String tableName) {
        this.attributes.put(TABLE_NAME_KEY, tableName);
        this.tablesMap.put(tableName, false);
    }

    public List<String> getTablesList() {
        return new ArrayList<String>(this.tablesMap.keySet());
    }

    public Object getValueAsObject(String key) {
        return this.attributes.get(key);
    }

    public int getValueAsInt(String key) {
        return this.getValueAsInt(this.attributes.get(key));
    }

    public String getValueAsString(String key) {
        return this.getValueAsString(this.attributes.get(key));
    }

    public boolean getValueAsBoolean(String key) {
        return this.getValueAsBoolean(this.attributes.get(key));
    }

    public Timestamp getValueAsTimestamp(String key) {
        return EntityWrapper.getValueAsTimestamp(this.attributes.get(key));
    }

    public BigDecimal getValueAsBigDecimal(String key) {
        return this.getValueAsBigDecimal(this.attributes.get(key));
    }

    public <T> List<T> getValueAsList(String key) {
        return this.getValueAsList(this.attributes.get(key));
    }

    public List<EntityWrapper> getChildren(String key) {
        ArrayList<EntityWrapper> convertedList = new ArrayList<EntityWrapper>();
        this.getValueAsList(this.attributes.get(key)).forEach(child -> {
            if (EntityWrapper.class.isAssignableFrom(child.getClass())) {
                convertedList.add((EntityWrapper)child);
            } else if (Map.class.isAssignableFrom(child.getClass())) {
                EntityWrapper wrapper = new EntityWrapper();
                wrapper.setMap((Map)child);
                convertedList.add(wrapper);
            }
        });
        return convertedList;
    }

    protected final void setClientId(int clientId) {
        this.setValueNoCheck("AD_Client_ID", new Integer(clientId));
    }

    public final int getClientId() {
        return this.getValueAsInt("AD_Client_ID");
    }

    public final void setOrgId(int orgId) {
        this.setValueNoCheck("AD_Org_ID", new Integer(orgId));
    }

    public int getOrgId() {
        return this.getValueAsInt("AD_Org_ID");
    }

    protected void setClientOrg(int clientId, int orgId) {
        if (clientId != this.getClientId()) {
            this.setClientId(clientId);
        }
        if (orgId != this.getOrgId()) {
            this.setOrgId(orgId);
        }
    }

    protected void setClientOrg(EntityWrapper entity) {
        this.setClientOrg(entity.getClientId(), entity.getOrgId());
    }

    public final void setIsActive(boolean active) {
        this.setValue("IsActive", new Boolean(active));
    }

    public final boolean isActive() {
        return this.getValueAsBoolean("IsActive");
    }

    public final Timestamp getCreated() {
        return this.getValueAsTimestamp("Created");
    }

    public final Timestamp getUpdated() {
        return this.getValueAsTimestamp("Updated");
    }

    public final int getCreatedBy() {
        return this.getValueAsInt("CreatedBy");
    }

    public final int getUpdatedBy() {
        return this.getValueAsInt("UpdatedBy");
    }

    protected final void setUpdatedBy(int userId) {
        this.setValueNoCheck("UpdatedBy", new Integer(userId));
    }

    protected final void setValueNoCheck(String key, Object value) {
        this.attributes.put(key, value);
    }

    public final void setValue(String key, Object value) {
        this.attributes.put(key, value);
    }

    private int getValueAsInt(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String getValueAsString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private boolean getValueAsBoolean(Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return "Y".equals(value);
        }
        return false;
    }

    private BigDecimal getValueAsBigDecimal(Object value) {
        BigDecimal bigDecimalValue = Env.ZERO;
        if (value != null) {
            if (value instanceof BigDecimal) {
                bigDecimalValue = (BigDecimal)value;
                return bigDecimalValue;
            }
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                bigDecimalValue = new BigDecimal(doubleValue);
            } else if (value instanceof Float) {
                Float floatValue = (Float)value;
                bigDecimalValue = new BigDecimal(floatValue.floatValue());
            } else if (value instanceof Integer) {
                Integer integerValue = (Integer)value;
                bigDecimalValue = new BigDecimal(integerValue);
            }
        }
        return bigDecimalValue;
    }

    public static Timestamp getValueAsTimestamp(Object value) {
        if (value != null) {
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            if (value instanceof Long) {
                return new Timestamp((Long)value);
            }
        }
        return null;
    }

    public <T> List<T> getValueAsList(Object value) {
        if (value != null && value instanceof List) {
            return (List)value;
        }
        return null;
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public final Properties getContext() {
        return this.context;
    }

    public final void setContext(Properties context) {
        this.context = context;
    }

    public String toString() {
        return "EntityWrapper [attributes=" + this.attributes + "]";
    }
}

