/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.SynchronizeAllTablesAndColumnsAbstract;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class SynchronizeAllTablesAndColumns
extends SynchronizeAllTablesAndColumnsAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.get_TrxName() == null || this.get_TrxName().isEmpty()) {
            throw new AdempiereException("No Transaction.  A transaction is required.");
        }
        Connection conn = Trx.get(this.get_TrxName(), true).getConnection();
        String syncMessage = "";
        int tableCount = 0;
        int tableChangedCount = 0;
        int columnCount = 0;
        int columnChangedCount = 0;
        Properties ctx = Env.getCtx();
        boolean hasErrors = false;
        int ad_table_id = this.getTableId();
        int ad_column_id = this.getColumnId();
        if (ad_column_id > 0) {
            ad_table_id = MColumn.getTable_ID(this.getCtx(), ad_column_id, null);
        }
        String where = null;
        if (ad_table_id <= 0) {
            MTable table2 = new MTable(ctx, MTable.Table_ID, null);
            syncMessage = table2.syncDatabase(conn, this.isOnlyReport());
            if (!syncMessage.equals("") && !"@MColumn_NoSQLNoChangesMade@".equals(syncMessage)) {
                this.addLog(table2.getTableName() + ": " + syncMessage);
                ++tableChangedCount;
            }
            ++tableCount;
            table2 = new MTable(ctx, MColumn.Table_ID, null);
            syncMessage = table2.syncDatabase(conn, this.isOnlyReport());
            if (!syncMessage.equals("") && !"@MColumn_NoSQLNoChangesMade@".equals(syncMessage)) {
                if (syncMessage.contains("Error")) {
                    hasErrors = true;
                }
                this.addLog(table2.getTableName() + ": " + syncMessage);
                ++tableChangedCount;
            }
            ++tableCount;
            where = "ColumnSQL is null AND (AD_Table_ID=" + MTable.Table_ID + " OR " + "AD_Table_ID" + "=" + MColumn.Table_ID + ")";
            if (this.isSyncObviousChanges()) {
                where = where + " AND RequiresSync='Y'";
            }
            int[] ids = new Query(this.getCtx(), "AD_Column", where, null).setOnlyActiveRecords(true).getIDs();
            for (int i = 0; i < ids.length; ++i) {
                MColumn column = MColumn.get(this.getCtx(), ids[i]);
                syncMessage = column.syncDatabase(conn, this.isOnlyReport());
                if (!syncMessage.equals("") && !"@MColumn_NoSQLNoChangesMade@".equals(syncMessage)) {
                    if (syncMessage.contains("Error")) {
                        hasErrors = true;
                    }
                    this.addLog(column.getAD_Table().getTableName() + "." + column.getColumnName() + ": " + syncMessage);
                    ++columnChangedCount;
                }
                if (++columnCount % 50 != 0) continue;
                this.log.info("Column Sync. Changed/Examined/Total: " + columnChangedCount + "/" + columnCount + "/" + ids.length);
            }
        }
        where = "IsView='N'";
        where = ad_table_id > 0 ? where + " AND AD_Table_ID=?" : where + " AND AD_Table_ID!=" + MTable.Table_ID + " AND " + "AD_Table_ID" + "!=" + MColumn.Table_ID;
        if (this.isSyncObviousChanges()) {
            where = where + " AND RequiresSync='Y'";
        }
        Query query = new Query(this.getCtx(), "AD_Table", where, this.get_TrxName());
        if (this.getTableId() > 0) {
            query = query.setParameters(this.getTableId());
        }
        List tables = query.setOnlyActiveRecords(true).list();
        for (MTable table3 : tables) {
            syncMessage = table3.syncDatabase(conn, this.isOnlyReport());
            if (!syncMessage.equals("") && !"@MColumn_NoSQLNoChangesMade@".equals(syncMessage)) {
                if (syncMessage.contains("Error")) {
                    hasErrors = true;
                }
                this.addLog(table3.getTableName() + ": " + syncMessage);
                ++tableChangedCount;
            }
            if (++tableCount % 50 != 0) continue;
            this.log.info("Table Sync. Changed/Examined/Total: " + tableChangedCount + "/" + tableCount + "/" + tables.size());
        }
        where = "ColumnSQL is null";
        where = ad_column_id <= 0 ? (ad_table_id > 0 ? where + " AND AD_Table_ID=?" : where + " AND AD_Table_ID!=" + MTable.Table_ID + " AND " + "AD_Table_ID" + "!=" + MColumn.Table_ID) : where + " AND AD_Column_ID=?";
        if (this.isSyncObviousChanges()) {
            where = where + " AND RequiresSync='Y'";
        }
        query = new Query(this.getCtx(), "AD_Column", where, this.get_TrxName());
        if (ad_column_id <= 0 && ad_table_id > 0) {
            query = query.setParameters(ad_table_id);
        } else if (ad_column_id > 0) {
            query = query.setParameters(ad_column_id);
        }
        int[] ids = query.setOnlyActiveRecords(true).getIDs();
        for (int i = 0; i < ids.length; ++i) {
            MColumn column = new MColumn(this.getCtx(), ids[i], null);
            if (column.getAD_Table_ID() == MTable.Table_ID || column.getAD_Table_ID() == MColumn.Table_ID) {
                column.set_TrxName(this.get_TrxName());
            }
            if (!((syncMessage = column.syncDatabase(conn, this.isOnlyReport())).equals("") || "@MColumn_NoSQLNoChangesMade@".equals(syncMessage) || "@MColumn_CannotSyncView@".equals(syncMessage))) {
                if (syncMessage.contains("Error")) {
                    hasErrors = true;
                }
                this.addLog("<b>" + column.getAD_Table().getTableName() + "." + column.getColumnName() + "</b>: " + syncMessage);
                ++columnChangedCount;
            }
            if (++columnCount % 50 != 0) continue;
            this.log.info("Column Sync. Changed/Examined/Total: " + columnChangedCount + "/" + columnCount + "/" + ids.length);
        }
        String returnMessage = Msg.parseTranslation(this.getCtx(), "@AD_Table_ID@: " + tableChangedCount + "/" + tableCount + " @AD_Column_ID@: " + columnChangedCount + "/" + columnCount);
        returnMessage = tableChangedCount + columnChangedCount == 0 ? (this.isOnlyReport() ? returnMessage + Msg.parseTranslation(this.getCtx(), " @SynchronizeAllTablesAndColumnsAbstract_NothingToReport@") : returnMessage + Msg.parseTranslation(this.getCtx(), " @SynchronizeAllTablesAndColumnsAbstract_NoChangesRequired@")) : (this.isOnlyReport() ? returnMessage + Msg.parseTranslation(this.getCtx(), " @SynchronizeAllTablesAndColumnsAbstract_OnlyReport@") : (hasErrors ? returnMessage + Msg.parseTranslation(this.getCtx(), " @SynchronizeAllTablesAndColumnsAbstract_ChangeMadeWithError@") : returnMessage + Msg.parseTranslation(this.getCtx(), " @SynchronizeAllTablesAndColumnsAbstract_ChangeMade@")));
        return returnMessage;
    }
}

