/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JTextArea;
import org.compiere.model.MSysConfig;
import org.compiere.print.ReportCtl;
import org.compiere.util.CLogger;

public class POSClientSide
extends Thread {
    Properties m_ctx = null;
    public static final int PORT = 5400;
    private static final String LINUXSO = "LINUX";
    private Socket socketClient = null;
    private String m_Host = null;
    private String m_Print = null;
    private boolean isStopped = true;
    private DataInputStream dis = null;
    private JTextArea fTerminal = null;
    private int m_port;
    private static CLogger log = CLogger.getCLogger(POSClientSide.class);

    public POSClientSide(Properties properties, String string, String string2, JTextArea jTextArea) {
        this.m_ctx = properties;
        this.m_Host = string;
        this.m_Print = string2;
        this.fTerminal = jTextArea;
        this.m_port = MSysConfig.getIntValue("ZK_PORT_SERVER_PRINT", 5400);
        if (!this.connect()) {
            this.start();
        }
    }

    private boolean connect() {
        if (this.isStopped()) {
            try {
                this.socketClient = new Socket(this.m_Host, this.m_port);
                this.socketClient.setKeepAlive(true);
                this.isStopped = false;
                this.setText("Connected to host:" + this.m_Host + " and to port " + this.m_port);
                return this.isStopped;
            }
            catch (IOException iOException) {
                this.setText("Error Connecting: " + iOException.getMessage());
                return this.isStopped;
            }
        }
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            while (!this.isStopped || !this.isInterrupted()) {
                this.connect();
                this.dis = new DataInputStream(this.socketClient.getInputStream());
                int n = this.dis.readInt();
                String string = "zk" + this.dis.readUTF().toString();
                int n2 = this.dis.readInt();
                String string2 = System.getProperty("user.home") + File.separator + string;
                this.setText("File path: " + string2);
                log.severe("path== " + string2);
                fileOutputStream = new FileOutputStream(string2);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.socketClient.getInputStream());
                FileInputStream fileInputStream = new FileInputStream(string2);
                byte[] byArray = new byte[n2];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)bufferedInputStream.read();
                }
                bufferedOutputStream.write(byArray);
                this.setText("File Received");
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                try {
                    this.setText("Operating system: " + System.getProperty("os.name"));
                    if (!System.getProperty("os.name").equalsIgnoreCase(LINUXSO)) {
                        ReportCtl.startDocumentPrint(0, n, true);
                        continue;
                    }
                    String[] stringArray = new String[]{"lp", "-d", this.m_Print, string2};
                    Runtime.getRuntime().exec(stringArray);
                    this.setText("Printing File");
                }
                catch (Exception exception) {
                    this.setText("Error while executing printing: " + exception.getMessage());
                }
                finally {
                    this.isStopped = true;
                    this.setText("Printing finished");
                    this.connect();
                }
            }
        }
        catch (IOException iOException) {
            this.setText("Error in printing process");
        }
        finally {
            this.isStopped = true;
            this.setText("Printing process finished");
            this.connect();
        }
    }

    private void printOtherOS(FileInputStream fileInputStream) {
        DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.AUTOSENSE;
        SimpleDoc simpleDoc = new SimpleDoc(fileInputStream, iNPUT_STREAM, null);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(iNPUT_STREAM, hashPrintRequestAttributeSet);
        try {
            DocPrintJob docPrintJob = null;
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (!printServiceArray[i].getName().equals(this.m_Print)) continue;
                docPrintJob = printServiceArray[i].createPrintJob();
            }
            docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setText(String string) {
        this.fTerminal.setText(this.getText() + string + "\n");
    }

    private String getText() {
        return this.fTerminal.getText();
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void closeConnect() {
        this.isStopped = true;
        this.interrupt();
        this.setText("Disconnected");
    }

    public String toString(String[] stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            string = string + string2 + " ";
        }
        return string;
    }
}

