/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class POSOrderLineTableHandle {
    private static final String TABLE_NAME = "POS_OrderLine_v";
    public static final String PRODUCTNAME = "ProductName";
    public static final String QTYORDERED = "QtyOrdered";
    public static final String UOM = "C_UOM_ID";
    public static final String PRICEACTUAL = "PriceActual";
    public static final String TAX = "C_Tax_ID";
    public static final String DISCOUNT = "Discount";
    public static final String LINENETAMT = "LineNetAmt";
    public static final String GRANDTOTAL = "GrandTotal";
    public static final int COLUMN_QTY = 10;
    public static final int POSITION_C_ORDERLINE_ID = 0;
    public static final int POSITION_QTYORDERED = 2;
    public static final int POSITION_PRICE = 4;
    public static final int POSITION_DISCOUNT = 5;
    public static final int POSITION_LINENETAMT = 6;
    public static final int POSITION_GRANDTOTAL = 8;
    private ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(" ", "C_OrderLine_ID", IDColumn.class, 0, false, true, null, false), new ColumnInfo(Msg.translate(Env.getCtx(), "ProductName"), "ProductName", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Qty"), "QtyOrdered", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_UOM_ID"), "UOMSymbol", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Price"), "PriceActual", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Discount"), "Discount", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "SubTotal"), "LineNetAmt", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_Tax_ID"), "TaxIndicator", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Total"), "GrandTotal", BigDecimal.class)};
    private final String sqlFrom = "POS_OrderLine_v";
    private final String sqlWhere = "C_Order_ID=?";
    private String sqlStatement;
    private IMiniTable table;
    private static CLogger log = CLogger.getCLogger(POSOrderLineTableHandle.class);

    public POSOrderLineTableHandle(IMiniTable iMiniTable) {
        this.table = iMiniTable;
    }

    public boolean prepareTable() {
        if (this.table == null) {
            return false;
        }
        this.sqlStatement = this.table.prepareTable(this.columns, TABLE_NAME, "C_Order_ID=?", false, TABLE_NAME);
        return true;
    }

    public void setEditable(boolean bl, boolean bl2) {
        this.table.setColumnClass(2, BigDecimal.class, !bl2);
        this.table.setColumnClass(4, BigDecimal.class, !bl || !bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadTable(int n) {
        boolean bl;
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(this.sqlStatement, null);
            cPreparedStatement.setInt(1, n);
            resultSet = cPreparedStatement.executeQuery();
            if (resultSet != null) {
                this.table.loadTable(resultSet);
            }
            bl = true;
        }
        catch (Exception exception) {
            try {
                log.log(Level.SEVERE, this.sqlStatement, exception);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
            return false;
        }
        DB.close(resultSet, cPreparedStatement);
        return bl;
    }
}

