/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.pos.service.CollectDetail;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MSysConfig;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class Collect {
    private String trxName;
    private MOrder order;
    private MPOS entityPOS;
    private int partnerId;
    private int bankAccountId;
    private Timestamp dateTrx;
    private List<CollectDetail> collectDetails;
    private boolean isCreditOrder = false;
    private int paymentTermId = 0;
    private StringBuffer errorMsg = new StringBuffer();
    private BigDecimal amountConverted = Env.ZERO;
    private boolean isCompleteCollect = false;

    public Collect(Properties ctx, MOrder order, int posId) {
        this(ctx, order, MPOS.get(ctx, posId));
    }

    public Collect(Properties ctx, MOrder order, MPOS entityPOS) {
        this.collectDetails = new ArrayList<CollectDetail>();
        this.entityPOS = entityPOS;
        if (order != null) {
            this.order = order;
            this.partnerId = order.getC_BPartner_ID();
            this.bankAccountId = entityPOS.getC_BankAccount_ID();
            this.dateTrx = order.getDateOrdered();
            this.trxName = order.get_TrxName();
        }
    }

    public void load(Properties ctx, MOrder order, MPOS entityPOS) {
        this.collectDetails = new ArrayList<CollectDetail>();
        this.entityPOS = entityPOS;
        if (order != null) {
            this.order = order;
            this.partnerId = order.getC_BPartner_ID();
            this.bankAccountId = entityPOS.getC_BankAccount_ID();
            this.dateTrx = order.getDateOrdered();
            this.trxName = order.get_TrxName();
        }
    }

    public void addCollect(CollectDetail detail) {
        this.collectDetails.add(detail);
    }

    public void removeCollect(CollectDetail detail) {
        this.collectDetails.remove(detail);
    }

    public void removeAllCollectDetail() {
        int lenght = this.collectDetails.size();
        for (int i = lenght - 1; i >= 0; --i) {
            this.collectDetails.remove(i);
        }
    }

    public BigDecimal getCollectDetailAmt() {
        BigDecimal payAmt = Env.ZERO;
        for (CollectDetail detail : this.collectDetails) {
            payAmt = payAmt.add(detail.getConvertedPayAmt());
        }
        return payAmt;
    }

    protected BigDecimal getBalance(BigDecimal openAmt) {
        BigDecimal totalPayAmt = this.getCollectDetailAmt();
        if (this.order != null) {
            return openAmt.subtract(totalPayAmt);
        }
        return Env.ZERO;
    }

    public void addCash(BigDecimal m_PayAmt) {
        int position = this.findCash();
        CollectDetail collectDetail = null;
        if (position != -1) {
            collectDetail = this.collectDetails.get(position);
            collectDetail.setPayAmt(m_PayAmt);
            this.collectDetails.set(position, collectDetail);
            return;
        }
        collectDetail = CollectDetail.createCash(m_PayAmt);
        collectDetail.setDateTrx(this.getDateTrx());
        this.collectDetails.add(collectDetail);
    }

    public void addCheck(BigDecimal payAmt, String checkNo, int bankId, Timestamp dateTrx) {
        int position = this.findCheck(checkNo);
        CollectDetail collectDetail = null;
        if (position != -1) {
            collectDetail = this.collectDetails.get(position);
            collectDetail.setPayAmt(payAmt);
            this.collectDetails.set(position, collectDetail);
            return;
        }
        collectDetail = CollectDetail.createCheck(payAmt, checkNo, bankId, dateTrx);
        this.collectDetails.add(collectDetail);
    }

    public int findCheck(String checkNo) {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("K") || collectDetail.getReferenceNo() == null || !collectDetail.getReferenceNo().equals(checkNo)) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistCash() {
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("X")) continue;
            return true;
        }
        return false;
    }

    public boolean isExistOnlyOneCash() {
        int count = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("X")) continue;
            ++count;
        }
        return count == 1 && this.collectDetails.size() == 1;
    }

    public int isExistCreditCard() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("C")) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistOnlyOneCreditCard() {
        int count = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("C")) continue;
            ++count;
        }
        return count == 1 && this.collectDetails.size() == 1;
    }

    public int isExistCheck() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("K")) continue;
            return i;
        }
        return -1;
    }

    public boolean isExistOnlyOneCheck() {
        int count = 0;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (!collectDetail.getTenderType().equals("K")) continue;
            ++count;
        }
        return count == 1 && this.collectDetails.size() == 1;
    }

    public int findCash() {
        for (int i = 0; i < this.collectDetails.size(); ++i) {
            CollectDetail collectDetail = this.collectDetails.get(i);
            if (!collectDetail.getTenderType().equals("X")) continue;
            return i;
        }
        return -1;
    }

    public boolean payCash(BigDecimal amount, int currencyId, BigDecimal overUnderAmt, BigDecimal amountRefunded) {
        return this.payCash(amount, currencyId, overUnderAmt, amountRefunded, null);
    }

    public boolean payCash(BigDecimal amount, int currencyId, BigDecimal overUnderAmt, BigDecimal amountRefunded, String referenceNo) {
        MPayment payment = this.createPayment("X");
        if (payment.isCashTrx() && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, payment.getAD_Client_ID())) {
            payment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        } else {
            payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        }
        payment.setDocumentNo(referenceNo);
        payment.setAmount(currencyId, amount);
        int conversionTypeId = this.entityPOS.getC_ConversionType_ID();
        if (conversionTypeId > 0) {
            payment.setC_ConversionType_ID(conversionTypeId);
        }
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        if (!payment.isPrepayment() || this.order.getC_Invoice_ID() > 0) {
            if (amountRefunded != null && amountRefunded.signum() != 0 && amountRefunded.doubleValue() < 1.0) {
                payment.setWriteOffAmt(amountRefunded);
            } else if (overUnderAmt != null && overUnderAmt.signum() != 0) {
                payment.setOverUnderAmt(overUnderAmt);
            }
        }
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment(payment);
            return true;
        }
        return false;
    }

    public boolean payCheck(BigDecimal amount, int currencyId, String accountNo, String routingNo, String checkNo, Timestamp dateCheck) {
        MPayment payment = this.createPayment("K");
        payment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        payment.setAmount(currencyId, amount);
        int conversionTypeId = this.entityPOS.getC_ConversionType_ID();
        if (conversionTypeId > 0) {
            payment.setC_ConversionType_ID(conversionTypeId);
        }
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setAccountNo(accountNo);
        payment.setRoutingNo(routingNo);
        payment.setCheckNo(checkNo);
        payment.setDescription(checkNo);
        payment.setDateTrx(dateCheck);
        payment.setDateAcct(this.getDateTrx());
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment(payment);
            return true;
        }
        return false;
    }

    public boolean payDirectDebit(BigDecimal amount, int currencyId, String routingNo, String accountCountry, String cVV, int bankId, String referenceNo) {
        MPayment payment = this.createPayment("D");
        payment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        payment.setAmount(currencyId, amount);
        int conversionTypeId = this.entityPOS.getC_ConversionType_ID();
        if (conversionTypeId > 0) {
            payment.setC_ConversionType_ID(conversionTypeId);
        }
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setRoutingNo(routingNo);
        payment.setA_Country(accountCountry);
        payment.set_CustomColumn("C_Bank_ID", bankId);
        payment.setCreditCardVV(cVV);
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.setDocumentNo(referenceNo);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment(payment);
            return true;
        }
        return false;
    }

    public boolean payment(BigDecimal amount, int currencyId, String tenderType, String referenceNo) {
        return this.payment(amount, currencyId, tenderType, referenceNo, -1);
    }

    public boolean payment(BigDecimal amount, int currencyId, String tenderType, String referenceNo, int bankId) {
        MPayment payment = this.createPayment(tenderType);
        payment.setC_CashBook_ID(this.entityPOS.getC_CashBook_ID());
        payment.setAmount(currencyId, amount);
        int conversionTypeId = this.entityPOS.getC_ConversionType_ID();
        if (conversionTypeId > 0) {
            payment.setC_ConversionType_ID(conversionTypeId);
        }
        if (bankId > 0) {
            payment.set_CustomColumn("C_Bank_ID", bankId);
        }
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setDocumentNo(referenceNo);
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment(payment);
            return true;
        }
        return false;
    }

    public boolean payCreditCard(BigDecimal amount, int currencyId, String accountName, int month, int year, String cardNo, String cvc, String cardtype, String referenceNo) {
        MPayment payment = this.createPayment("C");
        payment.setAmount(currencyId, amount);
        int conversionTypeId = this.entityPOS.getC_ConversionType_ID();
        if (conversionTypeId > 0) {
            payment.setC_ConversionType_ID(conversionTypeId);
        }
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.setTenderType("C");
        payment.setTrxType("S");
        payment.setCreditCardType(cardtype);
        payment.setCreditCardNumber(cardNo);
        payment.setCreditCardVV(cvc);
        payment.setCreditCardExpMM(month);
        payment.setCreditCardExpYY(year);
        payment.setA_Name(accountName);
        payment.setDocumentNo(referenceNo);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment(payment);
            return true;
        }
        return false;
    }

    public boolean payCreditMemo(MInvoice creditMemo, BigDecimal amount) {
        int invoiceId = this.order.getC_Invoice_ID();
        if (invoiceId == 0) {
            return false;
        }
        MPayment payment = this.createPayment("M");
        payment.setAmount(creditMemo.getC_Currency_ID(), amount);
        payment.setC_BankAccount_ID(this.entityPOS.getC_BankAccount_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.setDocumentNo(creditMemo.getDocumentNo());
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            List<MPayment> paymentsList;
            payment.saveEx();
            if (creditMemo.getC_Order_ID() != 0 && (paymentsList = MPayment.getOfOrder(Env.getCtx(), creditMemo.getC_Order_ID(), this.trxName)).size() > 0) {
                MAllocationHdr allocation = new MAllocationHdr(Env.getCtx(), true, this.getDateTrx(), creditMemo.getC_Currency_ID(), creditMemo.getDescription(), this.trxName);
                allocation.setDocStatus("DR");
                allocation.setDocAction("CO");
                allocation.saveEx();
                paymentsList.stream().findFirst().ifPresent(returnCollect -> {
                    MAllocationLine allocationLine = new MAllocationLine(allocation);
                    allocationLine.setPaymentInfo(returnCollect.getC_Payment_ID(), 0);
                    allocationLine.setDocInfo(creditMemo.getC_BPartner_ID(), creditMemo.getC_Order_ID(), creditMemo.getC_Invoice_ID());
                    allocationLine.setAmount(returnCollect.getPayAmt().negate());
                    allocationLine.saveEx();
                });
                allocation.processIt("CO");
                allocation.saveEx();
                payment.testAllocation();
                payment.saveEx();
                paymentsList.forEach(returnCollect -> {
                    returnCollect.testAllocation();
                    returnCollect.saveEx();
                });
            }
            creditMemo.testAllocation();
            creditMemo.saveEx();
            MBankStatement.addPayment(payment);
            return true;
        }
        return false;
    }

    private MPayment createPayment(String tenderType) {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.trxName);
        payment.setAD_Org_ID(this.entityPOS.getAD_Org_ID());
        payment.setC_POS_ID(this.entityPOS.getC_POS_ID());
        payment.setTenderType(tenderType);
        payment.setIsReceipt(true);
        payment.setC_Order_ID(this.order.getC_Order_ID());
        payment.setIsPrepayment(false);
        payment.setC_BPartner_ID(this.getC_BPartner_ID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        payment.setCreditCardType(null);
        int invoiceId = this.order.getC_Invoice_ID();
        if (invoiceId > 0) {
            payment.setC_Invoice_ID(invoiceId);
            MInvoice invoice = new MInvoice(Env.getCtx(), payment.getC_Invoice_ID(), this.trxName);
            payment.setDescription(Msg.parseTranslation(Env.getCtx(), "@C_Invoice_ID@ " + invoice.getDocumentNo()));
        } else {
            payment.setIsPrepayment(true);
            payment.setDescription(Msg.parseTranslation(Env.getCtx(), "@C_Invoice_ID@ " + this.order.getDocumentNo()));
        }
        this.order.setC_POS_ID(this.entityPOS.getC_POS_ID());
        this.order.saveEx(this.trxName);
        return payment;
    }

    private void addErrorMsg(String error) {
        if (error == null || error.length() == 0) {
            return;
        }
        if (this.errorMsg.length() > 0) {
            this.errorMsg.append(Env.NL);
        } else {
            this.errorMsg.append("@ValidationError@").append(Env.NL);
        }
        this.errorMsg.append(error);
    }

    public String getErrorMsg() {
        if (this.errorMsg != null && this.errorMsg.length() > 0) {
            return this.errorMsg.toString();
        }
        return null;
    }

    private void cleanErrorMsg() {
        this.errorMsg = new StringBuffer();
    }

    protected String validateTenderTypes(BigDecimal openAmt) {
        BigDecimal returnAmt;
        this.cleanErrorMsg();
        if (openAmt.doubleValue() <= 0.0) {
            this.addErrorMsg("@POS.validatePayment.NoOpenAmt@");
        }
        if (this.isAllowsPartialPayment()) {
            return null;
        }
        if (!this.isCreditOrder() && openAmt.subtract(this.getCollectDetailAmt()).doubleValue() > 0.0) {
            this.addErrorMsg("@POS.OrderPayNotCompleted@");
        }
        BigDecimal cashPayment = Env.ZERO;
        BigDecimal otherPayments = Env.ZERO;
        for (CollectDetail collectDetail : this.collectDetails) {
            if (collectDetail.getConvertedPayAmt() == null || !(collectDetail.getConvertedPayAmt().doubleValue() > 0.0)) {
                this.addErrorMsg("@POS.validatePayment.ZeroAmount@");
                continue;
            }
            if (collectDetail.getTenderType().equals("X")) {
                cashPayment = cashPayment.add(collectDetail.getConvertedPayAmt());
                continue;
            }
            if (collectDetail.getTenderType().equals("M")) {
                if (collectDetail.getC_Invoice_ID() == 0) {
                    this.addErrorMsg("@POS.CreditMemoNotSelected@");
                }
                BigDecimal amtCreditMemo = collectDetail.getOpenAmtCreditMemo();
                if (collectDetail.getConvertedPayAmt().compareTo(amtCreditMemo) > 0) {
                    this.addErrorMsg("@POS.OpenAmountCreditMemo@ < @POS.PayAmt@ ");
                    collectDetail.setPayAmt(amtCreditMemo);
                }
                otherPayments = otherPayments.add(collectDetail.getConvertedPayAmt());
                continue;
            }
            otherPayments = otherPayments.add(collectDetail.getConvertedPayAmt());
        }
        if (otherPayments.subtract(openAmt).signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.NonCashPaymentIncorrect@");
        }
        if (otherPayments.subtract(openAmt).signum() == 0 && cashPayment.signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.CashPaymentNotNeeded@");
        }
        if ((returnAmt = cashPayment.add(otherPayments.subtract(openAmt))).subtract(cashPayment).signum() == 1) {
            this.addErrorMsg("@POS.validatePayment.ChangeIncorrect@");
        }
        return this.getErrorMsg();
    }

    public void processTenderTypes(String trxName, BigDecimal openAmt) {
        this.cleanErrorMsg();
        this.trxName = trxName;
        AtomicReference<BigDecimal> cashPayment = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> otherPayment = new AtomicReference<BigDecimal>(Env.ZERO);
        this.collectDetails.stream().filter(collect -> !collect.getTenderType().equals("X") && !collect.getTenderType().equals("T")).forEach(collectDetail -> {
            BigDecimal cfr_ignored_0 = (BigDecimal)otherPayment.updateAndGet(amount -> {
                amount = amount.add(collectDetail.getConvertedPayAmt());
                return amount;
            });
        });
        this.collectDetails.stream().filter(collect -> collect.getTenderType().equals("X") || collect.getTenderType().equals("T")).forEach(collectDetail -> {
            BigDecimal cfr_ignored_0 = (BigDecimal)cashPayment.updateAndGet(amount -> {
                amount = amount.add(collectDetail.getConvertedPayAmt());
                return amount;
            });
        });
        BigDecimal amountRefunded = openAmt.subtract(otherPayment.get().add(cashPayment.get()));
        this.amountConverted = this.order.getGrandTotal();
        if (amountRefunded.signum() == -1 && cashPayment.get().doubleValue() > 0.0 && amountRefunded.abs().doubleValue() > cashPayment.get().doubleValue()) {
            this.addErrorMsg("@POS.validatePayment.PaymentBustBeExact@");
        }
        this.collectDetails.forEach(collectDetail -> {
            if (collectDetail.getTenderType().equals("X") || collectDetail.getTenderType().equals("T")) {
                BigDecimal payAmt = collectDetail.getConvertedPayAmt();
                BigDecimal amountRefundedConverted = amountRefunded.multiply(collectDetail.getConversionRateFromCurrency(this.order.getC_Currency_ID(), this.order.getAD_Org_ID())).negate();
                this.amountConverted = this.amountConverted.subtract(payAmt);
                if (this.amountConverted.signum() == -1) {
                    payAmt = payAmt.add(this.amountConverted);
                }
                payAmt = !this.isCompleteCollect() ? payAmt.multiply(collectDetail.getConversionRateFromCurrency(this.order.getC_Currency_ID(), this.order.getAD_Org_ID())) : collectDetail.getPayAmt();
                boolean result = this.payCash(payAmt, collectDetail.getCurrencyId(), Env.ZERO, amountRefundedConverted, collectDetail.getReferenceNo());
            } else if (collectDetail.getTenderType().equals("D")) {
                boolean result = this.payDirectDebit(collectDetail.getPayAmt(), collectDetail.getCurrencyId(), collectDetail.getRoutingNo(), collectDetail.getA_Country(), collectDetail.getCreditCardVV(), collectDetail.getC_Bank_ID(), collectDetail.getReferenceNo());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentDirectDebit@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("K")) {
                boolean result = this.payCheck(collectDetail.getPayAmt(), collectDetail.getCurrencyId(), null, collectDetail.getRoutingNo(), collectDetail.getReferenceNo(), collectDetail.getDateTrx());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentCheck@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("C")) {
                String mmyy = collectDetail.getCreditCardExpMM() + collectDetail.getCreditCardExpYY();
                int month = MPaymentValidate.getCreditCardExpMM(mmyy);
                int year = MPaymentValidate.getCreditCardExpYY(mmyy);
                boolean result = this.payCreditCard(collectDetail.getPayAmt(), collectDetail.getCurrencyId(), collectDetail.getA_Name(), month, year, collectDetail.getCreditCardNumber(), collectDetail.getCreditCardVV(), collectDetail.getCreditCardType(), collectDetail.getReferenceNo());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentCreditCard@");
                    return;
                }
            } else if (collectDetail.getTenderType().equals("M")) {
                if (this.isAllowsPartialPayment()) {
                    this.addErrorMsg("@POS.PrePayment.NoCreditMemoAllowed@");
                    return;
                }
                boolean result = this.payCreditMemo(collectDetail.getM_InvCreditMemo(), collectDetail.getPayAmt());
                if (!result) {
                    this.addErrorMsg("@POS.ErrorPaymentCreditMemo@");
                    return;
                }
            } else {
                this.payment(collectDetail.getPayAmt(), collectDetail.getCurrencyId(), collectDetail.getTenderType(), collectDetail.getReferenceNo(), collectDetail.getC_Bank_ID());
            }
        });
        this.order.saveEx(trxName);
    }

    public BigDecimal getPrePayAmt() {
        String sql = "SELECT Sum(PayAmt) FROM C_Order o\tLEFT JOIN C_Payment p on p.C_order_ID = o.C_order_ID\tWHERE o.C_Order_ID = ?";
        BigDecimal received = DB.getSQLValueBD(null, sql, this.order.getC_Order_ID());
        if (received == null) {
            received = Env.ZERO;
        }
        return received;
    }

    public ValueNamePair[] getCreditCards(BigDecimal amount, int clientId, int orgId, int currencyId, String trxName) {
        try {
            MPaymentProcessor[] paymentProcessors = MPaymentProcessor.find(Env.getCtx(), null, null, clientId, orgId, currencyId, amount, trxName);
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < paymentProcessors.length; ++i) {
                if (paymentProcessors[i].isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (paymentProcessors[i].isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (paymentProcessors[i].isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (paymentProcessors[i].isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (paymentProcessors[i].isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (!paymentProcessors[i].isAcceptVisa()) continue;
                map.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String creditCardType) {
        return new ValueNamePair(creditCardType, this.getCreditCardName(creditCardType));
    }

    public String getCreditCardName(String creditCardType) {
        if (creditCardType == null) {
            return "--";
        }
        if ("M".equals(creditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(creditCardType)) {
            return "Visa";
        }
        if ("A".equals(creditCardType)) {
            return "Amex";
        }
        if ("C".equals(creditCardType)) {
            return "ATM";
        }
        if ("D".equals(creditCardType)) {
            return "Diners";
        }
        if ("N".equals(creditCardType)) {
            return "Discover";
        }
        if ("P".equals(creditCardType)) {
            return "PurchaseCard";
        }
        return "?" + creditCardType + "?";
    }

    public int getC_BPartner_ID() {
        return this.partnerId;
    }

    public int getC_BankAccount_ID() {
        return this.bankAccountId;
    }

    public Timestamp getDateTrx() {
        return this.dateTrx;
    }

    public void setC_BPartner_ID(int partnerId) {
        this.partnerId = partnerId;
    }

    public void setC_BankAccount_ID(int bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public void setDateTrx(Timestamp dateTrx) {
        this.dateTrx = dateTrx;
    }

    public void setC_PaymentTerm_ID(int paymentTermId) {
        this.paymentTermId = paymentTermId;
    }

    public int getC_PaymentTerm_ID() {
        return this.paymentTermId;
    }

    public boolean isCreditOrder() {
        return this.isCreditOrder;
    }

    public void setIsCreditOrder(boolean isCreditOrder) {
        this.isCreditOrder = isCreditOrder;
    }

    public void setCompleteCollect(boolean isCompleteCollect) {
        this.isCompleteCollect = isCompleteCollect;
    }

    public boolean isCompleteCollect() {
        return this.isCompleteCollect;
    }

    public boolean isAllowsPartialPayment() {
        return this.order != null && "WR".equals(this.order.getC_DocTypeTarget().getDocSubTypeSO()) && "CO".equals(this.order.getDocStatus());
    }

    public int getDetailQty() {
        return this.collectDetails.size();
    }

    public List<CollectDetail> getCollectDetails() {
        return this.collectDetails;
    }

    public MPOS getM_POS() {
        return this.entityPOS;
    }

    public MOrder getOrder() {
        return this.order;
    }
}

