/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.command.CommandManager;
import org.adempiere.pos.util.POSTicketHandler;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPOS;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProductPricing;
import org.compiere.model.MSequence;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.InOutGenerate;
import org.compiere.process.InOutGenerateAbstract;
import org.compiere.process.InvoiceGenerate;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.eevolution.service.dsl.ProcessBuilder;

public class CPOS {
    private MPOS entityPOS;
    private MOrder currentOrder;
    private MSequence documentSequence;
    private MBPartner partner;
    private int priceListVersionId;
    private int priceListId;
    private Properties ctx;
    private Timestamp today;
    private ArrayList<Integer> orderList;
    private int recordPosition;
    private boolean isToPrint;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private BigDecimal quantity = BigDecimal.ZERO;
    private BigDecimal quantityAdded = BigDecimal.ZERO;
    private BigDecimal priceLimit = BigDecimal.ZERO;
    private BigDecimal price = BigDecimal.ZERO;
    private BigDecimal priceList = BigDecimal.ZERO;
    private BigDecimal discountPercentage = BigDecimal.ZERO;
    private boolean isAddQty = false;
    private int orderLineId = 0;
    private DecimalFormat decimalFormat;
    private SimpleDateFormat dateFormat;
    private int windowNo;
    private HashMap<Integer, BigDecimal> receivedAmount;

    public CPOS() {
        this.ctx = Env.getCtx();
        this.decimalFormat = DisplayType.getNumberFormat(12);
        this.dateFormat = DisplayType.getDateFormat(15);
        this.today = Env.getContextAsDate(this.ctx, "#Date");
    }

    public void setPOS(int salesRepresentativeId) {
        List<MPOS> poss = this.getPOSBySalesRepresentativeAndOrganization(salesRepresentativeId, Env.getAD_Org_ID(this.getCtx()));
        if (poss.size() == 0) {
            throw new AdempierePOSException("@NoPOSForUser@");
        }
        if (poss.size() == 1) {
            this.entityPOS = poss.get(0);
        }
    }

    public void setM_POS(MPOS pos) {
        this.entityPOS = pos;
    }

    public DecimalFormat getNumberFormat() {
        return this.decimalFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public boolean isCompleted() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.isProcessed() && "CO".equals(this.currentOrder.getDocStatus());
    }

    public int getAD_Sequence_ID() {
        if (this.entityPOS.getC_DocType_ID() > 0) {
            return this.entityPOS.getC_DocType().getDocNoSequence_ID();
        }
        throw new AdempierePOSException("@C_POS_ID@ @C_DocType_ID @NotFound@");
    }

    public int getAD_Org_ID() {
        return this.entityPOS.getAD_Org_ID();
    }

    public boolean isClosed() {
        if (!this.hasOrder()) {
            return false;
        }
        return "CL".equals(this.currentOrder.getDocStatus());
    }

    public boolean isVoided() {
        if (!this.hasOrder()) {
            return false;
        }
        return "VO".equals(this.currentOrder.getDocStatus());
    }

    public boolean isDrafted() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "DR".equals(this.currentOrder.getDocStatus());
    }

    public boolean isInProgress() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "IP".equals(this.currentOrder.getDocStatus());
    }

    public boolean isInvalid() {
        if (!this.hasOrder()) {
            return false;
        }
        return !this.isCompleted() && !this.isVoided() && "IN".equals(this.currentOrder.getDocStatus());
    }

    public boolean hasLines() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.getLines().length > 0;
    }

    public boolean isPOSOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WR".equals(this.getDocSubTypeSO());
    }

    public boolean isCreditOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WI".equals(this.getDocSubTypeSO());
    }

    public boolean isStandardOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "SO".equals(this.getDocSubTypeSO());
    }

    public boolean isPreInvoicedOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "IO".equals(this.getDocSubTypeSO());
    }

    public boolean isPrepayOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "PR".equals(this.getDocSubTypeSO());
    }

    public boolean isWarehouseOrder() {
        if (!this.hasOrder()) {
            return false;
        }
        return "WP".equals(this.getDocSubTypeSO());
    }

    public boolean isReturnMaterial() {
        if (!this.hasOrder()) {
            return false;
        }
        return "RM".equals(this.getDocSubTypeSO());
    }

    public boolean isInvoiced() {
        if (!this.hasOrder()) {
            return false;
        }
        MInvoice[] invoices = this.getOrder().getInvoices();
        boolean orderInvoiced = false;
        if (invoices != null && invoices.length > 0) {
            orderInvoiced = invoices[0].getDocStatus().equalsIgnoreCase("CO");
        }
        return this.currentOrder.isInvoiced() || orderInvoiced;
    }

    public boolean isDelivered() {
        if (!this.hasOrder()) {
            return false;
        }
        return this.currentOrder.isDelivered();
    }

    private String getDocSubTypeSO() {
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (docType != null && docType.getDocSubTypeSO() != null) {
            return docType.getDocSubTypeSO();
        }
        return "";
    }

    public int getC_DocType_ID() {
        if (!this.hasOrder()) {
            return 0;
        }
        if (this.isCompleted() || this.isVoided()) {
            return this.currentOrder.getC_DocType_ID();
        }
        return this.currentOrder.getC_DocTypeTarget_ID();
    }

    public boolean isToPrint() {
        return this.isToPrint;
    }

    public void setIsToPrint(boolean isToPrint) {
        this.isToPrint = isToPrint;
    }

    public MOrder getOrder() {
        return this.currentOrder;
    }

    public boolean hasOrder() {
        return this.currentOrder != null && this.currentOrder.getC_Order_ID() != 0;
    }

    public boolean hasBPartner() {
        return this.partner != null;
    }

    public boolean compareBPName(String name) {
        return this.partner.getName().equals(name);
    }

    public int getC_BPartner_ID() {
        if (this.hasBPartner()) {
            return this.partner.getC_BPartner_ID();
        }
        return 0;
    }

    public int getC_BankAccount_ID() {
        return this.entityPOS.getC_BankAccount_ID();
    }

    public String getBPName() {
        if (this.hasBPartner()) {
            return this.partner.getValue() + " - " + this.partner.getName() + (!Util.isEmpty(this.partner.getName2()) ? " " + this.partner.getName2() : "");
        }
        return null;
    }

    public int getC_Currency_ID() {
        if (this.hasBPartner() && this.currentOrder != null) {
            return this.currentOrder.getC_Currency_ID();
        }
        return 0;
    }

    public int getAD_User_ID() {
        return Env.getAD_User_ID(Env.getCtx());
    }

    public int getAutoLogoutDelay() {
        if (this.entityPOS != null) {
            return this.entityPOS.getAutoLogoutDelay();
        }
        return 0;
    }

    public int getPINEntryTimeout() {
        if (this.entityPOS != null) {
            return this.entityPOS.getPINEntryTimeout();
        }
        return 0;
    }

    public String getSalesRepName() {
        if (this.currentOrder != null && this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            String salesRepName = this.currentOrder.getC_BPartner().getSalesRep().getName();
            return salesRepName;
        }
        MUser salesRep = MUser.get(this.ctx);
        if (salesRep == null) {
            return null;
        }
        return salesRep.getName();
    }

    public int getSalesRep_ID() {
        if (this.currentOrder != null && this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
            return this.currentOrder.getC_BPartner().getSalesRep_ID();
        }
        return this.entityPOS.getSalesRep_ID();
    }

    public MPOS getM_POS() {
        return this.entityPOS;
    }

    public String getPOSName() {
        return this.entityPOS.getName();
    }

    public int getC_POS_ID() {
        return this.entityPOS.getC_POS_ID();
    }

    public boolean isEnableProductLookup() {
        return this.entityPOS.isEnableProductLookup();
    }

    public boolean isRequiredPIN() {
        return this.entityPOS.isPOSRequiredPIN();
    }

    public void newOrder(int partnerId) {
        this.log.info("PosPanel.newOrder");
        this.currentOrder = null;
        int docTypeId = this.entityPOS.getC_DocType_ID();
        this.createOrder(partnerId, docTypeId);
        this.reloadOrder();
    }

    public void setC_DocType_ID(int docTypeTargetId) {
        if (!this.isDrafted()) {
            return;
        }
        Trx.run(transactionName -> {
            this.currentOrder.set_TrxName(transactionName);
            this.currentOrder.setC_DocTypeTarget_ID(docTypeTargetId);
            String value = DB.getDocumentNo(this.getC_DocType_ID(), null, false, (PO)this.currentOrder);
            if (value != null) {
                this.currentOrder.setDocumentNo(value);
            }
            this.currentOrder.saveEx();
        });
        this.currentOrder.set_TrxName(null);
    }

    private void createOrder(int partnerId, int docTypeTargetId) {
        int orderId = this.getFreeC_Order_ID();
        if (orderId > 0) {
            this.currentOrder = new MOrder(Env.getCtx(), orderId, null);
            this.currentOrder.setDateOrdered(this.getToday());
            this.currentOrder.setDateAcct(this.getToday());
            this.currentOrder.setDatePromised(this.getToday());
            this.currentOrder.saveEx();
        } else {
            this.currentOrder = new MOrder(Env.getCtx(), 0, null);
        }
        this.currentOrder.setAD_Org_ID(this.entityPOS.getAD_Org_ID());
        this.currentOrder.setIsSOTrx(true);
        if (this.entityPOS.getM_PriceList_ID() > 0) {
            this.currentOrder.setM_PriceList_ID(this.entityPOS.getM_PriceList_ID());
        }
        if (this.entityPOS.getDeliveryRule() != null) {
            this.currentOrder.setDeliveryRule(this.getDeliveryRule());
        }
        if (this.entityPOS.getInvoiceRule() != null) {
            this.currentOrder.setInvoiceRule(this.getInvoiceRule());
        }
        this.currentOrder.setC_POS_ID(this.entityPOS.getC_POS_ID());
        this.currentOrder.setM_Warehouse_ID(this.entityPOS.getM_Warehouse_ID());
        if (docTypeTargetId != 0) {
            this.currentOrder.setC_DocTypeTarget_ID(docTypeTargetId);
        } else {
            this.currentOrder.setC_DocTypeTarget_ID("WI");
        }
        this.configureBPartner(partnerId);
        if (orderId < 0) {
            this.orderList.add(this.currentOrder.getC_Order_ID());
        }
        this.reloadIndex(this.currentOrder.getC_Order_ID());
    }

    private int getFreeC_Order_ID() {
        return DB.getSQLValue(null, "SELECT o.C_Order_ID FROM C_Order o WHERE o.DocStatus = 'DR' AND o.C_POS_ID = ? AND o.SalesRep_ID = ? AND NOT EXISTS(SELECT 1 \t\t\t\t\tFROM C_OrderLine ol \t\t\t\t\tWHERE ol.C_Order_ID = o.C_Order_ID) ORDER BY o.Updated", this.getC_POS_ID(), this.getSalesRep_ID());
    }

    public boolean isBPartnerStandard() {
        int partnerId;
        int n = partnerId = this.currentOrder != null ? this.currentOrder.getC_BPartner_ID() : 0;
        return this.entityPOS.getC_BPartnerCashTrx_ID() == partnerId;
    }

    public void configureBPartner(int partnerId) {
        AtomicReference<Integer> atomicPartner = new AtomicReference<Integer>();
        AtomicReference<Boolean> atomicSamePosPartner = new AtomicReference<Boolean>(false);
        atomicPartner.set(partnerId);
        if (this.isCompleted() || this.isVoided()) {
            return;
        }
        if (partnerId == 0) {
            atomicSamePosPartner.set(true);
            partnerId = this.entityPOS.getC_BPartnerCashTrx_ID();
        }
        this.partner = MBPartner.get(this.ctx, partnerId);
        if (this.partner == null || this.partner.get_ID() == 0) {
            throw new AdempierePOSException("POS.NoBPartnerForOrder");
        }
        if (this.currentOrder == null) {
            this.newOrder((Integer)atomicPartner.get());
        }
        Trx.run(transactionName -> {
            MBPartnerLocation[] partnerLocations;
            this.currentOrder.set_TrxName(transactionName);
            this.log.fine("CPOS.setC_BPartner_ID=" + atomicPartner.get());
            this.log.info("CPOS.SetC_BPartner_ID -" + this.partner);
            this.currentOrder.setBPartner(this.partner);
            if (this.partner.getM_PriceList_ID() > 0) {
                MPriceList businesPartnerPriceList = MPriceList.get(this.getCtx(), this.partner.getM_PriceList_ID(), null);
                MPriceList currentPriceList = MPriceList.get(this.getCtx(), this.getM_POS().getM_PriceList_ID(), null);
                if (currentPriceList.getC_Currency_ID() != businesPartnerPriceList.getC_Currency_ID()) {
                    this.currentOrder.setM_PriceList_ID(currentPriceList.getM_PriceList_ID());
                }
            }
            if ((partnerLocations = this.partner.getLocations(true)).length > 0) {
                for (MBPartnerLocation partnerLocation : partnerLocations) {
                    if (partnerLocation.isBillTo()) {
                        this.currentOrder.setBill_Location_ID(partnerLocation.getC_BPartner_Location_ID());
                    }
                    if (!partnerLocation.isShipTo()) continue;
                    this.currentOrder.setShip_Location_ID(partnerLocation.getC_BPartner_Location_ID());
                }
            }
            if (((Boolean)atomicSamePosPartner.get()).booleanValue() && this.currentOrder.getPaymentRule() == null) {
                this.currentOrder.setPaymentRule("B");
            }
            if (this.entityPOS.isSharedPOS()) {
                this.currentOrder.setSalesRep_ID(Env.getAD_User_ID(this.getCtx()));
            } else if (this.currentOrder.getC_BPartner().getSalesRep_ID() != 0) {
                this.currentOrder.setSalesRep_ID(this.currentOrder.getC_BPartner().getSalesRep_ID());
            } else {
                this.currentOrder.setSalesRep_ID(this.entityPOS.getSalesRep_ID());
            }
            this.currentOrder.saveEx();
            MPriceListVersion priceListVersion = this.loadPriceListVersion(this.currentOrder.getM_PriceList_ID());
            List<MProductPrice> productPrices = Arrays.asList(priceListVersion.getProductPrice("AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = " + this.currentOrder.getC_Order_ID() + " AND ol.M_Product_ID = M_ProductPrice.M_Product_ID)"));
            Arrays.asList(this.currentOrder.getLines(true, "M_Product_ID")).stream().filter(orderLine -> orderLine.getC_OrderLine_ID() == this.orderLineId).forEach(orderLine -> {
                if (productPrices.stream().filter(productPrice -> productPrice.getM_Product_ID() == orderLine.getM_Product_ID()).findFirst().isPresent()) {
                    orderLine.setC_BPartner_ID(this.partner.getC_BPartner_ID());
                    orderLine.setC_BPartner_Location_ID(this.currentOrder.getC_BPartner_Location_ID());
                    orderLine.setPrice();
                    orderLine.setTax();
                    orderLine.saveEx();
                } else {
                    orderLine.deleteEx(true);
                }
            });
            this.currentOrder.set_TrxName(null);
        });
    }

    public List<MPOS> getPOSByOrganization(int orgId) {
        return MPOS.getByOrganization(this.ctx, orgId, null);
    }

    public List<MPOS> getPOSBySalesRepresentativeAndOrganization(int salesRepresentativeId, int organizationId) {
        return MPOS.getBySalesRepresentativeAndOrganization(this.getCtx(), organizationId, salesRepresentativeId, null);
    }

    public Timestamp getToday() {
        return this.today;
    }

    public void setOrder(int orderId) {
        this.currentOrder = new MOrder(this.ctx, orderId, null);
        if (orderId != 0) {
            this.loadPriceListVersion(this.currentOrder.getM_PriceList_ID());
        }
        this.reloadOrder();
    }

    public BigDecimal[] updateLine(int orderLineId, BigDecimal qtyOrdered, BigDecimal priceLimit, BigDecimal priceEntered, BigDecimal priceList, BigDecimal discountPercentage) {
        if (!this.isDrafted()) {
            return null;
        }
        AtomicReference<BigDecimal> lineNetAmt = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> taxRate = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> grandTotal = new AtomicReference<BigDecimal>(Env.ZERO);
        Trx.run(transactionName -> {
            MOrderLine[] orderLines;
            this.currentOrder.set_TrxName(transactionName);
            for (MOrderLine orderLine : orderLines = this.currentOrder.getLines("AND C_OrderLine_ID = " + orderLineId, "Line")) {
                if (qtyOrdered.compareTo(orderLine.getQtyOrdered()) == 0 && priceEntered.compareTo(orderLine.getPriceEntered()) == 0 && discountPercentage != null && discountPercentage.compareTo(orderLine.getDiscount()) == 0) continue;
                BigDecimal price = priceEntered;
                if (discountPercentage != null && discountPercentage.compareTo(orderLine.getDiscount()) != 0) {
                    BigDecimal discountAmount = orderLine.getPriceList().multiply(discountPercentage.divide(Env.ONEHUNDRED));
                    price = orderLine.getPriceList().subtract(discountAmount);
                }
                orderLine.setPrice(price);
                orderLine.setQty(qtyOrdered);
                orderLine.setTax();
                orderLine.saveEx();
                lineNetAmt.set(orderLine.getLineNetAmt());
                taxRate.set(MTax.get(this.ctx, orderLine.getC_Tax_ID()).getRate());
                if (taxRate.get() == null) {
                    taxRate.set(Env.ZERO);
                } else {
                    taxRate.set(((BigDecimal)taxRate.get()).divide(Env.ONEHUNDRED));
                }
                grandTotal.set(((BigDecimal)lineNetAmt.get()).add(((BigDecimal)lineNetAmt.get()).multiply((BigDecimal)taxRate.get())));
            }
        });
        this.currentOrder.set_TrxName(null);
        return new BigDecimal[]{lineNetAmt.get(), taxRate.get(), grandTotal.get()};
    }

    public MOrderLine addOrUpdateLine(MProduct product, BigDecimal qtyOrdered, MProductPricing productPricing) {
        if (!this.isDrafted()) {
            return null;
        }
        AtomicReference lineToCreateOrUpdate = new AtomicReference();
        Trx.run(transactionName -> {
            this.currentOrder.set_TrxName(transactionName);
            List<MOrderLine> lines = Arrays.asList(this.currentOrder.getLines(true, "Line"));
            lines.stream().filter(orderLine -> orderLine.getM_Product_ID() == product.getM_Product_ID()).findFirst().ifPresent(orderLine -> {
                this.setOrderLineId(orderLine.getC_OrderLine_ID());
                BigDecimal currentPrice = orderLine.getPriceEntered();
                BigDecimal currentQty = orderLine.getQtyEntered();
                BigDecimal totalQty = currentQty.add(qtyOrdered);
                orderLine.setQty(this.isAddQty() ? totalQty : qtyOrdered);
                orderLine.setPrice(currentPrice);
                orderLine.saveEx();
                orderLine.set_TrxName(null);
                lineToCreateOrUpdate.set(orderLine);
            });
            if (!Optional.ofNullable(lineToCreateOrUpdate.get()).isPresent()) {
                MOrderLine orderLine2 = new MOrderLine(this.currentOrder);
                orderLine2.setProduct(product);
                orderLine2.setQty(qtyOrdered);
                orderLine2.setPrice();
                if (productPricing.getPriceStd().signum() > 0) {
                    orderLine2.setPriceLimit(productPricing.getPriceLimit());
                    orderLine2.setPrice(productPricing.getPriceStd());
                    orderLine2.setPriceList(productPricing.getPriceList());
                    this.setPriceLimit(productPricing.getPriceLimit());
                    this.setPriceList(productPricing.getPriceList());
                    BigDecimal percentageDiscount = orderLine2.getDiscount();
                    this.setDiscountPercentage(percentageDiscount);
                }
                orderLine2.saveEx();
                this.setOrderLineId(orderLine2.getC_OrderLine_ID());
                orderLine2.set_TrxName(null);
                lineToCreateOrUpdate.set(orderLine2);
            }
        });
        this.currentOrder.set_TrxName(null);
        return (MOrderLine)lineToCreateOrUpdate.get();
    }

    public String addOrUpdate(int productId, BigDecimal qtyOrdered) {
        String errorMessage = null;
        try {
            MProduct product = MProduct.get(this.ctx, productId);
            if (product == null) {
                return "@No@ @InfoProduct@";
            }
            MProductPricing productPricing = new MProductPricing(productId, this.getC_BPartner_ID(), qtyOrdered, true, null);
            productPricing.setM_PriceList_ID(this.getM_PriceList_ID());
            productPricing.calculatePrice();
            if (!this.hasOrder()) {
                return "@POS.MustCreateOrder@";
            }
            this.addOrUpdateLine(product, qtyOrdered, productPricing);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    private boolean voidOrder() {
        if (!(this.currentOrder.getDocStatus().equals("DR") || this.currentOrder.getDocStatus().equals("IP") || this.currentOrder.getDocStatus().equals("CO"))) {
            return false;
        }
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(false);
        Trx.run(transactionName -> {
            this.currentOrder.set_TrxName(transactionName);
            this.currentOrder.setDocAction("VO");
            if (this.currentOrder.processIt("VO")) {
                this.currentOrder.setDocAction("--");
                this.currentOrder.setDocStatus("VO");
                this.currentOrder.saveEx();
                result.set(true);
            } else {
                result.set(false);
            }
        });
        this.currentOrder.set_TrxName(null);
        return result.get();
    }

    public String cancelOrder() {
        String errorMsg = null;
        try {
            Trx.run(transactionName -> {
                this.currentOrder.set_TrxName(transactionName);
                int currentIndex = this.orderList.indexOf(this.currentOrder.getC_Order_ID());
                if (!this.hasOrder()) {
                    throw new AdempierePOSException("@POS.MustCreateOrder@");
                }
                if (!this.isCompleted()) {
                    this.currentOrder.deleteEx(true);
                } else if (this.isCompleted()) {
                    this.voidOrder();
                } else {
                    throw new AdempierePOSException("@POS.OrderIsNotProcessed@");
                }
                if (currentIndex >= 0) {
                    this.orderList.remove(currentIndex);
                }
                this.currentOrder = null;
                if (this.hasRecord()) {
                    if (this.isFirstRecord()) {
                        this.firstRecord();
                    } else if (this.isLastRecord()) {
                        this.lastRecord();
                    } else {
                        this.previousRecord();
                    }
                }
            });
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
        }
        this.currentOrder.set_TrxName(null);
        return errorMsg;
    }

    public void deleteLine(int orderLineId) {
        if (orderLineId != -1 && this.currentOrder != null) {
            Trx.run(transactionName -> {
                this.currentOrder.set_TrxName(transactionName);
                Arrays.asList(this.currentOrder.getLines(true, "M_Product_ID")).stream().filter(orderLine -> orderLine.getC_OrderLine_ID() == orderLineId).findFirst().ifPresent(orderLine -> orderLine.deleteEx(true));
            });
            this.currentOrder.set_TrxName(null);
        }
    }

    public void listOrder() {
        int[] orderIds;
        String sql = new String("SELECT o.C_Order_ID FROM C_Order o WHERE o.IsSOTrx='Y' AND o.Processed = 'N' AND o.AD_Client_ID = ? AND o.C_POS_ID = ? AND o.SalesRep_ID = ? ORDER BY o.Updated");
        this.orderList = new ArrayList();
        for (int orderId : orderIds = DB.getIDsEx(null, sql, Env.getAD_Client_ID(Env.getCtx()), this.getC_POS_ID(), this.getSalesRep_ID())) {
            this.orderList.add(orderId);
        }
        this.recordPosition = this.hasRecord() ? this.orderList.size() - 1 : -1;
    }

    public boolean hasRecord() {
        return !this.orderList.isEmpty();
    }

    public boolean isFirstRecord() {
        return this.recordPosition == 0;
    }

    public boolean isLastRecord() {
        return this.recordPosition == this.orderList.size() - 1;
    }

    public void previousRecord() {
        if (this.recordPosition > 0) {
            this.setOrder(this.orderList.get(--this.recordPosition));
        }
    }

    public void nextRecord() {
        if (this.recordPosition < this.orderList.size() - 1) {
            this.setOrder(this.orderList.get(++this.recordPosition));
        }
    }

    public void reloadIndex(int orderId) {
        int position = this.orderList.indexOf(orderId);
        if (position >= 0) {
            this.recordPosition = position;
        }
    }

    public void lastRecord() {
        this.recordPosition = this.orderList.size();
        if (this.recordPosition != 0) {
            --this.recordPosition;
        }
    }

    public void firstRecord() {
        this.recordPosition = this.orderList.size();
        if (this.recordPosition != 0) {
            this.recordPosition = 0;
        }
    }

    public boolean processOrder(String trxName, boolean isPrepayment, boolean isPaid) {
        boolean orderCompleted = this.isCompleted();
        if (orderCompleted) {
            this.setIsToPrint(false);
        } else {
            if (trxName == null) {
                trxName = this.currentOrder.get_TrxName();
            } else {
                this.currentOrder.set_TrxName(trxName);
            }
            if (this.currentOrder.getDocStatus().equalsIgnoreCase("IN")) {
                this.currentOrder.setDocStatus("IP");
            }
            this.currentOrder.setDocAction("CO");
            this.currentOrder.setC_POS_ID(this.getC_POS_ID());
            this.currentOrder.saveEx();
            if (this.currentOrder.processIt("CO")) {
                this.currentOrder.saveEx();
                orderCompleted = true;
                this.setIsToPrint(true);
            } else {
                this.log.info("Process Order FAILED " + this.currentOrder.getProcessMsg());
                this.currentOrder.saveEx();
                return orderCompleted;
            }
        }
        this.reloadOrder();
        this.currentOrder.set_TrxName(trxName);
        if (isPaid && !this.isStandardOrder() && !this.isPreInvoicedOrder()) {
            if (!this.isDelivered()) {
                this.generateShipment(trxName);
            }
            if (!this.isInvoiced() && ("I".equals(this.currentOrder.getInvoiceRule()) || "D".equals(this.currentOrder.getInvoiceRule()) && this.isDelivered())) {
                this.generateInvoice(trxName);
            }
            orderCompleted = true;
        }
        return orderCompleted;
    }

    private void generateShipment(String trxName) {
        ArrayList<Integer> selectionIds = new ArrayList<Integer>();
        selectionIds.add(this.getC_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(InOutGenerateAbstract.getProcessId()).withTitle(Msg.parseTranslation(this.getCtx(), "@InOutGenerateGen@")).withParameter("M_Warehouse_ID", this.getM_Warehouse_ID()).withParameter("Selection", true).withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withoutTransactionClose().execute(trxName);
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    public void completeReturn() {
        Trx.run(new TrxRunnable(){

            @Override
            public void run(String trxName) {
                String error = CPOS.this.completeReturn(trxName);
                if (error != null) {
                    throw new AdempiereException(error);
                }
                if (CPOS.this.isToPrint()) {
                    CPOS.this.printTicket();
                }
            }
        });
    }

    private String completeReturn(String trxName) {
        if (this.isDrafted() || this.isInProgress() || this.isInvalid()) {
            if (!this.processOrder(trxName, false, false)) {
                return Msg.parseTranslation(this.getCtx(), " @ProcessRunError@. @order.no@: " + this.getDocumentNo() + ". @Process@: " + CommandManager.COMPLETE_DOCUMENT);
            }
            String docSubTypeSO = this.getDocSubTypeSO();
            if ((docSubTypeSO.equals("SO") || docSubTypeSO.equals("WI") || docSubTypeSO.equals("WP")) && this.isCompleted()) {
                return "@POS.IsNotReturn@";
            }
        }
        MOrder returnOrder = new MOrder(this.getCtx(), this.getC_Order_ID(), trxName);
        returnOrder.setInvoiceRule("I");
        returnOrder.setDeliveryRule("F");
        returnOrder.saveEx();
        ArrayList<Integer> selectionIds = new ArrayList<Integer>();
        selectionIds.add(returnOrder.get_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(InOutGenerate.getProcessId()).withParameter("M_Warehouse_ID", this.getM_Warehouse_ID()).withParameter("Selection", true).withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withoutTransactionClose().execute(trxName);
        if (processInfo.isError()) {
            return processInfo.getLogInfo();
        }
        for (MInOut customerReturn : returnOrder.getShipments()) {
            customerReturn.processIt("CO");
            customerReturn.saveEx();
            for (MInOutConfirm confirm : customerReturn.getConfirmations(true)) {
                for (MInOutLineConfirm confirmLine : confirm.getLines(true)) {
                    confirmLine.setConfirmedQty(confirmLine.getTargetQty());
                    confirmLine.saveEx();
                }
                confirm.processIt("CO");
                confirm.saveEx();
            }
        }
        MOrder sourceOrder = (MOrder)returnOrder.getRef_Order();
        if (sourceOrder != null && returnOrder.getC_Order_ID() > 0) {
            if (sourceOrder.getInvoices().length > 0) {
                processInfo = ProcessBuilder.create(this.getCtx()).process(InvoiceGenerate.getProcessId()).withTitle(processInfo.getTitle()).withParameter("Selection", true).withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withParameter("DocAction", "CO").withoutTransactionClose().execute(trxName);
                if (processInfo.isError()) {
                    return processInfo.getLogInfo();
                }
            } else {
                Timestamp today = new Timestamp(System.currentTimeMillis());
                MPayment payment = new MPayment(returnOrder.getCtx(), 0, returnOrder.get_TrxName());
                payment.setDateTrx(today);
                payment.setC_Order_ID(returnOrder.getC_Order_ID());
                payment.setC_BankAccount_ID(this.getC_BankAccount_ID());
                payment.setDateAcct(today);
                payment.addDescription(Msg.parseTranslation(returnOrder.getCtx(), " @C_Order_ID@ " + returnOrder.getDocumentNo()));
                payment.setIsReceipt(false);
                payment.setC_DocType_ID(MDocType.getDocType("APP"));
                payment.setAmount(returnOrder.getC_Currency_ID(), returnOrder.getGrandTotal());
                payment.setDocAction("CO");
                payment.setDocStatus("DR");
                payment.setIsPrepayment(true);
                payment.saveEx();
                payment.processIt("CO");
                payment.saveEx();
                returnOrder.setC_POS_ID(this.getC_POS_ID());
                returnOrder.saveEx();
                processInfo.addLog(0, null, null, payment.getDocumentInfo());
            }
        }
        this.setIsToPrint(true);
        return null;
    }

    private void generateInvoice(String trxName) {
        ArrayList<Integer> selectionIds = new ArrayList<Integer>();
        selectionIds.add(this.getC_Order_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(InvoiceGenerate.getProcessId()).withTitle(Msg.parseTranslation(this.getCtx(), "@InvGenerateGen@")).withParameter("Selection", true).withParameter("AD_Org_ID", this.currentOrder.getAD_Org_ID()).withParameter("DocAction", "CO").withSelectedRecordsIds(MOrder.Table_ID, selectionIds).withoutTransactionClose().execute(trxName);
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }

    public String getProcessMsg() {
        return this.currentOrder.getProcessMsg();
    }

    public void setC_PaymentTerm_ID(int paymentTermId) {
        if (paymentTermId != 0 && this.hasOrder() && !this.isCompleted() && !this.isVoided()) {
            this.currentOrder.setC_PaymentTerm_ID(paymentTermId);
        }
    }

    public int getC_PaymentTerm_ID() {
        if (this.hasOrder()) {
            return this.currentOrder.getC_PaymentTerm_ID();
        }
        return 0;
    }

    public BigDecimal getTaxAmt() {
        BigDecimal taxAmt = Env.ZERO;
        for (MOrderTax tax : this.currentOrder.getTaxes(true)) {
            taxAmt = taxAmt.add(tax.getTaxAmt());
        }
        return taxAmt;
    }

    public BigDecimal getTotalLines() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal().subtract(this.getTaxAmt());
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getGrandTotal() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal();
        }
        return BigDecimal.ZERO;
    }

    public String getDocumentNo() {
        return this.currentOrder.getDocumentNo();
    }

    public String getDeliveryRule() {
        return this.entityPOS.getDeliveryRule();
    }

    public String getInvoiceRule() {
        return this.entityPOS.getInvoiceRule();
    }

    public BigDecimal getOpenAmt() {
        if (this.currentOrder != null) {
            return this.currentOrder.getGrandTotal().subtract(this.getAmountReceived());
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAmountReceived() {
        int orderId = this.getOrder().getC_Order_ID();
        if (this.receivedAmount == null) {
            this.receivedAmount = new HashMap();
        }
        if (this.receivedAmount.get(orderId) == null) {
            AtomicReference<BigDecimal> amount = new AtomicReference<BigDecimal>(Env.ZERO);
            MPayment.getOfOrder(this.getOrder()).forEach(payment -> {
                BigDecimal cfr_ignored_0 = (BigDecimal)amount.updateAndGet(amountToUpdate -> amountToUpdate.add(this.getConvertedPaymentAmount(payment.getPayAmt(), payment.getC_Currency_ID(), payment.getDateTrx())));
            });
            this.receivedAmount.put(orderId, amount.get());
        }
        return this.receivedAmount.get(orderId);
    }

    private BigDecimal getConvertedPaymentAmount(BigDecimal paymentAmount, int currencyId, Timestamp transactionDate) {
        if (this.getC_Currency_ID() <= 0 || currencyId <= 0 || this.getOrder().getC_Currency_ID() <= 0) {
            return paymentAmount;
        }
        BigDecimal currencyRate = MConversionRate.getRate(currencyId, this.getC_Currency_ID(), transactionDate, this.getM_POS().getC_ConversionType_ID(), this.getOrder().getAD_Client_ID(), this.getOrder().getAD_Org_ID());
        if (currencyRate == null || currencyRate.compareTo(Env.ZERO) == 0) {
            currencyRate = Env.ONE;
        }
        MCurrency currency = MCurrency.get(this.getCtx(), this.getC_Currency_ID());
        return paymentAmount.multiply(currencyRate, MathContext.DECIMAL128).setScale(currency.getStdPrecision(), 4);
    }

    public boolean isPaid() {
        return this.getOpenAmt().signum() == 0;
    }

    public BigDecimal getPaidAmt() {
        BigDecimal receivedInvoices = BigDecimal.ZERO;
        BigDecimal receivedPrePayments = BigDecimal.ZERO;
        BigDecimal receivedCash = BigDecimal.ZERO;
        BigDecimal receivedTotal = BigDecimal.ZERO;
        String payment = "C_Payment";
        String allocation = "C_AllocationHdr";
        String allocationLine = "C_AllocationLine";
        String cashLine = "C_CashLine";
        String orderId = "C_Order_ID";
        String invoiceId = "C_Invoice_ID";
        String allocationId = "C_AllocationHdr_ID";
        String payAmt = "PayAmt";
        String documentStatus = "DocStatus";
        String amount = "Amount";
        if (this.currentOrder != null) {
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("C_Order_ID").append("=?").append(" AND ").append("DocStatus").append(" IN ('CO','CL') ");
            receivedPrePayments = new Query(this.getCtx(), "C_Payment", whereClause.toString(), null).setClient_ID().setParameters(this.currentOrder.getC_Order_ID()).sum("PayAmt");
            if (receivedPrePayments == null) {
                receivedPrePayments = Env.ZERO;
            }
            if (this.currentOrder.getC_Invoice_ID() > 1) {
                whereClause = new StringBuilder();
                whereClause.append("EXISTS (SELECT 1 FROM ").append("C_AllocationHdr").append(" WHERE ").append("C_AllocationHdr").append(".").append("C_AllocationHdr_ID").append("=").append("C_AllocationLine").append(".").append("C_AllocationHdr_ID").append(" AND ").append("C_AllocationHdr").append(".").append("DocStatus").append(" IN ('CO','CL') AND ").append("C_AllocationLine").append(".").append("C_Invoice_ID").append("=?)");
                receivedInvoices = new Query(this.getCtx(), "C_AllocationLine", whereClause.toString(), null).setClient_ID().setParameters(this.currentOrder.getC_Invoice_ID()).sum("Amount");
                if (receivedInvoices == null) {
                    receivedInvoices = Env.ZERO;
                }
                whereClause = new StringBuilder();
                whereClause.append("C_Invoice_ID").append("=?");
                receivedCash = new Query(this.getCtx(), "C_CashLine", whereClause.toString(), null).setClient_ID().setParameters(this.currentOrder.getC_Invoice_ID()).sum("Amount");
                if (receivedCash == null) {
                    receivedCash = Env.ZERO;
                }
            }
        }
        receivedTotal = receivedInvoices.add(receivedPrePayments).add(receivedCash);
        return receivedTotal;
    }

    public void reloadOrder() {
        if (this.currentOrder == null) {
            if (this.recordPosition != -1 && this.recordPosition < this.orderList.size()) {
                this.setOrder(this.orderList.get(this.recordPosition));
            }
            return;
        }
        Trx.run(transactionName -> {
            this.currentOrder.set_TrxName(transactionName);
            if (this.isDrafted() && TimeUtil.getDay(this.currentOrder.getDateOrdered()).before(TimeUtil.getDay(this.getToday()))) {
                this.currentOrder.setDateOrdered(this.getToday());
                this.currentOrder.saveEx();
            }
            if (this.isDrafted() && this.currentOrder.getAD_Org_ID() != this.getAD_Org_ID()) {
                this.currentOrder.setAD_Org_ID(this.getAD_Org_ID());
                this.currentOrder.saveEx();
            }
            this.currentOrder.load(this.currentOrder.get_TrxName());
            this.currentOrder.getLines(true, "Line");
            this.partner = MBPartner.get(this.getCtx(), this.currentOrder.getC_BPartner_ID());
            this.clearValues();
        });
        this.currentOrder.set_TrxName(null);
    }

    private void clearValues() {
        this.receivedAmount = null;
    }

    public int getM_PriceList_Version_ID() {
        return this.priceListVersionId;
    }

    public int getM_PriceList_ID() {
        return this.priceListId;
    }

    public MPriceListVersion loadPriceListVersion(int priceListId) {
        this.priceListVersionId = 0;
        this.priceListId = priceListId;
        MPriceList priceList = MPriceList.get(this.ctx, priceListId, null);
        MPriceListVersion priceListVersion = priceList.getPriceListVersion(this.getToday());
        if (priceListVersion != null && priceListVersion.getM_PriceList_Version_ID() != 0) {
            this.priceListVersionId = priceListVersion.getM_PriceList_Version_ID();
        }
        return priceListVersion;
    }

    public int getM_Warehouse_ID() {
        return this.entityPOS.getM_Warehouse_ID();
    }

    public void validLocator() {
        MLocator[] locators;
        MWarehouse warehouse = MWarehouse.get(this.ctx, this.getM_Warehouse_ID());
        for (MLocator mLocator : locators = warehouse.getLocators(true)) {
            if (!mLocator.isDefault()) continue;
            return;
        }
        throw new AdempierePOSException("@M_Locator_ID@ @default@ @not.found@ @M_Warehouse_ID@: " + warehouse.getName());
    }

    public String getWarehouseName() {
        if (this.getM_Warehouse_ID() > 0) {
            MWarehouse.get(this.ctx, this.getM_Warehouse_ID()).getName();
        }
        return "";
    }

    public String getDocumentTypeName() {
        MDocType m_DocType;
        if (this.hasOrder() && (m_DocType = MDocType.get(this.getCtx(), this.currentOrder.getC_DocTypeTarget_ID())) != null) {
            return m_DocType.getName();
        }
        return "";
    }

    public Timestamp getDateOrdered() {
        if (this.hasOrder()) {
            return this.currentOrder.getDateOrdered();
        }
        return null;
    }

    public String getCurSymbol() {
        MCurrency currency;
        int currencyId = this.getC_Currency_ID();
        if (currencyId > 0 && (currency = MCurrency.get(this.getCtx(), currencyId)) != null) {
            return currency.getCurSymbol();
        }
        return "";
    }

    public ValueNamePair[] getCreditCards(BigDecimal amt) {
        try {
            MPaymentProcessor[] paymentProcessors = MPaymentProcessor.find(Env.getCtx(), null, null, this.currentOrder.getAD_Client_ID(), this.currentOrder.getAD_Org_ID(), this.currentOrder.getC_Currency_ID(), amt, this.currentOrder.get_TrxName());
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < paymentProcessors.length; ++i) {
                if (paymentProcessors[i].isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (paymentProcessors[i].isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (paymentProcessors[i].isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (paymentProcessors[i].isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (paymentProcessors[i].isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (!paymentProcessors[i].isAcceptVisa()) continue;
                map.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            this.log.fine("getCreditCards - #" + retValue.length + " - Processors=" + paymentProcessors.length);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ValueNamePair[] getCreditNotes() {
        try {
            String whereClause = "C_BPartner_ID = ? AND IsPaid ='N' AND EXISTS(SELECT 1 \t\t\t\tFROM C_DocType dt \t\t\t\tWHERE dt.C_DocType_ID = C_Invoice.C_DocType_ID \t\t\t\tAND dt.DocBaseType ='ARC')";
            List invoiceList = new Query(Env.getCtx(), "C_Invoice", whereClause, null).setParameters(this.currentOrder.getC_BPartner_ID()).list();
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (MInvoice invoice : invoiceList) {
                Integer id = invoice.getC_Invoice_ID();
                ValueNamePair valueNamePair = new ValueNamePair(id.toString(), invoice.getDocumentNo() + " " + invoice.getOpenAmt().toString());
                map.put(invoice.getDocumentNo(), valueNamePair);
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String CreditCardType) {
        return new ValueNamePair(CreditCardType, this.getCreditCardName(CreditCardType));
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public int getOSKeyLayout_ID() {
        if (this.entityPOS != null) {
            return this.entityPOS.getOSK_KeyLayout_ID();
        }
        return 0;
    }

    public int getC_POSKeyLayout_ID() {
        if (this.entityPOS != null) {
            return this.entityPOS.getC_POSKeyLayout_ID();
        }
        return 0;
    }

    public boolean isModifyPrice() {
        return this.entityPOS.isModifyPrice();
    }

    public int getC_Order_ID() {
        int m_C_Order_ID = 0;
        if (this.hasOrder()) {
            m_C_Order_ID = this.currentOrder.getC_Order_ID();
        }
        return m_C_Order_ID;
    }

    public void saveNextSeq(String trxName) {
        int next = this.documentSequence.getCurrentNext() + this.documentSequence.getIncrementNo();
        this.documentSequence.setCurrentNext(next);
        this.documentSequence.saveEx(trxName);
    }

    public String getSequenceDoc(String trxName) {
        this.documentSequence = new MSequence(Env.getCtx(), this.getAD_Sequence_ID(), trxName);
        return this.documentSequence.getPrefix() + this.documentSequence.getCurrentNext();
    }

    public void setPOReference(String documentNo) {
        String trxName = this.currentOrder.get_TrxName();
        Trx trx = Trx.get(trxName, true);
        this.currentOrder.setPOReference(documentNo);
        this.currentOrder.saveEx(trx.getTrxName());
        trx.close();
    }

    public BigDecimal getQty() {
        return this.quantity;
    }

    public void setQty(BigDecimal qty) {
        this.quantity = qty;
    }

    public BigDecimal getQtyAdded() {
        BigDecimal quantityAddedReturn = this.quantityAdded;
        this.quantityAdded = Env.ZERO;
        this.setAddQty(false);
        return quantityAddedReturn;
    }

    public void setQtyAdded(BigDecimal qtyAdded) {
        this.quantityAdded = qtyAdded;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(BigDecimal discountPercentage) {
        this.discountPercentage = discountPercentage;
    }

    public void setPriceLimit(BigDecimal priceLimit) {
        this.priceLimit = priceLimit;
    }

    public BigDecimal getPriceLimit() {
        return this.priceLimit;
    }

    public BigDecimal getPriceList() {
        return this.priceList;
    }

    public void setPriceList(BigDecimal priceList) {
        this.priceList = priceList;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setPrice(MProductPricing productPricing) {
        this.setPriceLimit(productPricing.getPriceLimit());
        this.setPrice(productPricing.getPriceStd());
        this.setPriceList(productPricing.getPriceList());
    }

    public String getElectronicScales() {
        if (this.entityPOS != null) {
            return this.entityPOS.getElectronicScales();
        }
        return null;
    }

    public String getMeasureRequestCode() {
        if (this.entityPOS != null) {
            return this.entityPOS.getMeasureRequestCode();
        }
        return null;
    }

    public boolean isPresentElectronicScales() {
        if (this.getElectronicScales() != null) {
            return this.getElectronicScales().length() > 0;
        }
        return false;
    }

    public boolean IsShowLineControl() {
        return true;
    }

    public boolean isVirtualKeyboard() {
        return this.getOSKeyLayout_ID() > 0;
    }

    public int getProductImageId(int productId, int posKeyLayoutId) {
        int imageId = 0;
        if (productId == 0) {
            return imageId;
        }
        int m_C_POSKey_ID = DB.getSQLValue(null, "SELECT pk.C_POSKey_ID FROM C_POSKey pk WHERE pk.C_POSKeyLayout_ID = ? AND pk.M_Product_ID = ? AND pk.IsActive = 'Y'", posKeyLayoutId, productId);
        if (m_C_POSKey_ID > 0) {
            MPOSKey key = new MPOSKey(this.ctx, m_C_POSKey_ID, null);
            imageId = key.getAD_Image_ID();
        } else {
            m_C_POSKey_ID = DB.getSQLValue(null, "SELECT pk2.C_POSKey_ID FROM C_POSKey pk1 INNER JOIN C_POSKey pk2 ON pk1.subkeylayout_id=pk2.c_poskeylayout_id AND pk1.subkeylayout_id IS NOT NULL WHERE pk2.M_Product_ID = ? AND pk1.IsActive = 'Y' AND pk2.IsActive = 'Y'", productId);
            if (m_C_POSKey_ID > 0) {
                MPOSKey key = new MPOSKey(this.ctx, m_C_POSKey_ID, null);
                imageId = key.getAD_Image_ID();
            }
        }
        return imageId;
    }

    public int getM_Product_ID(int orderLineId) {
        return DB.getSQLValue(null, "SELECT ol.M_Product_ID FROM C_OrderLine ol WHERE ol.C_OrderLine_ID = ?", orderLineId);
    }

    public boolean isValidUserPin(char[] userPin) {
        if (userPin == null || userPin.length == 0) {
            return false;
        }
        int supervisorId = this.entityPOS.getSupervisor_ID();
        MUser user = MUser.get(this.getCtx(), supervisorId > 0 ? supervisorId : this.getSalesRep_ID());
        boolean isCorrect = false;
        if (supervisorId <= 0) {
            supervisorId = user.getSupervisor_ID();
        }
        if (supervisorId > 0) {
            int i;
            MUser supervisor = MUser.get(this.getCtx(), supervisorId);
            Optional<String> superVisorName = Optional.ofNullable(supervisor.getName());
            if (supervisor.getUserPIN() == null || supervisor.getUserPIN().isEmpty()) {
                throw new AdempierePOSException("@Supervisor@ \"" + superVisorName.orElseGet(() -> "") + "\": @UserPIN@ @NotFound@");
            }
            char[] correctPassword = supervisor.getUserPIN().toCharArray();
            isCorrect = true;
            if (userPin.length != correctPassword.length) {
                isCorrect = false;
            } else {
                for (i = 0; i < userPin.length; ++i) {
                    if (userPin[i] == correctPassword[i]) continue;
                    isCorrect = false;
                }
            }
            for (i = 0; i < correctPassword.length; ++i) {
                correctPassword[i] = '\u0000';
            }
        } else {
            isCorrect = new Query(this.getCtx(), "AD_User", "IsPOSManager = 'Y' AND UserPIN = ?", null).setParameters(String.valueOf(userPin)).setClient_ID().setOnlyActiveRecords(true).match();
        }
        return isCorrect;
    }

    public String getProductValue(int productId) {
        return MProduct.get(this.getCtx(), productId).getValue();
    }

    public String getProductName(int productId) {
        return MProduct.get(this.getCtx(), productId).getName();
    }

    public static List<Vector<Object>> getQueryProduct(int referenceProductId, String productCode, int warehouseId, int priceListId, int partnerId) {
        ArrayList<Vector<Object>> rows = new ArrayList<Vector<Object>>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT p.M_Product_ID , p.Value, p.Name, coalesce(p.UPC, '') AS UPC ").append(" FROM M_Product p WHERE EXISTS(SELECT 1 FROM M_PriceList_Version plv INNER JOIN M_ProductPrice pp ON(pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID) WHERE plv.M_PriceList_ID = ? AND plv.ValidFrom <= ? AND plv.IsActive = 'Y' AND pp.PriceStd IS NOT NULL AND pp.PriceStd > 0 AND pp.M_Product_ID = p.M_Product_ID)AND p.AD_Client_ID=? AND p.IsActive='Y' AND p.IsSold=? AND p.Discontinued=? AND ");
        if (referenceProductId > 0) {
            sql.append("p.M_Product_ID = ").append(referenceProductId);
        } else {
            sql.append("(").append("UPPER(p.Name)  LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.Value) LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.UPC)   LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(" OR UPPER(p.SKU)   LIKE UPPER('").append("%").append(productCode.replace(" ", "%")).append("%").append("')").append(")");
        }
        CPreparedStatement statement = null;
        try {
            statement = DB.prepareStatement(sql.toString(), null);
            int count = 1;
            statement.setInt(count, priceListId);
            statement.setTimestamp(++count, Env.getContextAsDate(Env.getCtx(), "#Date"));
            statement.setInt(++count, Env.getAD_Client_ID(Env.getCtx()));
            statement.setString(++count, "Y");
            statement.setString(++count, "N");
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Vector<Object> columns = new Vector<Object>();
                Integer productId = resultSet.getInt("M_Product_ID");
                String productValue = resultSet.getString("Value").trim();
                String productName = resultSet.getString("Name").trim();
                String upc = resultSet.getString("UPC").trim();
                columns.add(productId);
                columns.add(productValue);
                columns.add(productName);
                columns.add(upc);
                rows.add(columns);
            }
            DB.close(resultSet, statement);
            statement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return rows;
    }

    public void printTicket() {
        if (!this.hasOrder()) {
            return;
        }
        POSTicketHandler ticketHandler = POSTicketHandler.getTicketHandler(this);
        if (ticketHandler == null) {
            return;
        }
        ticketHandler.printTicket();
    }

    public void setAddQty(boolean isAddQty) {
        this.isAddQty = isAddQty;
    }

    public boolean isAddQty() {
        return this.isAddQty;
    }

    public int getOrderLineId() {
        return this.orderLineId;
    }

    public void setOrderLineId(int orderLineId) {
        this.orderLineId = orderLineId;
    }

    public String getTotaLinesForView() {
        return this.getNumberFormat().format(this.getTotalLines());
    }

    public String getGrandTotalForView() {
        return this.getNumberFormat().format(this.getGrandTotal());
    }

    public String getTaxAmtForView() {
        return this.getNumberFormat().format(this.getGrandTotal().subtract(this.getTotalLines()));
    }

    public String getDateOrderedForView() {
        return this.getDateFormat().format(this.getDateOrdered());
    }

    public String getTicketHandlerClassName() {
        return this.entityPOS.getTicketClassName();
    }

    public String get_TrxName() {
        if (!this.hasOrder()) {
            return null;
        }
        return this.currentOrder.get_TrxName();
    }
}

