/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.search;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.sql.ResultSet;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.grid.VPOSBPartner;
import org.adempiere.pos.search.POSQuery;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MDocType;
import org.compiere.model.PO;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryDocType
extends POSQuery {
    private static final long serialVersionUID = -7109518709654253628L;
    private POSTextField f_Name;
    private POSTextField f_Description;
    private int m_C_DocType_ID;
    private String m_DocTypeName;
    private static CLogger log = CLogger.getCLogger(QueryDocType.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_DocType_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Description"), "Description", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "SeqNo"), "SeqNo", String.class)};
    private static String s_sqlFrom = "C_DocType";
    private static String s_sqlWhere = "IsActive='Y'";

    public QueryDocType(VPOS posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        this.setTitle(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.parameterPanel.setLayout((LayoutManager)new MigLayout("fill", "", "[50][50][]"));
        this.parameterPanel.setBorder(new TitledBorder(Msg.getMsg(this.ctx, "Query")));
        CLabel lname = new CLabel(Msg.translate(this.ctx, "Name"));
        this.parameterPanel.add((Component)lname, " growy");
        this.f_Name = new POSTextField("", this.posPanel.getKeyboard());
        lname.setLabelFor(this.f_Name);
        this.parameterPanel.add((Component)this.f_Name, "h 30, w 200");
        this.f_Name.addActionListener(this);
        CLabel ldescription = new CLabel(Msg.translate(this.ctx, "Description"));
        this.parameterPanel.add((Component)ldescription, " growy");
        this.f_Description = new POSTextField("", this.posPanel.getKeyboard());
        lname.setLabelFor(this.f_Description);
        this.parameterPanel.add((Component)this.f_Description, "h 30, w 200");
        this.f_Description.addActionListener(this);
        this.posTable.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "C_DocType");
        this.posTable.growScrollbars();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryDocType.this.f_Name.requestFocus();
            }
        });
    }

    @Override
    protected void newAction() {
        super.newAction();
        VPOSBPartner t = new VPOSBPartner(new Frame(), 0, this.posPanel);
        t.setVisible(true);
        this.m_C_DocType_ID = t.getC_BPartner_ID();
        this.close();
    }

    @Override
    public void editAction() {
        super.editAction();
        VPOSBPartner t = new VPOSBPartner(new Frame(), 1, this.posPanel);
        this.select();
        t.loadBPartner(this.m_C_DocType_ID);
        t.setVisible(true);
        this.close();
    }

    private void setResultsFromArray(MDocType[] results) {
        this.posTable.loadTable(results);
        int rowCount = this.posTable.getRowCount();
        if (rowCount > 0) {
            this.posTable.setRowSelectionInterval(0, 0);
            if (rowCount == 1) {
                this.select();
            }
        }
    }

    @Override
    public void setResults(PO[] results) {
        if (results == null || !(results instanceof MDocType[])) {
            return;
        }
        this.setResultsFromArray((MDocType[])results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        block7: {
            StringBuffer sql = new StringBuffer();
            CPreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                sql.append(" SELECT dt.C_DocType_ID, dt.Name, sq.Name, (COALESCE(sq.Prefix, '') || sq.CurrentNext || COALESCE(sq.Suffix, '')) SeqNo").append(" FROM C_DocType dt").append(" LEFT JOIN AD_Sequence sq ON (sq.AD_Sequence_ID = dt.DocNoSequence_ID)").append(" WHERE dt.AD_Client_ID = ? AND dt.AD_Org_ID IN (0, ?)").append(" AND dt.isActive='Y'").append(" AND dt.DocBaseType='SOO'").append(" AND dt.DocSubTypeSO IN(?, ?, ?, ?, ?, ?)").append(" ORDER BY dt.Name");
                int i = 1;
                pstm = DB.prepareStatement(sql.toString(), null);
                pstm.setInt(i++, Env.getAD_Client_ID(this.ctx));
                pstm.setInt(i++, this.posPanel.getAD_Org_ID());
                pstm.setString(i++, "WR");
                pstm.setString(i++, "WI");
                pstm.setString(i++, "SO");
                pstm.setString(i++, "PR");
                pstm.setString(i++, "WP");
                pstm.setString(i++, "IO");
                rs = pstm.executeQuery();
                this.posTable.loadTable(rs);
                int rowNo = this.posTable.getRowCount();
                if (rowNo > 0) {
                    this.posTable.setRowSelectionInterval(0, 0);
                    if (rowNo == 1) {
                        this.select();
                    }
                }
                DB.close(rs);
            }
            catch (Exception e) {
                log.severe("QueryTicket.setResults: " + e + " -> " + sql);
                break block7;
            }
            finally {
                DB.close(rs);
                DB.close(pstm);
                this.setCursor(Cursor.getDefaultCursor());
            }
            DB.close(pstm);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void select() {
        Integer ID;
        boolean enabled;
        this.cleanValues();
        int row = this.posTable.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.posTable.getSelectedRowKey()) != null) {
            this.m_C_DocType_ID = ID;
            this.m_DocTypeName = (String)this.posTable.getValueAt(row, 2);
        }
        log.fine("C_BPartner_ID=" + this.m_C_DocType_ID);
    }

    @Override
    protected void close() {
        this.dispose();
    }

    @Override
    public void reset() {
        this.f_Name.setText(null);
        this.setResults(new MBPartnerInfo[0]);
        this.cleanValues();
    }

    @Override
    public void refresh() {
        this.cleanValues();
        this.setResults(null);
    }

    private void cleanValues() {
        this.m_C_DocType_ID = -1;
        this.m_DocTypeName = null;
    }

    @Override
    protected void cancel() {
        this.cleanValues();
        this.dispose();
    }

    @Override
    public int getRecord_ID() {
        return this.m_C_DocType_ID;
    }

    @Override
    public String getValue() {
        return this.m_DocTypeName;
    }
}

