/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.adempiere.pos.process.CreateOrderBasedOnAnotherAbstract;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_M_InOut;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBankStatement;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.OrderRMACreateFrom;
import org.spin.process.OrderRMACreateFromInvoice;

public class CreateOrderBasedOnAnother
extends CreateOrderBasedOnAnotherAbstract {
    private Timestamp today;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.today = new Timestamp(System.currentTimeMillis());
        MOrder sourceOrder = new MOrder(this.getCtx(), this.getOrderSourceId(), this.get_TrxName());
        MOrder returnOrder = null;
        List<MInOut> shipments = Arrays.asList(sourceOrder.getShipments());
        if (shipments.size() > 0) {
            returnOrder = this.createReturnSource(sourceOrder);
            ArrayList<Integer> selectedRecordsIds = new ArrayList<Integer>();
            ProcessBuilder builder = ProcessBuilder.create(this.getCtx()).process(OrderRMACreateFrom.getProcessId()).withRecordId(I_C_Order.Table_ID, returnOrder.getC_Order_ID());
            LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection = new LinkedHashMap<Integer, LinkedHashMap<String, Object>>();
            shipments.forEach(sourceShipment -> Arrays.asList(sourceShipment.getLines()).forEach(sourceShipmentLine -> {
                LinkedHashMap<String, Number> selectionValues = new LinkedHashMap<String, Number>();
                selectionValues.put("CF_M_Product_ID", sourceShipmentLine.getM_Product_ID());
                selectionValues.put("CF_C_Charge_ID", sourceShipmentLine.getC_Charge_ID());
                selectionValues.put("CF_C_UOM_ID", sourceShipmentLine.getC_UOM_ID());
                selectionValues.put("CF_QtyEntered", sourceShipmentLine.getQtyEntered());
                selectedRecordsIds.add(sourceShipmentLine.getM_InOutLine_ID());
                selection.put(sourceShipmentLine.getM_InOutLine_ID(), selectionValues);
            }));
            builder.withSelectedRecordsIds(I_M_InOut.Table_ID, selectedRecordsIds, selection).withoutTransactionClose().execute(this.get_TrxName());
        } else {
            List<MInvoice> invoices = Arrays.asList(sourceOrder.getInvoices());
            if (invoices.size() > 0) {
                returnOrder = this.createReturnSource(sourceOrder);
                ArrayList<Integer> selectedRecordsIds = new ArrayList<Integer>();
                ProcessBuilder builder = ProcessBuilder.create(this.getCtx()).process(OrderRMACreateFromInvoice.getProcessId()).withRecordId(I_C_Order.Table_ID, returnOrder.getC_Order_ID());
                LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection = new LinkedHashMap<Integer, LinkedHashMap<String, Object>>();
                invoices.forEach(invoice -> Arrays.asList(invoice.getLines()).forEach(sourceInvoiceLine -> {
                    LinkedHashMap<String, Number> selectionValues = new LinkedHashMap<String, Number>();
                    selectionValues.put("CF_M_Product_ID", sourceInvoiceLine.getM_Product_ID());
                    selectionValues.put("CF_C_Charge_ID", sourceInvoiceLine.getC_Charge_ID());
                    selectionValues.put("CF_C_UOM_ID", sourceInvoiceLine.getC_UOM_ID());
                    selectionValues.put("CF_QtyEntered", sourceInvoiceLine.getQtyEntered());
                    selectedRecordsIds.add(sourceInvoiceLine.getC_InvoiceLine_ID());
                    selection.put(sourceInvoiceLine.getC_InvoiceLine_ID(), selectionValues);
                }));
                builder.withSelectedRecordsIds(I_M_InOut.Table_ID, selectedRecordsIds, selection).withoutTransactionClose().execute(this.get_TrxName());
            }
        }
        this.addLog(returnOrder.getDocumentNo());
        this.getProcessInfo().setRecord_ID(returnOrder.get_ID());
        String message = "@C_Order_ID@ " + returnOrder.getDocumentNo();
        if (!returnOrder.isProcessed()) {
            return message;
        }
        if (this.getIsIncludePayments() != null && this.getIsIncludePayments().equals("Y")) {
            this.createPayments(sourceOrder, returnOrder);
        }
        if (this.getIsAllocated() != null && this.getIsAllocated().equals("Y")) {
            this.createAllocations(returnOrder);
        }
        return message;
    }

    private MOrder createReturnSource(MOrder source) {
        MOrder target = new MOrder(this.getCtx(), 0, this.get_TrxName());
        target.set_TrxName(this.get_TrxName());
        PO.copyValues(source, target, false);
        target.setDocStatus("DR");
        target.setDocAction("CO");
        target.setIsSelected(false);
        target.setDateOrdered(this.today);
        target.setDateAcct(this.today);
        target.setDatePromised(this.today);
        target.setDatePrinted(null);
        target.setIsPrinted(false);
        target.setIsApproved(false);
        target.setIsCreditApproved(false);
        target.setC_Payment_ID(0);
        target.setC_CashLine_ID(0);
        target.setGrandTotal(Env.ZERO);
        target.setTotalLines(Env.ZERO);
        target.setIsDelivered(false);
        target.setIsInvoiced(false);
        target.setIsSelfService(false);
        target.setIsTransferred(false);
        target.setPosted(false);
        target.setProcessed(false);
        target.save(source.get_TrxName());
        if (this.getDocTypeRMAId() != 0) {
            target.setC_DocTypeTarget_ID(this.getDocTypeRMAId());
        } else {
            target.setC_DocTypeTarget_ID(MDocType.getDocTypeBaseOnSubType(source.getAD_Org_ID(), "SOO", "RM"));
        }
        target.setC_BPartner_ID(this.getBPartnerId());
        target.setRef_Order_ID(source.getC_Order_ID());
        target.setProcessed(false);
        target.saveEx();
        return target;
    }

    private void createAllocations(MOrder targetOrder) {
        List<MPayment> payments = MPayment.getOfOrder(targetOrder);
        MInvoice[] invoices = targetOrder.getInvoices();
        BigDecimal totalPay = BigDecimal.ZERO;
        BigDecimal totalInvoiced = BigDecimal.ZERO;
        for (MPayment payment : payments) {
            totalPay = totalPay.add(payment.getPayAmt());
        }
        for (MInvoice invoice : invoices) {
            totalInvoiced = totalInvoiced.add(invoice.getGrandTotal());
        }
        if (totalInvoiced.signum() != 0 && totalPay.signum() != 0 && totalInvoiced.compareTo(totalPay) == 0) {
            MAllocationHdr allocation = new MAllocationHdr(this.getCtx(), true, this.today, targetOrder.getC_Currency_ID(), targetOrder.getDescription(), this.get_TrxName());
            allocation.setDocStatus("DR");
            allocation.setDocAction("CO");
            allocation.saveEx();
            this.addLog(allocation.getDocumentInfo());
            for (MInvoice invoice : invoices) {
                MAllocationLine allocationLine = new MAllocationLine(allocation);
                allocationLine.setDocInfo(targetOrder.getC_BPartner_ID(), targetOrder.getC_Order_ID(), invoice.getC_Invoice_ID());
                allocationLine.setAmount(invoice.getGrandTotal());
                allocationLine.saveEx();
            }
            for (MPayment payment : payments) {
                MAllocationLine allocationLine = new MAllocationLine(allocation);
                allocationLine.setPaymentInfo(payment.get_ID(), 0);
                allocationLine.setAmount(payment.getPayAmt());
                allocationLine.saveEx();
            }
            allocation.processIt("CO");
            allocation.saveEx();
        }
    }

    private void createPayments(MOrder sourceOrder, MOrder targetOrder) {
        for (MPayment sourcePayment : MPayment.getOfOrder(sourceOrder)) {
            MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(sourcePayment, payment);
            payment.setDateTrx(this.today);
            payment.setDateAcct(this.today);
            payment.setC_Order_ID(targetOrder.getC_Order_ID());
            payment.setC_BPartner_ID(targetOrder.getC_BPartner_ID());
            payment.setC_Invoice_ID(-1);
            payment.addDescription(Msg.parseTranslation(sourceOrder.getCtx(), " @From@ ") + sourcePayment.getDocumentNo());
            payment.setIsReceipt(true);
            payment.setC_DocType_ID(MDocType.getDocType("ARR", sourceOrder.getAD_Org_ID()));
            payment.setIsPrepayment(true);
            payment.saveEx();
            payment.processIt(this.getDocAction());
            payment.saveEx();
            MBankStatement.addPayment(payment);
            this.addLog(payment.getDocumentInfo());
        }
    }
}

