/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.process.CloseStatementPOSAbstract;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CloseStatementPOS
extends CloseStatementPOSAbstract {
    protected LinkedHashMap<Integer, MBankStatement> baskStatements = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getBankAccountId() <= 0) {
            throw new AdempiereException("@C_BankAccount_ID@ @NotFound@");
        }
        if (this.getTransactionDate() == null || this.getTransactionDateTo() == null) {
            throw new AdempiereException("@DateTrx@ @NotFound@");
        }
        if (this.getDifference().signum() != 0 && !this.isOverUnderPayment()) {
            return Msg.parseTranslation(this.getCtx(), "@C_BankStatement_ID@ @NotApproved@ @NotMatch@");
        }
        if (this.isOverUnderPayment()) {
            if (this.getChargeId() <= 0) {
                throw new AdempiereException("@C_Charge_ID@ @NotFound@");
            }
            this.generateLostOrProfit();
        }
        this.createWithdrawal();
        this.closeBankStatements();
        return "@Ok@";
    }

    private void closeBankStatements() {
        this.getBankStatements().entrySet().stream().forEach(entry -> {
            MBankStatement bankStatement = (MBankStatement)entry.getValue();
            bankStatement.processIt("CO");
            bankStatement.saveEx();
        });
    }

    private void generateLostOrProfit() {
        MBankStatement bankStatement = this.getBankStatements().entrySet().iterator().next().getValue();
        MBankStatementLine bankStatementLine = new MBankStatementLine(bankStatement);
        bankStatementLine.setDateAcct(this.getTransactionDate());
        bankStatementLine.setStatementLineDate(this.getTransactionDateTo());
        bankStatementLine.setStmtAmt(this.getDifference().multiply(new BigDecimal(-1)));
        bankStatementLine.setC_Charge_ID(this.getChargeId());
        bankStatementLine.setChargeAmt(this.getDifference().multiply(new BigDecimal(-1)));
        bankStatementLine.saveEx();
    }

    private void createWithdrawal() {
        BigDecimal payAmt = this.getPaidAmount();
        BigDecimal beginningBalance = this.getParameterAsBigDecimal("BeginningBalance");
        String tenderType = this.getParameterAsString("TenderType");
        int withdrawalChargeId = this.getParameterAsInt("WithdrawalCharge_ID");
        String description = this.getParameterAsString("Description");
        Timestamp openingDate = this.getParameterAsTimestamp("OpeningDate");
        if (withdrawalChargeId <= 0 || payAmt == null || beginningBalance == null || beginningBalance.doubleValue() == 0.0) {
            return;
        }
        MPOS pos = MPOS.get(this.getCtx(), this.getPOSTerminalId());
        MBankAccount bankAccountFrom = MBankAccount.get(this.getCtx(), this.getBankAccountId());
        MOrg org = MOrg.get(this.getCtx(), bankAccountFrom.getAD_Org_ID());
        int linkedBPartnerId = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (linkedBPartnerId == 0) {
            throw new AdempiereException("@LinkedC_BPartner_ID@ @of@ " + org.getName() + " @NotFound@");
        }
        if (openingDate == null) {
            throw new AdempiereException("@OpeningDate@ @NotFound@");
        }
        if (Util.isEmpty(tenderType)) {
            tenderType = "A";
        }
        if (Util.isEmpty(description)) {
            description = Msg.parseTranslation(this.getCtx(), "@Withdrawal@ @POS@");
        }
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(this.getBankAccountId());
        paymentBankFrom.setDateAcct(this.getTransactionDateTo());
        paymentBankFrom.setDateTrx(this.getTransactionDateTo());
        paymentBankFrom.setTenderType(tenderType);
        paymentBankFrom.setDescription(description);
        paymentBankFrom.setC_BPartner_ID(linkedBPartnerId);
        paymentBankFrom.setC_Currency_ID(bankAccountFrom.getC_Currency_ID());
        paymentBankFrom.setPayAmt(beginningBalance);
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(withdrawalChargeId);
        paymentBankFrom.setC_POS_ID(this.getPOSTerminalId());
        if (tenderType.equals("X")) {
            paymentBankFrom.setC_CashBook_ID(pos.getC_CashBook_ID());
        }
        paymentBankFrom.saveEx();
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(this.getBankAccountId());
        paymentBankTo.setDateAcct(openingDate);
        paymentBankTo.setDateTrx(openingDate);
        paymentBankTo.setTenderType(tenderType);
        paymentBankTo.setDescription(description);
        paymentBankTo.setC_BPartner_ID(linkedBPartnerId);
        paymentBankTo.setC_Currency_ID(bankAccountFrom.getC_Currency_ID());
        paymentBankTo.setPayAmt(beginningBalance);
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(withdrawalChargeId);
        paymentBankTo.setC_POS_ID(this.getPOSTerminalId());
        if (tenderType.equals("X")) {
            paymentBankTo.setC_CashBook_ID(pos.getC_CashBook_ID());
        }
        paymentBankTo.saveEx();
        paymentBankFrom.setRelatedPayment_ID(paymentBankTo.getC_Payment_ID());
        paymentBankFrom.saveEx();
        paymentBankFrom.processIt("CO");
        paymentBankFrom.saveEx();
        MBankStatement.addPayment(paymentBankFrom);
        paymentBankTo.setRelatedPayment_ID(paymentBankFrom.getC_Payment_ID());
        paymentBankTo.saveEx();
        paymentBankTo.processIt("CO");
        paymentBankTo.saveEx();
        MBankStatement.addPayment(paymentBankFrom);
    }

    private LinkedHashMap<Integer, MBankStatement> getBankStatements() {
        if (this.baskStatements != null && this.baskStatements.size() > 0) {
            return this.baskStatements;
        }
        this.baskStatements = new LinkedHashMap();
        List<?> payments = this.getInstancesForSelection(this.get_TrxName());
        payments.stream().forEach(payment -> {
            Integer bankStatementLineId = this.getSelectionAsInt(payment.get_ID(), "BSL_C_BankStatementLine_ID");
            if (bankStatementLineId != null && bankStatementLineId > 0) {
                MBankStatementLine bankStatementLine = new MBankStatementLine(this.getCtx(), bankStatementLineId, this.get_TrxName());
                MBankStatement bankStatement = new MBankStatement(this.getCtx(), bankStatementLine.getC_BankStatement_ID(), this.get_TrxName());
                if (!this.baskStatements.containsKey(bankStatement.get_ID())) {
                    this.baskStatements.put(bankStatement.get_ID(), bankStatement);
                }
            }
        });
        return this.baskStatements;
    }
}

