/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pos.POSKeyboard;
import org.adempiere.pos.VCollectDetail;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.service.Collect;
import org.adempiere.pos.service.POSPanelInterface;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class VCollect
extends Collect
implements ActionListener,
POSPanelInterface,
VetoableChangeListener {
    private VPOS pos;
    private CPanel dialog;
    private BorderLayout mainLayout;
    private GridBagLayout parameterLayout;
    private CPanel mainPanel;
    private CPanel parameterPanel;
    private JScrollPane scrollPane;
    private CPanel centerPanel;
    private CLabel labelPaidAmt;
    private CLabel fieldPaidAmt;
    private CLabel labelPayAmt;
    private CLabel fieldPayAmt;
    private CLabel labelOpenAmt;
    private CLabel fieldOpenAmt;
    private CLabel labelReturnAmt;
    private CLabel fieldReturnAmt;
    private CButton buttonPlus;
    private CButton buttonCancel;
    private CButton buttonOk;
    private boolean isProcessed;
    private Properties ctx;
    private int collectRowNo;
    private CLogger log = CLogger.getCLogger(VCollect.class);
    private Dimension screenSize;
    private int widthSize;
    private int heightSize;

    public VCollect(VPOS posPanel) {
        super(posPanel.getCtx(), posPanel.getOrder(), posPanel.getM_POS());
        this.pos = posPanel;
        this.ctx = this.pos.getCtx();
        this.collectRowNo = 0;
        this.init();
    }

    public VCollect load(VPOS posPanel) {
        this.load(posPanel.getCtx(), posPanel.getOrder(), posPanel.getM_POS());
        this.centerPanel.removeAll();
        this.collectRowNo = 0;
        this.calculatePanelData();
        this.refreshPanel();
        this.addCollectType();
        this.pos.disablePOSButtons();
        return this;
    }

    public void init() {
        this.log.info("");
        try {
            this.jbInit();
            this.refreshPanel();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.screenSize = this.pos.getSize();
        this.widthSize = this.screenSize.width * 40 / 100;
        this.heightSize = this.screenSize.height * 50 / 100;
        this.dialog = new CPanel();
        this.dialog.setName(Msg.translate(this.ctx, "Payment"));
        this.mainLayout = new BorderLayout();
        this.parameterLayout = new GridBagLayout();
        this.mainPanel = new CPanel();
        this.parameterPanel = new CPanel();
        this.centerPanel = new CPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(this.widthSize, this.heightSize));
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.centerPanel.setLayout(this.parameterLayout);
        this.mainPanel.add(this.scrollPane);
        this.scrollPane.getViewport().add(this.centerPanel);
        this.labelPayAmt = new CLabel(Msg.translate(this.ctx, "PayAmt") + ":");
        this.labelPayAmt.setFont(this.pos.getBigFont());
        this.fieldPayAmt = new CLabel();
        this.fieldPayAmt.setFont(this.pos.getBigFont());
        this.labelOpenAmt = new CLabel(Msg.translate(this.ctx, "OpenAmt") + ":");
        this.labelOpenAmt.setFont(this.pos.getBigFont());
        this.fieldOpenAmt = new CLabel();
        this.fieldOpenAmt.setFont(this.pos.getBigFont());
        this.labelReturnAmt = new CLabel(Msg.translate(this.ctx, "AmountReturned") + ":");
        this.labelReturnAmt.setFont(this.pos.getBigFont());
        this.fieldReturnAmt = new CLabel();
        this.fieldReturnAmt.setFont(this.pos.getBigFont());
        this.labelPaidAmt = new CLabel(Msg.translate(this.ctx, "PaidAmt") + ":");
        this.labelPaidAmt.setFont(this.pos.getBigFont());
        this.labelPaidAmt.setVisible(false);
        this.fieldPaidAmt = new CLabel();
        this.fieldPaidAmt.setFont(this.pos.getBigFont());
        this.fieldPaidAmt.setVisible(false);
        AppsAction action = new AppsAction("Plus", KeyStroke.getKeyStroke(113, 1009), false);
        action.setDelegate(this);
        this.buttonPlus = (CButton)action.getButton();
        this.buttonPlus.setPreferredSize(new Dimension(this.pos.getButtonSize(), this.pos.getButtonSize()));
        this.buttonPlus.setFocusable(false);
        this.buttonCancel = ConfirmPanel.createCancelButton(true);
        this.buttonCancel.setPreferredSize(new Dimension(this.pos.getButtonSize(), this.pos.getButtonSize()));
        this.buttonOk = ConfirmPanel.createOKButton(true);
        this.buttonOk.setPreferredSize(new Dimension(this.pos.getButtonSize(), this.pos.getButtonSize()));
        this.parameterPanel.add((Component)this.labelPayAmt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldPayAmt, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.labelOpenAmt, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldOpenAmt, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.labelReturnAmt, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldReturnAmt, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.labelPaidAmt, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldPaidAmt, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.buttonPlus, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.buttonCancel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.parameterPanel.add((Component)this.buttonOk, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.dialog.add((Component)this.mainPanel, "Center");
    }

    private void addCollectType() {
        BigDecimal balance;
        String tenderType = "X";
        if (this.collectRowNo > 0) {
            tenderType = "C";
        }
        if ((balance = this.getBalance(this.pos.getOpenAmt())).doubleValue() < 0.0) {
            balance = Env.ZERO;
        }
        VCollectDetail collectDetail = new VCollectDetail(this, tenderType, balance);
        this.addCollect(collectDetail);
        this.centerPanel.add((Component)collectDetail.getPanel(), new GridBagConstraints(0, this.collectRowNo, 1, 1, 0.0, 0.0, 13, 11, new Insets(1, 1, 1, 1), 0, 0));
        this.scrollPane.validate();
        this.scrollPane.repaint();
        collectDetail.requestFocusInPayAmt();
        ++this.collectRowNo;
        this.calculatePanelData();
    }

    public void executePayment(String trxName) {
        if (this.pos.processOrder(trxName, this.isAllowsPartialPayment(), this.getBalance(this.pos.getOpenAmt()).signum() <= 0)) {
            this.processTenderTypes(trxName, this.pos.getOpenAmt());
            String error = this.getErrorMsg();
            if (error != null && error.length() > 0) {
                throw new POSaveFailedException(Msg.parseTranslation(this.ctx, "@order.no@ " + this.pos.getDocumentNo() + ": " + this.getErrorMsg()));
            }
        } else {
            throw new POSaveFailedException(Msg.parseTranslation(this.ctx, "@order.no@ " + this.pos.getDocumentNo() + ": @ProcessRunError@ (" + this.pos.getProcessMsg() + ")"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.isProcessed = false;
        if (actionEvent.getSource().equals(this.buttonPlus)) {
            this.addCollectType();
        } else {
            if (actionEvent.getSource().equals(this.buttonOk)) {
                try {
                    this.pos.getFrame().getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    Trx.run(new TrxRunnable(){

                        @Override
                        public void run(String trxName) {
                            String validResult = VCollect.this.validatePayment();
                            if (validResult != null) {
                                throw new AdempiereException(validResult);
                            }
                            VCollect.this.executePayment(trxName);
                            if (VCollect.this.pos.isToPrint()) {
                                VCollect.this.pos.printTicket();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    ADialog.warn(this.pos.getWindowNo(), this.dialog, Msg.parseTranslation(this.ctx, e.getLocalizedMessage()));
                    this.pos.reloadOrder();
                    return;
                }
                finally {
                    this.pos.getFrame().getContentPane().setCursor(Cursor.getDefaultCursor());
                }
                this.isProcessed = true;
                this.hidePanel();
                this.pos.setOrder(0);
                this.pos.showKeyboard();
                this.pos.refreshPanel();
                this.pos.restoreTable();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonCancel)) {
                this.hidePanel();
                this.pos.showKeyboard();
                this.pos.refreshPanel();
                this.pos.restoreTable();
                return;
            }
        }
        this.changeViewPanel();
    }

    @Override
    public void removeAllCollectDetail() {
        this.centerPanel.removeAll();
        super.removeAllCollectDetail();
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    public void removeCollectDetail(VCollectDetail child) {
        CPanel comp = child.getPanel();
        this.removeCollect(child);
        this.centerPanel.remove(comp);
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    public boolean showPanel() {
        this.dialog.setMinimumSize(new Dimension(this.widthSize, this.heightSize));
        this.dialog.setVisible(true);
        return this.isProcessed;
    }

    public POSKeyboard getKeyboard() {
        return this.pos.getKeyboard();
    }

    @Override
    public void refreshPanel() {
        this.calculatePanelData();
        this.changeViewPanel();
    }

    @Override
    public String validatePayment() {
        String errorMsg = null;
        if (!this.pos.hasOrder()) {
            errorMsg = "@POS.MustCreateOrder@";
        } else if (!this.pos.isStandardOrder()) {
            errorMsg = this.validateTenderTypes(this.pos.getOpenAmt());
        }
        return errorMsg;
    }

    @Override
    public void changeViewPanel() {
        boolean isCreditOpen = this.pos.isCompleted() && this.pos.getOpenAmt().doubleValue() > 0.0;
        boolean isStandardOrder = this.pos.isStandardOrder();
        this.setIsCreditOrder(this.isCreditOrder() || isCreditOpen && !isStandardOrder);
        if (this.pos.isCompleted()) {
            this.buttonPlus.setEnabled(isCreditOpen);
            this.buttonOk.setEnabled(true);
        } else if (this.pos.isVoided()) {
            this.buttonPlus.setEnabled(false);
            this.buttonOk.setEnabled(false);
        } else if (this.pos.isStandardOrder()) {
            this.buttonPlus.setEnabled(false);
        } else {
            this.buttonPlus.setEnabled(!this.isCreditOrder() || isCreditOpen);
            this.buttonOk.setEnabled(true);
        }
    }

    private void calculatePanelData() {
        BigDecimal collectDetail = this.getCollectDetailAmt();
        BigDecimal balance = this.getBalance(this.pos.getOpenAmt());
        String currencyISOCode = this.pos.getCurSymbol();
        if (this.isAllowsPartialPayment()) {
            this.labelPaidAmt.setVisible(true);
            this.fieldPaidAmt.setVisible(true);
            this.fieldPaidAmt.setText(currencyISOCode + " " + this.pos.getNumberFormat().format(this.pos.getPaidAmt()));
        } else {
            this.labelPaidAmt.setVisible(false);
            this.fieldPaidAmt.setVisible(false);
        }
        this.fieldPayAmt.setText(currencyISOCode + " " + this.pos.getNumberFormat().format(collectDetail));
        BigDecimal returnAmt = Env.ZERO;
        BigDecimal openAmt = Env.ZERO;
        if (balance.doubleValue() < 0.0) {
            returnAmt = balance.abs();
        } else if (balance.doubleValue() > 0.0) {
            openAmt = balance;
        }
        this.fieldOpenAmt.setText(currencyISOCode + " " + this.pos.getNumberFormat().format(openAmt));
        this.fieldReturnAmt.setText(currencyISOCode + " " + this.pos.getNumberFormat().format(returnAmt));
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        this.log.config(name + " = " + value);
    }

    @Override
    public void moveUp() {
    }

    @Override
    public void moveDown() {
    }

    public void hidePanel() {
        this.dialog.setVisible(false);
    }

    public CPanel getPanel() {
        return this.dialog;
    }

    public VPOS getPOS() {
        return this.pos;
    }
}

