/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.JFormattedTextField;
import net.miginfocom.swing.MigLayout;
import org.adempiere.pos.POSKeyListener;
import org.adempiere.pos.POSKeyPanel;
import org.adempiere.pos.POSTextField;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class POSKeyboard
extends CDialog
implements ActionListener,
POSKeyListener,
KeyListener,
FocusListener,
WindowFocusListener {
    private static final long serialVersionUID = 3296839634889851637L;
    private POSTextField f_SourceField;
    private MPOSKeyLayout m_Keylayout;
    private JFormattedTextField m_Text = new JFormattedTextField();
    private HashMap<Integer, MPOSKey> m_Keys;
    private boolean m_IsOk;
    private static CLogger log = CLogger.getCLogger(POSKeyboard.class);

    public POSKeyboard(CPanel cPanel, int n, POSTextField pOSTextField, String string) {
        this(cPanel, n);
        this.setTitle(string);
        this.setPosTextField(pOSTextField);
    }

    public POSKeyboard(CPanel cPanel, int n) {
        super((Frame)Env.getFrame(cPanel), true);
        this.m_Keylayout = MPOSKeyLayout.get(Env.getCtx(), n);
        this.init(n);
    }

    public void init(int n) {
        CPanel cPanel = new CPanel();
        this.getContentPane().add(cPanel);
        cPanel.setLayout((LayoutManager)new MigLayout("fill"));
        if (this.m_Keylayout.getPOSKeyLayoutType() != null && this.m_Keylayout.getPOSKeyLayoutType().equals("N")) {
            this.m_Text.setHorizontalAlignment(11);
        }
        this.m_Text.addKeyListener(this);
        this.m_Text.addFocusListener(this);
        this.m_Text.setFocusable(true);
        cPanel.add((Component)this.m_Text, "north, growx, h 30!, wrap, gap 10 10 10 10");
        POSKeyPanel pOSKeyPanel = new POSKeyPanel(n, this);
        pOSKeyPanel.setFocusable(false);
        cPanel.add((Component)pOSKeyPanel, "center, growx, growy");
        ConfirmPanel confirmPanel = new ConfirmPanel(true, false, true, false, false, false, false);
        confirmPanel.addActionListener(this);
        Dimension dimension = new Dimension(50, 50);
        confirmPanel.getResetButton().setPreferredSize(dimension);
        confirmPanel.getOKButton().setPreferredSize(dimension);
        confirmPanel.getCancelButton().setPreferredSize(dimension);
        cPanel.add((Component)confirmPanel, "south");
        this.pack();
    }

    @Override
    public void dispose() {
        if (this.m_Keys != null) {
            this.m_Keys.clear();
            this.m_Keys = null;
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equals("Reset")) {
            if (this.m_Keylayout.getPOSKeyLayoutType().equals("N")) {
                this.m_Text.setText("0");
            } else {
                this.m_Text.setText("");
            }
            try {
                this.m_Text.commitEdit();
            }
            catch (ParseException parseException) {
                log.log(Level.FINE, "JFormattedTextField commit failed");
            }
        } else if (string.equals("Cancel")) {
            this.processCancelAction();
        } else if (string.equals("Ok")) {
            this.processOkAction();
        }
        log.info("PosSubBasicKeys - actionPerformed: " + string);
    }

    private void processOkAction() {
        this.f_SourceField.setText(this.m_Text.getText());
        try {
            this.f_SourceField.commitEdit();
            this.m_IsOk = true;
        }
        catch (ParseException parseException) {
            log.log(Level.FINE, "JFormattedTextField commit failed");
        }
        this.dispose();
    }

    private void processCancelAction() {
        this.m_IsOk = false;
        this.dispose();
    }

    @Override
    public void keyReturned(MPOSKey mPOSKey) {
        String string = mPOSKey.getText();
        String string2 = this.m_Text.getText();
        int n = this.m_Text.getCaretPosition();
        if (this.m_Text.getSelectedText() != null) {
            n = this.m_Text.getSelectionStart();
        }
        String string3 = string2.substring(0, n);
        if (this.m_Text.getSelectedText() != null) {
            n = this.m_Text.getSelectionEnd();
        }
        String string4 = string2.substring(n, string2.length());
        if (string != null && !string.isEmpty()) {
            if (this.m_Keylayout.getPOSKeyLayoutType().equals("K")) {
                if (mPOSKey.getText() != null) {
                    this.m_Text.setText(string3 + string + string4);
                }
            } else if (this.m_Keylayout.getPOSKeyLayoutType().equals("N")) {
                if (string.equals(".")) {
                    this.m_Text.setText(string3 + string + string4);
                }
                if (string.equals(",")) {
                    this.m_Text.setText(string3 + string + string4);
                } else if (string.equals("C")) {
                    this.m_Text.setText("0");
                } else {
                    try {
                        int n2 = Integer.parseInt(string);
                        if (n2 >= 0 && n2 <= 9) {
                            this.m_Text.setText(string3 + n2 + string4);
                        } else {
                            Object object = this.m_Text.getValue();
                            if (object == null) {
                                this.m_Text.setText(Integer.toString(n2));
                            } else if (object instanceof BigDecimal) {
                                this.m_Text.setText(((BigDecimal)object).add(new BigDecimal(Integer.toString(n2))).toPlainString());
                            } else if (object instanceof Integer) {
                                this.m_Text.setText(Integer.toString((Integer)object + n2));
                            } else if (object instanceof Long) {
                                this.m_Text.setText(Long.toString((Long)object + (long)n2));
                            } else if (object instanceof Double) {
                                this.m_Text.setText(Double.toString((Double)object + (double)n2));
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                try {
                    this.m_Text.commitEdit();
                }
                catch (ParseException parseException) {
                    log.log(Level.FINE, "JFormattedTextField commit failed");
                }
            }
        }
    }

    public void setPosTextField(POSTextField pOSTextField) {
        this.f_SourceField = pOSTextField;
        this.m_Text.setFormatterFactory(this.f_SourceField.getFormatterFactory());
        this.m_Text.setText(this.f_SourceField.getText());
        this.m_Text.setValue(this.f_SourceField.getValue());
        this.getContentPane().invalidate();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        log.finest("Key=" + keyEvent.getKeyCode() + " - " + keyEvent.getKeyChar() + " -> " + this.m_Text.getText());
        if (keyEvent.getKeyCode() == 27) {
            this.processCancelAction();
        } else if (keyEvent.getKeyCode() == 10) {
            this.processOkAction();
        }
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.m_Text.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        this.processCancelAction();
    }
}

