/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellEditor;

public class POSDefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = 6870214767566702838L;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;

    public POSDefaultCellEditor(final JButton jButton) {
        this.editorComponent = jButton;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object object) {
                jButton.setText(object != null ? object.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return jButton.getText();
            }
        };
        jButton.addActionListener(this.delegate);
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return this.delegate.isCellEditable(eventObject);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        if (this.editorComponent instanceof JButton) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
            if (component != null) {
                this.editorComponent.setOpaque(true);
                this.editorComponent.setBackground(component.getBackground());
                if (component instanceof JComponent) {
                    this.editorComponent.setBorder(((JComponent)component).getBorder());
                }
            } else {
                this.editorComponent.setOpaque(false);
            }
        }
        return this.editorComponent;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= POSDefaultCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            POSDefaultCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            POSDefaultCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            POSDefaultCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            POSDefaultCellEditor.this.stopCellEditing();
        }
    }
}

