/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Optional;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.command.Command;
import org.adempiere.pos.command.CommandManager;
import org.adempiere.pos.command.CommandReceiver;
import org.adempiere.pos.search.POSQuery;
import org.adempiere.pos.search.QueryBPartner;
import org.adempiere.pos.service.POSQueryInterface;
import org.adempiere.pos.service.POSQueryListener;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.Waiting;
import org.compiere.apps.form.FormFrame;
import org.compiere.model.MBPartner;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.VBrowser;
import org.spin.util.ASPUtil;

public class POSActionMenu
implements ActionListener,
POSQueryListener {
    private VPOS pos;
    private POSQuery queryPartner;
    private JPopupMenu popupMenu;
    private CommandManager commandManager;
    private Command currentCommand;

    public POSActionMenu(VPOS vPOS) {
        this.pos = vPOS;
        this.popupMenu = new JPopupMenu();
        this.commandManager = new CommandManager();
        for (Map.Entry<String, CommandReceiver> entry : this.commandManager.getCommandReceivers().entrySet()) {
            CommandReceiver commandReceiver = entry.getValue();
            this.addMenuItem(commandReceiver.getEvent());
        }
    }

    private void addMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        this.popupMenu.add(jMenuItem).addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.popupMenu.setVisible(false);
            this.currentCommand = this.commandManager.getCommand(actionEvent.getActionCommand());
            this.beforeExecutionCommand(this.currentCommand);
        }
        catch (AdempiereException adempiereException) {
            ADialog.error(this.pos.getWindowNo(), this.pos.getFrame(), adempiereException.getLocalizedMessage());
        }
    }

    private void beforeExecutionCommand(Command command) {
        if (command.getCommand() == CommandManager.GENERATE_IMMEDIATE_INVOICE) {
            if (this.pos.isCompleted()) {
                this.queryPartner = new QueryBPartner(this.pos);
                this.queryPartner.setModal(true);
                this.queryPartner.addOptionListener(this);
                this.queryPartner.showView();
            }
        } else if (command.getCommand() == CommandManager.GENERATE_REVERSE_SALES) {
            if (this.pos.isCompleted()) {
                this.executeCommand(command);
            }
        } else if (command.getCommand() == CommandManager.GENERATE_RETURN) {
            if (this.pos.getC_Order_ID() > 0 && !this.pos.isReturnMaterial() && this.pos.isCompleted()) {
                this.executeCommand(command);
            }
        } else if (command.getCommand() == CommandManager.COMPLETE_DOCUMENT) {
            if (this.pos.getC_Order_ID() > 0) {
                this.executeCommand(command);
            }
        } else if (command.getCommand() == CommandManager.GENERATE_WITHDRAWAL) {
            this.executeCommand(command);
        } else if (command.getCommand() == CommandManager.CLOSE_STATEMENT) {
            this.executeCommand(command);
        } else {
            ADialog.info(this.pos.getWindowNo(), this.popupMenu, "DocProcessed", this.pos.getDocumentNo());
        }
    }

    private void afterExecutionCommand(Command command) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Command command) {
        Waiting waiting = new Waiting((Frame)this.pos.getFrame(), Msg.parseTranslation(this.pos.getCtx(), "@Processing@"), false, 120);
        try {
            CommandReceiver commandReceiver = this.commandManager.getCommandReceivers(command.getEvent());
            if (command.getCommand() == CommandManager.GENERATE_IMMEDIATE_INVOICE && this.pos.getC_Order_ID() > 0 && this.pos.isCompleted() && !this.pos.isVoided()) {
                commandReceiver.setCtx(this.pos.getCtx());
                commandReceiver.setPartnerId(this.queryPartner.getRecord_ID());
                commandReceiver.setOrderId(this.pos.getC_Order_ID());
                commandReceiver.setPOSId(this.pos.getC_POS_ID());
                commandReceiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                MBPartner mBPartner = MBPartner.get(this.pos.getCtx(), commandReceiver.getPartnerId());
                Optional<String> optional = Optional.ofNullable(mBPartner.getTaxID());
                String string = commandReceiver.getName() + " @DisplayDocumentInfo@ : " + this.pos.getDocumentNo() + " @To@ @C_BPartner_ID@ : " + mBPartner.getName() + " @TaxID@ : " + optional.orElseGet(() -> "");
                if (ADialog.ask(this.pos.getWindowNo(), this.popupMenu, "StartProcess?", Msg.parseTranslation(this.pos.getCtx(), string))) {
                    AEnv.showCenterScreen(waiting);
                    command.execute(commandReceiver);
                    ProcessInfo processInfo = commandReceiver.getProcessInfo();
                    waiting.setVisible(false);
                    if (processInfo != null && processInfo.isError()) {
                        this.showError(processInfo);
                    } else {
                        this.afterExecutionCommand(command);
                        if (processInfo != null) {
                            this.showOkMessage(processInfo);
                            this.pos.setOrder(processInfo.getRecord_ID());
                        }
                        this.pos.refreshHeader();
                        this.pos.printTicket();
                    }
                }
            } else if (!(command.getCommand() != CommandManager.GENERATE_REVERSE_SALES || this.pos.getC_Order_ID() <= 0 || this.pos.isReturnMaterial() || this.pos.isVoided() || this.pos.isClosed())) {
                commandReceiver.setCtx(this.pos.getCtx());
                commandReceiver.setOrderId(this.pos.getC_Order_ID());
                commandReceiver.setPOSId(this.pos.getC_POS_ID());
                commandReceiver.setPartnerId(this.pos.getC_BPartner_ID());
                commandReceiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                String string = commandReceiver.getName() + " @order.no@ : " + this.pos.getDocumentNo() + " @To@ @C_BPartner_ID@ : " + this.pos.getBPName();
                if (ADialog.ask(this.pos.getWindowNo(), this.popupMenu, "StartProcess?", Msg.parseTranslation(this.pos.getCtx(), string))) {
                    AEnv.showCenterScreen(waiting);
                    command.execute(commandReceiver);
                    ProcessInfo processInfo = commandReceiver.getProcessInfo();
                    waiting.setVisible(false);
                    if (processInfo != null && processInfo.isError()) {
                        this.showError(processInfo);
                    } else {
                        this.afterExecutionCommand(command);
                        if (processInfo != null) {
                            this.showOkMessage(processInfo);
                        }
                    }
                    this.pos.printTicket();
                }
            } else if (command.getCommand() == CommandManager.GENERATE_RETURN && this.pos.getC_Order_ID() > 0 && !this.pos.isReturnMaterial() && this.pos.isCompleted()) {
                commandReceiver.setCtx(this.pos.getCtx());
                commandReceiver.setOrderId(this.pos.getC_Order_ID());
                commandReceiver.setPOSId(this.pos.getC_POS_ID());
                commandReceiver.setPartnerId(this.pos.getC_BPartner_ID());
                commandReceiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                String string = commandReceiver.getName() + " @DisplayDocumentInfo@ : " + this.pos.getDocumentNo() + " @To@ @C_BPartner_ID@ : " + this.pos.getBPName();
                if (ADialog.ask(this.pos.getWindowNo(), this.popupMenu, "StartProcess?", Msg.parseTranslation(this.pos.getCtx(), string))) {
                    AEnv.showCenterScreen(waiting);
                    command.execute(commandReceiver);
                    ProcessInfo processInfo = commandReceiver.getProcessInfo();
                    waiting.setVisible(false);
                    if (processInfo != null && processInfo.isError()) {
                        this.showError(processInfo);
                    } else {
                        this.afterExecutionCommand(command);
                        if (processInfo != null && processInfo.getRecord_ID() > 0) {
                            this.showOkMessage(processInfo);
                            this.pos.setOrder(processInfo.getRecord_ID());
                            this.pos.refreshHeader();
                        }
                    }
                }
            } else if (command.getCommand() == CommandManager.GENERATE_WITHDRAWAL) {
                Env.setContext(this.pos.getCtx(), this.pos.getWindowNo(), "C_POS_ID", this.pos.getC_POS_ID());
                Dimension dimension = new Dimension(1024, 768);
                FormFrame formFrame = new FormFrame(this.pos.getWindowNo());
                formFrame.setSize(dimension);
                new VBrowser(formFrame, true, this.pos.getWindowNo(), "", ASPUtil.getInstance().getBrowse(50056), "", true, "", true);
                formFrame.pack();
                AEnv.showCenterScreen(formFrame);
            } else if (command.getCommand() == CommandManager.CLOSE_STATEMENT) {
                Env.setContext(this.pos.getCtx(), this.pos.getWindowNo(), "C_POS_ID", this.pos.getC_POS_ID());
                Dimension dimension = new Dimension(1024, 768);
                FormFrame formFrame = new FormFrame(this.pos.getWindowNo());
                formFrame.setSize(dimension);
                MBrowse mBrowse = new MBrowse(Env.getCtx(), 50057, null);
                new VBrowser(formFrame, true, this.pos.getWindowNo(), "", mBrowse, "", true, "", true);
                formFrame.pack();
                AEnv.showCenterScreen(formFrame);
            } else if (command.getCommand() == CommandManager.COMPLETE_DOCUMENT) {
                commandReceiver.setCtx(this.pos.getCtx());
                commandReceiver.setOrderId(this.pos.getC_Order_ID());
                commandReceiver.setPOSId(this.pos.getC_POS_ID());
                commandReceiver.setPartnerId(this.pos.getC_BPartner_ID());
                commandReceiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                command.execute(commandReceiver);
                ProcessInfo processInfo = commandReceiver.getProcessInfo();
                waiting.setVisible(false);
                if (processInfo != null && processInfo.isError()) {
                    this.showError(processInfo);
                } else {
                    this.afterExecutionCommand(command);
                    if (processInfo != null) {
                        this.showOkMessage(processInfo);
                    }
                    this.pos.refreshHeader();
                }
            }
        }
        catch (Exception exception) {
            waiting.setVisible(false);
            ADialog.error(this.pos.getWindowNo(), this.pos.getFrame(), exception.getLocalizedMessage());
        }
        finally {
            waiting.setVisible(false);
            waiting = null;
        }
    }

    public void show(Component component, int n, int n2) {
        this.popupMenu.show(component, n, n2);
    }

    @Override
    public void okAction(POSQueryInterface pOSQueryInterface) {
        if (pOSQueryInterface.getRecord_ID() <= 0) {
            return;
        }
        if (pOSQueryInterface instanceof QueryBPartner) {
            this.executeCommand(this.currentCommand);
        }
    }

    @Override
    public void cancelAction(POSQueryInterface pOSQueryInterface) {
    }

    private void showError(ProcessInfo processInfo) throws AdempierePOSException {
        Optional<String> optional = Optional.ofNullable(processInfo.getSummary());
        Optional<String> optional2 = Optional.ofNullable(processInfo.getLogInfo());
        String string = Msg.parseTranslation(this.pos.getCtx(), "@AD_Process_ID@ " + processInfo.getTitle() + " @ProcessRunError@ @Summary@ : " + optional.orElseGet(() -> "") + " @ProcessFailed@ : " + optional2.orElseGet(() -> ""));
        throw new AdempierePOSException(string);
    }

    private void showOkMessage(ProcessInfo processInfo) {
        this.pos.refreshHeader();
        Optional<String> optional = Optional.ofNullable(processInfo.getSummary());
        Optional<String> optional2 = Optional.ofNullable(processInfo.getLogInfo());
        String string = Msg.parseTranslation(this.pos.getCtx(), " @AD_Process_ID@ " + processInfo.getTitle() + " @Summary@ : " + optional.orElseGet(() -> "") + " @ProcessOK@ : " + optional2.orElseGet(() -> ""));
        ADialog.info(this.pos.getWindowNo(), this.popupMenu, "ProcessOK", string);
    }
}

