/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.handler.GenericPOHandler;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.xml.sax.SAXException;

public class WorkflowElementHandler
extends GenericPOHandler {
    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        MWFNode[] nodes;
        int workflowId = Env.getContextAsInt(ctx, "AD_Workflow_ID");
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        if (packOut == null) {
            packOut = new PackOut();
            packOut.setLocalContext(ctx);
        }
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("AD_WF_Node");
        MWorkflow workflow = MWorkflow.get(ctx, workflowId);
        packOut.createGenericPO(document, workflow, true, tableList);
        for (MWFNode node : nodes = workflow.getNodes(true, Env.getAD_Client_ID(ctx))) {
            if (node.getAD_Process_ID() > 0) {
                packOut.createProcess(node.getAD_Process_ID(), document);
            }
            if (node.getAD_Window_ID() > 0) {
                packOut.createWindow(node.getAD_Window_ID(), document);
            }
            if (node.getAD_Browse_ID() > 0) {
                packOut.createBrowse(node.getAD_Browse_ID(), document);
            }
            if (node.getAD_Form_ID() > 0) {
                packOut.createForm(node.getAD_Form_ID(), document);
            }
            if (node.getAD_Task_ID() > 0) {
                packOut.createTask(node.getAD_Task_ID(), document);
            }
            if (node.getAD_View_ID() > 0) {
                packOut.createView(node.getAD_View_ID(), document);
            }
            packOut.createGenericPO(document, node);
        }
        for (MWFNode node : nodes) {
            List nextNodeList = new Query(ctx, "AD_WF_NodeNext", "AD_WF_Node_ID = ?", null).setParameters(node.getAD_WF_Node_ID()).setClient_ID().list();
            for (MWFNodeNext nextNode : nextNodeList) {
                packOut.createGenericPO(document, nextNode);
                List nextConditionList = new Query(ctx, "AD_WF_NextCondition", "AD_WF_NodeNext_ID = ?", null).setParameters(nextNode.getAD_WF_NodeNext_ID()).setClient_ID().list();
                for (MWFNextCondition nextCondition : nextConditionList) {
                    packOut.createGenericPO(document, nextCondition);
                }
            }
        }
    }

    @Override
    protected void beforeSave(PO entity) {
        entity.set_ValueOfColumn("AD_WF_Node_ID", null);
    }
}

