/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.HashMap;
import java.util.Map;
import org.adempiere.pipo.ElementHandler;
import org.adempiere.pipo.handler.CodeSnipitElementHandler;
import org.adempiere.pipo.handler.DataElementHandler;
import org.adempiere.pipo.handler.DistFileElementHandler;
import org.adempiere.pipo.handler.EntityTypeElementHandler;
import org.adempiere.pipo.handler.GenericPOHandler;
import org.adempiere.pipo.handler.PrintFormatElementHandler;
import org.adempiere.pipo.handler.SQLStatementElementHandler;
import org.adempiere.pipo.handler.TableElementHandler;
import org.adempiere.pipo.handler.WorkflowElementHandler;
import org.compiere.util.Util;

public class PackinCustomHandler {
    private static PackinCustomHandler instance = null;
    private Map<String, ElementHandler> handlers = null;

    private PackinCustomHandler() {
        this.createDefaultHandlers();
    }

    private void createDefaultHandlers() {
        DataElementHandler dataHandler = new DataElementHandler();
        this.handlers = new HashMap<String, ElementHandler>();
        this.handlers.put("adempieredata", dataHandler);
        this.handlers.put("GenericPO_AD_Workflow", new WorkflowElementHandler());
        this.handlers.put("data", dataHandler);
        this.handlers.put("dtable", dataHandler);
        this.handlers.put("drow", dataHandler);
        this.handlers.put("dcolumn", dataHandler);
        this.handlers.put("GenericPO_AD_Column", new TableElementHandler());
        this.handlers.put("GenericPO", new GenericPOHandler());
        this.handlers.put("codesnipit", new CodeSnipitElementHandler());
        this.handlers.put("distfile", new DistFileElementHandler());
        this.handlers.put("SQLStatement", new SQLStatementElementHandler());
        this.handlers.put("GenericPO", new EntityTypeElementHandler());
        this.handlers.put("GenericPO_AD_PrintFormat", new PrintFormatElementHandler());
    }

    public static PackinCustomHandler getInstance() {
        if (instance == null) {
            instance = new PackinCustomHandler();
        }
        return instance;
    }

    public void addTableHandler(String tableName, ElementHandler tableHandler) {
        if (Util.isEmpty(tableName)) {
            return;
        }
        this.handlers.put("GenericPO_" + tableName.trim(), tableHandler);
    }

    public void addCustomHandler(String keyHandler, ElementHandler tableHandler) {
        if (Util.isEmpty(keyHandler)) {
            return;
        }
        this.handlers.put(keyHandler.trim(), tableHandler);
    }

    public ElementHandler getHandler(String key) {
        if (Util.isEmpty(key)) {
            return null;
        }
        return this.handlers.get(key);
    }

    public ElementHandler getHandlerFromTableName(String tableName) {
        if (Util.isEmpty(tableName)) {
            return null;
        }
        return this.getHandler("GenericPO_" + tableName.trim());
    }
}

